/* Data link program for the PC.
 *
 * Changed for 6809 "bit banger" port.
 * Sets COM1 to: 19200 baud, 2 stop
 * bits, no parity.
 *
 * Receives a data block via COM1 which
 * requests a C function. It decodes it
 * and returns the requested data.
 *
 *   NOTE: Use large memory model to
 *         allow memory allocation.
 *         Even if "farmalloc" is
 *         used the total memory
 *         allocated <=  64 K unless
 *         large is used.
 *
 *             "pc linkc /e /ml"
 */

/* PROBLEMS (things to fix or change)
 * ----------------------------------
 *
 * (1)    Functions that get and put data
 *        in the storage blocks check for
 *        over and under running, but the
 *        calls usually do not check
 *        for this.
 *        Change BMAX to allow a medium
 *        memory model to be used. Super
 *        large data chunks are not really
 *        necessary.
 */

#include       <stdio.h>
#include       <sys\types.h>
#include       <sys\timeb.h>
#include       <malloc.h>
#include       <dos.h>
#include       <conio.h>

/* Debug definition. Comment out if not needed */
/*#define        DEBUG*/
/* Serial input channel signal definitions */
#define        SIG       0x80      /* Rcv signal detect */
#define        DSR       0x20      /* Data set ready * /
#define        CTS       0x10      /* Clear to send */
#define        RDY       0x100     /* Data ready */
#define        OER       0x200     /* Overrun error */
#define        PER       0x400     /* Parity error */
#define        FER       0x800     /* Framing error */
#define        XHE       0x2000    /* Xmit holding reg. empty */
#define        XSE       0x4000    /* Xmit shift reb. empty */
#define        DLE       0x10      /* Data link escape */
#define        XON       0x11      /* DC1 (turn link on) */
#define        XOFF      0x13      /* DC3 (turn link off) */
#define        ESCKEY    0x011B    /* Keyboard escape (ESC key) */
#define        CTLC      0x03      /* Control C (program exit) */
#define        RDSKWT    1500      /* Wait for Ramdisk to settle */
#define        BMAX      0xFFFF    /* Buffer size (close to max) */
#define        FMAX      12        /* # of file pointers (8 available) */
#define        TCHECK    100       /* # characters for time out check */
#define        TCHAR     5         /* # time out characters */
/*   Data link block headers for calls (sent on input and echoed
 *   on output).
 */
#define        FOPEN     1         /* Open file */
#define        FCLOSE    2         /* Close open file */
#define        FREAD     3         /* Get binary data records to file */
#define        FWRITE    4         /* Write binary data records to file */
#define        FGETS     5         /* Get string from ASCII file */
#define        GETS      6         /* Get string from keyboard */
#define        FGETC     7         /* Get character from ASCII file */
#define        GETC      8         /* Get character from keyboard */
#define        FPUTS     9         /* Send string to ASCII file */
#define        PUTS      10        /* Send string to display */
#define        FPUTC     11        /* Send character to ASCII file */
#define        PUTC      12        /* Send character to display */
#define        GETCHAR   13        /* Get character from keyboard */
#define        PUTCHAR   14        /* Send character to display */
#define        GETKEY    15        /* Get keyboard input indication */
#define        EXIT      16        /* Exit program */
#define        RESET     17        /* Reset system (from PC) */
/*   Data link block headers for major errors */
#define        OVERFLOW  18        /* Data block overflow */
#define        BADCALL   19        /* Unknown call */
#define        BADARGS   20        /* Unexpected call arguments */
#define        PHASING   21        /* Unexpected input */
#define        BADBYTE   22        /* Error in data reception */
/*   Major state flags. */
#define        PACKET    23        /* Enter data link packet mode */
#define        DIRECT    24        /* Enter data link direce com. mode */

/* Global variables: */

char far       *inblock, *outblock, *inptr, *outptr, *saveptr;
char far       *getstr(), *string1, *string2;
unsigned int   insize, outsize, savesize;
int            stat, port=0;       /* Port= com1 */
long           int timeout;
FILE           *fparray[FMAX], *fpfetch();

/* PROGRAM STARTUP MODULE */
main(argc, argv)
int  argc;
char *argv[];

{

int  i,j;                          /* General indices */
FILE *fp;                          /* File pointer */
char type, iochar, ioint;          /* Input block stuff */
int  channel;                      /* Call channel # (file access) */

unsigned int bcheck, bctest, filesize;
int delay;
long int delta;

/* Initialise COM1 to 19200 baud, no parity, 8 bits, 2 stop */
outportb (0X3FB, 0X87);  /* Line Control register (baud setup) */
/*outportb (0X3F8, 0X06);*/  /* Divisor LSB for 19200 baud */
outportb (0X3F8, 0X0C);  /* Divisor LSB for 9600 baud */
outportb (0X3F9, 0X00);  /* Divisor MSB */
outportb (0X3FB, 0X07);  /* Line Control register (normal I/O) */

/* Clear data input registers */
	while (RDY & (bioscom(3, NULL, port))) bioscom(2, NULL, port);

/* Wait for any setup to finish. Needed with ramdisk
 * as something causes an interrupt after program is
 * started. Also need time for opposite end of link
 * to finish its setup.


	delta= timer();
	while ((timer()-delta) < RDSKWT) if (getkey() != EOF) delta= timer();
*/

/* Send null characters to check for serial input time out wait */
	timeout= chkchrs(100, timeout= 20000);
	timeout= (TCHAR*timeout)/TCHECK;
	#ifdef DEBUG
	printf("\n Delay= %ld cycles\n", timeout);
	#endif

/* Check to see that the port is active. Sending
 * nulls should have gotten port ready feedback
 * working.
 */
	if (!(DSR & (bioscom(3, NULL, port)))) {
		printf("\n COM1 inactive\n");
		return;
	}

/* Allocate memory for data input and output blocks. */

	/* Input memory */
	inblock=  farmalloc(BMAX);
	if (inblock == NULL) {
		printf("\n Unable to allocate enough input memory\n");
		return;
	}
	/* Output memory */
	outblock=  farmalloc(BMAX);
	if (outblock == NULL) {
		printf("\n Unable to allocate enough output memory\n");
		return;
	}

/* Set up the file pointer array. It is arranged
 *   so that an entry # can be returned, with
 *   NULL represented by 0.
 *
 * The entries are as follows:
 *   Array index    Value     Remarks
 *   -----------    -----     -------
 *   0              NULL      Never used.
 *   1              stdin     Do not close this path.
 *   2              stdout    (see above)
 *   3              stderr    (see above)
 *   >= 4           NULL      Use for open file pointers.
 */
	for(i= 1; i< FMAX; i++) fparray[i]= NULL;
	fparray[1]= stdin;
	fparray[2]= stdout;
	fparray[3]= stderr;

/* Send "DLE" out port to start sending program */
	bioscom(1, DLE, port);

/* Main block input-output loop.
 *   Gets block from program, processes it
 *   and sends answering block back to the
 *   program.
 */
	while(getblock()) {           /* Loop till error */
		#ifdef DEBUG
/*        pbuf();*/
		#endif

		/* Decode call and set up output data block */
		type= putflag(*inptr++);
		insize--;

		switch(type&0xFF) {
			case(FOPEN): {
				/* Get argument strings */
				string1= getstr();
				string2= getstr();
				if((string1 == NULL)||(string2 == NULL)||insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n FOPEN: bad arguments\n");
					#endif
				}
				else if(!fpavail()) {    /* If no slot, send NULL */
					outint(0);
					#ifdef DEBUG
					printf("\n FOPEN: file pointer array full\n");
					#endif
				}
				/* Open file. If cannot open file or set array send 0 */
				else if((fp= fopen(string1, string2)) != NULL)
					outint(fpinsert(fp));
				else {
					#ifdef DEBUG
					printf("\n FOPEN: could not open file\n");
					printf("\n Call:\n%Fs\n%Fs\n", string1, string2);
					#endif
					outint(0);
				}
				break;
			}
			case (FCLOSE): {
				/* NOTE: Correct operation returns 0! */
				/* Check for incorrect channel # or extra arguments */
				if(!getint(&channel) || insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n FCLOSE: bad arguments\n");
					#endif
				}
				else if((fp= fpfetch(channel)) == NULL) {
					outint(1);
					#ifdef DEBUG
			printf("\n FCLOSE: could not find channel %d\n", channel);
					fpcheck();
					#endif
				}
				else if(fclose(fp) != 0) {
					#ifdef DEBUG
					printf("\n FCLOSE: could not close file\n");
					#endif
					outint(1);
				}
				else {
					fpdelete(channel);  /* Assume works */
					outint(0);
				}
				break;
			}
			case (GETCHAR): {
				/* Check for no arguments */
				if(insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n GETCHAR: bad call (arguments present)\n");
					#endif
				}
				/* Get keyboard character and put in output file */
				else outint(getchar());
				break;
			}
			case (GETKEY): {
				/* Check for no arguments */
				if(insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n GETKEY: bad call (arguments present)\n");
					#endif
				}
				/* Get keyboard character and put in output file */
				else outint(getkey());
				break;
			}
			case (PUTCHAR): {
				/* Get argument */
				if(getint(&ioint) && !insize) outint(putchar(ioint));
				else {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n PUTCHAR: bad call argument\n");
					#endif
				}
				break;
			}
			case (GETS): {
				/* Check for no arguments, string buffer pointer
				 * kept at other end of link */
				if(insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n GETS: bad call (arguments present)\n");
					#endif
				}
				/* Get keyboard data. If error on fetch or place,
				 * the buffer gets no data, which is equivalent
				 * to sending NULL.
				 */
				else outstr(gets(outptr));
				break;
			}
			case (GETC): {
				/* Check for incorrect channel # or extra arguments */
				if(!getint(&channel) || insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n GETC: bad channel # data\n");
					#endif
				}
				else if((fp= fpfetch(channel)) == NULL) {
					outint(EOF);
					#ifdef DEBUG
					printf("\n GETC: could not match channel #\n");
					#endif
				}
				/* Get character from file and put in output
				 * buffer. Returns character (or EOF) as integer.
				 */
				else outint(getc(fp));
				break;
			}
			case (PUTC): {
				/* Check for incorrect calls or extra arguments */
				if(!getint(&ioint) || !getint(&channel) || insize) {
					putflag(BADARGS);
					#ifdef DEBUG
					printf("\n PUTC: incorrect argument types\n");
					#endif
				}              
				else if((fp= fpfetch(channel)) == NULL) {
					outint(EOF);
					#ifdef DEBUG
					printf("\n PUTC: could not match channel #\n");
					#endif
				}
				else outint(putc(ioint, fp));
				break;
			}
			case (EXIT): {
				/* Always exit (may have garbage on line) */
				if(getint(&ioint) && !insize) exit(ioint);
				else {
					putflag(BADARGS);
					#ifdef DEBUG
	printf("\n EXIT: bad call: call= %x  bufsize= %d\n", ioint, insize);
					#endif
					exit(0x0FFF);  /* Worst case? */
				}
				/* SHOULD NEVER GET HERE */
				break;
			}

			case (DIRECT): {
			/* Communicate via COM1. Exit to DOS if receive
			 * "^C" from the link.
			 */
				int key;

				bioscom(1, DIRECT, port);     /* Echo */
				#ifdef DEBUG
				printf("\n In direct mode\n");
				#endif
				
				ioloop:

				/* Check for keyboard char. If present send out COM1 */
				if (bioskey(1) != 0) {
					key= bioskey(0);
					if (key == ESCKEY) {
						printf("\n Keyboard exit to DOS not allowed\n");
					}
					else 
						bioscom(1, key, port);
				}
				/* Check for COM1 input. If present, send to screen */
				if ((bioscom(3, NULL, port) & 0X100) != 0) {
					key= bioscom(2, NULL, port);
					if (key == CTLC) {
						if(fpunused(0)) exit(0);
						printf("\n Open files: exit to DOS not allowed\n");
					}
					else if(key == PACKET) {
							putflag(PACKET);    /* Echo */
							#ifdef DEBUG
							printf("\n In packet mode\n");
							#endif
							break;              /* Exit to main loop */
					}
					else
						putch(key);
				}
				/* Do again */
				goto ioloop;
			}
			default: {
				#ifdef DEBUG
				printf("\n Unknown call: %d \n", type);
				pbuf();
				#endif
				putflag(BADCALL);
			}
		}
		sendblock();             /* Send reply */
	}
}

/* Put flag in output buffer. Resets buffer so
 *   can be used if need to exit with a major
 *   error. Returns flag.
 */
char putflag(flag)
char flag;

{
	outptr= outblock;
	*outptr++= flag;
	outsize= 1;
	return(flag);
}

/* Empty file entry check. Use before attempting
 *   to open a file. Looks at all but the 0 entry.
 *   If NULL found returns the entry #, else
 *   returns 0.
 */
fpavail()

{
	int  entry;

	for(entry= 1; entry < FMAX; entry++)
		if(fparray[entry] == NULL) return(entry);
	return(0);
}

/* File open check:
 *   If no files open (except for
 *   "stdio") returns 1, else 0.
 */
fpunused()

{
	int  entry;

	for(entry= 4; entry < FMAX; entry++)
		if(fparray[entry] != NULL) return(0);
	return(1);
}

/* File pointer insert. Looks at all but the
 *   0 entry. If NULL found the entry is set
 *   to the file pointer and the entry # returned.
 *   If the pointer is already present returns
 *   with the entry #. If neither happens 0 is
 *   returned.
 */
fpinsert(fptr)
FILE *fptr;

{
	int  entry;

	for(entry= 1; entry < FMAX; entry++) {
		if(fparray[entry] == fptr) return(entry);
		else if(fparray[entry] == NULL) {
			fparray[entry]= fptr;
			return(entry);
		}
	}
	return(0);
}

/* File pointer fetch. Enter with the entry
 *   # and will return with the file pointer.
 *   If returns with NULL the entry was unused
 *   or # >= FMAX.
 */
FILE *fpfetch(entry)
int  entry;

{
	if(entry >= FMAX) return(NULL);
	return(fparray[entry]);
}

/* File pointer delete. Enter with the entry
 *   # to delete (entry 0 should always be
 *   NULL). If fparray[#] == NULL or # >= FMAX
 *   or # <= 3 will return 0, else sets entry
 *   to NULL and returns 1.
 */
fpdelete(entry)
int  entry;

{
	if((entry <= 3)||(entry >= FMAX)||(fparray[entry] == NULL)) return(0);
	fparray[entry]= NULL;
	return(1);
}

/* Put byte into output block.
 * If no room, exit false.
 */
outchr(putbyte)
char putbyte;

{
	if(outsize >= BMAX) return(0);
	*outptr++= putbyte;
	outsize++;
	return(1);
}

/* Put 16 bit integer into output block.
 * High byte first, low byte next.
 * If no room exit false.
 */
outint(putint)
int putint;

{
	if((outsize + 2) > BMAX) return(0);
	*outptr++= (putint >> 8);
	*outptr++= putint;
	outsize += 2;
	return(1);
}

/* Put string into output block.
 * If run out of room or
 * pointer == NULL, exit false with
 * no data transferred.
 */
outstr(putstring)
char far  *putstring;

{
	saveptr= outptr;
	savesize= outsize;
	if(putstring == NULL) return(0);   /* Safety check */
	while(outsize < BMAX) {
		outsize++;
		if((*putstring++= *outptr++) == '\0') return(1);
	}
	outptr= saveptr;
	outsize= savesize;
	return(0);
}

/* Get byte from input block.
 * If no room, exit false.
 */
getchr(getbyte)
char *getbyte;

{
	if(!insize) return(0);
	*getbyte= *inptr++;
	insize--;
	return(1);
}

/* Get 16 bit integer from input block.
 * High byte first, low byte next.
 * If no room exit false.
 */
getint(blkint)
int  *blkint;

{
	if(insize < 2) return(0);
	*blkint= ((*inptr++) << 8) & 0xFF00;
	*blkint |= ((*inptr++) & 0xFF);
	insize -= 2;
	return(1);
}

/* Get string from input block.
 * Returns pointer to string if
 * found, else returns NULL.
 */
char far *getstr()
{
	saveptr= inptr;
	savesize= insize;
	while(insize) {
		insize--;
		if(*inptr++ == '\0') return(saveptr);
	}
	inptr= saveptr;
	insize= savesize;
	return(NULL);
}

/* Get port data till timeout.
 *   If overflow, serial input error or data
 *   already waiting will set up the output
 *   block error status and return 0.
 *
 * NOTE:  Any keyboard activity during transfer causes
 *        characters to be dropped when running at
 *        57.6 Kbaud.
 */
getblock()
{
	long int delay;

	inptr= inblock;
	insize= 0;
	
	/* Check for data already waiting */
	if (RDY & (stat= bioscom(3, NULL, port))) {
		putflag(PHASING);
		#ifdef DEBUG
		printf("\n Input block phasing error.\n");
		#endif
		return(0);
	}

	/* Wait for start */
	while(!(RDY & (stat= bioscom(3, NULL, port))));

	/* Check for data error */
	if ((OER | FER | PER) & stat) {
		#ifdef DEBUG
		printf("\n Data input error (waiting) %x\n", stat);
		#endif
		putflag(BADBYTE);
		return(0);
	}

	/* Get first byte to make up for delay loop setup time */
	*inptr++= bioscom(2, NULL, port);
	insize++;

	/* Wait for data or timeout */
	for (delay= 0; delay < timeout; delay++)
	{
		/* Get data (if ready) and check for data error */
		if (RDY & (stat= bioscom(3, NULL, port)))
		{
			if (insize >= BMAX)
			{
				#ifdef DEBUG
				printf("\n Input data block too large\n");
				#endif
				putflag(OVERFLOW);
				return(0);
			}
			*inptr++= bioscom(2, NULL, port);
			insize++;
			delay= 0;
		}
		/* See if data error */
		else if ((OER | FER | PER) & stat)
		{
			#ifdef DEBUG
			printf("\n Data input error (loading) %x\n", stat);
			#endif
			putflag(BADBYTE);
			return(0);
		}
	}

	inptr= inblock;               /* Reset input pointer */
	return(1);
}

/* Send data in output block (Assumes receiver
 *   is waiting. Block always starts with a
 *   reply flag (byte) followed by data. No
 *   data represents a NULL or EOF, depending
 *   on the call. The reply flag is always the
 *   same as the call flag unless there is a
 *   major error.
 */
sendblock()
{
	outptr= outblock;

	while(outsize)
	{
	bioscom(1, *outptr++, port);
	outsize--;
	}
}

/* Return an absolute time figure in hundredths of a second.
*/
long int timer()
{
struct timeb elapsed;

	ftime(&elapsed);
	return ((elapsed.time*1000) + (elapsed.millitm));
}

/* Determine cycles for "N" characters out.
 * "nchar" is the number of characters and
 * "timeout" is the maximum number of cycles
 * allowed. If timed out return 0, else
 * return the number of cycles taken.
 *
 * long Chkchrs(int nchar, long timeout)
 */
long int chkchrs(nchar, maxcycles)

int nchar;
long int maxcycles;
{
	long int delay;
	/* wait till serial output registers entirely empty */
	while (!((XSE|XHE) & (stat= bioscom(3, NULL, port))));
	nchar += 2; /* fill both registers */
	for (delay= 0; delay < maxcycles; delay++)
	{
		/* Fake data fetch */
		if (XHE & (stat= bioscom(3, NULL, port)))
		{
			if (!(nchar--)) break;
			bioscom(1, 0, port);
		}
		else if (0 & stat)
		{
		}
	}
	if (delay == maxcycles) return(0);
	return(delay);
}

/* Print input buffer for test purposes */
pbuf()

{
	int  i= 0;
	saveptr= inblock;
	savesize= insize;
	printf("\n\n");
	while(savesize--) {
		printf(" %Fc  %Fx :", *saveptr, *saveptr);
		i++;
		if(i >= 8) {
			printf("\n");
			i= 0;
		}
		saveptr++;
	}
}
/* Print check of file pointer array entries */
fpcheck()

{
	int  i;
	printf(" File pointer array entry check:\n");
	for(i= 0; i < FMAX; i++) {
		printf("   %d  ", i);
		if(fparray[i] == NULL) printf("NULL\n");
		else printf("In use\n");
	}
}

