/*
HEADER:         Definitions.;
TITLE:          Small-C Compiler for 6809 FLEX system;
VERSION:        2.3;

DESCRIPTION:    "Small-C Compiler definitions."
KEYWORDS:       ;
SYSTEM:         6809 FLEX;
FILENAME:       CCDEF.C;
WARNINGS:       "Requires TSC relocatable assembler, library generater and
		linking loader."

SEE-ALSO:       ;
AUTHORS:        Dieter H. Flunkert;
COMPILERS:      VAX VMS C compiler;
MODIFICATIONS:  ; 11-7-98 F. Wilson: Changed some parts to self compile on
		  both the 6809 and 68HC11. Compilers used are the Motorola
		  "freeware" compilers with slight modifications.
*/

/*#define CPU*/      /* if run on target processor */
/*#define CC6809*/   /* if generate code for a 6809 */
/*#define CC68HC11*/ /* if generate code for a 68HC11 */
/*#define CCZ80*/    /* if generate code for a Z80 */
/*#define OPTIMIZE*/ /* if want to include optimizer */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#define MAXINC 9  /* inclusive file pointer array size */
#define VERSION "small-c V2.3"
#define BREAK 3
#define PHASE2
/* Edited 25-Jan-82 Jeff Lomicka  */
/* - Test and fix changes of 23-sep-81 */
/* - VMS version, open for write is weird */
/*   main returns status code 2 on error. */
/* Edited 23-Sep-81 to incorporate changes from */
/* Dr. Dobbs Journal, Feb. 81    */
/* Changed for 6809 CPU from Dieter Flunkert    */
/*        06-Nov-85                             */
/* Define system dependent parameters */
/* Stand-alone definitions   */
#define TAB 9   /* For output file spacing. If not def is one space */
#define EOL 10  /* Line feed $A. FLEX uses Carriage Return $D */
#define YES 1
#define NO 0
#define SWSIZ 4
#define SWTABSZ 100
#define ERRCODE 0
/*
** define static table
*/
#define stattbsize 690
#define statlabel 14
#define statsize 23
/* Define the symbol table parameters */
#define symsiz 14
#define symtbsz 8008
#define numglbs 512
#define MASKGLBS 511
#define startglb symtab
#define startstat stattab
#define endglb startglb+numglbs*symsiz
#define endstat startstat+stattbsize
#define startloc endglb+symsiz
#define endloc symtab+symtbsz-symsiz
/* Define symbol table entry format */
#define name 0
#define ident 9
#define type 10
#define storage 11
#define offset 12
#define offsize 2
/* System wide name size (for symbols) */
#define namesize 9
#define namemax  8
/* Define possible entries for "ident" */
#define variable 1
#define array 2
#define pointer 3
#define function 4
#define MACRO 5
#define LABEL 6
/* Define possible entries for "type" */
#define cchar (1<<2)
#define cint (2<<2)
/* Define possible entries for "storage" */
#define statik 1
#define stkloc 2
#define EXTERNAL 3
#define automatic 4
/* Define the "while" statement queue */
#define wqtabsz 100
#define wqsiz 4
#define wqmax wq+wqtabsz-wqsiz
/* Define entry offsets in while queue */
#define wqsym 0
#define wqsp 1
#define wqloop 2
#define wqlab 3
/* Define the literal pool   */
#define litabsz 1000
#define litmax litabsz-1
/* Define the input line   */
#define linesize 90
#define linemax linesize-1
#define mpmax linemax
/* Define staging buffer size  */
#define stagesize 1200
/* Define the macro (define) pool  */
#define macqsize 500
#define macmax macqsize-1
/* Define statement types (tokens)  */
#define stif 1
#define stwhile 2
#define streturn 3
#define stbreak 4
#define stcont 5
#define stasm 6
#define stexp 7
#define STDO 8
#define STFOR 9
#define STSWITCH 10
/*#define STGOTO 11*/
#define STCASE 12
#define STDEF 13
/*#define STLABEL 14*/
#define libsize linesize /* LIBPATH plus file name should fit */
#ifdef CC6809
#define LIBPATH "\\tcj_sub.09\\small-c\\compiler\\lib09\\"
#else
#ifdef CC68HC11
#define LIBPATH "\\tcj_sub.09\\small-c\\compiler\\lib11\\"
#else
#ifdef Z80
#define LIBPATH "\\tcj_sub.09\\small-c\\compiler\\lib80\\"
#endif
#endif
#endif
