*****        IOMON     *****
*
* AUTHOR: Frank J. Wilson
*   DATE: March 25, 1985
*    USE: Machine language program monitor.
*         Assemble as "B19" records and download
*         into the target computer. Source
*         computer acts as terminal via the
*         serial printer port at 57600 baud
*         with 2 stop bits (no parity). To
*         upload at full speed to a PC a special
*         receiving program must be used.
*  SCOPE: Intended for public domain use.
*  C-P-U: 2 Mhz 6809.
*  OPSYS:
*  MODS.: (1) 1-29-94 Modified to run on the
*         Color Computer 3 only. Uses external
*         I/O routines loaded into RAM from a
*         ROM program on cassette.
*         (2) 2-9-94 Loads against end of memory and
*         fixes I/O routine vectors.
*         (3) 2-27-94 Fixed command table and G command.
*         (4) 4-9-94 Put breakpoint delete in the I, D
*         and U commands. Added D and U explanations to
*         the writeup. Put exit handshaking in the D
*         command.
*         (5) 4-28-94 Modified UPLOAD protocol.
*         (6) 1-23-94 Changed to use data link protocol.
*         Link allows PC to be used as a file server.
*
* THEORY:
*  On initial entry all program registers except the
*  stack and program counter are set to 0. The stack
*  is set to the incoming value and the PC points
*  back to the monitor command decode. The program stack
*  length MUST include enough room for the SWI. Note that
*  Interrupts are turned off on initial monitor entry, and
*  that the SWI also turns off the interrupts while in the
*  monitor. Since the NMI interrupt cannot be turned off,
*  extra space is included in the monitor stack.
*  Breakpoints use the SWI. If an SWI occurs and the
*  breakpoint is not found in the breakpoint table, the
*  program cannot continue execution until the SWI is
*  removed using the M command or is bypassed using the
*  "control" P command. This problem can be detected by
*  the presence of a question mark after the monitor prompt
*  when the breakpoint is hit.
*
* COMMANDS:
*  The monitor prompt is ">", and is followed by the
*  keyboard commands. In the following explanation, <CR>
*  represents a carriage return, Hex numbers are shown as
*  H and ASCII characters as A. Keyboard inputs are
*  underlined. Some commands do not require a carriage
*  return. A mistake in a command sequence will cause an
*  immediate exit. To halt a printout press any key except
*  ESC, which exits the communication link. The same to
*  resume printing, except for <CR> which will return to
*  to the monitor.
*
* 1) >M HHHH <CR>
*     - ---- ----
*
*  This opens a memory location for examination or change.
*  Memory contents are printed in Hex and ASCII. Four
*  operations are now possible. The "<" key will go to the
*  next lower location, while the ">" key will go to the
*  next higher one and a carriage return will return to
*  the monitor. While a location is open the contents can
*  be changed using either Hex or ASCII input. For hex,
*  input two Hex digits (0-9 or A-F). For ASCII, first
*  enter a single quote followed by the character. When a
*  location has been changed the next higher one is
*  automaticaly opened.
*
* 2) >B HHHH
*     - ----
*  Put a breakpoint in memory. When program execution
*  reaches this point the monitor is recalled and the
*  previous memory contents are restored. The program may
*  be continued (using the G command) or other operations
*  may be performed.
*
*    >B <CR>
*     - ----
*  When no memory location is input a list of the present
*  breakpoints will be printed. Each item will include the
*  location number in the breakpoint table for use in the
*  X command. The breakpoint the monitor was entered from
*  (except on initial entry or when it has been removed
*  by the X command) will be followed by an asterisk.
*  On the next break it will be restored.
*
* 3) >R
*     -
*  A list of the program registers will be printed out.
*  Register contents can be changed by using a control
*  character (such as "control" A for the A register)
*  followed by the new contents. Condition codes are a
*  special case. The codes will be printed out as the
*  ASCII prompts for the active positions. All the prompts
*  will then be printed underneath. Eight keyboard inputs
*  are required to make a change. For each bit position, 1
*  will activate the bit, 0 will deactivate it and a space
*  will leave it as is.
*
* 4) >G
*     -
*  Continue to execute the program.
*
* 5) >X HH
*     - --
*  Delete a breakpoint. Input the breakpoint table entry
*  number. This can be found with the B command.
*
*    >X <CR>
*     - ----
*  Delete all breakpoints.
*
* 6) >T
*     -
*  Prints the change in program flow if the next program
*  instruction is an RTS.
*
* 7) >D HHHH HHHH
*     - ---- ----
*  Display the contents of memory in Hex and ASCII. Give
*  the start and finish locations as four digit Hex
*  numbers. Finish must be >= start.
*
*    >D <CR>
*     - ----
*  Same as above, using the addresses from the last D, F
*  or S command.
*
* 8) >F HHHH HHHH HH
*     - ---- ---- --
*  Fill memory. The start and finish addresses are input
*  first, followed by the desired fill byte.
*
* 9) >S HHHH HHHH HH 'A 'A HH <CR>
*      - ---- ---- -- -- -- -- ----
*  Search memory for a data string. Hex (or ASCII as
*  in the M command) is input after the start and finish
*  addresses. Miximum string length is given by BUFLEN. If
*  the buffer is full only a <CR> will be accepted.
*
* 10) >H
*      -
*  Prints all the command prompts.
*
* 11) >L
*
*  Load "S19" or "B19" records via the serial input port.
*  Use the "G" command to start the program. Note that
*  the loader can only exit if there is a start record.
*  This command deletes all breakpoints.
*

UPAROW EQU '< Code for up-arrow key (use with SHIFT key).
DNAROW EQU '> Code for down-arrow key (use with SHIFT key).
SPACE EQU $20 ASCII space.
CRET EQU $D Carriage return.
LFEED EQU $A Line feed.

* MONITOR EQUATE.

NBP EQU 16 # OF BREAKPOINTS.
BUFLEN EQU 20 String buffer length.

 ORG $100

* Initial startup code. Overlayed with
* program RAM.

Movcode LDA     #$D0            TURN OFF ALL INTERRUPTS.
	TFR     A,CC
;        clra                    Set to 9600 baud.
;        ldd     #9600
;        jsr     [>Setbaud]
_movwt  jsr     [>Serinptr]
	cmpa    #DLE            LINK09 startup.
	bne     _movwt
	ldd     [>Memend]
	subd    #Monend-1
	std     Move
	ldd     #Monitor-1      Reset MEMEND.
	addd    Move
	std     [>Memend]
	ldx     #CMDTBL         Update command table vector locations.
Cmove   tst     ,X+
	beq     Moveprg
	ldd     ,X
	addd    Move
	std     ,X++
	ldd     ,X
	addd    Move
	std     ,X++
	bra     Cmove
Moveprg ldx     #Stack          Move program against I/O routines.
	tfr     X,D
	addd    Move
	tfr     D,Y
Shift   lda     ,X+
	sta     ,Y+
	cmpx    #Monend
	bne     Shift
	ldd     #Start
	addd    Move
	tfr     D,PC            Set up and start monitor.
Move    rmb     2               Amount to move Monitor.

* Following will be moved against to the
* top of free RAM. It consists of stack
* data for the "G" command and the monitor.
* The memory end pointer will be reset to
* just below the monitor.

* RTI data for the "G" command.

Stack: rmb 12

* Monitor program:

Monitor:

* Program storage locations.
* If program is put in ROM, these must
* be in RAM.

NPTR RMB 2 Breakpoint restore pointer.

* BREAKPOINT TABLE. NBP= # OF ENTRIES.
* EACH ENTRY STARTS WITH THE USE FLAG.
* IF USED THE FLAG >< 0. NEXT LOCATION
* IS THE CODE AND THE NEXT TWO LOCATIONS
* ARE THE MEMORY POINTER.

BTABLE RMB 4*NBP

* Program temporary storage locations.

TSTACK RMB 2 TRACE STACK POINTER.
TEMP RMB 1 TEMPORARY STORAGE FOR GET2.
BCOUNT RMB 1 STORE B.P. COUNT.
BNBR RMB 1 Breakpoint #.
TEMP2 RMB 2 SAVE MEMORY POINTER.
BLOCK RMB 2 Block operation start.
BLKEND RMB 2 Block operation end.
FLXCHR RMB 1 Input char. save.
Savstat RMB 1 Save link status on SWI.

* Search buffer.

SBUFR RMB BUFLEN

* Monitor stack. Maximum use is 45 bytes.
* For safety, 60 are used (in case of NMI).

 RMB 100 Monitor stack.
MSTACK

* Startup routine.

Start   lda     #$D0            Turn off interrupts.
	tfr     A,CC
	leax    >BTABLE,PCR
	stx     >NPTR,PCR        Set to valid entry.
	ldd     #MSTACK-BTABLE  Amount to clear.
Bsetlp  clr     ,X+             Clear almost everything.
	addd    #-1
	bne     Bsetlp
	leax    >Stack,PCR       Set up RTI data.
	stx     >TSTACK,PCR
	tfr     X,S             Establish stack.
;        clra                    Set baud rate to 9600.
;        ldd     #9600
;        jsr     [>Setbaud]
	jsr     >setdir         Direct I/O.
	lda     Lnkstat         Save link status.
	sta     >Savstat,PCR
	tfr     S,X             X changed by SETBAUD.
	lda     #$D0            Default condition codes.
	sta     ,X+             Store.
	lda     #9              Clear registers.
Deflt   clr     ,X+
	deca
	bne     Deflt
	leay    >ENTRY,PCR      Set PC to Monitor.
	sty     ,X
	leax    >Monitor-1,PCR  Memory end next to monitor.
	stx     [>Memend]
	leax    Stmsg,PCR
	lbsr    PSTRNG
	lbra    ENTRY           Start Monitor.
	
* Keyboard character input routine.
* Masks char. to 7-bit and returns char.
* in location FLXCHR if present. Also
* clears FLXCHR on exit.

FLXIN LDA >FLXCHR,PCR
 BNE FLXRTN
 JSR [>ClrLnptr]
 CMPA #$5F Check for lower case.
 BLS FLXRTN No.
 ANDA #$5F Drop lower case.
FLXRTN CLR >FLXCHR,PCR
 CMPA #CRET Check for C-R.
 RTS

* Keyboard character output routine.
* Also clears location FLXCHR.

FLXOUT  cmpa    #CTRLC          Do not do ^C exit.
	beq     FLXRTN
	cmpa    #PACKET         Or link mode change.
	beq     FLXRTN
	PSHS    A,B
	JSR     [>ConOutptr]
	PULS    A,B
	BRA     FLXRTN

* Inactivate breakpoint. Enter with X register
* pointing to the table location.

MRSTR LDA 1,X GET B.P. CODE.
 STA [2,X] RETURN TO MEMORY.
 CLR ,X CLEAR B.P. FLAG.
 RTS

* Activate breakpoint. Enter with X register
* pointing to the table location.

MSET LDA [2,X] GET CODE.
 STA 1,X SAVE.
 INC ,X FLAG B.P.
 LDA #$3F PUT SWI IN MEMORY.
 STA [2,X]
 RTS

* Check B.P. pointed to by X. If pending
* restore it.

CKLAST TST ,X
 BPL NOTPND
 CLR ,X
 BSR MSET
NOTPND RTS

* SOFTWARE INTERRUPT JUMP.

MONITR STS >TSTACK,PCR SAVE PROGRAM STACK.
 LDD 10,S FIX PROGRAM COUNTER.
 ADDD #-1
 STD 10,S D= interrupt location.
 LEAS >MSTACK,PCR SET STACK.
 pshs   D                       For breakpoint match.
 lda    Lnkstat                 Save incoming link status.
 sta    >Savstat,PCR
 jsr    >setdir                 Direct I/O.
 puls   D
 LBSR BMATCH SEE IF OUR SWI.
 BNE REMOVB IF YES.
PQST LDA #'? INDICATE NOT ACCEPTABLE.
 BSR FLXOUT
 BRA ENTRY
REMOVB LDD >NPTR,PCR
 STX >NPTR,PCR
 TFR D,X Put B.P. in X.
 BSR CKLAST Restore B.P. if pending.
 LDX >NPTR,PCR
 BSR MRSTR
 LDA #$80
 STA ,X
REGDMP lbsr PNTREG ALWAYS WANT THESE.

* Monitor main entry point for keyboard
* input decoding.

ENTRY   LEAS    >MSTACK,PCR     Set monitor stack.
	jsr     >setdir
	lbsr    CRLF
	LEAX    >MONMSG,PCR     PRINT PROMPT.
	LBSR    PSTRNG
	LBSR    FLXIN           GET COMMAND.
CHKLP   TST     ,X
	LBEQ    REGCMD
	CMPA    ,X+             SEE IF MATCH.
	BEQ     GTCMD
	LEAX    4,X             GO TO NEXT COMMAND.
	BRA     CHKLP
GTCMD   LBSR    CRECHO          SPACE TO NEXT CHAR.
	JMP     [,X]            GO TO ROUTINE.
MONMSG  FCC     '> '
	FCB     $4
CMDTBL  FCB     '?              Print command prompts.
	FDB     HELP,HMSG
	FCB     '/              Print command prompts.
	FDB     HELP,HMSG
	FCB     'M              Memory display and change.
	FDB     MEMCHK,MMSG
	FCB     'B              Breakpoint display and change.
	FDB     BRKPT,BMSG
	FCB     'R              Register dump.
	FDB     REGDMP,RMSG
	FCB     'G              Go (start program execution).
	FDB     RUNPGM,GMSG
	FCB     'X              Remove breakpoints.
	FDB     XOUT,XMSG
	FCB     'T              Trace (assume stack has RTS).
	FDB     TRACE,TMSG
	FCB     'D              Display (show memory block).
	FDB     LIST,DMSG
	FCB     'F              Fill (change memory block).
	FDB     FILL,FMSG
	FCB     'L              Input "B19" records (serial port).
	FDB     LOAD,LMSG
	FCB     'S              String search.
	FDB     SEARCH,SMSG
	FCB     0               End of table.

* Print prompts for all commands.

HELP:
 LEAX -1,X
HPRINT:
 TST ,X
 BNE _HPRNT
 lbsr CRLF
 LEAX >BNDMSG,PCR
 lbsr PSTRNG
 LEAY >BLOCK,PCR
 lbsr PNTWO
 lbsr PNT4
 LBRA ENTRY
_HPRNT lbsr CRLF
 LDA ,X+
 lbsr FLXOUT
 PSHS X
 LDX 2,X
 lbsr PSTRNG
 PULS X
 LEAX 4,X
 BRA HPRINT

LOAD    lbsr    XSUB            Delete breakpoints.
	jsr     >extlnk         Go to server operating system.
	ldd     [>Ldrbaud]      Save loader baud rate.
	pshs    D
	ldd     #57600          Set to high speed.
	jsr     [>Setldr]
	jsr     [>Loadptr]      Exit with status and startup character.
	pshs    A,CC            Save exit status.
	lda     #CTRLC          Exit communication link.
	jsr     [>Fastptr]
	bra     _chkxit
Slxit   jsr     [>Serinptr]     Wait for link09 startup.
_chkxit cmpa    #DLE
	bne     Slxit
	puls    A,CC            Restore status.
	exg     D,X             Save exit character.
	puls    D               Restore baud rate.
	pshs    CC              Save till after link setup.
	std     [>Ldrbaud]
	jsr     >setdir         Direct I/O (link09 starts in "packet" mode).
	exg     X,D             Restore exit character.
	puls    CC              Now process load status.
	lbne    PQST            Error in loading.
	cmpa    #XON
	lbne    PQST            Error in communication startup.
	ldx     >TSTACK,PCR     Get stack
	sty     10,X            Set PC to start address.
	lbra    ENTRY

REGCMD LEAX >STKMSG,PCR SEE IF REGISTER CHANGE COMMAND.
 ADDA #$40 SET ^ TO NORMAL CHAR.
 CMPA #'C Do condition codes separately.
 LBEQ SETCC
REGCHK TST ,X CHECK FOR DONE.
 LBEQ ENTRY COULD NOT DECODE COMMAND.
 CMPA ,X CHECK COMMAND.
 BEQ GOTREG
MSGBP LDB ,X+
 CMPB #4
 BNE MSGBP
 LEAX 2,X
 BRA REGCHK
RPROMT BSR PSTRNG PRINT REGISTER PROMPT.
 LDA #'=
CRECHO lbsr FLXOUT
 BRA PSPACE
SETREG BSR RPROMT PRINT REGISTER MESSAGE.
 LDY >TSTACK,PCR SET STACK POINTER.
 LDD ,X++ GET OFFSET AND # BYTES.
 LEAY A,Y SET POINTER.
 RTS
GOTREG BSR SETREG PRINT PROMPT AND SET X AND Y.
 CMPB #1
 BNE SET4
 LBSR GET2
 STB ,Y
 BRA SETRTN
SET4 LBSR GET4
 STD ,Y
SETRTN lbra ENTRY

* PRINT BYTE IN HEX.
* ENTER WITH Y= POINTER.

PNT2 LDA ,Y
 BSR FIRST
 LDA ,Y+
 BRA SECOND

* PRINT DOUBLE BYTE IN HEX.
* ENTER WITH Y= POINTER.

PNT4 BSR PNT2
 BRA PNT2

* Print first half of A as a hex digit.

FIRST LSRA
 LSRA
 LSRA
 LSRA

* Print second half of A as a hex digit.

SECOND ANDA #$F
 SUBA #10
 BLO SNBR
 ADDA #'A
SCHR lbra FLXOUT
SNBR ADDA #10+'0
 BRA SCHR

* PRINT SPACE.

PSPACE LDA #SPACE GET SPACE.
 lbra FLXOUT PRINT IT.

* PRINT # SPACES IN B.

PBLNKS BSR PSPACE
 DECB
 BNE PBLNKS
 RTS

* PRINT STRING. POINTER IN X.

PSTRLP lbsr FLXOUT
PSTRNG LDA ,X+
 CMPA #4
 BNE PSTRLP
 RTS

* DECODE HEX DIGIT.
* DIGIT IN A. IF RETURN NEGATIVE
* IS NOT HEX.
* BINARY EQUIVALENT RETURNED IN B,
* A IS UNCHANGED.

HEXDEC TFR A,B
 SUBB #'0
 BLO NOTHEX
 CMPB #'9-'0
 BHI HEXDGT
HXRTRN TSTB SET PROPER CONDITION CODES.
 RTS
HEXDGT SUBB #'A-'0
 BLO NOTHEX
 CMPB #'F-'A
 BLS HEXRST
NOTHEX LDB #$80-10
HEXRST ADDB #10
 BRA HXRTRN

* GET DIGIT INTO B.

GETDGT lbsr FLXIN
 BEQ PQSTN Was C-R.
DGCHK BSR HEXDEC
 BMI PQSTN
 lbra FLXOUT

* Get keybord input either in ASCII or as two
* HEX digits. Input is in HEX unless the first
* character input is a single quote.

GET2A lbsr FLXIN
 CMPA #''
 BNE NOT2A
 lbsr FLXOUT
 JSR [>Serinptr]
 TFR A,B
 lbra PNTASC
NOT2A STA >FLXCHR,PCR

* GET TWO HEX DIGITS INTO B.

GET2 BSR GETDGT
FIX2 LSLB
 LSLB
 LSLB
 LSLB
 STB >TEMP,PCR
 BSR GETDGT
 ADDB >TEMP,PCR
 RTS

* GET FOUR HEX DIGITS INTO D.

GET4 BSR GET2
 PSHS B
 BSR GET2
 PULS A,PC

* SET BREAKPOINTS.

BRKPT lbsr FLXIN Get next input char.
 BEQ PNTBP Input was a C-R.
 STA >FLXCHR,PCR No. Restore input.
 BSR BEMPTY CHECK FOR ANY EMPTYS.
 BEQ PQSTN
 BSR GET4 GET DESIRED P.C.
 LBSR BMATCH CHECK FOR ALREADY USED.
 BEQ READY Not used.
 lbsr CKLAST Restore if pending.
 BRA REENTR
READY BSR BEMPTY GET EMPTY LOCATION IN X.
 STD 2,X STORE P.C.
 lbsr MSET
REENTR LBRA ENTRY
PQSTN LBRA PQST NON-ACCEPTABLE DATA.

* PRINT BREAKPOINTS.

PNTBP LBSR BSETUP Set breakpoint param.
BTEST BSR BFULL
 BEQ REENTR
 lbsr CRLF Start on new line.
 LEAY >BNBR,PCR Print breakpoint #.
 lbsr PNTONE
 TFR X,Y Set up # pointer.
 LEAY 2,Y Get # location.
 lbsr PNTWO Print breakpoint.
 TST ,X See if to be restored.
 BPL BTNXT No.
 LDA #'* Yes. Flag it.
 lbsr FLXOUT
BTNXT BRA BTEST

* Find full B.P. location. If found, exit
* with >< condition and X= table entry.
* If exit with an = condition, none were
* found. Do BSETUP before first entry.

BFULL TST >BNBR,PCR
 BEQ NEWNBR
BNXT BSR BINCR
 BEQ BFRTN
NEWNBR INC >BNBR,PCR
 TST ,X
 BEQ BNXT
BFRTN RTS Exit subroutine.

* CHECK FOR EMPTY B.P. LOCATION.
* IF FOUND, COUNT >< 0 AND X= EMPTY TABLE ENTRY.

BEMPTY BSR BSETUP
BKLOOP TST ,X
 BEQ BMCH
 BSR BINCR
 BNE BKLOOP
 BRA BMCH

* RESET BREAK POINTS.

XOUT lbsr FLXIN Get command.
 BNE XONE Only delete one.
 BSR XSUB Delete all breakpoints.
EXITX BRA REENTR Go to main loop.
XONE STA >FLXCHR,PCR Restore input.
 lbsr GET2 Get breakpoint #.
 BSR BSETUP Set up table search.
XNEXT BSR BFULL Get breakpoint.
 LBEQ PQST Bad call.
 CMPB >BNBR,PCR Desired entry?
 BNE XNEXT No.
 lbsr MRSTR Clear B.P.
 BRA EXITX Done.

* Delete all active breakpoints.

XSUB BSR BSETUP Set up table parameters.
XLOOP BSR BFULL Get breakpoint.
 BNE XDEL Return when done.
 RTS
XDEL lbsr MRSTR Delete breakpoint.
 BRA XLOOP Do next.

* CHECK FOR MATCH BETWEEN CODE IN D REGISTER AND THE
* B.P. TABLE. IF FOUND, COUNT >< 0 AND X= TABLE
* LOCATION.

BMATCH BSR BSETUP
BTST TST ,X
 BEQ BNEXT
 CMPD 2,X
 BEQ BMCH
BNEXT BSR BINCR
 BNE BTST
BMCH TST >BCOUNT,PCR
 RTS

* SET NEXT TABLE LOCATION IN X AND DECREMENT
* ENTRY COUNT.

BINCR LEAX 4,X SET TO NEXT B.P. LOCATION.
 DEC >BCOUNT,PCR TEST FOR DONE.
 RTS

* SET UP TABLE LOCATION IN X AND SET UP
* B.P. NUMBER AND COUNT. ONLY X REGISTER
* CHANGED.

BSETUP PSHS A SAVE A.
 LDA #NBP SET UP COUNT.
 STA >BCOUNT,PCR
 LEAX >BTABLE,PCR SET B.P. LOCATION.
 CLR >BNBR,PCR Set up B.P. count.
 PULS A,PC RESTORE A.

* Start program. Put in SWI jump to monitor for breakpoint.

RUNPGM:
	LEAX    >MONITR,PCR
	STX     [>SWIptr]
	LDS     >TSTACK,PCR     Restore trace stack.
	lda     >Savstat,PCR    Restore original link status.
	jsr     >_dset0
	RTI                     Start run.

* Print condition codes.

PNTCC lbsr CRLF NEW LINE.
 LEAX >STKMSG,PCR POINT TO STACK DATA STRING.
 LBSR SETREG Y= STACK POINTER FOR CC.
 PSHS X SAVE X REGISTER.
 LDB ,Y GET CONDITION CODES.
 LEAX >CCMSG,PCR GET CC STRING.
 LDA #8 SET BIT COUNT.
 STA >TEMP,PCR
CCLOOP LDA ,X+ GET BIT NAME.
 ROLB CHECK NEXT BIT.
 BCS CCOUT PRINT FILLER IF SET.
 LDA #'. Filler for 0 bits.
CCOUT lbsr FLXOUT PRINT DATA.
 DEC >TEMP,PCR CHECK FOR DONE.
 BNE CCLOOP
 PULS X,PC Restore X pointer.

* Print condition code prompt.

CCPRMT lbsr CRLF New line for all bits.
 LDB #4 Space to align.
 lbsr PBLNKS
 LEAX >CCMSG,PCR Print all bit prompts.
 lbra PSTRNG

* Print stack registers.

PNTREG BSR PNTCC Print condition codes.
 LDA #5 SET LINE COUNT.
 STA >TEMP,PCR
 BRA DORTRN
RGLOOP TST ,X CHECK FOR DONE.
 BEQ PNTEND
 LBSR SETREG PRINT MESSAGE AND SET FETCH.
 CMPB #1 CHECK # BYTES.
 BNE DOUBLE
 BSR PNTONE
 BRA CHKLIN
DOUBLE BSR PNTWO
CHKLIN DEC >TEMP,PCR SEE IF NEED NEW LINE.
 BNE RGLOOP
DORTRN lbsr CRLF NEW LINE.
 BRA RGLOOP
PNTONE LBSR PNT2
 BRA ADDSPC
PNTWO LBSR PNT4
ADDSPC lbra PSPACE
PNTEND LBSR RPROMT PRINT STACK LOCATION.
 LDD >TSTACK,PCR FIX STACK POINTER.
 ADDD #12
 STD >TEMP2,PCR
 LEAY >TEMP2,PCR PRINT STACK (BEFORE SWI).
 BRA PNTWO

* Set condition codes from the keyboard.
* Print first and then use 1 to insert
* and 0 to delete (space bypasses). When
* have all 8 the subroutine exits.

SETCC LBSR PNTCC
 BSR CCPRMT Print code prompts.
 LDA ,Y
 STA >TEMP,PCR
 lbsr CRLF
 LDB #4
 lbsr PBLNKS
 LDA #8
 STA >BCOUNT,PCR
CCIN lbsr FLXIN
 CMPA #'1
 BNE CC0
 ORCC #%00000001
 BRA CCROT
CC0 CMPA #'0
 BNE CCSP
 ANDCC #%11111110
 BRA CCROT
CCSP CMPA #$20
 BEQ OLDCC
 CMPA #$0D
 BNE CCIN
 lbra PQST
OLDCC LDB >TEMP,PCR
 ADDB #$80
CCROT ROL >TEMP,PCR
SHOWCC lbsr FLXOUT
 DEC >BCOUNT,PCR
 BNE CCIN
 LDA >TEMP,PCR
 STA ,Y
 BRA MNLINK

* TRACE PROGRAM FLOW. ASSUME ARE AT AN "RTS" IN THE
* PROGRAM. THIS ROUTINE WILL GO TO THE STACK AND PRINT
* THE RETURN VECTOR.

TRACE LDY >TSTACK,PCR GET PROGRAM STACK LOCATION.
 LEAY 12,Y ASSUME HAD SWI.
 LBSR PNT4
MNLINK lbra ENTRY

* PRINT MEMORY DATA.

MEMCHK LBSR GET4 GET DESIRED LOCATION.
 TFR D,Y
 lbsr CRLF START ON NEW LINE.
MLOOP STY >TEMP2,PCR SAVE LOCATION.
 LEAY >TEMP2,PCR PRINT MEMORY LOCATION.
 lbsr PNTWO
 LDY >TEMP2,PCR PRINT MEMORY DATA.
 LBSR PNTONE
 LDA [>TEMP2,PCR] PRINT ASCII EQUIVALENT.
 BSR PNTASC
 lbsr PSPACE For print alignment.
 lbsr FLXIN SEE WHAT USER WANTS.
 BEQ MNLINK Exit if C-R.
 CMPA #DNAROW LINE FEED= NEXT LOC.
 BNE CHKBAK
MLINE lbsr CRLF
 BRA MLOOP
CHKBAK CMPA #UPAROW PREVIOUS LOC?
 BNE MCHANG
 LEAY -2,Y GO BACK.
 BRA MLINE
MCHANG STA >FLXCHR,PCR Restore char.
 lbsr GET2A Get input (# or ASCII).
 STB [>TEMP2,PCR] SAVE IN MEMORY LOC.
 BRA MLINE GET NEXT COMMAND.

* Print ASCII code in A register.

PNTASC ANDA #$7F TRIM TO 7-BIT.
 CMPA #$20 CHECK FOR PRINTABLE.
 BHS VALCHR
 LDA #'. Substitute a period.
VALCHR lbra FLXOUT PRINT ASCII.

* Memory dump routine. Command is "D"
* followed by the start and finish
* memory locations. If the start is
* greater than the finish the command
* is not accepted. If just a C-R is
* input the last operation is repeated.

LIST BSR CHKPTR
 LDD >TEMP2,PCR Get start of block.
 ANDB #$F0 Back up to start of line.
 STD >TEMP2,PCR
PNT8 lbsr CRexit
 LEAY >TEMP2,PCR
 LBSR PNTWO
 BSR SETLIN
P8HEX CMPY >BLOCK,PCR
 BLO SPACE3
 CMPY >BLKEND,PCR
 BLS HEXOUT
SPACE3 LDB #3
 lbsr PBLNKS
 LEAY 1,Y
 BRA NXTHEX
HEXOUT lbsr PNTONE
NXTHEX DEC >TEMP,PCR
 BNE P8HEX
 lbsr PSPACE
 BSR SETLIN
P8ASCI LDA 0,Y+
 CMPY >BLOCK,PCR At data start?
 BHI P8OUT If yes (prev. Y+ means > ).
 LDA #SPACE
P8OUT LBSR PNTASC
 CMPY #0 Rolled over?
 BEQ FILXIT
 CMPY >BLKEND,PCR
 BHI FILXIT
 DEC >TEMP,PCR
 BNE P8ASCI
 STY >TEMP2,PCR
 BRA PNT8
SETLIN LDY >TEMP2,PCR
 LDA #$10
 STA >TEMP,PCR
 RTS

* Do same as GETPTR unless the first
* input is a C-R. In that case, restore
* the old values.

CHKPTR lbsr FLXIN
 BNE CHKNEW
 LDD >BLOCK,PCR
 STD >TEMP2,PCR
 RTS
CHKNEW STA >FLXCHR,PCR

* Get two 16-bit inputs from the
* keyboard.

GETPTR BSR IN4SPC
 STD >TEMP2,PCR
 STD >BLOCK,PCR
 BSR IN4SPC
 STD >BLKEND,PCR
 CMPD >TEMP2,PCR
 LBLO PQST
 RTS
IN4SPC lbsr GET4
 PSHS D
 lbsr PSPACE
 PULS D,PC

* Fill subroutine. Use the 'F' command.
* Follow this by the start and stop
* memory locations and the fill char.

FILL BSR GETPTR
 lbsr GET2
 LDX >BLKEND,PCR
 LEAX 1,X
FILOUT STB 0,-X
 CMPX >BLOCK,PCR
 BNE FILOUT
FILXIT lbra ENTRY

* String search routine. Searches for the specified
* input string starting over the input limits.

SEARCH BSR GETPTR
 LDA #BUFLEN
 STA >BCOUNT,PCR
 CLR >BNBR,PCR
 LEAX >SBUFR,PCR
INSTR lbsr GET2A
 STB ,X+
 lbsr PSPACE
 INC >BNBR,PCR
 DEC >BCOUNT,PCR
ENDCHK lbsr FLXIN
 BEQ INITS Got a C-R.
 TST >BCOUNT,PCR
 BEQ ENDCHK
 STA >FLXCHR,PCR
 BRA INSTR
INITS lbsr CRLF
SFIND LDX >TEMP2,PCR
 LEAY >SBUFR,PCR
 LDB >BNBR,PCR
SNEXT LDA ,X+
 CMPA ,Y+
 BNE CHKNXT
 DECB
 BNE SNEXT
 LEAY >TEMP2,PCR
 lbsr PNT4
 lbsr CRexit
CHKNXT LDX >TEMP2,PCR
 CMPX >BLKEND,PCR
 LBEQ ENTRY
 LEAX 1,X
 STX >TEMP2,PCR
 BRA SFIND

CRLF    jsr     [>SetFptr]
	jmp     [>CRptr]

CRexit  jsr     [>CRexitptr]
	lbeq    ENTRY
	rts

* Character strings.
Stmsg:
 fcb    CR,LF,CR,LF
 fcc    '==> 6809 machine language monitor <=='
 fcb    CR,LF
 fcc    '      (? or / to list options)'
 fcb    CR,LF,$04
HMSG FCC ': Print command prompts.'
 FCB $04
MMSG FCC ': Memory display and change.'
 FCB $04
BMSG FCC ': Breakpoint display and change.'
 FCB $04
RMSG FCC ': Register dump.'
 FCB $04
GMSG FCC ': Go (start program execution).'
 FCB $04
XMSG FCC ': Remove breakpoints.'
 FCB $04
TMSG FCC ': Trace (assume stack has RTS).'
 FCB $04
DMSG FCC ': Display (show memory block).'
 FCB $04
FMSG FCC ': Fill (change memory block).'
 FCB $04
LMSG FCC ': Input "B19" records (serial port, 57.6 Kbaud, 8 data, 2 stop).'
 FCB $04
SMSG FCC ': String search.'
 FCB $04
BNDMSG FCC 'Default memory boundaries: '
 FCB $04

STKMSG
 FCB 'C,'C,$4,0,1,'A,$4,1,1,'B,$4,2,1,'D,'P,$4,3,1,'X,$4,4,2
 FCB 'Y,$4,6,2,'P,'C,$4,10,2,'U,$4,8,2,0,'S,$4
CCMSG FCC 'EFHINZVC'
 FCB $4

Monend  equ     *               For use by relocator.
