* Serial I/O routines.

* Send byte in A out the serial SCI port.
*Serout    jmp       [>Seroutptr]      Use ROM routines.

* Get byte in A from the serial SCI port.
*Serin     jmp       [>Serinptr]

*PIA2AC  equ     $FF21           For input activity check.
*Zbit    equ     %100            CC zero flag.
*
* Check for serial input activity.
* Returns >< if had input.
*Chkin   pshs    B
*        tst     PIA2AC
*        bpl     _noedge
*        jsr     [>_SETEDGE]     Clear flag.
*        andcc   #$FF^Zbit
*        puls    B,PC
*_noedge orcc    #Zbit
*        puls    B,PC

* External access equates:
*        ext     Serout, Serin
*        ext     Chkin

* Serial load subroutine with timeout
* for end of input check.
* Enter with X= buffer pointer,
* Y= buffer size and A= timeout
* in 50 microsecond increments.
* A= 0 is the MAXIMUM timeout!
* Input sync time is 7.5 +/-0.5 cycles.
* Waits for first byte, but times
* out on subsequent ones.
* Exits with Y= size transferred
* and carry set if buffer over-run.
*
*
*         |         |
*   10,S  |---------|
*         | Return  |
*         |         |
*    8,S  |---------|
*         | Buffer  |
*         | end     |
*    6,S  |---------|
*         | X       |
*         | register|
*    4,S  |---------|
*         | Delay   |
*    3,S  |---------|
*         | Ctr/flg |
*    2,S  |---------|
*         | Btime   |
*    1,S  |---------|
*         | Itime   |
*    0,S  |---------|<- Stack
*         |         |
*

TSERIN:
 LEAS -8,S Set up stack storage.
 STX 4,S
 TFR Y,D Get buffer end.
 ADDD 4,S
 STD 6,S
 coma Enter with A = timeout ( >= 1).
 STA 3,S
 LDD [>BaudTime]
 suba #2 Itime correction.
 addb #1 Btime correction.
 STD 0,S Save ITIME (0,S) and BTIME (1,S).
 LDY PIAptr Side A data register.
 CLR 2,S Bit counter and overrun flag.
*
TFINDL LDB #RSin In loop for timing.
 BITB 0,Y First try with no timeout.
 BNE TFINDL
 BRA DSERIN
TSERLP LDA 3,S Get delay.
DFINDL ADDA #1 Carry set on overflow, else clear.
 BITB 0,Y Does not affect carry.
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BEQ DSERXT
 NOP
 BITB 0,Y
 BHI DFINDL Branch on neither zero or carry.
DSERXT BCC DSERIN
 LBRA TSERSET Timed out (normal exit).
DSERIN CMPX 6,S Check for room.
 BLO NEXTIN
 STB 2,S Overrun flag.
 BRA TSERLP Wait for time out.
NEXTIN LDD #7
 STB 2,S
 LDB 0,S
TBTDLY DECB
 BNE TBTDLY
 LDB 0,Y Get data.
* RORB Put into A.
 andb #RSin
 addb #$FF
 RORA
* NOP Timing correction.
 LDB 1,S
 DEC 2,S
 BNE TBTDLY
TXITDLY DECB Bit counter cleared.
 BNE TXITDLY
 LDB 0,Y
* RORB
 andb #RSin
 addb #$FF
 RORA
 LDB #RSin Also use for input check.
TFINDH BITB 0,Y
 BEQ TFINDH
 STA ,X+
 BRA TSERLP
*
TSERSET TFR X,D Get size transferred.
 SUBD 4,S
 TFR D,Y
 LDX 4,S
 ANDCC #%11111110 Normal exit (clear carry).
 TST 2,S Overrun?
 BEQ TSERXT
 ORCC #%00000001 Error (set carry).
TSERXT LEAS 8,S
 RTS
