* NOTE: Modified for 6809. This should be
*       the first program assembled in the
*       link module group, as it has the
*       origin.
*
* Link routines to allow Small-C to use
* a PC as a host for all I/O. Includes file,
* keyboard and display handling. Uses serial
* ports for command and data transfer.

* Origin set to allow space between end of
* program and start of relocated ROM code
* at $F600.

Link    equ     $F400

	org     Link

* Send string (0 ends ) pointed to by Y:
Sendstr lda     0,Y+
	jsr     [>Seroutptr]
	tsta
	bne     Sendstr
	rts

* Send integer in D:
Sendint jsr     [>Seroutptr]
	pshs    b
	puls    a
	jmp     [>Seroutptr]

* FOPEN
*
* Enter with calling argument string
* pointers on the stack. Will call
* the corresponding routine in a PC
* via a serial port data link. Returns
* with a channel #. If the number is 0
* the open did not work.
*
* Stack call equates:
String1 equ     4
String2 equ     2
* Local storage:
Channel rmb     2
Inflag  rmb     1               Flag (reply must match).
* Routine entry:
fopen   tfr     S,X
	lda     #FOPEN          Send flag.
	sta     Inflag
	jsr     [>Seroutptr]
	ldy     String1,X       Send arguments.
	jsr     Sendstr
	ldy     String2,X
	jsr     Sendstr
* Fall through from "Fopen".
* Use if integer returned.
Intrtrn ldy     #Channel        Set up reply arguments.
	ldd     #Intsize 
	jsr     Blkin           Get block.
	tstb                    Test for error.
	bne     _fopen1
_fopen0 jmp     Blkerr
_fopen1 lda     Flag
	cmpa    Inflag
	bne     _fopen0
	ldd     Size
	cmpd    #Intsize
	bne     _fopen0
	ldd     Channel
	rts

* WARNING: Only for assembly purposes.
Blkerr  ldd     #1              Indicate error of some kink.
	jsr     exit
	bra     *               Should never get here!

* FCLOSE
*
* Enter with the channel # on the stack.
* Returns != 0 if error.
fclose  tfr     S,X             *tsx
	lda     #FCLOSE         Send flag.
	sta     Inflag
	jsr     [>Seroutptr]
	ldd     2,X             Send channel #.
	jsr     Sendint
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* GETCHAR
*
* Enter with no arguments (assumes Stdin).
* Returns with next keyboard character or
* EOF if error.
getchar lda     #GETCHAR        Send flag.
	sta     Inflag
	jsr     [>Seroutptr]
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* PUTCHAR
*
* Enter with character on the stack
* (promoted to integer by call).
* Returns char of EOF if error.
putchar tfr     S,X
	lda     #PUTCHAR        Send flag.
	sta     Inflag
	jsr     [>Seroutptr]
	ldd     2,X             Send channel #.
	jsr     Sendint
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* GETKEY
*
* Enter with no arguments (assumes Stdin).
* Returns with next keyboard character
* or EOF if not available.
getkey  lda     #GETKEY        Send flag.
	sta     Inflag
	jsr     [>Seroutptr]
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* EXIT
*
* Enter with exit flag and
* reset CPU when done.
exit    tfr     S,X
	lda     #EXIT
	jsr     [>Seroutptr]
	ldd     2,X
	jsr     Sendint
	jmp     [>Resetptr]

* GETC
*
* Enter with channel #.
* Return with character or EOF.
getc    tfr     S,X     *tsx
	lda     #GETC
	sta     Inflag
	jsr     [>Seroutptr]
	ldd     2,X             Send channel #.
	jsr     Sendint
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* PUTC
*
* Enter with character and channel
* #. Returns with character or EOF
* if error.
putc    tfr     S,X     *tsx
	lda     #PUTC
	sta     Inflag
	jsr     [>Seroutptr]
	ldd     4,X             Send character.
	jsr     Sendint
	ldd     2,X             Send channel #.
	jsr     Sendint
*       jmp     Intrtrn
	jsr     Intrtrn         TEMPORARY!
	rts

* GETS
*
* Get string of characters
* from Stdin.
* Enter with buffer pointer.
* Return with pointer or
* NULL if error.
gets    tfr     S,X     *tsx
	lda     #GETS
	sta     Inflag
	jsr     [>Seroutptr]
	ldy     2,X             Buffer pointer.
	beq     _gets0          NULL is call error.
	ldd     #80             Assume some limit.
	jsr     Blkin
	tstb
	bne     _gets1
_gets0  jmp     Blkerr
_gets1  lda     Flag
	cmpa    Inflag
	bne     _gets0
	ldd     Size
	beq     _gets2          If 0 (NULL) was error.
	ldd     2,X             Get original pointer.
_gets2  rts

* Set link to direct mode.
* Bypass if already in the
* mode. Echo not sent as a 
* packet.

setdir  lda     #DIRECT
_dset0  cmpa    Lnkstat         No-op if already there.
	beq     _dset2
	sta     Lnkstat
	jsr     [>Seroutptr]
_dset1  jsr     [>Serinptr]
	cmpa    Lnkstat
	bne     _dset1
_dset2  rts

Lnkstat fcb     PACKET          Link starts up in packet state.

* Set link to packet mode.
* Must wait for echo to verify
* that the link is clear in
* both directions.
setpkt  lda     #PACKET
	bra     _dset0        

* Exit link. Only allowed in
* the Direct mode. Sends ^C
* and sets status to Packet.
* Returns A == 0 and "=" 
* status if allowed.
extlnk  lda     Lnkstat
	cmpa    #DIRECT
	bne     _ext0
	lda     #PACKET
	sta     Lnkstat
	lda     #CTRLC
	jsr     [>Seroutptr]
	clra
_ext0   rts

* Link program external equates:
* ------------------------------

* Routines:
	ext     fopen, fclose, getchar, putchar, getkey
	ext     exit, getc, putc, gets, setpkt, setdir
	ext     Sendstr


