*       Initialisation code.
*       I/O vectors, get command string and run
*       program starting at "main" (assumes C compiler
*       output).


Entry:  jsr     >setdir         ; Get file I/O from keyboard.
	jsr     [>CRptr]        ; Print command prompt.
	ldx     #Cmdstr
	jsr     [>Msgptr]
	ldd     #Cmdlen         ; Get command from keyboard.
	ldx     #Cmdbuf
	jsr     >Getline        ; Size <= $FF.
	jsr     [>CRptr]
	jsr     >setpkt         ; Only changes A.
	clra
	ldx     #Header         ; Add in for *Argv[0].
	addd    #Cmdbuf-Header  ; Fix up size (total <= $FF).
	jsr     Getargs         ; Decode string into arguments.
	pshs    D               ; Argc on stack.
	pshs    X               ; *Argv[] on stack.
	jsr     main
	jsr     Pulargs         ; Restore stack (changed by Getargs).
	swi                     ; Go back to Monitor
	bra     Entry           ; If force continue.
;        ldd     #0              ; Assume no errors.
;        pshs    D
;        jsr     exit            ; Exit system.

Cmdstr  FCC     "Command: "
	FCB     0
Header  FCC     "Small-C"       ; *Argv[0] (no spaces in string).
	FCB     SP              ; Fall through into "Cmdbuf".
Cmdlen  EQU     80-Header+Cmdstr+1
Cmdbuf  RMB     Cmdlen

	end     Entry           ; Program starting address.
