* Decode line buffer into tokens and a pointer
* array for use in entry to C programs that
* need "argc" and "argv[]".
* Enter with the line buffer pointer in X and
* the buffer data size in D (limit to <= $FF).
* Buffer must be C compatible (0 after end).
* Token pointers will be pushed on the stack.
* Exits with the number of tokens in D and
* X -> the start of the token pointer array.
* Last pointer is NULL to signal end of array.
*
* WARNING: The stack is CHANGED on exit.
*          To restore the stack load it
*          from Argstak, which has been
*          corrected for the call to
*          Getargs.
*     

Argstak rmb     2               ; Entry stack storage.

Getargs puls    Y               ; Get return vector.
        sts     Argstak         ; Save stack.
        stx     Xstore          ; Save buffer start.
        abx                     ; Move to end of buffer.
        ldd     #NULL           ; NULL pointer to end array.
        pshs    D
        clrb                    ; Clear token count.
_gtarg0 cmpx    Xstore          ; At start of buffer?
        beq     _gtarg3
        leax    -1,x
        lda     ,X
        cmpa    #SP             ; Bypass spaces.
        beq     _gtarg0
        clr     1,X             ; Set end of token.
        incb                    ; Increment token count.
_gtarg1 cmpx    Xstore          ; At start of buffer?
        beq     _gtarg2
        leax    -1,x
        lda     ,X
        cmpa    #SP             ; Go to start of token.
        bne     _gtarg1
        leax    1,X             ; Correct pointer.
_gtarg2 pshs    X               ; Save in stack array.
        bra     _gtarg0
_gtarg3 clra                    ; Return with array pointer and size.
        tfr     S,X
        jmp     ,Y

* Restores stack to value at Getargs call.
*
Pulargs puls    Y               ; Get return vector.
        lds     Argstak         ; Set to original stack.
        jmp     ,Y              ; Return.


* Command line buffer console input subroutine.
*
* Enter with X= buffer pointer and D= maximum buffer size ( >= 1
* and <= $FF).
*
* Exit with D= actual size (exclusive of the ending null) and
* X= buffer pointer. If X == NULL had error, such as entered
* with X == NULL or D == 0.

* Storage:

Xstore  rmb     2
Maxline rmb     1
Linesiz rmb     1
Tabset  rmb     1

* Program:

Getline tsta                    ; Check D size.
        bne     _gline0
        tstb
        beq     _gline0
        decb                    ; Space for ending null.
        stb     Maxline
        stx     Xstore          ; Save buffer pointer.
        cmpx    #NULL           ; Error in buffer pointer?
        bne     _gline1
_gline0 ldx     #NULL           ; Error exit.
        rts
_gline1 clr     Tabset          ; Set up starting parameters.
        clr     Linesiz
_gline2 jsr     Getchar
        cmpa    #BS             ; Backspace?
        bne     _gline3
        tst     Linesiz         ; Do no back up over start.
        beq     _gline2
        jsr     [>Seroutptr]
        lda     #SP
        jsr     [>Seroutptr]
        lda     #BS
        jsr     [>Seroutptr]
        dec     Linesiz         ; Correct buffer.
        leax    -1,X
        bra     _gline5         ; Also clear tab flag.
_gline3 cmpa    #CR
        bne     _gline4
        clr     ,X
        clra
        ldb     Linesiz
        ldx     Xstore
        rts
_gline4 ldb     Linesiz         ; Any room left?
        cmpb    Maxline
        blo     _gline6
_gline5 clr     Tabset          ; Stop TAB fill.
        bra     _gline2
_gline6 cmpa    #SP             ; Printing character?
        blo     _gline2
        tsta
        bmi     _gline2
        sta     ,X
        leax    1,X
        inc     Linesiz
        jsr     [>Seroutptr]
        bra     _gline2

* Get console character and take care of tabs.
Getchar tst     Tabset          ; Doing tabs?
        beq     _gchar3
_gchar0 ldb     Linesiz         ; Next to tab stop?
        incb
        andb    #%111
        bne     _gchar1
        clr     Tabset          ; Stop tab mode.
_gchar1 lda     #SP             ; Tab fill.
_gchar2 rts                     ; Get console character.
_gchar3 jsr     [>Serinptr]
        cmpa    #TAB            ; Got a tab?
        bne     _gchar2
        inc     Tabset          ; Start tab mode.
        bra     _gchar0

        ext     Getargs, Pulargs, Getline
