* NOTE: Modified to work with 6809 based CPU
*       and boot ROM.
*
* Get data block via the serial port.
* Starts with a type flag followed by the data.
* End of data is when the serial input port 
* times out. Data is in bytes, and the maximum 
* data size (exclusive of the flag) can be from 
* 0 up through $FFFF.
*
* Enter with:
*
*       Y register:     Location data of buffer.
*       D register:     Buffer size.
*
* Exits with:
*
*       Block size:     Set to amount received.
*       Block flag:     Block flag (initial byte).
*       D register:     0 if error, else 1.
*       X register:     Unchanged.
*       Y register:     Changed.
*

* Global storage.
Size    rmb     2               Amount of data received.
Flag    rmb     1               Block flag (initial byte).

* Block input routine.

Blkin   pshs    X               Change to match ROM calls.
	tfr     Y,X
	tfr     D,Y
	leay    1,Y             Adjust for flag byte.
	leax    -1,X
	lda     ,X              Save data to be overwritten.
	sta     Flag
*        lda     #57             2.86 msec (5 char @ 19.2 Kbaud & 2 Mhz).
	lda     #114            5.72 msec (5 char @ 9600 baud & 2 Mhz).
	jsr     TSERIN
	pshs    CC              Save status.
	leay    -1,Y            Adjust for flag byte.
	sty     Size            Actual size.
	lda     Flag            Get saved and initial (flag) bytes.
	ldb     ,X
	stb     Flag            Swap places.
	sta     ,X
	clra                    Set up D for status.
	clrb
	puls    X,CC
	bcs     _blkext
	incb                    No error.
_blkext rts
