/* Upload data from the monitor.
   Check first to see that the communication
   line is ready. Use a timeout to check for
   end of file.
   Uses XOFF to flag start, so that if
   start communication routine instead of
   upload the monitor can detect it.
   Large storage capacity allows other use
   than monitor.
   Add communication program at end, similar
   to the loader.
*/

#include        <stdio.h>
#include        <bios.h>
#include        <malloc.h>
#include        <sys\types.h>
#include        <sys\timeb.h>

#define         SIG(status) (status & 0x80)     /* Rcv signal detect */
#define         DSR(status) (status & 0x20)     /* Data set ready * /
#define         CTS(status) (status & 0x10)     /* Clear to send */
#define         RDY(status) (status & 0x100)    /* Data ready */
#define         OER(status) (status & 0x200)    /* Overrun error */
#define         FER(status) (status & 0x800)    /* Framing error */
#define         XON         0x11                /* DC1 turn link on */
#define         XOFF        0x13                /* DC3 turn link off */

main(argc, argv) 
 
int argc;
char *argv[];

{

FILE *fp;                                        /* File pointer */

char far *block1, far *block2, far *block3;
char far *bsave1, far *bsave2, far *bsave3;
unsigned int bsize= 50000, bcheck, bctest, filesize;    /* 150 K storage */
int bnumber, bntest, stat, port=0, hpdata;              /* Port= com1 */

        /* Open output file */
        if (argc == 2) {
                if ((fp= fopen(argv[1], "wb")) == NULL) {
                        printf("Can't open file %s\n", argv[1]);
                        return;
                }
        }
        else {
                printf("Error in command line\n");
                return;
        }
        
        /* Clear data input registers */
        while (RDY(comstat(port))) bioscom(2, hpdata, port);

        /* Allocate memory */
        for (bnumber= 1; bnumber <= 3; bnumber++) {
                switch (bnumber) {
                        case 1:
                                bsave1= block1= farmalloc(bsize);
                                if (block1 == NULL) goto memerr;
                                break;
                        case 2:
                                bsave2= block2= farmalloc(bsize);
                                if (block2 == NULL) goto memerr;
                                break;
                        case 3:
                                bsave3= block3= farmalloc(bsize);
                                if (block3 == NULL) goto memerr;
                                break;
                }
        }

        /* Send "XOFF" out port to flag sending program */
        hpdata= XOFF;
        bioscom(1, hpdata, port);

        if (block1) {
                /* Wait for data start or an error
                  NOTE: Should have a long time out here
                */
                chkdat: stat= comstat(port);
                        if (!((FER(stat)||OER(stat)||!DSR(stat)||RDY(stat))))
                                goto chkdat;

                /* Get port data (and status) till done */        
                bnumber= 1;
                bcheck= 0;
                while (!(stat= comdata(&hpdata, port))) {
                        /* TRANSFER DATA TO MEMORY */
/*  putchar(hpdata); */
                        switch (bnumber) {
                                case 1:
                                        *block1++= hpdata;
                                        break;
                                case 2:
                                        *block2++= hpdata;
                                        break;
                                case 3:
                                        *block3++= hpdata;
                                        break;
                        }
                        bcheck++;
                        /* Check for block full */
                        if (bcheck == bsize) {
                                /* Check for out of room */
                                if (bnumber == 3) {
                                        printf("File too large");
                                        return;
                                }
                                else {
                                        bnumber++;
                                        bcheck= 0;
                                }
                        }
                }
                /* Check for EOF (timeout) */
                if (stat != 1) {
                        printf("Problem in data transfer");
                        return;
                }
                /* Transfer data to output file */
                else {
                        hpdata= XOFF;
                        bioscom(1, hpdata, port);
                        bntest= 1;
                        bctest= 0;
                        while (!((bctest == bcheck) && (bntest == bnumber))) {
                                switch (bntest) {
                                        case 1:
                                                hpdata= *bsave1++;
                                                break;
                                        case 2:
                                                hpdata= *bsave2++;
                                                break;
                                        case 3:
                                                hpdata= *bsave3++;
                                                break;
                                }
                                if (putc(hpdata, fp) == EOF) {
                                        printf("Error in writing to file\n");
                                        return;
                                }
                                bctest++;
                                if (bctest == bsize) {
                                        bctest= 0;
                                        bntest++;
                                }
                        }
                }
                /* Close output file */
                if (fclose(fp) != 0) {
                        printf("Error closing out file\n");
                        return;
                }
                /* Put communication program here? */
        }
        else printf("Cannot transfer file");
        return;

        memerr: printf("Unable to allocate enough memory\n");
}

/* Get com1 status 
        bit  0(0x0001)= delta clear to send
        bit  1(0x0002)= delta data set ready
        bit  2(0x0004)= trailing edge ring indicator
        bit  3(0x0008)= delta receive line signal detector
        bit  4(0x0010)= clear to send
        bit  5(0x0020)= data set ready
        bit  6(0x0040)= ring indicator
        bit  7(0x0080)= received line signal detect
        bit  8(0x0100)= data ready
        bit  9(0x0200)= overrun error
        bit 10(0x0400)= parity error
        bit 11(0x0800)= framing error
        bit 12(0x1000)= break detect
        bit 13(0x2000)= transmit holding register empty
        bit 14(0x4000)= transmit shift register empty
        bit 15(0x8000)= time out
*/
comstat(port)

int port;                            /* 0= com1, 1= com2 */
{
        return(bioscom(3, NULL, port));
}

/* Return port character and status.
   If return 0: Got character
             1: Timed out
             2: Data error (overrun or framing error)
             3: Data set no longer ready
*/
comdata(hpdata, port)

int *hpdata, port;                       /* Returned data and port */
{

long int delay, timeout= 15000; /* Large enough for > 1 second real time */
int portstat;

        for (delay= 0; delay < timeout; delay++) {
                portstat= comstat(port);
                /* See if data error */
                if (OER(portstat) || FER(portstat)) return(2);
                /* Check that HP110 still on */
                if (!DSR(portstat)) return(3);
                /* Get for data if available */
                if (RDY(portstat)) {
                        *hpdata= bioscom(2, hpdata, port);
                        return (0);
                }
        }
        return (1);
}

/* Return an absolute time figure in milliseconds
   NOTE: Returns a long integer
*/
long int timer()

{
struct timeb elapsed;

        ftime(&elapsed);
        return ((elapsed.time*1000) + (elapsed.millitm));
}



