******************************************************************
* Inverse trig functions for the Gordon Doughman HC11FP11 math   *
* package when modified to work with the 6809 microprocessor.    *
*                                                                *
* Enter with argument in FPACC1, exit with angle in FPACC1.      *
*                                                                *
* F. Wilson: 3-25-94                                             *
* P.O. Box 55                                                    *
* Tomales, CA 94971                                              *
*                                                                *
* NOTE: The functions have had limited testing and there are NO  *
* guarantees as to accuracy or operation. They are for public    *
* domain experimental use, with no commercial implications.      *
*                                                                *
* Mofifications:                                                 *
*    (1)  9-19-97   F. Wilson: Changed to allow re-entrant use.  *
*                                                                *
******************************************************************

* Data storage stack offsets:
SineFlag  equ  $00            0= Sine, >< 0= Cosine.
ExchFlag  equ  $01            0= exchange FPACC1 and FPACC2 before dividing.
Sgnsave   equ  $02            Sign of Z in FPACC.
Invflag   equ  $03            If X was inverted is >< 0.
Xreg      equ  $04            Floating point "memory" format.
Xnew      equ  $08
Yreg      equ  $0C
Zreg      equ  $10
Jreg      equ  $14            Exponent.
Jmax      equ  $15
Lead10    equ  $16            Leading byte of Atan10.
Stkloc    equ  $17            Next free stack location.

******************************************************************
* ARCSIN                                                         *
******************************************************************
ARCSIN    clra
          bra  ArcSet

******************************************************************
* ARCCOS                                                         *
******************************************************************
ARCCOS    lda  #$FF
ArcSet    leas -Stkloc,S      Space for variables.
          tfr  S,U            Use U for variable locations.
          sta  Invflag,u
          sta  SineFlag,u
          clr  ExchFlag,u
          jsr  PSHFPAC2
          lda  MANTSGN1       First, make X positive.
          sta  Sgnsave,u
          clr  MANTSGN1
          leax Xreg,u         Save X.
          jsr  PUTFPAC1
          ldx  #ONE           Check for <= 1.
          jsr  GETFPAC2
          jsr  FLTCMP
          bls  ArcSqr
          lda  #ARCERR
          orcc #%1
          jsr  PULFPAC2
          leas Stkloc,S
          rts
ArcSqr    leax Xreg,u
          jsr  GETFPAC2
          jsr  FLTMUL         FPACCC1= X^2.
          bcc  ArcNzer
          clra                Underflow (set FPACC1 to 0).
          clrb
          std  FPACC1EX
          std  FPACC1MN+1
          sta  MANTSGN1
ArcNzer   ldx  #CONSTP5       X^2 > 1/2?
          jsr  GETFPAC2
          jsr  FLTCMP
          bls  ArcDir
          com  Invflag,u
          inc  ExchFlag,u
ArcDir    jsr  AtnSET
          jsr  EXG1AND2
          jsr  FLTSUB
          jsr  FLTSQR         FPACC1= (1 -X^2)^1/2
          bcs  ArcRtrn
          leax Xreg,u
          jsr  GETFPAC2       FPACC2= X.
          tst  ExchFlag,u
          bne  ArcDiv
          jsr  EXG1AND2
ArcDiv    jsr  FLTDIV         FPACC1= FPACC1/FPACC2.
          jsr  SaveX          Do ARCTAN.
          tst  SineFlag,u
          beq  ArcRtrn
          tst  MANTSGN1
          beq  ArcRtrn
          ldx  #Const180
          jsr  GETFPAC2
          jsr  FLTADD         Correction for ARCCOS quadrant.
ArcRtrn   jsr  PULFPAC2
          leas Stkloc,S
          rts

ARCERR    equ  9              Absolute value of ARCSIN or ARCCOS > 1.

Const180  fcb  $88,$34,$00,$00     180 degrees.

******************************************************************
* ARCTAN                                                         *
******************************************************************
*                                                                *
* Uses the CORDIC routine as explained in the article "Fast trig *
* and math" by Matt Scudiere from the 68 Micro Journal.          *
* For accuracy and to avoid division by 0 the tangent value is   *
* compared to 1 (angle= 45 degrees) and if greater is inverted.  *
* In this case the resultant angle must be subtracted from 90.   *
* The basic algorithm is quite old, first published in 1624 in   *
* the book Arithmetica Logarithmica. The CORDIC method was       *
* developed by Volder: Jack E. Volder, "The CORDIC Trigonometric *
* Computing Technique", IRE Transactions on Electronic Computers,*
* September 1959, page 330.                                      *
******************************************************************

ARCTAN    leas -Stkloc,S
          tfr  S,U
          jsr  PSHFPAC2
          lda  MANTSGN1       First, make X positive.
          sta  Sgnsave,u
          clr  MANTSGN1
          jsr  AtnSET
          clr  Invflag,u
          jsr  FLTCMP         Is X > 1?
          bls  noinv
          jsr  EXG1AND2       Yes. Invert X.
          jsr  FLTDIV
          inc  Invflag,u
noinv     bsr  SaveX
          jsr  PULFPAC2
          leas Stkloc,S
          rts

SaveX     lda  ONE            Initial J.
          suba FPACC1EX
          cmpa #10            Check for X -> Atan(X) as X -> 0.
          bls  DoCORDIC
          jsr  RAD2DEG
          leax Zreg,u
          jsr  PUTFPAC1
          lbra AtanExit
DoCORDIC  sta  Jreg,u
          adda #20
          sta  Jmax,u
          leax Xreg,u         Save.
          jsr  PUTFPAC1
          bra  InitATAN
GetATAN   leax Xreg,u         Do: Xnew = X -Y*(2^-J).
          jsr  GETFPAC1
InitATAN  leax Yreg,u
          jsr  GETFPAC2
          lda  FPACC2EX
          suba Jreg,u
          sta  FPACC2EX
          jsr  FLTSUB
          tst  MANTSGN1       Xnew >= 0?
          bmi  NextEXP
SaveXnew  leax Xnew,u         Yes. Save it.
          jsr  PUTFPAC1
          leax Yreg,u         Do: Y= Y + X*(2^-J).
          jsr  GETFPAC1
          leax Xreg,u
          jsr  GETFPAC2
          lda  FPACC2EX
          suba Jreg,u
          sta  FPACC2EX
          jsr  FLTADD
          leax Yreg,u
          jsr  PUTFPAC1
          leax Xnew,u         Update X.
          leay Xreg,u
          ldd  0,X
          std  0,Y
          ldd  2,X
          std  2,Y
          leax Zreg,u         Update ATAN.
          jsr  GETFPAC1
          lda  Jreg,u         Use table or estimate?
          cmpa #10
          bls  TableZ
          lda  Atan           Estimate delta Z.
          suba Jreg,u
          sta  Lead10,u
          ldx  #Atan10
          bra  NextZ
TableZ    ldx  #Atan          Delta Z from table.
          lsla                J*4.
          lsla
          leax A,X
NextZ     cmpx #Atan10        First byte correction?
          bne  _nxtZ0
          bsr  FakeGet2
          bra  _nxtZ1
FakeGet2  pshs A,CC           Bypass start of GETFPAC2.
          lda  Lead10,u
          ldb  1,X            Non 0.
          jmp  _gt2
_nxtZ0    jsr  GETFPAC2
_nxtZ1    jsr  FLTADD         When bypass GETFPAC2.
          leax Zreg,u
          jsr  PUTFPAC1
          lbra GetATAN
NextEXP   inc  Jreg,u         Next exponent.
          lda  Jreg,u
          cmpa Jmax,u         Done?
          bhi  AtanExit
          dec  FPACC2EX       Xnew= Xnew +Y*(2^-J).
          jsr  FLTADD
          tst  MANTSGN1
          lbpl SaveXnew
          bra  NextEXP
AtanExit  tst  Invflag,u      Yes. Check for complementary angle.
          beq  Direct
          ldx  #Const90
          jsr  GETFPAC1
          leax Zreg,u
          jsr  GETFPAC2
          jsr  FLTSUB
          bra  ExitATAN
Direct    leax Zreg,u
          jsr  GETFPAC1
ExitATAN  lda  Sgnsave,u      Restore sign of result.
          sta  MANTSGN1
          andcc     #%11111110
          rts

AtnSET    ldx  #ONE
          jsr  GETFPAC2
          leax Yreg,u         Initialise Y= 1.0
          jsr  PUTFPAC2
          clra                Initialise Z= 0.0
          clrb
          leax Zreg,u
          std  ,X
          std  2,X
          rts

Const90   fcb  $87,$34,$00,$00

* Table of ATAN(X) in terms of descending inverse binary powers of X,
* starting with 0.
Atan      fcb  $86,$34,$00,$00     0    1/1       45.000000 degrees.
          fcb  $85,$54,$85,$3A     1    1/2       26.565051
          fcb  $84,$60,$94,$75     2    1/4       14.036243
          fcb  $83,$64,$00,$23     3    1/8       7.1250163
          fcb  $82,$64,$E2,$A8     4    1/16      3.5763344
          fcb  $81,$65,$1B,$C7     5    1/32      1.7899121
          fcb  $80,$65,$2A,$1D     6    1/64      0.89517371
          fcb  $7F,$65,$2D,$AD     7    1/128     0.44761417
          fcb  $7E,$65,$2E,$98     8    1/256     0.22381050
          fcb  $7D,$65,$2E,$D2     9    1/512     0.11190568
          fcb  $7C,$65,$2E,$DF     10   1/1024    0.055952892
Atan10    fcb  $00,$65,$2E,$E0     >10

          END  Entry
