* Test the 6809FP11.ASM and
* TRIG.ASM math routines.
* Inputs A and B correspond to
* FPACC1 and FPACC2. If just a
* carriage return is entered the
* previous data is used.

CR        equ  $D
LF        equ  $A
BS        equ  $8
SP        equ  $20
XON       equ  $11

          org  $200

Entry     ldd  #Vlist         Set up access vectors.
          jsr  ,X
          sts  Chkstk         For stack checking.
          clr  Column
Start     cmps Chkstk
          beq  _start3
          clra
          jmp  Error
_start3   jsr  pcrlf
          clr  Column
          ldx  #Asave
          jsr  PUTFPAC1
          ldu  #Oplist        Print choices.
          clrb
_start0   pshs B
          clra
          ldb  0,S
          std  <FPACC1MN+1    Print selection #.
          jsr  UINT2FLT
          ldx  #Buffer
          jsr  FLTASC
          jsr  strlen
          nega
          adda #4
          jsr  gocol
          jsr  Ptext
          lda  #6             Go to column 5.
          jsr  gocol
          ldx  0,U
          jsr  Pmsg
          puls B
          cmpb #Maxops
          beq  _start1
          incb
          leau 6,U
          bra  _start0
_start1   ldx  #Inptmsg
          jsr  Ptext
          ldx  #Buffer
          lda  #Bufsize
          jsr  Line
          jsr  strlen
          tsta
          beq  Start
          jsr  ASCFLT
          lbcs Error
          tst  <MANTSGN1
          beq  _start2
_rngerr   lda  #10
          lbra Error
_start2   jsr  FLT2INT
          lbcs Error
          ldd  <FPACC1MN+1
          cmpd #Maxops
          bhi  _rngerr
          pshs B
          lslb
          addb 0,S
          leas 1,S
          lslb
          ldu  #Oplist
          leau B,U
          ldx  0,U
          jsr  Pmsg
          ldx  #Asave
          jsr  GETFPAC1
          jsr  [4,U]
          lbra Start

strlen    pshs X
          clra
_chklen   tst  ,X+
          beq  _lenxit
          inca
          bra  _chklen
_lenxit   puls X,PC

gocol     suba Column
          bls  _gcxit
_gocol0   pshs A
          lda  #SP
          jsr  chrout
          puls A
          deca
          bne  _gocol0
_gcxit    rts

Inherent1 jsr  [2,U]
          jmp  Aout

Inherent2 jsr  [2,U]
          jsr  Aout
          jmp  Bout

Oneacc    jsr  Ain
          jsr  [2,U]
          lbcs Error
          jmp  Aout

Twoacc    jsr  Ain
          jsr  Bin
          jsr  [2,U]
          lbcs Error
          jsr  Aout
          jmp  Bout

Load      jsr  Ain
          jsr  Bin
          jsr  Aout
          jmp  Bout

Exit      jmp  [>STOP]

Compare   jsr  Ain
          jsr  Bin
          jsr  [2,U]
          bhi  RsltHI
          beq  RsltEQ
          bra  RsltLO

RsltHI    ldx  #HImsg
          jmp  Pmsg

RsltEQ    ldx  #EQmsg
          jmp  Pmsg

RsltLO    ldx  #LOmsg
          jmp  Pmsg

Error     cmpa #Maxerr
          bls  _error0
          lda  #Maxerr+1
_error0   ldx  #Errlst
          lsla
          ldx  A,X
_error1   bsr  Pmsg
          lds  Chkstk
          jmp  Start

* Put number in A.
Ain       ldx  #Ainmsg
_ain0     jsr  Ptext
          ldx  #Buffer
          lda  #Bufsize
          bsr  Line
          tst  0,X
          beq  _ain1
          jsr  ASCFLT
          lbcs Error
_ain1     rts

* Put number in B.
Bin       jsr  EXG1AND2
          ldx  #Binmsg
          bsr  _ain0
_bin0     jmp  EXG1AND2

* Print number in A.
Aout      ldx  #Aoutmsg
_aout0    jsr  Ptext
          ldx  #Buffer
          jsr  FLTASC
          jsr  Pmsg
          rts

* Print number in B.
Bout      jsr  EXG1AND2
          ldx  #Boutmsg
          bsr  _aout0
          bra  _bin0

* Print message.
_ptext    bsr  chrout
Ptext     lda  ,X+
          bne  _ptext
          rts

* Print message and end with CR/LF.
Pmsg      bsr  Ptext
          clr  Column
          jmp  pcrlf

* ASCII buffer input routine.
* Enter with: X-> buffer location.
*             A=  buffer size.
Line      decA                Space for terminating null.
          tfr  A,B
          pshs X,D            0,S= Space available, 1,S= Size.
_loop     jsr  [>_SERIN]      Get keyboard input.
          cmpa #CR            Done?
          beq  _CR_exit
          cmpa #BS            Backspace?
          bne  _chksize
          lda  1,S            Already at start?
          cmpa 0,S
          beq  _loop
          lda  #BS
          bsr  chrout
          lda  #SP
          bsr  chrout
          lda  #BS
          bsr  chrout
          leax -1,X
          inc  0,S
          bra  _loop
_chksize  tst  0,S            Full?
          beq  _loop
          sta  ,X+            Store input.
          dec  0,S
          bsr  chrout
          bra  _loop
_CR_exit  clr  ,X             Terminate string.
          bsr  chrout
          puls D,X,PC         Restore X and return.

pcrlf     lda  #CR
          bra  _chrout4
chrout    cmpa #CR
          bne  _chrout0
_chrout4  clr  Column
          bsr  _chrout2
          lda  #LF
          bra  _chrout2
_chrout0  cmpa #BS
          bne  _chrout1
          tst  Column
          bne  _chrout3
          rts
_chrout3  dec  Column
          bra  _chrout2
_chrout1  inc  Column
_chrout2  jmp  [>_CONOUT]     Does RTS.

Oplist    fdb  Addmsg,   FLTADD,   Twoacc
          fdb  Submsg,   FLTSUB,   Twoacc
          fdb  Mulmsg,   FLTMUL,   Twoacc
          fdb  Divmsg,   FLTDIV,   Twoacc
          fdb  Sqrtmsg,  FLTSQR,   Oneacc
          fdb  Pimsg,    GETPI,    Inherent1
          fdb  Exgmsg,   EXG1AND2, Inherent2
          fdb  Movemsg,  TFR1TO2,  Inherent2
          fdb  Cmprmsg,  FLTCMP,   Compare
          fdb  Sinemsg,  FLTSIN,   Oneacc
          fdb  Cosmsg,   FLTCOS,   Oneacc
          fdb  Tanmsg,   FLTTAN,   Oneacc
          fdb  ArcSmsg,  ARCSIN,   Oneacc
          fdb  ArcCmsg,  ARCCOS,   Oneacc
          fdb  ArcTmsg,  ARCTAN,   Oneacc
          fdb  Loadmsg,       0,   Load
          fdb  Exitmsg,       0,   Exit
Maxops    equ  *-Oplist/6-1

Addmsg    fcc  'A + B'
          fcb  0
Submsg    fcc  'A -B'
          fcb  0
Mulmsg    fcc  'A X B'
          fcb  0
Divmsg    fcc  'A/B'
          fcb  0
Sqrtmsg   fcc  'Square root of A'
          fcb  0
Pimsg     fcc  'A = Pi'
          fcb  0
Exgmsg    fcc  'Exchange A and B'
          fcb  0
Movemsg   fcc  'Move A to B'
          fcb  0
Cmprmsg   fcc  'Compare A to B'
          fcb  0
Sinemsg   fcc  'A= Sine(A)'
          fcb  0
Cosmsg    fcc  'A= Cosine(A)'
          fcb  0
Tanmsg    fcc  'A= Tangent(A)'
          fcb  0
ArcSmsg   fcc  'A= ArcSine(A)'
          fcb  0
ArcCmsg   fcc  'A= ArcCosine(A)'
          fcb  0
ArcTmsg   fcc  'A= ArcTangent(A)'
          fcb  0
Loadmsg   fcc  'Load A and B'
          fcb  0
Exitmsg   fcc  'Exit program'
          fcb  0
HImsg     fcc  'A > B'
          fcb  0
EQmsg     fcc  'A = B'
          fcb  0
LOmsg     fcc  'A < B'
          fcb  0

Ainmsg    fcc  'Input data for A: '
          fcb  0
Binmsg    fcc  'Input data for B: '
          fcb  0
Aoutmsg   fcc  'A= '
          fcb  0
Boutmsg   fcc  'B= '
          fcb  0

Errlst    fdb  Stkmsg         0
          fdb  Fmterr         1 (floating point package)
          fdb  Ovflerr        2    "         " "
          fdb  Undflwerr      3    "         " "
          fdb  Div0err        4    "         " "
          fdb  Interr         5    "         " "
          fdb  Negsqrt        6    "         " "
          fdb  Tan90          7    "         " "
          fdb  Maxangle       8 (floating point package)
          fdb  Arcrng         9
          fdb  Opterr         10
Maxerr    equ  *-Errlst/2-1
          fdb  Errmsg         11 and above.

Stkmsg    fcc  'Stack has changed'
          fcb  0
Fmterr    fcc  'Floating point format error'
          fcb  0
Ovflerr   fcc  'Floating point overflow'
          fcb  0
Undflwerr fcc  'Floating point underflow'
          fcb  0
Div0err   fcc  'Attempted division by zero'
          fcb  0
Interr    fcc  'Number out of range for conversion to integer'
          fcb  0
Negsqrt   fcc  'Attempted to take square root of negative number'
          fcb  0
Tan90     fcc  'Attempted to take the tangent of +/- 90 degrees'
          fcb  0
Maxangle  fcc  'Angle too large to reduce'
          fcb  0
Arcrng    fcc  'Attempted to take ARCSIN or ARCCOS of number > +1 or < -1'
          fcb  0
Opterr    fcc  'Not an option number'
          fcb  0
Errmsg    fcc  'Unknown error number'
          fcb  0

Inptmsg   fcc  'Selection? '
          fcb  0

Bufsize   equ  15
Buffer    rmb  Bufsize
Chkstk    rmb  2
Select    rmb  2
Column    rmb  1              Printing column.
Asave     fcb  0,0,0,0        Temporary storage for FPACC1.

* Access vector list.
Vlist:
_SERIN    fdb  Serin_sO
_CONOUT   fdb  ConOut_sO
STOP      fdb  Reset_rO
          fdb  0

          end  Entry
