/*
 *  stable --- prints the symbol table in alphabetical order
 *
 * MODS: (1) 2-9-94 F. Wilson: Added external reference symbol
 *           table to be printed out for use when compiling
 *           other programs.
 */
stable(ptr)

struct nlist *ptr;
{
  if (ptr != NULL)
    {
      stable (ptr->Lnext);
        printf ("%-16s %04x\n",ptr->name,ptr->def);
      stable (ptr->Rnext);
    }
}

/* Print symbol equate file for those defined as external.
 * The file can be used when compiling other programs, giving
 * the same effect as a "linker".
 */
extsym(ptr)

struct nlist *ptr;
{
  if (ptr != NULL)
    {
      extsym(ptr->Lnext);
        if (ptr->symtype != 0)
          printf ("%-16s EQU $%04x\n",ptr->name,ptr->def);
      extsym(ptr->Rnext);
    }
}

/*
 *  cross  --  prints the cross reference table 
 */
cross(point)

struct nlist *point;
{
struct link *tp;
int i = 1;
  if (point != NULL)
    {
      cross (point->Lnext);
        printf ("%-16s %04x *",point->name,point->def);
         tp = point->L_list;
          while (tp != NULL)
           {
             if (i++>10)
              {
               i=1;
               printf("\n                      ");
              }
              printf ("%04d ",tp->L_num);
               tp = tp->next;
           }
         printf ("\n");
      cross (point->Rnext);
    }
}
