*****      bootmon      *****
*
* AUTHOR: Frank J. Wilson
*   DATE: March 25, 1985
*    USE: Machine language program monitor.
*         Use with the single board 6809 based
*         computer running with an 8 Mhz crystal.
*         Assemble and download into the target
*         computer. Source computer acts as
*         terminal via the ROM routines.
*  SCOPE: Intended for public domain use.
*
* THEORY:
*  On initial entry all program registers except the
*  stack and program counter are set to 0. The stack
*  is set to the incoming value and the PC points
*  back to the monitor command decode. The program stack
*  size MUST include enough room for the SWI. Note that
*  Interrupts are turned off on initial monitor entry, and
*  that the SWI also turns off the interrupts while in the
*  monitor. Since the NMI interrupt cannot be turned off,
*  extra space is included in the monitor stack.
*  If an SWI exit is taken from the program and the
*  breakpoint is not found in the breakpoint table, the
*  program cannot continue execution until the SWI is
*  removed using the M command or is bypassed using the
*  "control" P command. This problem can be detected by
*  the presence of a question mark after the monitor prompt
*  when the breakpoint is hit.
*
* CMNDS:
*  The monitor prompt is ">", and is followed by the
*  keyboard commands. In the following explanation, <CR>
*  represents a carriage return, Hex numbers are shown as
*  H and ASCII characters as A. Keyboard inputs are
*  underlined. Some commands do not require a carriage
*  return. A mistake in a command sequence will cause an
*  immediate exit. To halt a printout press any key. Then
*  press any key to resume printing or a <CR> to return
*  to the monitor.
*
* 1) >E HHHH <CR>
*     - ---- ----
*
*  This opens a memory location for examination or change.
*  Memory contents are printed in Hex and ASCII. Four
*  operations are now possible. The ">" key will go to
*  the next higher location in memory, while the "<" key
*  goes to the next lower one and a carriage return will exit
*  to the monitor. While a location is open the contents can
*  be changed using either Hex or ASCII input. For hex,
*  input two Hex digits (0-9 or A-F). For ASCII, first
*  enter a single quote followed by the character. When a
*  location has been changed the next higher one is
*  automaticaly opened.
*
* 2) >B HHHH
*     - ----
*  Put a breakpoint in memory. When program execution
*  reaches this point the monitor is recalled and the
*  previous memory contents are restored. The program may
*  be continued (using the G command) or other operations
*  may be performed.
*
*    >B <CR>
*     - ----
*  When no memory location is input a list of the present
*  breakpoints will be printed. Each item will include the
*  location number in the breakpoint table for use in the
*  X command. The breakpoint the monitor was entered from
*  (except on initial entry or when it has been removed
*  by the X command) will be followed by an asterisk.
*  On the next break it will be restored.
*
* 3) >R
*     -
*  A list of the program registers will be printed out.
*  Register contents can be changed by using a control
*  character (such as "control" A for the A register)
*  followed by the new contents. Condition codes are a
*  special case. The codes will be printed out as the
*  ASCII prompts for the active positions. All the prompts
*  will then be printed underneath. Eight keyboard inputs
*  are required to make a change. For each bit position, 1
*  will activate the bit, 0 will deactivate it and a space
*  will leave it as is.
*
* 4) >G
*     -
*  Continue to execute the program. The breakpoint jump at
*  memory locations $106 through $108 is reinstalled and
*  an RTI instruction is done.
*
* 5) >X HH
*     - --
*  Delete a breakpoint. Input the breakpoint table entry
*  number. This can be found with the B command.
*
*    >X <CR>
*     - ----
*  Delete all breakpoints.
*
* 6) >T
*     -
*  Prints the change in program flow if the next program
*  instruction is an RTS.
*
* 7) >D HHHH HHHH
*     - ---- ----
*  Display the contents of memory in Hex and ASCII. Give
*  the start and finish locations as four digit Hex
*  numbers. Finish must be >= start.
*
*    >D <CR>
*     - ----
*  Same as above, using the addresses from the last D, F
*  or S command.
*
* 8) >F HHHH HHHH HH
*     - ---- ---- --
*  Fill memory. The start and finish addresses are input
*  first, followed by the desired fill byte. This command
*  deletes all breakpoints.
*
* 9) >S HHHH HHHH HH 'A 'A HH <CR>
*     - ---- ---- -- -- -- -- ----
*  Search memory for a data string. Hex (or ASCII as
*  in the M command) is input after the start and finish
*  addresses. Miximum string length is given by BUFLEN. If
*  the buffer is full only a <CR> will be accepted.
*
* 10) >?
*      -
*  Prints all the command prompts.
*
* 11) >/
*      -
*  Prints all the command prompts.
*
* 12) >L HHHH HHHH
*      - ---- ----
*  Load "B19" record (binary version of "S19" records) data
*  coming in the serial input port at 57.6 Kbaud (2 stop).
*  Control C sent to exit the communication link.
*  Start location put in the program stack. Use the "G"
*  command to start the program. Note that the loader can
*  only exit if there is a start record. This command deletes
*  all breakpoints.
*
* 13) >I HHHH HHHH (Not implemented yet)
*      - ---- ----
*  Input a block of memory. Give start and maximum locations.
*  Send ^C to exit link, wait for XOFF (if XON bypass download)
*  and receive the block, doing a timeout exit.  Then send XOFF
*  (receiving program exit prompt) and wait for on XON.
*
* 14) >O HHHH HHHH (Not implemented yet)
*      - ---- ----
*  Output a block of memory. Give start and finish locations.
*  Send ^C to exit link, wait for XOFF (if XON bypass upload)
*  and send the block.  Then wait for XON (receiving program
*  does a timeout exit).
*

* SYSTEM EQUATES:
*    The calls for serial input and output functions use
*    BootROM.

MEMEND EQU $F000

UPAROW EQU '<       Code for up-arrow key (use with SHIFT key).
DNAROW EQU '>       Code for down-arrow key (use with SHIFT key).
SPC EQU $20 ASCII space.
CR EQU $D Carriage return.
LF EQU $A Line feed.
CTRLC EQU $3 Control C (comlink exit).
XON equ $11  Comlink startup prompt.

* MONITOR EQUATE.

NBP EQU 16 # OF BREAKPOINTS.
BUFLEN EQU 20 String buffer length.

*****       MONITOR     *****

* Put monitor after user memory.

 ORG MEMEND+1

* Unplanned RTS vector (assumes stack
* is still set here):

Restart   fdb  START     Restart system.

* Monitor program storage locations.
* If program is put in ROM, these must
* be in RAM.

NPTR RMB 2 Breakpoint restore pointer.

* BREAKPOINT TABLE. NBP= # OF ENTRIES.
* EACH ENTRY STARTS WITH THE USE FLAG.
* IF USED THE FLAG >< 0. NEXT LOCATION
* IS THE CODE AND THE NEXT TWO LOCATIONS
* ARE THE MEMORY POINTER.

BTABLE RMB 4*NBP

* Program temporary storage locations.

TSTACK RMB 2 TRACE STACK POINTER.
TEMP RMB 1 TEMPORARY STORAGE FOR GET2.
BCOUNT RMB 1 STORE B.P. COUNT.
BNBR RMB 1 Breakpoint #.
TEMP2 RMB 2 SAVE MEMORY POINTER.
BLOCK RMB 2 Block operation start.
BLKEND RMB 2 Block operation end.
FLXCHR RMB 1 Input char. save.

* Search buffer.

SBUFR RMB BUFLEN

* Monitor stack. Maximum use (including FLEX calls)
* is 45 bytes. For safety, 60 are used (in case of
* NMI).

 RMB 60 Monitor stack.
MSTACK

* Initial program start. From here to the end of
* the program the code may be put in ROM.

START:
 std ROMdata Save ROM version and revision.
 lda #$D0 Turn off any interrupts.
 TFR A,CC
 stx Vsetptr Vector setup routine pointer.
 ldd #Vtable Set up ROM access pointers.
 jsr ,X
 ldx #Stmsg
 jsr PSTRNG
 LDX #BTABLE Set start of RAM locations.
 STX NPTR Set to valid entry.
BSETLP CLR ,X+ Clear almost everything.
 CMPX #MSTACK
 BNE BSETLP
 LDS #MSTACK SET STACK.
 ldx #START Reset restart vector.
 stx Restart
 LDX #MEMEND Use if want stack at MEMEND.
 LEAX -11,X BACK OFF FOR MEMEND STACK.
 STX TSTACK SET TRACE STACK TO DEFAULT.
 LDA #$D0 DEFAULT C.C.
 STA ,X+ STORE.
 LDA #9 SET UP STACK CLEAR COUNT.
DEFLT CLR ,X+ CLEAR REGISTERS.
 DECA CHECK FOR DONE.
 BNE DEFLT
 LDD #ENTRY SET P.C. TO MONITOR.
 STD ,X
 BRA ENTRY

* Keyboard character input routine.
* Masks char. to 7-bit and returns char.
* in location FLXCHR if present. Also
* clears FLXCHR on exit.

FLXIN LDA FLXCHR
 BNE FLXRTN
 JSR [>Serinptr]
 CMPA #$5F Check for lower case.
 BLS FLXRTN No.
 ANDA #$5F Drop lower case.
FLXRTN CLR FLXCHR
 CMPA #CR Check for C-R.
 RTS

* Keyboard character output routine.
* Also clears location FLXCHR.

FLXOUT PSHS A,B
 JSR [>ConOutptr]
 PULS A,B
 BRA FLXRTN

* Inactivate breakpoint. Enter with X register
* pointing to the table location.

MRSTR LDA 1,X GET B.P. CODE.
 STA [2,X] RETURN TO MEMORY.
 CLR ,X CLEAR B.P. FLAG.
 RTS

* Activate breakpoint. Enter with X register
* pointing to the table location.

MSET LDA [2,X] GET CODE.
 STA 1,X SAVE.
 INC ,X FLAG B.P.
 LDA SWIref PUT SWI IN MEMORY.
 STA [2,X]
 RTS

SWIref:   SWI

* Check B.P. pointed to by X. If pending
* restore it.

CKLAST TST ,X
 BPL NOTPND
 CLR ,X
 BSR MSET
NOTPND RTS

* SOFTWARE INTERRUPT JUMP.

MONITR STS TSTACK SAVE PROGRAM STACK.
 LDD 10,S FIX PROGRAM COUNTER.
 ADDD #-1
 STD 10,S D= interrupt location.
 LDS #MSTACK SET STACK.
 LBSR BMATCH SEE IF OUR SWI.
 BNE REMOVB IF YES.
PQST LDA #'? INDICATE NOT ACCEPTABLE.
 BSR FLXOUT
 BRA ENTRY
REMOVB LDD NPTR
 STX NPTR
 TFR D,X Put B.P. in X.
 BSR CKLAST Restore B.P. if pending.
 LDX NPTR
 BSR MRSTR
 LDA #$80
 STA ,X
REGDMP JSR PNTREG ALWAYS WANT THESE.

* Monitor main entry point for keyboard
* input decoding.

ENTRY LDS #MSTACK Set monitor stack.
 LBSR CRLF
 LDX #MONMSG PRINT PROMPT.
 LBSR PSTRNG
 BSR FLXIN GET COMMAND.
CHKLP TST ,X
 BEQ REGCMD
 CMPA ,X+ SEE IF MATCH.
 BEQ GTCMD
 LEAX 2,X GO TO NEXT COMMAND.
 BRA CHKLP
GTCMD LBSR CRECHO SPACE TO NEXT CHAR.
 JMP [,X] GO TO ROUTINE.

MONMSG FCC '> '
 FCB $4
 FCC '?' Print command prompts.
 FDB HELP
 FCC '/' Print command prompts.
 FDB HELP
 FCC 'E' Examine (and change) memory.
 FDB MEMCHK
 FCC 'B' Breakpoint display and change.
 FDB BRKPT
 FCC 'R' Register dump.
 FDB REGDMP
 FCC 'G' Go (start program execution).
 FDB RUNPGM
 FCC 'X' Remove breakpoints.
 FDB XOUT
 FCC 'T' Trace (assume stack has RTS).
 FDB TRACE
 FCC 'D' Display memory.
 FDB DUMP
 FCC 'F' Fill memory.
 FDB FILL
 FCC 'L' Load memory via the serial port.
 FDB SLOAD
 FCC 'S' Search for string.
 FDB SEARCH
 FCB 0 End of table.

* Print prompts for all commands.

HELP:
	LDX     #Helpmsg
	JSR     PSTRNG
	BRA     ENTRY

SLOAD jsr XSUB
 lda #CTRLC Exit comlink.
 jsr [>Seroutptr]
 JSR [>Loadptr] Exits on "S9" record or error.
 lbne PQST Error in loading.
 cmpa #XON Check for communication startup.
 LBNE PQST Improper startup prompt.
;_sldxt JSR [>Serinptr] Get communication startup.
; cmpa #XON
; lbne _sldxt
 LDX TSTACK Get stack
 STY 10,X Set PC to start address.
 ldd Vsetptr Get address of vector offset routine.
 std 4,X Start with routine address in X.
 ldd ROMdata ROM version and revision
 std 1,X
 BRA ENTRY

REGCMD LDX #STKMSG SEE IF REGISTER CHANGE COMMAND.
 ADDA #$40 SET ^ TO NORMAL CHAR.
 CMPA #'C Do condition codes separately.
 LBEQ SETCC
REGCHK TST ,X CHECK FOR DONE.
 LBEQ ENTRY COULD NOT DECODE COMMAND.
 CMPA ,X CHECK COMMAND.
 BEQ GOTREG
MSGBP LDB ,X+
 CMPB #4
 BNE MSGBP
 LEAX 2,X
 BRA REGCHK
RPROMT BSR PSTRNG PRINT REGISTER PROMPT.
 LDA #'=
CRECHO JSR FLXOUT
 BRA PSPACE
SETREG BSR RPROMT PRINT REGISTER MESSAGE.
 LDY TSTACK SET STACK POINTER.
 LDD ,X++ GET OFFSET AND # BYTES.
 LEAY A,Y SET POINTER.
 RTS
GOTREG BSR SETREG PRINT PROMPT AND SET X AND Y.
 CMPB #1
 BNE SET4
 LBSR GET2
 STB ,Y
 BRA SETRTN
SET4 LBSR GET4
 STD ,Y
SETRTN JMP ENTRY

* PRINT BYTE IN HEX.
* ENTER WITH Y= POINTER.

PNT2 LDA ,Y
 BSR FIRST
 LDA ,Y+
 BRA SECOND

* PRINT DOUBLE BYTE IN HEX.
* ENTER WITH Y= POINTER.

PNT4 BSR PNT2
 BRA PNT2

* Print first half of A as a hex digit.

FIRST LSRA
 LSRA
 LSRA
 LSRA

* Print second half of A as a hex digit.

SECOND ANDA #$F
 SUBA #10
 BLO SNBR
 ADDA #'A
SCHR JMP FLXOUT
SNBR ADDA #10+'0
 BRA SCHR

* PRINT SPACE.

PSPACE LDA #SPC GET SPACE.
 JMP FLXOUT PRINT IT.

* PRINT # SPACES IN B.

PBLNKS BSR PSPACE
 DECB
 BNE PBLNKS
 RTS

* PRINT STRING. POINTER IN X.

PSTRLP JSR FLXOUT
PSTRNG LDA ,X+
 CMPA #4
 BNE PSTRLP
 RTS

* DECODE HEX DIGIT.
* DIGIT IN A. IF RETURN NEGATIVE
* IS NOT HEX.
* BINARY EQUIVALENT RETURNED IN B,
* A IS UNCHANGED.

HEXDEC TFR A,B
 SUBB #'0
 BLO NOTHEX
 CMPB #'9-'0
 BHI HEXDGT
HXRTRN TSTB SET PROPER CONDITION CODES.
 RTS
HEXDGT SUBB #'A-'0
 BLO NOTHEX
 CMPB #'F-'A
 BLS HEXRST
NOTHEX LDB #$80-10
HEXRST ADDB #10
 BRA HXRTRN

* GET DIGIT INTO B.

GETDGT JSR FLXIN
 BEQ PQSTN Was C-R.
DGCHK BSR HEXDEC
 BMI PQSTN
 JMP FLXOUT

* Get keybord input either in ASCII or as two
* HEX digits. Input is in HEX unless the first
* character input is a single quote.

GET2A JSR FLXIN
 CMPA #''
 BNE NOT2A
 JSR FLXOUT
 JSR [>Serinptr]
 TFR A,B
 JMP PNTASC
NOT2A STA FLXCHR

* GET TWO HEX DIGITS INTO B.

GET2 BSR GETDGT
FIX2 LSLB
 LSLB
 LSLB
 LSLB
 STB TEMP
 BSR GETDGT
 ADDB TEMP
 RTS

* GET FOUR HEX DIGITS INTO D.

GET4 BSR GET2
 PSHS B
 BSR GET2
 PULS A,PC

* SET BREAKPOINTS.

BRKPT JSR FLXIN Get next input char.
 BEQ PNTBP Input was a C-R.
 STA FLXCHR No. Restore input.
 BSR BEMPTY CHECK FOR ANY EMPTYS.
 BEQ PQSTN
 BSR GET4 GET DESIRED P.C.
 LBSR BMATCH CHECK FOR ALREADY USED.
 BEQ READY Not used.
 JSR CKLAST Restore if pending.
 BRA REENTR
READY BSR BEMPTY GET EMPTY LOCATION IN X.
 STD 2,X STORE P.C.
 JSR MSET
REENTR LBRA ENTRY
PQSTN LBRA PQST NON-ACCEPTABLE DATA.

* PRINT BREAKPOINTS.

PNTBP LBSR BSETUP Set breakpoint param.
BTEST BSR BFULL
 BEQ REENTR
 JSR CRLF Start on new line.
 LDY #BNBR Print breakpoint #.
 JSR PNTONE
 TFR X,Y Set up # pointer.
 LEAY 2,Y Get # location.
 JSR PNTWO Print breakpoint.
 TST ,X See if to be restored.
 BPL BTNXT No.
 LDA #'* Yes. Flag it.
 JSR FLXOUT
BTNXT BRA BTEST

* Find full B.P. location. If found, exit
* with >< condition and X= table entry.
* If exit with an = condition, none were
* found. Do BSETUP before first entry.

BFULL TST BNBR
 BEQ NEWNBR
BNXT BSR BINCR
 BEQ BFRTN
NEWNBR INC BNBR
 TST ,X
 BEQ BNXT
BFRTN RTS Exit subroutine.

* CHECK FOR EMPTY B.P. LOCATION.
* IF FOUND, COUNT >< 0 AND X= EMPTY TABLE ENTRY.

BEMPTY BSR BSETUP
BKLOOP TST ,X
 BEQ BMCH
 BSR BINCR
 BNE BKLOOP
 BRA BMCH

* RESET BREAK POINTS.

XOUT JSR FLXIN Get command.
 BNE XONE Only delete one.
 BSR XSUB Delete all breakpoints.
EXITX BRA REENTR Go to main loop.
XONE STA FLXCHR Restore input.
 JSR GET2 Get breakpoint #.
 BSR BSETUP Set up table search.
XNEXT BSR BFULL Get breakpoint.
 LBEQ PQST Bad call.
 CMPB BNBR Desired entry?
 BNE XNEXT No.
 JSR MRSTR Clear B.P.
 BRA EXITX Done.

* Delete all active breakpoints.

XSUB BSR BSETUP Set up table parameters.
XLOOP BSR BFULL Get breakpoint.
 BNE XDEL Return when done.
 RTS
XDEL JSR MRSTR Delete breakpoint.
 BRA XLOOP Do next.

* CHECK FOR MATCH BETWEEN CODE IN D REGISTER AND THE
* B.P. TABLE. IF FOUND, COUNT >< 0 AND X= TABLE
* LOCATION.

BMATCH BSR BSETUP
BTST TST ,X
 BEQ BNEXT
 CMPD 2,X
 BEQ BMCH
BNEXT BSR BINCR
 BNE BTST
BMCH TST BCOUNT
 RTS

* SET NEXT TABLE LOCATION IN X AND DECREMENT
* ENTRY COUNT.

BINCR LEAX 4,X SET TO NEXT B.P. LOCATION.
 DEC BCOUNT TEST FOR DONE.
 RTS

* SET UP TABLE LOCATION IN X AND SET UP
* B.P. NUMBER AND COUNT. ONLY X REGISTER
* CHANGED.

BSETUP PSHS A SAVE A.
 LDA #NBP SET UP COUNT.
 STA BCOUNT
 LDX #BTABLE SET B.P. LOCATION.
 CLR BNBR Set up B.P. count.
 PULS A,PC RESTORE A.

* Start program. Put in jump to monitor on SWI.

RUNPGM:
		LDD  #MONITR
		STD  [>SWIptr]          SWI vector jump pointer in RAM.
		LDS  TSTACK         Restore trace stack.
		RTI                 Start run.

* Print condition codes.

PNTCC LBSR CRLF NEW LINE.
 LDX #STKMSG POINT TO STACK DATA STRING.
 LBSR SETREG Y= STACK POINTER FOR CC.
 PSHS X SAVE X REGISTER.
 LDB ,Y GET CONDITION CODES.
 LDX #CCMSG GET CC STRING.
 LDA #8 SET BIT COUNT.
 STA TEMP
CCLOOP LDA ,X+ GET BIT NAME.
 ROLB CHECK NEXT BIT.
 BCS CCOUT PRINT FILLER IF SET.
 LDA #'. Filler for 0 bits.
CCOUT JSR FLXOUT PRINT DATA.
 DEC TEMP CHECK FOR DONE.
 BNE CCLOOP
 PULS X,PC Restore X pointer.

* Print condition code prompt.

CCPRMT JSR CRLF New line for all bits.
 LDB #4 Space to align.
 JSR PBLNKS
 LDX #CCMSG Print all bit prompts.
 JMP PSTRNG

* Print stack registers.

PNTREG BSR PNTCC Print condition codes.
 LDA #5 SET LINE COUNT.
 STA TEMP
 BRA DORTRN
RGLOOP TST ,X CHECK FOR DONE.
 BEQ PNTEND
 LBSR SETREG PRINT MESSAGE AND SET FETCH.
 CMPB #1 CHECK # BYTES.
 BNE DOUBLE
 BSR PNTONE
 BRA CHKLIN
DOUBLE BSR PNTWO
CHKLIN DEC TEMP SEE IF NEED NEW LINE.
 BNE RGLOOP
DORTRN LBSR CRLF NEW LINE.
 BRA RGLOOP
PNTONE LBSR PNT2
 BRA ADDSPC
PNTWO LBSR PNT4
ADDSPC JMP PSPACE
PNTEND LBSR RPROMT PRINT STACK LOCATION.
 LDD TSTACK FIX STACK POINTER.
 ADDD #12
 STD TEMP2
 LDY #TEMP2 PRINT STACK (BEFORE SWI).
 BRA PNTWO

* Set condition codes from the keyboard.
* Print first and then use 1 to insert
* and 0 to delete (space bypasses). When
* have all 8 the subroutine exits.

SETCC BSR PNTCC
 BSR CCPRMT Print code prompts.
 LDA ,Y
 STA TEMP
 JSR CRLF
 LDB #4
 JSR PBLNKS
 LDA #8
 STA BCOUNT
CCIN JSR FLXIN
 CMPA #'1
 BNE CC0
 ORCC #%00000001
 BRA CCROT
CC0 CMPA #'0
 BNE CCSP
 ANDCC #%11111110
 BRA CCROT
CCSP CMPA #$20
 BEQ OLDCC
 CMPA #$0D
 BNE CCIN
 JMP PQST
OLDCC LDB TEMP
 ADDB #$80
CCROT ROL TEMP
SHOWCC JSR FLXOUT
 DEC BCOUNT
 BNE CCIN
 LDA TEMP
 STA ,Y
 BRA MNLINK

* TRACE PROGRAM FLOW. ASSUME ARE AT AN "RTS" IN THE
* PROGRAM. THIS ROUTINE WILL GO TO THE STACK AND PRINT
* THE RETURN VECTOR.

TRACE LDY TSTACK GET PROGRAM STACK LOCATION.
 LEAY 12,Y ASSUME HAD SWI.
 LBSR PNT4
MNLINK JMP ENTRY

* PRINT MEMORY DATA.

MEMCHK LBSR GET4 GET DESIRED LOCATION.
 TFR D,Y
 LBSR CRLF START ON NEW LINE.
MLOOP STY TEMP2 SAVE LOCATION.
 LDY #TEMP2 PRINT MEMORY LOCATION.
 JSR PNTWO
 LDY TEMP2 PRINT MEMORY DATA.
 LBSR PNTONE
 LDA [TEMP2] PRINT ASCII EQUIVALENT.
 BSR PNTASC
 JSR PSPACE For print alignment.
 JSR FLXIN SEE WHAT USER WANTS.
 BEQ MNLINK Exit if C-R.
; CMPA #DNAROW LINE FEED= NEXT LOC.
; BNE CHKBAK

 cmpa #'>               ; Next location?
 beq MLINE
 cmpa #'.               ; (same key).
 bne CHKBAK

MLINE jsr CRLF
 BRA MLOOP
;CHKBAK CMPA #UPAROW PREVIOUS LOC?
; BNE MCHANG

CHKBAK:
 cmpa #'<               ; Previous location?
 beq GoBack
 cmpa #',               ; (same key).
 bne MCHANG
GoBack leay -2,Y        ; Go back.

; LEAY -2,Y GO BACK.
 BRA MLINE
MCHANG STA FLXCHR Restore char.
 JSR GET2A Get input (# or ASCII).
 STB [TEMP2] SAVE IN MEMORY LOC.
 BRA MLINE GET NEXT COMMAND.

* Print ASCII code in A register.

PNTASC ANDA #$7F TRIM TO 7-BIT.
 CMPA #$20 CHECK FOR PRINTABLE.
 BHS VALCHR
 LDA #'. Substitute a period.
VALCHR JMP FLXOUT PRINT ASCII.

* Memory dump routine. Command is "D"
* followed by the start and finish
* memory locations. If the start is
* greater than the finish the command
* is not accepted. If just a C-R is
* input the last operation is repeated.

DUMP BSR CHKPTR
 LDD TEMP2 Get start of block.
 ANDB #$F0 Back up to start of line.
 STD TEMP2
PNT8 JSR CRexit
 LDY #TEMP2
 LBSR PNTWO
 BSR SETLIN
P8HEX CMPY BLOCK
 BLO SPACE3
 CMPY BLKEND
 BLS HEXOUT
SPACE3 LDB #3
 JSR PBLNKS
 LEAY 1,Y
 BRA NXTHEX
HEXOUT JSR PNTONE
NXTHEX DEC TEMP
 BNE P8HEX
 JSR PSPACE
 BSR SETLIN
P8ASCI LDA 0,Y+
 CMPY BLOCK At data start?
 BHI P8OUT If yes (prev. Y+ means > ).
 LDA #SPC
P8OUT BSR PNTASC
 CMPY #0 Rolled over?
 BEQ FILXIT
 CMPY BLKEND
 BHI FILXIT
 DEC TEMP
 BNE P8ASCI
 STY TEMP2
 BRA PNT8
SETLIN LDY TEMP2
 LDA #$10
 STA TEMP
 RTS

* Do same as GETPTR unless the first
* input is a C-R. In that case, restore
* the old values.

CHKPTR JSR FLXIN
 BNE CHKNEW
 LDD BLOCK
 STD TEMP2
 RTS
CHKNEW STA FLXCHR

* Get two 16-bit inputs from the
* keyboard.

GETPTR BSR IN4SPC
 STD TEMP2
 STD BLOCK
 BSR IN4SPC
 STD BLKEND
 CMPD TEMP2
 LBLO PQST
 RTS
IN4SPC JSR GET4
 PSHS D
 JSR PSPACE
 PULS D,PC

* Fill subroutine. Use the 'F' command.
* Follow this by the start and stop
* memory locations and the fill char.

FILL jsr XSUB
 BSR GETPTR
 JSR GET2
 LDX BLKEND
 LEAX 1,X
FILOUT STB 0,-X
 CMPX BLOCK
 BNE FILOUT
FILXIT JMP ENTRY

* String search routine. Searches for the specified
* input string starting over the input limits.

SEARCH BSR GETPTR
 LDA #BUFLEN
 STA BCOUNT
 CLR BNBR
 LDX #SBUFR
INSTR JSR GET2A
 STB ,X+
 JSR PSPACE
 INC BNBR
 DEC BCOUNT
ENDCHK JSR FLXIN
 BEQ INITS Got a C-R.
 TST BCOUNT
 BEQ ENDCHK
 STA FLXCHR
 BRA INSTR
INITS JSR CRLF
SFIND LDX TEMP2
 LDY #SBUFR
 LDB BNBR
SNEXT LDA ,X+
 CMPA ,Y+
 BNE CHKNXT
 DECB
 BNE SNEXT
 LDY #TEMP2
 JSR PNT4
 JSR CRexit
CHKNXT LDX TEMP2
 CMPX BLKEND
 LBEQ ENTRY
 LEAX 1,X
 STX TEMP2
 BRA SFIND

* Character strings.
 
STKMSG
 FCB 'C,'C,$4,0,1,'A,$4,1,1,'B,$4,2,1,'D,'P,$4,3,1,'X,$4,4,2
 FCB 'Y,$4,6,2,'P,'C,$4,10,2,'U,$4,8,2,0,'S,$4
CCMSG FCC 'EFHINZVC'
 FCB $4
Stmsg:
 FCB CR,LF,CR,LF
 FCC '==> 6809 machine language monitor <=='
 FCB CR,LF
 FCC '      (? or / to list options)'
 FCB CR,LF,$04
Helpmsg:
 FCB CR,LF
 FCC 'E= examine and change memory.'
 FCB CR,LF
 FCC 'B= add breakpoint.'
 FCB CR,LF
 FCC 'R= print registers.'
 FCB CR,LF
 FCC 'G= start program'
 FCB CR,LF
 FCC 'X= remove breakpoint(s).'
 FCB CR,LF
 FCC 'T= trace last subroutine call.'
 FCB CR,LF
 FCC 'D= memory display.'
 FCB CR,LF
 FCC 'F= fill memory with value.'
 FCB CR,LF
 FCC 'L= load program into memory.'
 FCB CR,LF
 FCC 'S= search for string match.'
 FCB CR,LF,$04
; I and O reserved for memory
; block Input or Output.

* Program startup data storage:

Vsetptr   rmb  2                ; Vector setup routine pointer.
ROMdata   rmb  2                ; ROM version and revision.

* Vector offset table:

Vtable:
SWIptr    fdb  SWI_wO
Serinptr  fdb  Serin_sO
Seroutptr fdb  Serout_sO
ConOutptr fdb  ConOut_sO
ClrLnptr  fdb  ClrLn_sO
ClrFptr   fdb  Fclr_sO
CRptr     fdb  CRLF_sO
CRexitptr fdb  CRpause_sO
Loadptr   fdb  Xload_sO
Baudptr   fdb  BDset_sO
		fdb   0

CRLF      jsr  [>ClrFptr]
		jmp  [>CRptr]

CRexit    jsr  [>CRexitptr]
		lbeq ENTRY
		rts

		end  START

