* ROM BOOT LOADER
* ---------------
*
* Use with a 68B09 CPU (2 Mhz E clock rate), with
* serial input and output via a PIA. The serial
* data must have 1 start, 8 data and 2 stop bits.
*
*    FOLLOWING DELETED
*    (1) Physical RAM is tested at Reset to verify
*    the size. Original data is left intact. If 
*    the test fails a message is sent and the system
*    halted.
*    END DELETION
*
*    (2) After Reset the ROM will  send a boot
*    message followed by ^C and wait for a binary
*    program to be loaded. The serial routines are
*    at 9600 baud, except for the binary loader,
*    which is 57.6 Kbaud. Binary data is similar
*    to "S19" except that "S" is changed to "B" and
*    the data is in machine language form without
*    CR-LF at the end of each record.
*    (3) After loading, the end of user RAM is pointed
*    to by the S register, D holds the ROM version
*    and revision and X points to the vector list setup
*    routine.
*    (4) Using a vector list permits new routines
*    to replace those in ROM, and the vector list
*    can be changed or added to if a library is
*    loaded. In this case the list pointers in the
*    data area must be updated. If the vector has
*    been deleted or is past the end of the list
*    the replacement routine jumps to the location
*    pointed to by UNAVAIL, which is initialy the
*    vector error message and system restart routine.
*    If have == condition the error was a DELETED
*    vector, else was past the end of the list.
*    (5) Serial input data must have 2 stop bits
*    to permit data processing. The serial routines
*    can be set to 9600 baud, 19.2 Kbaud or 57.6
*    Kbaud. The default rate is 9600 baud. Console
*    output data can be at any of the above rates, but
*    57.6 Kbaud is limited to an effective 19.2 Kbaud
*    repetition rate.
*    (6) The CRpause routine checks the PIA for serial
*    input activity before printing the end of line
*    string (CR-LF). If there has been any activity
*    it will wait for the next serial input character.
*    After printing the EOL string it will exit with
*    an == condition if the character was ESC (escape).
*    (7) If the serial input routine exits with A == 0
*    and an == condition the line is in BREAK status.
*    (8)  Side A of the PIA is used for serial I/O and
*    access to it must be through the routines Aset and
*    Aout to avoid interference.  CRpause uses the side
*    A interrupt flag, which is cleared by reading the
*    data register.  This limits reading side A to when
*    CRpause is not being used, and requires a copy of
*    side A output data to be kept in location PIAdata
*    for use by the serial output routine.
*    Side B is fully available.
*    (9) The source is compiled with the Motorola
*    "freeware" 6809 compiler with an added "ext"
*    callout to allow easier parameter passing between
*    programs without the complexity of a linking loader.
*    (10) RSin and RSout are not part of the vector list,
*    as RSin must be in the MSB to allow a sign check to
*    determine the pin state.  IOpins_wO is gets a data
*    word.  The high byte has the bits set for available
*    PIA side A pins, and the low byte gives the CPU clock
*    speed, which is 4 times the buss speed.  If it is
*    over 16 (data in high nibble) it is in Khz, else it is
*    in Mhz.  32 is a special case, representing a standard
*    32.768 Khz crystal.
*
* TO DO:
*    (1)  Write a comprehensive test program.
*    (2)  Document everything.
*
* MODIFICATIONS:
*    (1)  2- 7-96   F. Wilson (Version 1, Revision 1):
*    Changed vector offsets to allow 256 vectors. 
*    (2)  2-10-96   F. Wilson (Version 1, Revision 2):
*    Added check for vector $0000 as "not implemented".
*    (3)  2-19-96   F. Wilson (Version 1, Revision 3):
*    Put vector list size in RAM, just after list
*    pointer and deleted list pointer location from
*    vector list.
*    (4)  3-4-96    F. Wilson (Version 1, Revision 4):
*    Changed Reset code so that the RAM dedicated to the
*    Boot ROM and stack is assumed good, otherwise the
*    RAM integrity check would not have been able to
*    print out an error message. Moved check for ROM
*    and RAM data sizes next to the other integrity
*    checks.
*    (5)  3-16-96   F. Wilson (Version 1, Revision 5):
*    Moved Y index register initialisation to the binary
*    loader (was in call).
*    (6)  9-27-96   F. Wilson (Version 1, Revision 6):
*    Added location PIAmask to vector list, and corrected
*    a few typographical errors.
*    (7) 10-1-96    F. Wilson (Version 2, Revision 0):
*    Changed location SavePIA to PIAdata, which now
*    holds the PIA side A data output register setting.
*    This eliminates the NoPIA routine and simplifies
*    the serial I/O routines. Added location PIAdir which
*    holds the data direction register setting. In the
*    Aout and Aset calls the serial I/O bits are set to
*    the defaults.
*    Vector error resets the whole system.
*    (8)  10-14-96  F. Wilson (Version 2, Revision 1):
*    Added global end of line character and string for aid
*    in "C" style string handling and conversion.
*    (9)  10-22-96  F. Wilson (Version 2, Revision 2):
*    Saved more registers on subroutine calls, so most do
*    minimum register change. Deleted memory test to make
*    room for the changes. Removed string handling of global
*    EOL character.
*    (10) 12-10-96  F. Wilson (Version 2, Revision 3):
*    Added "S" record capability to the loader routine.
*    Changed program start to have X -> the vector offset
*    substitution routine.
*    (11) 12-17-96  F. Wilson (Version 2, Revision 4):
*    Added RS232 interrupt (IRQ) on and off routines
*    and deleted the timer check routine.  Shortened
*    the ROM boot message.
*    (12) 1-9-97    F. Wilson (Version 2, Revision 5):
*    Changed CA1 interrupt condition from low -> high
*    to high -> low transition to match RS232 start
*    bit.
*    (13) 1-27-97   F. Wilson (Version 2, Revision 6):
*    Made the DELETED vector offset into an equate.
*    Also made minor comment revisions and updates.
*    (14) 5-23-97   F. Wilson (Version 2, Revision 7):
*    Added side A available pin check.
*    (15) 6-11-97   F. Wilson (Version 3, Revision 0):
*    Changed end of vector offset list to $0000 from
*    $FF. Moved serial input and output pin locations
*    to vector list.
*    (16) 6-16-97   F. Wilson (Version 3, Revision 1):
*    Deleted available pin routine and put the pins
*    in the vector list.
*    (17) 6-20-97   F. Wilson (Version 3, Revision 2):
*    Changed vector list to all pointers. Vector load
*    error exit via a pointer in RAM.
*    (18) 9-3-97    F. Wilson (Version 3, Revision 3):
*    Added quick serial output followed by serial input
*    (useful when have ^C exit followed by data).
*    Changed serial input and output pin locations to
*    equates and IOpins to have available PIA side A
*    pins in the high byte and CPU speed in the low byte.
*    If speed is above 16 it is in Khz (32 == 32.768 Khz),
*    else it is in Mhz.
*    (19) 9-10-97   F. Wilson (Version 4, Revision 0):
*    Initial load (after system reset) waits for Xon (at
*    9600 baud) from the communication loop startup.
*    Eliminates Xon wait, which was starting up too late
*    when the vector relocation list was large.
*
*
* Memory map:
*
*               _________
*    $FFFF     |         |
*              | Boot    |
*              | ROM     |
*              |_________|
*              |         |
*              | PIA     |
*              |_________|
*              | Ram used|
*              | by ROM  |
*              |.........|
*              |         |
*              | User    |
*              | RAM     |
*              |         |
*              |         |
*              |         |
*    $0000     |_________|

* System equates:

Version   equ  4              Initial load waits for Xon to exit.
Revision  equ  0              New version not run yet.
Speed     equ  $08            8 Mhz clock (2 Mhz buss).
ROMtype   equ  Version*$100+Revision    ROM identification.
Romsize   equ  2048/2         2 Kbyte EEPROM (1/2 used).
PIAspace  equ  Romsize        Sloppy decode (only 4 used).

EEPROM    equ  $10000-Romsize
PIA       equ  EEPROM-PIAspace

RAMend    equ  PIA-1          End of RAM.
BootRAM   equ  RAMend-53      To make RAM_chk= 0.
UserRAM   equ  BootRAM-1      End of available RAM at bootup.

MinStack  equ  64             Minimum stack size.

		ext  ROMtype

* Condition code bits:

Entire    equ  %10000000
Firq      equ  %01000000      Fast interrupt mask bit.
Hcarry    equ  %00100000
Irq       equ  %00010000      Interrupt mask bit.
Neg       equ  %00001000
Zero      equ  %00000100
Vflow     equ  %00000010
Carry     equ  %00000001

* System equates:

CR        equ  $0D            Carriage return.
LF        equ  $0A            Line feed.
BS        equ  $08            Back space.
Ctrlc     equ  $03            Exits link.
Xon       equ  $11            Link on.
Xoff      equ  $13            Link off.
NULL      equ  $0000          End of list, no input.

* Equates for the PIA.
* The "A" side is used by the board
* to:
* (1) Control timer interrupts (which
*     use the NMI vector).
* (2) Send and receive serial RS232 signals.
* (3) Activate the IRQ line on receipt of an
*     RS232 start bit.

Adata     equ  0              I/O register (data or direction).
Actrl     equ  1              Control register.
Bdata     equ  2
Bctrl     equ  3

SetIO     equ  %00000100      Change to I/O register.
C2high    equ  %00001000      Set C2 value high.
CtrlC2    equ  %00110000      C2= out and direct control.
C1high    equ  %00000010      C1 set by ^ signal.
C1enabl   equ  %00000001      C1 interrupt enable.
C1int     equ  %10000000      C1 interrupt flag.

RSin      equ  %10000000      Serial input bit (A section).
RSout     equ  %01000000      Serial output bit (A section).
IOpins    equ  RSin|RSout^$FF Available PIA side A pins.

		ext  RSin, RSout

* Offsets for subroutines and data.
* These correspond with the labels in
* the RAM_V_list table, and are used
* by the SetVect routine.  Location
* offsets are replaced with pointers.
* End replacement array with NULL.
*
* Label endings:
*
*    _bO:      Byte size data location.
*    _wO:      Word size data (or pointer) location.
*    _dO:      Double word size data (or pointer) location.
*    _sO:      Subroutine location (returns to caller).
*    _rO:      Routine location (does not return).
*

		org  $0001

NOVECT_wO rmb  1              UNAVAIL:  Vector loader error pointer.
DELTD_wO  rmb  1              DELTDval: Value to flag a deleted vector.

		ext  NOVECT_wO

SWI3_wO   rmb  1              SWI3:     Software interrupt vector.
SWI2_wO   rmb  1              SWI2:        "        "        "
FIRQ_wO   rmb  1              FIRQ:        Fast interrupt    "
IRQ_wO    rmb  1              IRQ:              Interrupt    "
SWI_wO    rmb  1              SWI:     Software interrupt    "
NMI_wO    rmb  1              NMI:  Nonmaskable interrupt    "

		ext  SWI3_wO, SWI2_wO, SWI_wO
		ext  FIRQ_wO, IRQ_wO, NMI_wO

Mem_wO         rmb  1         MemLoc: End of user RAM.
PIA_wO         rmb  1         PIA: PIA location.
PIA_dat_bO     rmb  1         PIAdata: PIA-A section output data.
PIA_dir_bO     rmb  1         PIAdir: PIA-A section data direction.

		ext  Mem_wO, PIA_wO
		ext  PIA_dat_bO, PIA_dir_bO

L_Time_wO      rmb  1         L_Itm, L_Btm:  Binary loader baud control.
So_Btm_bO      rmb  1         So_Btm:        Serial output   "     "
Si_Time_wO     rmb  1         Si_Itm, Si_Btm: Serial input   "     "
Clr_Dly_bO     rmb  1         ClrDly:           "      "   delay   "

		ext  L_Time_wO, So_Btm_bO, Si_Time_wO, Clr_Dly_bO

LF_Dly_wO      rmb  1         LFdelay: Console output (display) delay.
CHR_Dly_wO     rmb  1         CHRdelay:   "      "        "       " 
Mem_Lim_dO     rmb  1         Mlow, Mhi: Binary loader data limits.

		ext  LF_Dly_wO, CHR_Dly_wO, Mem_Lim_dO

Ldr_sO    rmb  1              Binload: Binary loader.
Xload_sO  rmb  1              Xload: Binary load with link start char.

		ext  Ldr_sO, Xload_sO

Aout_sO        rmb  1         Aout:    Send PIA side A data.
Aset_sO        rmb  1         Aset:    PIA side data direction A setup.
TmrOn_sO       rmb  1         TmrOn:   Turn on interrupt timer.
TmrOff_sO      rmb  1         TmrOff:    "  off    "       "
RS_on_sO       rmb  1         RSintON: Enable RS232 interrupt.

		ext  Aout_sO, Aset_sO, TmrOn_sO, TmrOff_sO, RS_on_sO

Fclr_sO        rmb  1         ClrFlag: Clear RS232 interrupt flag.
Fchk_sO        rmb  1         ChkFlag: Check for RS232 interrupt.
ConOut_sO      rmb  1         ConOut:  RS232 data display formatter.
EOLchk_bO      rmb  1         EOLchk:    "     "     "    EOL character.
CRmsg_wO       rmb  1         CRmsg:     "     "     "    EOL echo pointer.
CRpause_sO     rmb  1         CRpause:   "     "     "    pause character.
CRLF_sO        rmb  1         CRLF:    Send CRLF using the CRmsg string.  
Msg_sO         rmb  1         SendMsg: Send character string.

		ext  Fclr_sO, Fchk_sO, ConOut_sO, EOLchk_bO
		ext  CRmsg_wO, CRpause_sO, CRLF_sO, Msg_sO

ClrLn_sO  rmb  1              ClrLine: Wait for RS232 input line to clear.
Serin_sO  rmb  1              Serin:   Get RS232 input.
Serout_sO rmb  1              Serout:  Send RS232 output.
BDset_sO  rmb  1              SetBaud: Set system RS232 baud rate.
LDset_sO  rmb  1              SetLdr:   "  loader   "     "    "

		ext  ClrLn_sO, Serin_sO, Serout_sO
		ext  BDset_sO, LDset_sO

Reset_rO  rmb  1              Reset:   Reset board.
LFchar_bO rmb  1              LFchar:  RS232 data input line feed character.
RS_off_sO rmb  1              RSintOFF: Disable RS232 interrupt.
Vlist_dO  rmb  1              VlistLOC, VlistMAX: Vector list pointer, size.
CONset_sO rmb  1              SetCon:  Set console RS232 baud rate.

		ext  Reset_rO, LFchar_bO, RS_off_sO
		ext  Vlist_dO, CONset_sO

IOpins_wO rmb  1              IOpins:  Available PIA-A pins and CPU clock.
Fastchk_sO     rmb  1         Fastchk:  Quick send/receive.

		ext  IOpins_wO, Fastchk_sO

* Equates for setting up RAM
* used by the ROM.

		org  BootRAM

*    Temporary useage:

Bitctr    rmb  1
Len       rmb  1
Chksum    rmb  1
Htemp     rmb  1
B9flag    rmb  1

*    Permanent:

UNAVAIL   rmb  2              Vector loader error exit pointer.
DELval    rmb  2              Value to flag a deleted vector.
PIAdata   rmb  1              PIA-A output data.
PIAdir    rmb  1              PIA-A data direction.
Mlow      rmb  2              0: Lowest location to load.
Mhi       rmb  2              BootRAM-MinStack: Highest location to load.
CRptr     rmb  2              End of line string (default CR-LF).
LFchar    rmb  1              Console scroll character (default LF).
EOLchk    rmb  1              Newline wait check character (default CR).
LinkExit  rmb  1              Ctrlc: Data link exit prompt (default ^C).

*    ROM routine RS232 data:

RSdata:

L_Itm     rmb  1              Binary loader baud rate (keep together).
L_Btm     rmb  1

Condata:

So_Btm    rmb  1              Serial output baud rate.

Si_Itm    rmb  1              Serial input baud rate (keep together).
Si_Btm    rmb  1

ClrDly    rmb  1              ClLine:   check time.
LFdelay   rmb  2              Console:  scrolling delay .
CHRdelay  rmb  2                        character delay.

BaudSize  equ  *-RSdata       Size of RS232 data.
ConSize   equ  *-Condata      Size of console RS232 data.

*    Location of vector list pointer and size.
*    NOTE: Keep together.

VlistLOC  rmb  2              RAM_V_list: Start of access vector list.
VlistMAX  rmb  2                          Maximum list offset.

*    CPU vectors:


SWI3vect  rmb  1              JMP
SWI3      rmb  2              SetRTI
SWI2vect  rmb  1              JMP
SWI2      rmb  2              SetRTI
FIRQvect  rmb  1              JMP
FIRQ      rmb  2              SetRTI
IRQvect   rmb  1              JMP
IRQ       rmb  2              SetRTI
SWIvect   rmb  1              JMP
SWI       rmb  2              SetRTI
NMIvect   rmb  1              JMP
NMI       rmb  2              SetRTI

MemLOC    rmb  2              UserRAM: End of user RAM.

ListEND   equ  *

* Bootup EEPROM. Contains startup code and
* external access routines and data.

		org  EEPROM

* Print vector error: trying to
* access or load a DELETED or
* unimplemented vector.

_seterr   ldx  #Badvect
		lbsr SendMsg
* Fall through into Reset.
*
* Should enter from true reset (interrupts
* off and NMI not actuated).
Reset     lds  #UserRAM       ; Assume dedicated RAM is good.
		orcc #Firq|Irq      ; Set up default PIA status.
		lda  #CtrlC2+C2high ; Deleted C1high (use hi>low transition)
		sta  PIA+Actrl      ; C2A high (timer reset).
		ldb  #RSout
		stb  PIA+Adata
		lda  #CtrlC2+C2high+SetIO     ; Deleted C1high.
		sta  PIA+Actrl
		stb  PIA+Adata
		ldx  #RAM_D_list    ; Sets serial I/O to 9600 baud.
		ldy  #BootRAM
_vmove    lda  ,X+
		sta  ,Y+
		cmpy #ListEND
		blo  _vmove
*          lbsr CheckRAM       Check RAM integrity.
*          cmpx #RAMend        Full memory?
*          beq  _bootOK
*          ldx  #Badmem        <ERROR> Bad memory location.
*          lbsr SendMsg
*          bra  *              Halt system.
_bootOK   ldx  #Bootmsg
		bsr  SendMsg
		lda  #Ctrlc         Force data link exit.
		lbsr Serout
		lbsr Xload          Load binary and wait for Xon
		cmpa #Xon
		beq  _start
		ldx  #Badload
		bsr  SendMsg
		bra  Reset
_start    lds  #UserRAM       Get program entry pointers.
		ldx  #SetVect
		ldd  #ROMtype
		jmp  0,Y            Start loaded program.

* Send string pointed to by X (0 ends).
* On exit X points to the next location
* after the end of the message:
SendMsg   pshs A
_send     lda  ,X+            Subroutine entry.
		beq  _sndxit
		lbsr ConOut
		bra  _send
_sndxit   puls A,PC

* Check RAM for bad locations.
* Exits with X= last good location.
* A, B, X changed. Does not change
* contents:
*
*CheckRAM  ldx  #0             Start of memory.
*          lda  #$55           Test pattern.
*_tstloop  cmpx #RAMend+1
*          bhs  _endmem        Done?
*          ldb  ,X             Save original data.
*          sta  ,X             Check pattern.
*          cmpa ,X
*          bne  _badmem        X -> bad location (B= original data).
*          coma                Check pattern complement.
*          sta  ,X
*          cmpa ,X
*          bne  _badmem
*          coma                Restore pattern.
*          stb  ,X             Restore original data.
*          cmpb ,X
*          bne  _badmem
*          leax 1,X
*          bra  _tstloop
*_endmem   leax -1,X           Set X= end of memory.
*_badmem   rts

* Loader. Reads "S" records or binary
* equivalent ("S" changed to $B and
* CR-LF deleted). Exits on receipt of
* "S9" or $B9 record and Y -> start
* location. If error exits !=, else
* ==. Baud rate <= 9600 for receipt of
* "S" records.

Binload:  pshs A,B,X,U
		tfr  S,U            Save entry stack.
		ldy  Mlow           Starting value for loader.
		clr  B9flag         Clear exit flag.
Binloop:  ldx  #Loadin        Start by assuming binary.
		jsr  ,X
Bincheck: cmpb #$B9
		bne  CheckB1
		jsr  ,X
		cmpb #3
		bne  Loaderr        <ERROR> Wrong record length.
		stb  B9flag
		bra  BDATA
CheckB1:  cmpb #$B1
		beq  Bindata
		cmpb #'S
		bne  ChkCR
		ldb  #$B0           Change to binary record.
		bsr  LoadS2
		ldx  #LoadS         Reset input to convert ASCII
		bra  Bincheck

Bindata:  jsr  ,X
BDATA:    STB  Chksum
		DECB                So that = 0 at end of data.
		STB  Len
		jsr  ,X
		STB  Htemp
		ADDB Chksum
		STB  Chksum
		DEC  Len
		jsr  ,X
		lda  Htemp
		tfr  D,Y
BNXTDAT   ADDB Chksum
		STB  Chksum
		DEC  Len
		BEQ  BTSTNXT
		jsr  ,X
		STB  ,Y+
		BRA  BNXTDAT

ChkCR:    cmpb #CR
		beq  Binloop
		cmpb #LF
		beq  Binloop        Fall through on error: Unknown type.
Loaderr   andcc     #Zero^$FF Exit !=.
Loadxit   tfr  U,S            Restore stack.
		puls A,B,X,U,PC

BTSTNXT:
		jsr  ,X
		ADDB Chksum
		COMB
		BNE  Loaderr        <ERROR> Bad checksum.
		tst  B9flag
		beq  Binloop
		orcc #Zero          Good exit.
		bra  Loadxit

LoadS:
		bsr  GetASCII
		lslb
		lslb
		lslb
		lslb
LoadS2:   pshs B
		bsr  GetASCII
		orb  ,S+
		rts

GetASCII: bsr  Loadin
		subb #'0
		blo  Loaderr
		cmpb #9
		bls  ASCexit
Chkltr:
		subb #'A-'0-10
		blo  Loaderr
		cmpb #$0F
		bhi  Loaderr

;          cmpb #'A-'0
;          blo  Loaderr
;          cmpb #'F-'0
;          bhi  Loaderr
;          subb #'A-'0-10
ASCexit:  rts

* Initial time (machine cycles) is: 47 +/-4 + 5*L_Itm.
* Subsequent timing is: 30 + 5*L_Btm.
Loadin:   lda  #RSin
TFINDL    bita PIA
		bne  TFINDL
		ldd  L_Itm          Include B for extra cycle.
		ldb  #7             Do last bit separately.
		stb  Bitctr
		cmpy Mlow           Room for bounds check.
		blo  Loaderr        <ERROR> Underlap.
		cmpy Mhi
		bhi  Loaderr        <ERROR> Overlap.
TBTDLY    DECA
		BNE  TBTDLY
		LDA  PIA            Get data.
		anda #RSin          Isolate data.
		adda #$FF           Shift into carry.
		rorb
		nop
		nop
		LDA  L_Btm
		DEC  Bitctr
		BNE  TBTDLY
TXITDLY   DECA
		BNE  TXITDLY
		LDA  PIA
		anda #RSin
		adda #$FF
		rorb
		lda  #RSin
TFINDH    bita PIA
		beq  TFINDH
		RTS

SetRTI    rti                 For instruction value.

* PIA side A output, data in A. Sets serial
* output to quiescent (high) state.

Aout      pshs A
		ora  #RSout         Default serial output.
		sta  PIAdata        Store.
		sta  Adata+PIA      Send.
		puls A,PC

* Change PIA side A data direction. Keeps sense
* of the serial input (bits 6 and 7).
* Data in A. No registers are changed.

Aset      pshs A,B,X
		ldx  #PIA
		ldb  Actrl,X        Change to data direction.
		andb #SetIO^$FF     Default serial input.
		stb  Actrl,X
		anda #RSin^$FF      Just in case.
		ora  #RSout
		sta  Adata,X        New I/O state.
		sta  PIAdir         Save it.
		orb  #SetIO
		stb  Actrl,X
		puls A,B,X,PC

* Turn on the timer (uses the NMI).

TmrOn     pshs A
		lda  #C2high^$FF
_rsoff    anda PIA+Actrl
_timer    sta  PIA+Actrl
		puls A,PC

* Disable the RS232 interrupt.

RSintOFF  pshs A
		lda  #C1enabl^$FF
		bra  _rsoff


* Turn off the timer.

TmrOff    pshs A
		lda  #C2high
_rson     ora  PIA+Actrl
		bra  _timer

* Enable the RS232 interrupt.
* Start bit on the RS232 line
* activates the IRQ interrupt.

RSintON   pshs A
		lda  #C1enabl
		bra  _rson

* Get timer status. Returns != if off.
*
*TmrStat   pshs A
*          lda  PIA+Actrl
*          anda #C2high
*          puls A,PC

* Substitute access vectors
* in offset array. Enter with D ->
* offset array. Uses vector list
* pointed to by VlistLOC. Allows
* a library to use its own vector
* list. On entry a program can
* use this routine to set up an
* array of access vectors
* independent of the ROM revision,
* board changes or library setup.
* Offsets are in words. NULL is
* the end of the list. Access
* vectors will be substituted,
* removing the original data.
* Vectors past the end of the
* vector list and DELETED vectors
* are an error and cause the
* system to restart.

DELETED   equ  _seterr        Unique memory location.

SetVect   pshs A,B,X,Y
		tfr  D,X
		ldy  VlistLOC
_setloop  ldd  ,X
		beq  _setexit       End of offset list.
		cmpd VlistMAX       Vector offset exists?
		bhi  _vcterr
		subd #1             No offset 0.
		lslb                Double offset.
		rola
		ldd  D,Y
		cmpd DELval         Implemented?
		beq  _vcterr
		std  ,X
		leax 2,X
		bra  _setloop
_setexit  puls A,B,X,Y,PC

* SetVect error exit.
_vcterr   jmp  [>UNAVAIL]

* Clear the serial input activity flag.

ClrFlag   tst  Adata+PIA      Reads the register.
		rts

* Check for serial input activity
* having occurred (exits !=).
* Does not clear the activity flag.

ChkFlag   pshs B
		ldb  PIA+Actrl
		bitb #C1int
		puls B,PC

* Prints CR-LF after checking for input activity.
* If had activity it waits till a character is
* received. Returns == if it matches EOL:
CRpause   pshs A
		bsr  ChkFlag        Want to wait?
		beq  _clrZ          No.
		bsr  ClrLine        Wait for prompt.
		cmpa EOLchk         Matches check char?
		bne  _clrZ
_setZ     bsr  CRLF
		orcc      #Zero     Return == condition.
		puls A,PC
_clrZ     bsr  CRLF
		andcc     #Zero^$FF Return != condition.
		puls A,PC

* Send CR-LF string via the console.
* The string is pointed to by location
* CRptr.
CRLF      pshs A,X
		ldx  CRptr
		lbsr SendMsg
		puls A,X,PC

* Console output routine.
* Enter with A= data. Exits
* with == condition.
* Includes delays for character
* recognition and scrolling.

ConOut    pshs A,B
		cmpa LinkExit       Do not send link exit (assume ^C).
		beq  _conrtrn
		bsr  Serout
		cmpa LFchar         Check for scrolling.
		bne  _conDelay
		ldd  LFdelay
		bra  _ConWait
_conDelay ldd  CHRdelay
		beq  _conrtrn       Allow 0 delay.
_ConWait  addd #-1
		bne  _ConWait
_conrtrn  puls A,B,PC         Exits with == condition.

* Send byte in register A.
* Enter with A= data. Format
* is 1 start, 8 data and 2 stop.
* Timing (machine cycles) is: 35 + 5*So_Btm.

Serout    pshs A,B
		ldb  #12
		bsr  _serset
		puls A,B,PC

_serset   stb  Bitctr
		ldb  PIAdata
		coma
		bra  _serlo
_serlp    ldb  So_Btm
		beq  _ser1
_ser2     decb
		bne  _ser2
_ser1     ldb  PIAdata
		lsra
		bcs  _serlo
_serhi    orb  #RSout
		stb  PIA
		dec  Bitctr
		bne  _serlp
		rts
_serlo    andb #RSout^$FF
		stb  PIA
		dec  Bitctr
		bne  _serlp
		rts

* Sends data in A (with no stop 
* bits) and returns with a reply
* in A.
* Effective overhead to detect
* a worst case reply is 18~,
* limiting baud rate to 19.2 Kbaud
* or less.
Fastchk   pshs B
		ldb  #10
		bsr  _serset        
		bra  _serchk

* Wait for clear line before
* getting serial input (avoids
* misreading a character).
* Timing (machine cycles) is: 13*ClrDly
* and should be 10 baud.
* Exits with A= data (changes A).
* If in BREAK status will not continue
* till done.
* If exit with == condition and A= 0 
* may have entered BREAK status.

ClrLine   pshs B
		ldb  #RSin
_clrset   lda  ClrDly         Minimum for clear line (10 baud).
_clrchk   bitb PIA            Check for activity.
		beq  _clrset        If so, start all over.
		deca
		bne  _clrchk        Wait for timeout.
		bitb PIA            Make sure of no activity.
		bne  _serwait       Keep tight check loop.
		bra  _clrset        Darn. Start all over.

* Serial input.
* Exits with A= data (changes A).
* If the line is in BREAK status
* the routine will exit with an
* == condition and A= 0.
* Initial time (machine cycles) is: 25 +/-4 + 5*Si_Itm.
* Subsequent timing is: 30 + 5*Si_Btm.

Serin     pshs B 
_serchk   ldb  #RSin
_serwait  bitb PIA
		bne  _serwait
		ldd  Si_Itm-1       Include A for extra cycle.
		lda  #8             Do last bit separately.
		sta  Bitctr
_serdly   decb
		bne  _serdly
		ldb  PIA            Get data.
		andb #RSin          Isolate data.
		addb #$FF           Shift into carry.
		rora
		nop
		nop
		ldb  Si_Btm
		dec  Bitctr
		bne  _serdly
_serxit   decb
		bne  _serxit
		ldb  PIA
		andb #RSin          Zero status if data in stop.
		puls B,PC

; Binload with exit character check.
; Meant to wait for Xon from the PC
; communication loop. Returns with
; loader status and A= exit character.
Xload     ldx  #_ldxit        Set up Xon check exit.
		pshs X,B            Preset _serchk call.
		lbsr Binload        Get binary input file.
		beq _serchk         Check for data link start.
		andcc     #Zero^$FF Load error.
		puls X,B,PC
_ldxit    orcc      #Zero     No error.
		rts

* Set up baud rate data. Only
* 9600, 19200 and 57600 in list.
* Desired rate in D. If error
* will exit with zero condition.

SetBaud   pshs A,B,X,Y
		bsr  ChkBaud        Find table position.
		beq  Bauderr        If not found.
		ldb  #BaudSize      Size of data.
_setmove  ldy  #RSdata        In ROM data area.
		leax 2,X            Drop rate.
_movedata lda  ,X+
		sta  ,Y+
		decb
		bne  _movedata
		comb                Exit !=.
Bauderr   puls A,B,X,Y,PC

* Similar to SetBaud, but only
* sets up the binary loader:

SetLdr    pshs A,B,X,Y
		bsr  ChkBaud
		beq  Bauderr
		ldb  #BaudSize-ConSize
		bra  _setmove       

* Similar to SetBaud, but only
* sets up the console:

SetCon    pshs A,B,X,Y
		bsr  ChkBaud
		beq  Bauderr
		ldb  #ConSize
		ldy  #Condata
		leax 4,X            Bypass rate and loader.
		bra  _movedata

* Enter with baud rate in D.
* Exits with X= table entry and !=.
* If baud rate not found exits ==.
* Changes X:

ChkBaud   tsta                Call error?
		beq  _chkerr
		ldx  #BaudTable
_testbd   tst  ,X             0= end of table.
		beq  _chkerr        Baud rate not found.
		cmpd ,X             Check for rate.
		beq  _chkexit
		leax BaudSize+2,X   Next entry.
		bra  _testbd
_chkexit  tsta                Will exit !=.
_chkerr   rts

* Baud rate data (baud value
* followed by settings).
* LFdelay is based on scrolling
* during vertical sync and a 50 Hz
* rate. CHRdelay is for a 19.2 Kbaud
* effective limit.
*
* Baud rate L_Itm L_Btm So_Btm Si_Itm Si_Btm ClrDly LFdelay CHRdelay

BaudTable:
		fdb  9600
		fcb       52,  36,  35,  56,  36,  160
		fdb                                     5714,     0
		fdb  19200
		fcb       21,  15,  14,  26,  15,  80
		fdb                                     5714,     0
		fdb  57600
		fcb       1,   1,   0,   5,   1,   27
		fdb                                     5714,     99
		fcb  0

* Vector list corresponding to offset equates.
* List should not be changed except for
* additions at end.
* DELETED locations point to an error routine.
*
* NOTE: From here to "Bootmsg" must be left
*       "as-is".

RAM_V_list:
		fdb  UNAVAIL, DELval
		fdb  SWI3, SWI2, FIRQ, IRQ, SWI, NMI
		fdb  MemLOC, PIA, PIAdata, PIAdir
		fdb  L_Itm, So_Btm, Si_Itm, ClrDly
		fdb  LFdelay, CHRdelay, Mlow, Binload, Xload
		fdb  Aout, Aset, TmrOn, TmrOff, RSintON
		fdb  ClrFlag, ChkFlag, ConOut, EOLchk
		fdb  CRmsg, CRpause, CRLF, SendMsg, ClrLine
		fdb  Serin, Serout, SetBaud, SetLdr
		fdb  Reset, LFchar, RSintOFF, VlistLOC
		fdb  SetCon, IOpins*$100+Speed, Fastchk

* RAM initial data:

RAM_D_list:
		fcb  0, 0, 0, 0, 0

		fdb  _seterr, _seterr
		fcb  RSout, RSout
		fdb  0, BootRAM-MinStack
		fdb  CRmsg
		fcb  LF, CR, Ctrlc

		fcb  1, 1, 33, 56, 36, 160
		fdb  5714, 0

		fdb  RAM_V_list
		fdb  RAM_D_list-RAM_V_list/2

		jmp  SetRTI
		jmp  SetRTI
		jmp  SetRTI
		jmp  SetRTI
		jmp  SetRTI
		jmp  SetRTI

		fdb  UserRAM

Bootmsg:
	fcb  CR, LF
	fcc " 68B09 ROM "
	fcb  Version+'0
	fcc  "."
	fcb  Revision+'0
	fcb  CR, LF
	fcc  " Load binary @ 57.6 Kbaud, 2 stop"
	fcb  CR, LF, 0

Badvect:
	fcc  " Vector"
Badload:
	fcc  " Load error - RESTART -"
CRmsg:
	fcb  CR, LF, 0
*Badmem:
*     fcc  " Bad memory - HALTED -"
*     fcb  CR, LF, 0

* Use to check amount of ROM left.
* No code between here and the
* interrupt vectors.

CodeEND   equ  *

* CPU interrupt vectors at the end of ROM:

		org  $FFF0

CPUvect:
		rmb  2              Reserved by CPU manufacturer.
		fdb  SWI3vect
		fdb  SWI2vect
		fdb  FIRQvect
		fdb  IRQvect
		fdb  SWIvect
		fdb  NMIvect
		fdb  Reset

* Check for match of RAM and ROM data sizes (must = 0).

MCH_chk   equ  Bootmsg-RAM_D_list-ListEND+BootRAM

* Check for RAM overlap (must be >= 0).

RAM_chk   equ  RAMend+1-ListEND

* Check for ROM overlap (must be >= 0):

ROM_chk   equ  CPUvect-CodeEND

		END  Reset
