--$Name: Том из Шеффилда: Старый Город$
--$Version: 0.92$
--$Author: Андрей Лобанов$

require "autotheme"
require "parser/mp-ru"
require "fmt"
require "snd"
require "sprite"
require "theme"
require "timer"

local font = sprite.fnt(theme.get "inv.fnt.name", theme.get "win.fnt.size")
local font_height = math.floor(sprite.font_scaled_size(font:height()) * 7 / 8)
local font_color = theme.get "inv.col.fg"
local cursor = ""
local blank = fmt.bottom(fmt.img("pad:0 0 0 1,blank:" .. math.floor(tostring(font_height / 2)) .. "x" ..
								 tostring(font_height)))
local cursor_visible
local spr

instead.fading = false
mp.prompt = "➤ "
mp.msg.HELP = mp.msg.HELP:gsub(">", "➤")
mp.cursor = cursor
mp.clear_on_move = false
mp:pager_mode(true)

game.dsc = fmt.b "Том из Шеффилда: Старый Город^" .. "Версия: 0.92^^" ..
   fmt.b "Автор игры:" .. fmt.tab "30%" .. "Андрей Лобанов^" ..
   fmt.b "Автор Instead:" .. fmt.tab "30%" .. "Пётр Косых^" ..
   fmt.b "Музыка:" .. fmt.tab "30%" .. "MAM - Classic^^" ..
   fmt.b "Тестирование:" .. fmt.tab "30%" .. "TechniX^" ..
   fmt.tab "30%" .. "Пётр Косых^" ..
   fmt.tab "30%" .. "Бош Олег^" ..
   fmt.tab "30%" .. "Артур А.^^" ..
   "Если вам необходима справка по игре, наберите \"помощь\"."

function draw_screen()
   sprite.direct(true)
   spr:draw(sprite.scr(), 0, 0)
   sprite.direct(false)
end

function make_screen()
   local px, tmp
   local h, w = theme.get("scr.h"), theme.get("scr.w")
   px = pixels.new(w, h)
   tmp = pixels.new(w, h)
   for x = 0, w / 5 do
	  px:line(x-1, 0, x-1, h/(x+1)/5, 10, 10, 10, 255)
	  px:line(x-1, h, x-1, h-h/(x+1)/5, 10, 10, 10, 255)
	  px:line(w-x, 0, w-x, h/(x+1)/5, 10, 10, 10, 255)
	  px:line(w-x, h, w-x, h-h/(x+1)/5, 10, 10, 10, 255)
   end
   for y = 0, h, 3 do
	  px:fill(0, y, w, 2, 0, 0, 0, 24)
   end
   return px:sprite()
end

sprite.render_callback(draw_screen)

function init()
   --"Том",
   pl.word = "Том/мр,3л"
   pl.room = "начало"
   pl.description = "Здесь нет зеркала."
   cursor = fmt.bottom(fmt.img("pad:0 0 0 1,box:" .. math.floor(tostring(font_height / 2)) .. "x" ..
							   tostring(font_height) .. "," .. font_color))
   timer:set(500)
   spr = make_screen()
end

function game:timer()
   if cursor_visible then
	  mp.cursor = cursor
   else
	  mp.cursor = blank
   end
   cursor_visible = not cursor_visible
   return true, false
end

VerbExtendWord {
   "#Climb",
   "подняться",
}

mp.msg.Close.CLOSE = "{#Me} закрыл {#first/вн}."
mp.msg.Open.OPEN = "{#Me} открыл {#first/вн}."
mp.msg.Lock.LOCK = "{#Me} запер {#first/вн}."
mp.msg.Unlock.UNLOCK = "{#Me} отпер {#first/вн}."

cutscene {
   nam = "начало",
   onexit = function(s)
	  snd.music "mus/classic.it"
   end,
   text = {
	  fmt.c "* * *",
   },
   next_to = "окраина города",
}

obj {
	  -"небо|небосклон|небеса",
   nam = "небо",
   description = "Светло-голубое полуденное небо.",
   before_Take = "Небо это просто слой атмосферы. Его невозможно взять. Тому об этом рассказывали в школе.",
   Touch = "До неба невозможно дотянуться.",
   Smell = "Том втянул воздух. Пахнет пыльным бетоном и зеленью.",
   found_in = function(s)
	  if here().building then
		 return false
	  else
		 return true
	  end
   end,
}:attr "scenery"

obj {
	  -"дорога|земля|асфальт",
   nam = "асфальт",
   description = "Старый потрескавшийся асфальт. Через трещины проросла какая-то трава.",
   before_Take = "Невозможно взять дорогу даже если сильно захотеть.",
   Smell = "Дорога пахнет разогретым на солнце асфальтом и зеленью.",
   Touch = "Шершавый асфальт с глубокими трещинами.",
   obj = {
	  obj {
			-"трава|травка",
		 description = "Доказательство торжества жизни. В итоге именно она побеждает.",
		 before_Take = "Том сорвал травинку, помял в руке и выбросил.",
		 Smell = "Пахнет зеленью и разогретым асфальтом.",
		 Touch = "Том дотронулся до травы. Мягкая и приятная на ощупь.",
	  }:attr "scenery",
   },
   found_in = function(s)
	  if here().building then
		 return false
	  else
		 return	true
	  end
   end,
}:attr "scenery"

room {
	  -"окраина города,окраина,улица",
   nam = "окраина города",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том вошёл в город. Последний встретил его нависшими громадами зданий. У города нет никакого пригорода, малоэтажных окраин -- издали он выглядит монолитным нагромождением высоток."
	  else
		 return "Том находится на окраине города."
	  end
   end,
   onexit = function(s, w)
	  if w ^ "сквер" then
		 p "Том пошёл было в сторону сквера, но его привлекло что-то внутри одного из ближайших зданий и он решил задержаться."
		 return false
	  end
   end,
   obj = {
	  obj {
			-"дома|здания",
		 nam = "дома",
		 dsc = "Высокие здания образуют широкую длинную улицу.",
		 description = function(s)
			return "Брошенные высотные " .. s:noun() .. " с пустыми тёмными окнами, заросшие какими-то вьющимися растениями.^^Через дверной проём виднеется в глубине здания едва заметное свечение."
		 end,
		 before_Take = function(s)
			return s:noun() .. " слишком огромные и тяжёлые, чтобы их можно было хотя бы чем-то приподнять."
		 end,
		 Touch = "Том дотронулся до стены ближайшего здания. Колючая зелень скрывает влажный бетон.",
		 Smell = "Пахнет зеленью и бетоном.",
		 obj = {
			obj {
				  -"зелень|растения|вьюн*",
			   nam = "вьюны",
			   description = "Эти вьющиеся растения разрослись как минимум на этой улице, покрыв стены буквально всех зданий.",
			   before_Take = "Тому не хочется рвать толстое колючее растение.",
			   Touch = "Жёсткое и колючее растение.",
			   Smell = "Пахнет сыростью и зеленью.",
			}:attr "scenery",
			obj {
				  -"стена|стены",
			   description = function(s)
				  local v
				  if s:multi_alias() == 1 then
					 v = " скрывается "
				  else
					 v = " скрываются "
				  end
				  return s:Noun() .. v .. "под слоем густой растительности."
			   end,
			}:attr "scenery",
			obj {
				  -"окна",
			   description = function(s)
				  if here() ^ "окраина города" then
					 return "Узкие тёмные провалы выглядят как многочисленные недобрые глаза. Впечатление усугубляет буйная растительность, покрывающая стены."
				  else
					 return "В окнах видна пустынная, ярко освещённая полуденным солнцем улица."
				  end
			   end,
			   ["before_Enter,Walk"] = "Лучше воспользоваться дверью.",
			   before_Take = "Окна без стёкол. Тому нечего взять.",
			   Smell = "Воздух пахнет бетоном и зеленью.",
			   Touch = "Окна без стёкол. Тому нечего потрогать.",
			}:attr "scenery",
		 },
	  }:attr "static",
	  obj {
			-"дом|ближайший дом|здание|ближайшее здание",
		 description = function(s)
			return _"дома":description(s)
		 end,
		 ["before_Walk,Enter"] = function(s)
			walk "внутри здания"
		 end,
		 obj = {
			obj {
				  -"свечение|свет",
			   nam = "свечение",
			   description = function(s)
				  return "Через дверной проём виднеется в глубине здания едва заметное свечение."
			   end,
			   before_Take = "Свечение невозможно взять.",
			   Smell = "Вряд ли свечение имеет какой-либо запах.",
			   Touch = "Том не может прикоснуться к светящемуся объекту с улицы.",
			}:attr "scenery",
		 },
	  }:attr "scenery",
	  obj {
			-"сквер",
		 dsc = "На востоке виден сквер.",
		 description = "Одичавший сквер, выглядит отсюда бесформенной массой.",
		 before_Take = "Сквер весьма затруднительно взять. Особенно на таком расстоянии.",
		 Touch = "Деревья слишком далеко, чтобы до них дотянуться.",
		 Smell = "На таком расстоянии запах не чувствуется.",
		 ["before_Walk,Enter"] = function(s)
			walk "сквер"
		 end,
	  }:attr "static"
   },
   e_to = "сквер",
}

obj {
	  -"стены|стена",
   description = "Бетонные стены. Кое где угадываются остатки обоев.",
   before_Take = "Стены невозможно взять.",
   Smell = "Стены пахнут пылью.",
   Touch = "Том дотронулся до стены и ощутил шершавый бетон под пальцами.",
   found_in = function(s)
	  if here().building and not here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

obj {
	  -"пол",
   description = "Пластиковое покрытие пол",
   before_Take = "Том не представляет как взять пол. Да и я тоже. А ты?",
   Smell = "Том не хочет нюхать пол.",
   Touch = "Пластиковое покрытие сохранило свою гладкость.",
   found_in = function(s)
	  if here().building and not here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

obj {
	  -"потолок",
   description = "Белый потолок без каких-либо примечательных деталей.",
   before_Take = "Том даже не дотягивается до потолка.",
   Smell = "Потолок находится слишком высоко.",
   Touch = "Том не дотягивается до потолка.",
   found_in = function(s)
	  if here().building and not here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

room {
	  -"здание",
   nam = "внутри здания",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том вошёл в заброшенное здание. После яркого солнечного дня снаружи полумрак помещения казался кромешной тьмой, но через пару минут глаза привыкли к освещению."
	  else
		 return "Том находится в заброшенном здании."
	  end
   end,
   onexit = function(s, w)
	  if w ^ "окраина города" then
		 if not _"гостиничный терминал".touched then
			p "Том решил, что стоит обследовать здание прежде чем идти дальше."
			return false
		 else
			walk "оглушён"
		 end
	  end
   end,
   obj = {
	  door {
			-"дверь|дверной проём",
		 description = function(s)
			if here() ^ "окраина города" then
			   return "Внутри слишком темно, чтобы с улицы можно было что-либо рассмотреть."
			else
			   return "Через дверной проём видна ярко освещённая улица."
			end
		 end,
		 before_Take = "Дверной проём это просто проём в стене. Его невозможно взять.",
		 door_to = function(s)
			if here() ^ "окраина города" then
			   return "внутри здания"
			else
			   return "окраина города"
			end
		 end,
		 found_in = {
			"окраина города",
			"внутри здания",
		 },
	  }:attr "scenery,open",
	  obj {
			-"лестница",
		 dsc = "Наверх ведёт широкая лестница.",
		 description = "Ступеньки потрескались от времени. На них лежит нечто истлевшее. Возможно, когда-то это был ковёр.",
		 before_Take = "Лестница слишком массивная, чтобы её можно было взять.",
		 Smell = "Тому не хочется нюхать лестницу.",
		 Touch = "Том дотронулся до лестницы. Шершавый бетон.",
		 ["before_Enter,Walk,Use"] = function(s)
			walk "второй этаж"
		 end,
		 obj = {
			obj {
				  -"ковёр|истлевший ковёр",
			   seen = false,
			   description = function(s)
				  if not s.seen then
					 s.seen = true
					 return "Комья чего-то серо-бурого. Похоже, это и правда когда-то был ковёр."
				  else
					 return "Старый истлевший ковёр лежит на ступенях неаккуратными комьями."
				  end
			   end,
			}:attr "scenery",
		 },
	  }:attr "static",
	  obj {
			-"свечение|свет|сияние|экран|прямоугольник|терминал",
		 nam = "терминал",
		 seen = false,
		 dsc = function(s)
			if not s.seen then
			   return "В углу светится голубоватым сиянием небольшой прямоугольник."
			else
			   return "В углу светится экран терминала."
			end
		 end,
		 description = function(s)
			if not s.seen then
			   s.seen = true
			   return "Том внимательно осмотрел светящийся прямоугольник. Это оказался экран терминала! Трудно представить, чтобы в этом заброшенном городе сохранился рабочий компьютерный терминал, но ещё сложнее представить, что кто-то мог бы собрать терминал сейчас."
			else
			   return "Удивительный, рабочий компьютерный терминал!"
			end
		 end,
		 before_Take = "Терминал слишком громоздкий, чтобы носить его с собой.",
		 Smell = "Пахнет пылью. Как и всё в этом здании.",
		 ["Touch,SwitchOn,Use"] = function(s)
			walk "гостиничный терминал"
		 end,
	  }:attr "static",
   },
   out_to = "окраина города",
   u_to = "второй этаж",
}

dlg {
	  -"гостиничный терминал|терминал",
   nam = "гостиничный терминал",
   building = true,
   reservation = false,
   touched = false,
   onenter = function(s)
	  s.touched = true
	  mp.msg.DLG_HELP = "Для выбора пункта меню введите цифру."
	  return "Том подошёл к терминалу. На экране отображается следующая информация:^^Добро пожаловать. Выберите действие:"
   end,
   phr = {
	  { true, "Свободные номера", "На экране отобразилась поэтажная схема гостиницы. Все номера отмечены зелёным цветом." },
	  { cond = function() return _"гостиничный терминал".reservation and disabled "ключ" end, "Получить ключ", function() p("Рядом с экраном открылась небольшая крышка. Под ней лежал ключ.^^" .. fmt.em "[ПОЛУЧЕН КЛЮЧ]"); enable "ключ"; take "ключ"; pop(); end  },
	  { cond = function() return not _"гостиничный терминал".reservation end, "Забронировать номер", function() p "Терминал предложил ввести желаемый номер, после чего запросил личную информацию и голосовое подтверждение. Том ввёл информацию наугад."; _"гостиничный терминал".reservation = true; end },
	  { true, "Завершить работу", function() p "Спасибо, что воспользовались терминалом."; mp.msg.DLG_HELP = "Для выбора фразы введите цифру."; walkback(); end },
   },
}

obj {
	  -"ключ",
   nam = "ключ",
   seen = false,
   description = function(s)
	  local v = "Небольшой электронный ключ. На боку у него выгравировано число 203. "
	  if not s.seen then
		 s.seen = true
		 v = v .. "Том точно помнит, что вводил на терминале другое число. "
	  end
	  v = v .. "Интересно, работает ли он ещё."
	  return v
   end,
   Smell = "Кусок пластика ничем не пахнет.",
   Touch = "Пластиковый ключ гладкий на ощупь.",
}:disable()

room {
	  -"второй этаж|этаж",
   nam = "второй этаж",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том поднялся на второй этаж. Лестница, ведущая выше, обвалилась."
	  else
		 return "Том находится на втором этаже."
	  end
   end,
   GetOff = function(s)
	  walk "внутри здания"
   end,
   obj = {
	  obj {
			-"двери|дверные проёмы",
		 dsc = "Двери, ведущие в номера отсутствуют.",
		 description = "За пустыми дверными проёмами видны пустые номера. На полу лежит мусор, обои на стенах ободраны клоками.",
		 before_Take = "Невозможно взять пустые дверные проёмы.",
		 Smell = "Пустые дверные проёмы не имеют запаха.",
		 Touch = "Том бы с радостью потрогал пустые дверные проёмы, если бы это было возможно.",
		 obj = {
			obj {
				  -"номера",
			   description = "Пустые однотипные комнаты. На полу лежит мусор, обои на стенах ободраны клоками.",
			   before_Take = "Том не представляет как можно взять комнату.",
			   Smell = "Пахнет пылью и чем-то затхлым.",
			   Touch = "Том не хотел бы ничего здесь трогать.",
			}:attr "scenery",
			obj {
				  -"обои",
			   description = "Старые пожелтевшие обои с нелепым узором.",
			   before_Take = "Тому не нужны эти бесполезные обрывки бумаги.",
			   Smell = "Пахнет старой бумагой и сыростью.",
			   Touch = "Тому не хочется трогать эти лохмотья.",
			}:attr "scenery",
			obj {
				  -"мусор",
			   description = "Какие-то деревянные и пластиковые обломки, битое стекло, комья истлевшего тряпья и что-то, происхождение чего Том не хотел бы знать.",
			   before_Take = "Тому не нужен этот отвратительный мусор.",
			   Smell = "Пахнет пылью и чем-то затхлым.",
			   Touch = "Том не хочет притрагиваться к этому отвратительному мусору.",
			}:attr "scenery",
		 },
	  }:attr "static",
	  door {
			-"дверь|дверь 203|уцелевшая дверь",
		 nam = "дверь 203",
		 dsc = function(s)
			if here() ^ "второй этаж" then
			   return "Только одна дверь уцелела."
			else
			   return true
			end
		 end,
		 description = "На двери написан номер 203.",
		 before_Take = "Дверь надёжно держится на месте.",
		 Smell = "Дверь пахнет пылью.",
		 Touch = "Том дотронулся до двери. Странно, но на ней даже не облупилась краска.",
		 ["before_Open,Push"] = function(s)
			if s:has "locked" then
			   return "Том толкнул дверь, но она не поддалась. Заперто."
			else
			   s:attr "open"
			   return "Том открыл дверь."
			end
		 end,
		 with_key = "ключ",
		 found_in = {
			"второй этаж",
			"номер 203",
		 },
		 door_to = function(s)
			if here() ^ "второй этаж" then
			   walk "номер 203"
			else
			   walk "второй этаж"
			end
		 end,
	  }:attr "static,openable,lockable,locked",
	  obj {
			-"номер|номер 203",
		 description = function(s)
			if _"дверь 203":has "open" then
			   return "Через дверь видно невероятное -- номер в идеальном состоянии. Как будто даже пыли в нём нет."
			else
			   return "Номер находится за закрытой дверью."
			end
		 end,
		 before_Take = "Номер это помещение. Его невозможно взять.",
		 Smell = function(s)
			if _"дверь 203":has "open" then
			   return "Из номера доносится едва уловимый приятный запах."
			else
			   return "Номер находится за закрытой дверью."
			end
		 end,
		 ["before_Enter,Walk"] = function(s)
			if _"дверь 203":has "open" then
			   walk "номер 203"
			else
			   return "Дверь номера заперта."
			end
		 end,
	  }:attr "scenery",
   },
   in_to = "номер 203",
   d_to = "внутри здания",
}:attr "supporter"

room {
	  -"номер|номер 203|203",
   nam = "номер 203",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том не без удивления вошёл в номер 203."
	  else
		 return "Том находится в номере 203."
	  end
   end,
   obj = {
	  obj {
			-"окна|окно",
		 dsc = "В окна льётся яркий дневной свет.",
		 description = "В окнах стоят целые стёкла, за которыми видна ярко освещённая полуденным солнцем улица.",
		 before_Take = "Тому не нужны окна. К тому же их не снять без инструментов.",
		 Smell = "Окно ничем не пахнет.",
		 Touch = "Том дотронулся до стекла. Гладкое и прохладное.",
		 before_Open = "Том попытался открыть окно, но оно не поддалось.",
	  }:attr "static,openable",
	  obj {
			-"кровать",
		 dsc = "Большую часть помещения занимает кровать.",
		 description = "Большая кровать. Выглядит очень удобной. Том никогда не спал ни на чём подобном.",
		 before_Take = "Кровать слишком большая и тяжёлая, чтобы ",
		 Smell = "Кровать ничем не пахнет.",
		 Touch = "Мягкая простынь, мягкая подушка, матрас, каких Том никогда не встречал в своей жизни.",
		 before_Enter = "Соблазн прилечь и вздремнуть на такой кровати очень велик, но Том хочется поскорее встретиться с Нэнси.",
	  }:attr "static,supporter,enterable",
	  obj {
			-"тумбочка|ящик",
		 dsc = "Рядом с кроватью стоит тумбочка.",
		 description = function(s)
			p "Ничем не примечательная тумбочка с выдвижным ящиком."
			mp:content(s)
		 end,
		 before_Take = "Тумбочка, конечно, симпатичная, но Том не хочет уносить её куда-либо.",
		 Smell = "Тумбочка не пахнет ничем примечательным.",
		 Touch = "Приятное на ощупь полированное дерево. Очень хорошая мебель.",
		 obj = {
			obj {
				  -"книга|книжка|библия",
			   nam = "книга",
			   ["Exam,Open"] = "На обложке можно различить название. \"Библия\". Том никогда не видел таких красивых книг, хоть эту и не пощадило время. К сожалению, слова невозможно разобрать.",
			   before_Take = "Тому показалось неправильным уносить отсюда эту книгу и он оставил всё как есть.",
			   Smell = "Пахнет старой бумагой.",
			   Touch = "Кожаная обложка приятна на ощупь.",
			},
		 },
	  }:attr "static,container,openable",
   },
   out_to = "второй этаж",
}

cutscene {
   nam = "оглушён",
   text = {
	  "Том вышел из здания.",
	  "Что-то мелькнуло с боку и он ощутил удар по голове.",
	  "В глазах потемнело и он потерял сознание.",
	  ". . .",
   },
   next_to = "лежанка",
}

room {
   nam = "сквер",
}

obj {
	  -"стены",
   description = "Стены окрашены в серый цвет.",
   before_Take = "Стены невозможно взять.",
   Smell = "Стены едва уловимо пахнут краской.",
   Touch = "Том дотронулся до стены. Гладкую краску приятно ощущать под пальцами.",
   found_in = function(s)
	  if here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

obj {
	  - "пол",
   description = "Бетонный пол без примечательных деталей.",
   before_Take = "Том не представляет как взять пол.",
   Smell = "Том не хочет нюхать пол.",
   Touch = "Шершавый и сухой бетон.",
   found_in = function(s)
	  if here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

obj {
	  -"потолок",
   description = "Белый потолок без примечательных деталей.",
   before_Take = "Том даже не дотягивается до потолка.",
   Smell = "Потолок слишком высоко.",
   Touch = "Том не дотягивается до потолка.",
   found_in = function(s)
	  if here().underground then
		 return true
	  else
		 return false
	  end
   end,
}:attr "scenery"

room {
	  -"камера",
   nam = "камера",
   building = true,
   underbground = true,
   known = false,
   seen = false,
   disp = function(s)
	  if s.known then
		 return "камера"
	  else
		 return "неизвестная комната"
	  end
   end,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том очнулся в незнакомой комнате без окон."
	  else
		 if not s.konwn then
			return "Том находится в незнакомой комнате."
		 else
			return "Том находится в клетке."
		 end
	  end
   end,
   onexit = function(s, w)
	  if w ^ "коридор" and not _"Сергей".talked then
		 p "Решётка закрыта."
		 return false
	  end
   end,
   Wait = function(s)
	  if _"Джо".talked then
		 if _"Сергей".talked then
			return false
		 else
			enable "Сергей"
			_"Сергей".talked = true
			walk "разговор Джо с Сергеем"
		 end
	  else
		 return false
	  end
   end,
   obj = {
	  obj {
			-"лежанка",
		 nam = "лежанка",
		 dsc = "В углу на полу лежит лежанка.",
		 description = "Лежанка из грубой ткани, набитая чем-то достаточно жёстким, чтобы лежать было не очень удобно.",
		 before_Take = "Тому не хочется брать это тряпьё.",
		 Smell = "Пахнет лежалыми тряпками.",
		 Touch = "Лежанка из грубой материи шершавая и жёсткая на ощупь.",
	  }:attr "static,supporter,enterable",
	  obj {
			-"решётка|прутья",
		 dsc = function(s)
			if _"Сергей".talked then
			   return "Решётка, преграждающая выход, открыта."
			else
			   return "Вместо двери выход из комнаты преграждает решётка."
			end
		 end,
		 description = function(s)
			if _"Джо".talked then
			   return "Надёжная металлическая решётка."
			else
			   return "Толстые металлические прутья не оставляют надежды легко выбраться из комнаты."
			end
		 end,
		 before_Take = "Том подёргал прутья. Не поддаются.",
		 Smell = "Пахнет железом.",
		 Touch = "Прутья гладкие и очень твёрдые.",
	  }:attr "static",
	  obj {
			-"охранник|человек|незнакомец|Джо",
		 nam = "Джо",
		 known = false,
		 talked = false,
		 dsc = function(s)
			if not s.talked or disabled "Сергей" then
			   if not s.known then
				  return "По ту сторону решётки сидит человек."
			   else
				  return "По ту сторону решётки сидит Джо."
			   end
			else
			   return "Рядом с дверью стоят Джо"
			end
		 end,
		 description = function(s)
			local v
			if s.known then
			   v = "Джо"
			else
			   v = "Человек"
			end
			v = v .. " одет в невзрачную одежду."
			if not s.talked then
			   v = v .. " Он сидит на маленьком складном стульчике."
			end
			return v
		 end,
		 Smell = "Пахнет потом.",
		 Touch = function(s)
			local v = "Том не дотягивается до "
			if s.known then
			   v = v .. "Джо."
			else
			   v = v .. "человека."
			end
		 end,
		 talk_to = function(s)
			if not s.talked then
			   s.talked = true
			   walk "разговор с Джо"
			else
			   if disabled "Сергей" then
				  p "Джо спит на своём маленьком стульчике. Или только делает вид, что спит. В любом случае, не похоже, что он расположен к дальнейшей беседе."
			   else
				  p "Джо не расположен к беседе."
			   end
			end
		 end,
		 daemon = function(s)
			if _"зал".talked then
			   if here() ^ "коридор" then
				  disable(s)
				  disable "Сергей"
				  p "Джо и Сергей прошли через узкую боковую дверь."
			   end
			else
			   if here() ^ "коридор" then
				  place(s, "зал")
				  place("Сергей", "зал")
				  p "Джо и Сергей проследовали по коридору на север и прошли через дверь."
			   end
			end
		 end,
	  }:attr "animate",
	  obj {
			-"Сергей",
		 nam = "Сергей",
		 talked = false,
		 dsc = "и Сергей.",
		 description = "Крупный жилистый мужчина.",
		 Smell = "Пахнет каким-то моющим средством.",
		 Touch = "Том не хочет трогать посторонних людей просто так.",
	  }:attr "animate":disable(),
	  obj {
			-"стул|стульчик|складной стул",
 		 description = "Маленький складной стульчик. Просто доска и несколько брусков, собранных в практичную складную конструкцию.",
		 before_Take = function(s)
			local v
			if _"Джо".known then
			   v = "Джо"
			else
			   v = "охранник"
			end
			return "На стуле сидит " .. v .. ". Вряд ли бы ему понравилось, если бы Том выхватил из под него стул. Даже если бы и смог дотянуться."
		 end,
		 Smell = "Том не хочет нюхать стул.",
		 Touch = "Том не дотягивается до стула.",
	  }:attr "scenery",
	  obj {
			-"лампа|лампочка|светильник|плафон",
		 description = "Небольшая лампа на потолке даёт немного света. Впрочем, вполне достаточно, чтобы разглядеть обстановку во всех деталях.",
		 before_Take = function(s)
			return s:Noun() .. " висит слишком высоко."
		 end,
		 Smell = function(s)
			return s:Noun() .. " висит слишком высоко."
		 end,
		 Touch = function(s)
			return s:Noun() .. " висит слишком высоко. Том не дотягивается."
		 end,
	  }:attr "scenery",
	  obj {
			-"коридор",
		 description = function(s)
			if _"Джо".talked then
			   return "За дверным проёмом частично виден коридор."
			else
			   return "За решёткой частично виден коридор."
			end
		 end,
		 before_Take = "Коридор невозможно взять. Это помещение.",
		 Smell = "Из коридора пахнет чем-то едва уловимым и трудно угадываемым.",
		 Touch = "Том не может коснуться коридора.",
		 ["before_Enter,Walk"] = function(s)
			walk "коридор"
		 end,
	  }:attr "scenery",
   },
   e_to = "коридор",
   out_to = "коридор",
}

dlg {
   nam = "разговор с Джо",
   disp = "разговор",
   onenter = "Человек заметил, что Том очнулся и начал разговор первым:^^-- О! Очнулся. Серёга сильно тебя приложил, конечно.",
   phr = {
	  { "Ты кто?", function() p "-- Меня зовут Джо."; _"Джо".known = true; end,
		{ "Что случилось?", "-- Зачем ты полез к терминалу? Кто тебя просил? Вот мы тебя и приняли, чтобы ты ещё каких глупостей не натворил.",
		  { "Глупостей?", "-- Конечно. Терминал находится в общегородской сети.",
			{ "Я всё равно не понимаю что это значит.", "-- Это значит, что автоматическая система защиты города отреагировала на твои действия и активизировалась впервые за много лет. Это сделает нашу жизнь гораздо менее спокойной, чем нам хотелось бы.",
			  { "Менее спокойной?", "-- Конечно! Давным давно, автоматизированная оборонная система, построенная для защиты от Хьёртов, была кем-то перепрограммирована и начала борьбу с любой высокоразвитой жизнью.",
				{ "Ты хочешь сказать, что и с людьми тоже?", "-- И с людьми и с домашними животными. Это была настоящая бойня. Во всяком случае, так рассказывают старики, которые застали те далёкие события.",
				  { "Что теперь будет?", "-- С нами? Неизвестно. Нашей спокойной жизни пришёл конец, но что мы будем делать дальше, пока неизвестно. Мы привыкли к городу. Мы всю жизнь здесь прожили. И наши родители и наши деды. Ценой большой осторожности они смогли обеспечить нам спокойное существование, но оно не могло продолжаться дальше. А что будет с тобой, решит совет. Запасёмся терпением -- какое-то время придётся подождать." },
				},
			  },
			},
		  },
		},
	  },
	  { "Где я?", "-- Ты табличку на входе в город не читал что ли?",
		{ "Я всё ещё в городе?", "-- Если точнее, то под ним. Наверху слишком опасно и мы редко туда поднимаемся. Если бы не твоя выходка, то мы бы ещё не скоро предприняли очередную вылазку.",
		  { "Вы живёте под землёй?", "-- Поверь, это не так плохо, как может показаться. У нас здесь есть всё, что может понадобиться. Некоторые за всю жизнь поднимаются на поверхность всего несколько раз, и им там не особо нравится.",
			{ "Сложно представить.", "-- Нам сложно представить, как можно жить на поверхности. Хотя, похоже, теперь придётся переучиваться, как в своё время пришлось переучиваться жить нашим дедам.",
			  { "Они спустились под землю?", "-- Под землёй уже был свой город. Практически всё производство находилось именно тут. Многие тогда решили, что лучше остаться в городе, чем искать себе место вдали от родных мест. Давай пока помолчим и дождёмся решения совета. Я, честно говоря, не прочь вздремнуть." },
			},
		  },
		},
	  },
   },
}

cutscene {
   nam = "разговор Джо с Сергеем",
   disp = "разговор",
   text = {
	  "К Джо подошёл какой-то мужчина.",
	  "-- Ну что там? -- спросил у подошедшего Джо?",
	  "-- С этим, -- он кивнул в мою сторону, -- пока ничего не делаем.",
	  "-- О чём же тогда так долго совещались?",
	  "-- Задались вопросом, почему мы до сих пор сидим под землёй.",
	  "-- Но снаружи же хьёрты!",
	  "-- А ты у нашего гостя спроси откуда он пришёл.",
   },
   next_to = "разговор с Джо и Сергеем",
}

dlg {
   nam = "разговор с Джо и Сергеем",
   disp = "разговор",
   onenter = "Джо повернулся ко мне и спросил:^^-- Откуда ты пришёл?",
   onexit = function(s)
	  _"Джо".talked = true
	  walk "камера"
	  p "Джо открыл решётку."
	  _"Джо":daemonStart()
	  return false
   end,
   phr = {
	  { "Из Шеффилда. Иду в Лидс к жене.", "-- И что же? Можно так вот запросто ходить по поверхности?",
		{ "Конечно можно. Только надо соблюдать осторожность: дикие звери далеко не все дружелюбны да иногда хьёрты попадаются.", "Иногда? И насколько же это иногда?",
		  { "Однажды я встретил хьёрта. Ещё мальчишкой. Если в лесах соблюдать элементарные правила, то встречи можно избежать. Главное - не привлекать к себе внимание по ночам.", "-- То есть снаружи достаточно безопасно, чтобы жить?",
			{ "До сегодняшнего дня я и не знал, что можно жить под землёй. Я и мои предки всегда жили на поверхности.", "-- Это нужно рассказать совету, -- вклинился в разговор неизвестный.^-- Серёга прав, -- обратился ко мне Джо.",
			  { "Можно подумать, у меня сейчас есть выбор. Я согласен.", "Джо усмехнулся:^^-- Ну да, ты прав. Пойдём, -- с этими словами он открыл решётку." },
			},
		  },
		},
	  },
   },
}

room {
	  -"коридор",
   nam = "коридор",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Том вышел в коридор. Очень длинный коридор. Том никогда не видел таких длинных помещений."
	  else
		 return "Том находится в коридоре."
	  end
   end,
   onenter = function(s, f)
	  place("Джо")
	  place("Сергей")
   end,
   obj = {
	  obj {
			-"камера",
		 description = "Небольшая комната с лежанкой и лампой под потолком.",
		 before_Take = "Том не знает как можно взять комнату в руки.",
		 Smell = "Нужно отдать должное -- воздух в этом подземном комплексе вполне свежий. Конечно, не такой как на поверхности, но всё равно дышать им даже приятно.",
		 Touch = "Невозможно потрогать комнату.",
		 ["before_Enter,Walk"] = function(s)
			walk "камера"
		 end,
	  }:attr "scenery",
	  obj {
			-"зал",
		 description = "За дверью, ведущей в зал, ничего не видно.",
		 before_Take = "Том не знает как взять большой зал в руки.",
		 Smell = "Ничего особенного. Пахнет как и везде в этом комплексе.",
		 Touch = "Невозможно потрогать большое помещение.",
		 ["before_Enter,Walk"] = function(s)
			walk "зал"
		 end,
	  }:attr "scenery",
	  door {
			-"дверь|узкая дверь|боковая дверь",
		 dsc = "Посередине коридора находится небольшая дверь.",
		 description = "Узкая деревянная дверь.",
		 before_Take = "Дверь тяжёлая. Один Том не снимет её с петель.",
		 Smell = "Дверь пахнет старым деревом.",
		 Touch = "Деревянная дверь шершавая на ощупь.",
		 door_to = function(s)
			walk "конец"
		 end,
		 before_Open = function(s)
			if not _"зал".talked then
			   return "Дверь заперта."
			else
			   return false
			end
		 end,
	  }:attr "static",
   },
   w_to = "камера",
   n_to = "зал",
}

room {
	  -"зал",
   nam = "зал",
   talked = false,
   dsc = "Том находится в просторном зале.",
   onenter = function(s)
	  if not s.talked then
		 s.talked = true
		 walk "разговор с советом"
	  end
   end,
   onexit = function(s)
	  walk "зал"
   end,
   obj = {
	  obj {
			-"совет|члены совета|люди",
		 dsc = "За длинным столом сидит несколько человек.",
		 description = "Невзрачные люди. Наверное, редко когда человек, наделённый властью привлекает внимание своей внешностью.",
		 before_Take = "Том не хочет брать членов совета.",
		 Smell = "Нюхать их Тому совсем не хочется.",
		 Touch = "Было бы бестактно трогать членов совета.",
	  }:attr "static,animate",
	  obj {
			-"стол",
		 description = "Деревянный стол, накрытой однотонной скатертью.",
		 before_Take = "Стол слишком большой.",
	  }:attr "scenery",
   },
   s_to = "коридор",
   out_to = "коридор",
}

dlg {
   nam = "разговор с советом",
   disp = "разговор",
   onenter = "Том очутился в просторном зале, где за столом сидело несколько человек. Похоже, это и есть упомянутый ранее совет. Один из членов совета обратился к тому:^^-- Итак, ты пришёл с поверхности?",
   onexit = function(s, t)
	  walk "зал"
   end,
   phr = {
	  { "Да. Я иду из Шеффилда в Лидс. Там моя жена.", "-- Ты хочешь сказать, что хьёртов удалось победить?",
		{ "Нет. Они просто ушли. Мне отец рассказывал.", "-- Наверху теперь безопасно?",
		  { "Не совсем. Иногда хьёрты появляются и охотятся, но если соблюдать осторожность, то можно не опасаться.", "-- Ты нарушил покой машин. Теперь наше поселение снова под угрозой. Мы отпустим тебя, если ты покажешь внешний мир Джо и Сергею. Они помогут тебе выйти из города незамеченным.",
			{ "Показать мир? Что вы имеете в виду?", "-- Если то, что ты говоришь о поверхности, правда, то мы можем покинуть город. Но прежде чем начать переселение, нужно удостовериться в том, что на поверхности можно жить.",
			  { "Похоже, выбора у меня всё равно нет. Я помогу вам.", "-- Хорошо. Наши люди уже готовы. Они проводят тебя к выходу." },
			},
		  },
		},
	  },
   },
}

gameover {
   nam = "конец",
   dsc = "Том прошёл через узкую дверь в ещё один коридор. Спустя некоторое время блужданий он вместе со своими спутниками оказался перед ярким пятном выхода из подземного города.^^Никто никогда не слышал про подземный город и на самом деле, Том был совсем не рад тому, что нашёл его.^^Где-то в Лидсе его ждёт Нэнси...",
}
