room {
   nam = "озеро",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Через уютную темноту небытия до Максима дотянулся холод. \"Откуда в нигде может взяться холод?\" подумал он и эта мысль стала первой, в череде спешных размышлений, приведших к полному возвращению в сознание и открытию глаз.^^Максим обнаружил себя лежащим на снегу на некотором расстоянии от своего корабля. Преодолевая боль во всём теле, он встал на ноги."
	  else
		 return "Максим находится посреди снежной равнины."
	  end
   end,
   obj = {
	  obj {
		 nam = "корабль_о",
		 seen = false,
		 dsc = "Неподалёку от Максима находится {корабль}.",
		 act = function(s)
			local v = "Да... Досталось кораблю знатно. Одно крыло раскололось, сенсоры на носу превратились в кремниевое крошево, а корпус рядом с люком лопнул."
			if not s.seen then
			   s.seen = true
			   enable "люк"
			   enable "крыло"
			   v = v .. " Как Максим оказался снаружи корабля и как при этом выжил, он не имеет ни малейшего понятия."
			end
			return v
		 end,
		 obj = {
			obj {
			   nam = "люк",
			   o = false,
			   dsc = "В боку корабля есть {люк}.",
			   act = function(s)
				  if not s.o then
					 return "Похоже, люк деформировался при падении и сейчас не открывается."
				  else
					 return "Люк открыт и Максим не уверен, что сможет открыть его повторно. Так что пусть остаётся открытым."
				  end
			   end,
			}:disable(),
			obj {
			   nam = "крыло",
			   try = 0,
			   dsc = "Одно {крыло} немного зарылось в снег.",
			   act = function(s)
				  local v
				  if s.try == 0 then
					 v = "Крыло раскололось. Его каркас и обломки фюзеляжа торчат веером."
				  elseif s.try < 4 then
					 v = "Максим попробовал раскачать обломок каркаса, но тот крепко держится."
				  elseif s.try == 4 then
					 take "обломок крыла"
					 v = "Максим в очередной раз потянул обломок и в этот раз тот поддался. С неприятным скрежетом, он отломился"
				  else
					 v = "Максиму больше ни к чему доламывать крыло."
				  end
				  s.try = s.try + 1
				  return v
			   end,
			}:disable(),
		 },
	  },
	  obj {
		 nam = "лёд",
		 seen = false,
		 dsc = "Рядом с ним начинается ледяная {гладь}.",
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   return "Глядя на неё, Максим едва сдерживает дрожь. Упади корабль на лёд, едва ли бы тогда удалось выжить."
			else
			   return "Корабль упал на берегу большого озера."
			end
		 end,
	  },
   },
   way = {
	  "корабль",
   },
}

obj {
   nam = "обломок крыла",
   inv = "Небольшой обломок каркаса крыла корабля. Длинный и круглый в сечении.",
   use = function(s, w)
	  if w ^ "корабль" then
		 return "Бить корабль бессмысленно."
	  elseif w ^ "люк" then
		 w.o = true
		 enable "корабль"
		 return "Максим вставил обломок в щель между люком и лопнувшей обшивкой и навалился всем весом. Не с первой попытки, но ему всё таки удалось сдвинуть люк. Теперь можно попасть внутрь корабля."
	  elseif w ^ "крыло" then
		 return "Нет смысла дальше ломать крыло."
	  elseif w ^ "лёд" then
		 return "Пока что Максим не испытывает никакого желания проверить толщину льда на озере."
	  elseif w ^ "бортовой компьютер" then
		 return "Максим не хочет ломать бортовой компьютер. Наоборот -- он хочет его починить."
	  elseif w ^ "крышка силовой установки" then
		 disable(w)
		 disable(s)
		 enable "силовая установка"
		 return "Максим вставил обломок в щель между крышкой и внутренней обшивкой корабля и навалился на него. Крышка выгнулась, но поддалась. С грохотом она упала на пол."
	  end
   end,
}

room {
   nam = "корабль",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим забрался в корабль. Внутри он выглядит не лучше, чем снаружи. Большинство приборов разбито, пол усеян осколками пластика, текстолита и кремния."
	  else
		 return "Максим находится в корабле."
	  end
   end,
   obj = {
	  obj {
		 nam = "бортовой компьютер",
		 seen = false,
		 on = false,
		 dsc = function(s)
			if not s.on then
			   return "Перед креслом пилота находится бортовой {компьютер}."
			else
			   return "Перед креслом пилота светится экран бортового {компьютера}."
			end
		 end,
		 act = function(s)
			local v = ""
			if not s.on then
			   v = "Компьютер обесточен."
			   if not s.seen then
				  s.seen = true
				  v = v .. " Нужно проверить силовую установку."
			   end
			   return v
			else
			   walk "интерфейс бортового компьютера"
			end
		 end,
	  },
	  obj {
		 nam = "крышка силовой установки",
		 dsc = "Сбоку в стене есть {крышка} силовой установки.",
		 act = "Максим попытался открыть крышку руками, но у него ничего не вышло."
	  },
	  obj {
		 nam = "силовая установка",
		 seen = false,
		 dsc = "Сбоку в стене зияет проём, в котором видна силовая {установка} корабля.",
		 act = "Силовая установка не подаёт никаких признаков жизни. Похоже, она полностью выведена из строя.",
	  }:disable(),
	  obj {
		 nam = "дверь во второй отсек",
		 dsc = "За креслом пилота находится {дверь} во второй отсек корабля",
		 act = "Хорошо, что Максим всегда держит эту дверь открытой. По крайней мере её не заело в закрытом состоянии.",
	  },
   },
   way = {
	  path{ "наружу", "озеро" },
	  "второй отсек",
   },
}:disable()

room {
   nam = "второй отсек",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим вошёл во второй отсек. Вообще, он задуман как ангар для квадроцикла, но Максим использует его и как кладовую, так как класс корабля не рассчитан на долгие перелёты."
	  else
		 return "Максим находится во втором отсеке."
	  end
   end,
   obj = {
	  obj {
		 nam = "квадроцикл",
		 seen = false,
		 disp = fmt.b("квадроцикл"),
		 dsc = function(s)
			if here() ^ "второй отсек" then
			   return "Большую часть отсека занимает {квадроцикл}."
			else
			   return "Рядом со входом стоит {квадроцикл}."
			end
		 end,
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   enable "аккумулятор"
			   return "Максим включил квадроцикл - энергия есть!"
			else
			   if disabled "у странных построек" then
				  return "Интересно, сгодится ли он для езды по снегу?"
			   else
				  if not _"аппарель".op then
					 return "Стоит съездить посмотреть что за источник сигнала такой. В каталоге планета числится необитаемой."
				  else
					 if not _"аккумулятор".disconnect and not _"аккумулятор".removed then
						walk "на квадроцикле"
					 else
						return "Сперва стоит подключить и зафиксировать аккумулятор."
					 end
				  end
			   end
			end
		 end,
		 obj = {
			obj {
			   nam = "аккумулятор",
			   disconnect = false,
			   removed = false,
			   dsc = function(s)
				  if where(s) ^ "квадроцикл" then
					 return "В нём установлен {аккумулятор}."
				  else
					 return "В ней установлен {аккумулятор}."
				  end
			   end,
			   tak = function(s)
				  if s.removed then
					 if s.disconnect then
						return "Максим взял аккумулятор."
					 else
						p "Аккумулятор подключен к "
						if where(s) ^ "квадроцикл" then
						   p "квадроциклу."
						else
						   p "силовой установке."
						end
						return false
					 end
				  else
					 p "Аккумулятор жёстко закреплён в квадроцикле."
					 return false
				  end
			   end,
			   inv = "Универсальный аккумулятор. Вполне годится для обеспечения работы квадроцикла. Должен потянуть и компьютер корабля.",
			   use = function(s, w)
				  if w ^ "квадроцикл" then
					 place(s, w)
					 return "Максим вставил аккумулятор в квадроцикл."
				  elseif w ^ "силовая установка" then
					 place(s, w)
					 return "Максим вставил аккумулятор в силовую установку."
				  else
					 return "Аккумулятор тут без надобности."
				  end
			   end,
			}:disable(),
		 },
	  },
	  obj {
		 nam = "стеллажи",
		 seen = false,
		 dsc = "Вдоль стен установлены {стеллажи}.",
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   enable "ящик с инструментами"
			   return "Среди банок с концентрированной едой, дисками с софтом и запасных колёс для квадроцикла на стеллаже закреплён ящик с инструментами."
			end
			return "Стеллажи для хранения полезных вещей -- еды, софта и колёс для квадроцикла."
		 end,
		 obj = {
			obj {
			   nam = "ящик с инструментами",
			   dsc = "На стеллаже закреплён {ящик} с инструментами.",
			   tak = "Максим взял ящик с инструментами.",
			   inv = function(s)
				  disable(s)
				  take "отвёртка"
				  take "гаечный ключ"
				  return "Максим вытащил из ящика отвёртку и гаечный ключ."
			   end,
			}:disable(),
		 },
	  },
	  obj {
		 nam = "аппарель",
		 op = false,
		 dsc = "Почти вся дальняя стена представляет собой {аппарель}.",
		 act = function(s)
			if disabled "панель управления аппарелью" then
			   enable "панель управления аппарелью"
			   return "Рядом с аппарелью на стене есть панель управления."
			end
		 end,
	  },
	  obj {
		 nam = "панель управления аппарелью",
		 dsc = "Рядом с ней расположена {панель} управления.",
		 act = function()
			_"аппарель".op = not _"аппарель".op
			if _"аппарель".op then
			   open "#наружу"
			   return "Максим нажал кнопку открытия на пульте и с механическим жужжанием аппарель опустилась."
			else
			   close "#наружу"
			   return "Максим нажал на кнопку закрытия на пульте и с механическим жужжанием аппарель поднялась."
			end
		 end,
	  }:disable(),
   },
   way = {
	  "корабль",
	  path{ "#наружу", "наружу", "озеро" }:close(),
   },
}

obj {
   nam = "отвёртка",
   inv = "Обычная универсальная отвёртка. Годится для любых винтов.",
   use = function(s, w)
	  if w ^ "аккумулятор" then
		 if not w.disconnect then
			w.disconnect = true
			_"бортовой компьютер".on = false
			return "Максим отсоединил клеммы аккумулятора."
		 else
			if where(w) ^ "квадроцикл" then
			   w.disconnect = false
			   return "Максим подключил аккумулятор к квадроциклу."
			elseif w.removed then
			   if where(w) ^ "силовая установка" then
				  w.disconnect = false
				  _"бортовой компьютер".on = true
				  return "Максим подключил бортовой компьютер к аккумулятору."
			   end
			   return "Максим уже отключил аккумулятор. Осталось его снять."
			end
		 end
	  elseif w ^ "медицинский робот" and not have "прут" then
	 take "прут"
		 return "Максим частично разобрал робота. В нём обнаружился металлический прут."
	  else
		 return "Отвёртка тут не поможет."
	  end
   end,
}

obj {
   nam = "гаечный ключ",
   inv = "Разводной гаечный ключ. Полезнейшая в ремонте вещь.",
   use = function(s, w)
	  if w ^ "аккумулятор" then
		 if where(w) ^ "квадроцикл" then
			if w.removed then
			   w.removed = false
			   return "Максим затянул крепление аккумулятора."
			else
			   w.removed = true
			   return "Максим открутил крепление аккумулятора."
			end
		 else
			return "В силовой установке нет крепления для аккумулятора."
		 end
	  else
		 return "Гаечный ключ тут бесполезен."
	  end
   end,		 
}

room {
   nam = "интерфейс бортового компьютера",
   noinv = true,
   disp = "бортовой компьютер",
   decor = function(s)
	  return "• {@ walk \"диагностика корабля\"|Диагностика}^• {@ walk \"пространственные сенсоры\"|Пространственные сенсоры}^• {@ walk связь|Связь}^^• {@ walk корабль|Назад}"
   end,
}

room {
   nam = "диагностика корабля",
   noinv = true,
   seen = false,
   decor = function(s)
	  local v = "Диагностика систем корабля:^^• " ..  fmt.b("Силовая установка... ") .. "НЕТ СВЯЗИ^• " .. fmt.b("Двигатели... ") .. "НЕТ СВЯЗИ^• ".. fmt.b("Система атмосферного маневрирования... ") .. "НЕТ СВЯЗИ^• " .. fmt.b("Система дальней связи... ") .. "ВЫШЛА ИЗ СТРОЯ^• " .. fmt.b("Система связи... ") .. "ПЕРЕДАТЧИК ВЫШЕЛ ИЗ СТРОЯ^• " .. fmt.b("Пространственные сенсоры... ") .. "НЕТ СВЯЗИ^^Корабль не пригоден к полёту. Пожалуйста, свяжитесь с ближайшей станцией Союза Человеческих Колоний."
	  if not s.seen then
		 s.seen = true
		 v = v .. fmt.em("^^Максим усмехнулся и подумал: \"Отличная рекомендация при неработающих то системах связи. Программисты никогда не меняются.\".")
	  end
	  v = v .. "^^• {@ walk \"интерфейс бортового компьютера\"|Назад}"
	  return v
   end,
}

room {
   nam = "пространственные сенсоры",
   noinv = true,
   decor = fmt.b("ВНИМАНИЕ!!!") .. "^^ПРОСТРАНСТВЕННЫЕ СЕНСОРЫ НЕДОСТУПНЫ!^^• {@ walk \"интерфейс бортового компьютера\"|Назад}",
}

room {
   nam = "связь",
   noinv = true,
   decor = "• {@ walk \"дальняя связь\"|Дальняя связь}^• {@ walk \"планетарная связь\"|Планетарная связь}^^• {@ walk \"интерфейс бортового компьютера\"|Назад}",
}

room {
   nam = "дальняя связь",
   noinv = true,
   decor = "ВНИМАНИЕ!!! МОДУЛЬ ДАЛЬНЕЙ СВЯЗИ ВЫШЕЛ ИЗ СТРОЯ^^• {@ walk связь|Назад}",
}

room {
   nam = "планетарная связь",
   noinv = true,
   dsc = "ВНИМАНИЕ!!! ПЕРЕДАТЧИК ВЫШЕЛ ИЗ СТРОЯ.^^ЗАФИКСИРОВАН НЕОПОЗНАННЫЙ СИГНАЛ НА СЕВЕРО-ЗАПАДЕ.^^ВЫЧИСЛЯЮ РАССТОЯНИЕ...^^ОШИБКА! ВЫШЛИ ИЗ СТРОЯ 3 ЭЛЕМЕНТА НИЖНЕГО ЛИТЕРА АНТЕННЫ.",
   decor = "• {@ walk связь|Назад}",
   enter = function()
	  if disabled "у странных построек" then
		 enable "у странных построек"
	  end
   end,
}
room {
   nam = "на квадроцикле",
   decor = "Максим находится в седле квадроцикла. Простое и надёжное средство передвижения.",
   way = {
	  path{ "корабль", "второй отсек" },
	  path{ "по пеленгу", after = "к постройкам", "у странных построек" },
   },
}

room {
   nam = "у странных построек",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим слез с квадроцикла. Рядом с ним высится крупный комплекс искусственных сооружений. Встретить такое Максим никак не ожидал -- во всех каталогах Тета-2234 числится как необитаемая."
	  else
		 return "Максим находится рядом с загадочными постройками."
	  end
   end,
   enter = function(s)
	  if not s:visited() then
		 snd.music "snd/b.xm"
	  end
   end,
   obj = {
	  obj {
		 nam = "стена",
		 dsc = "В {стене} видна",
		 act = "Стена состоит из металлических листов. Стыки такие плотные, что едва заметны.",
		 obj = {
			obj {
			   nam = "дверь строения",
			   dsc = "{дверь}.",
			   act = function()
				  local v = "Судя по всему дверь открывается автоматически."
				  if disabled "панель строения" then
					 enable "панель строения"
					 v = v .. "Рядом с ней есть панель с клавишами."
				  end
				  return v
			   end,
			   obj = {
				  obj {
					 nam = "панель строения",
					 dsc = "Рядом с ней находится {панель} с единственной клавишей.",
					 act = function()
						if disabled "коридор" then
						   enable "коридор"
						   return "Максим нажал на клавишу и дверь с пневматическим шипением открылась."
						else
						   return "Максим нажал на клавишу снова, но ничего не произошло."
						end
					 end,
				  },
			   },
			},
		 },
	  },
	  "квадроцикл",
   },
   way = {
	  path{ "внутрь", "коридор" },
   },
}:disable()

room {
   nam = "коридор",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "За дверью Максим обнаружил тёмный коридор, едва освещённый редкими светильниками."
	  else
		 return "Максим находится в коридоре."
	  end
   end,
   obj = {
	  obj {
		 nam = "пол коридора",
		 dsc = "Под ногами находится металлический {пол}.",
		 act = "За решёткой пола угадываются какие-то коммуникации.",
	  },
	  obj {
		 nam = "стены коридора",
		 dsc = "Краска на {стенах} облупилась от старости.",
		 act = "Сколько же лет этому сооружению?",
	  },
	  obj {
		 nam = "светильники",
		 seen = false,
		 dsc = "Под потолком расположены {светильники}.",
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   return "Такие светильники Максим видел только на древних изображениях, демонстрировавшихся на занятиях по истории. Значит, это человеческое сооружение. Сколько же ему лет?"
			else
			   return "Древние светильники с матовым плафоном. Может быть, это даже стекло!"
			end
		 end,
	  },
   },
   way = {
	  path{ "наружу", "у странных построек" },
	  path{ "дверь", after = "кают-компания", "кают-компания" },
   },
}:disable()

room {
   nam = "кают-компания",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Просторное помещение напомнило Максимы кают-компанию старинного корабля. Так он и окрестил это помещение про себя."
	  else
		 return "Максим находится в кают-компании."
	  end
   end,
   obj = {
	  obj {
		 nam = "буфеты",
		 dsc = "Вдоль стен стоят {шкафы}.",
		 act = function()
			if disabled "брикеты" then
			   enable "брикеты"
			   return "Максим открыл один из шкафов. Внутри оказались какие-то брикеты в герметичной упаковке."
			else
			   return "Металлические шкафы. Впрочем, не без излишеств в виде незамысловатых украшений."
			end
		 end,
		 obj = {
			obj {
			   nam = "брикеты",
			   dsc = "В одном из них лежат {брикеты}",
			   act = function()
				  if not have "брикет" then
					 take "брикет"
					 return "Максим взял один из них."
				  else
					 if _"брикет".seen then
						return "В шкафу лежит множество брикетов в герметичной упаковке."
					 else
						return "Похоже, здесь находится запас еды. Интересно для кого она предназначена?"
					 end
				  end
			   end,
			}:disable(),
			obj {
			   nam = "стол в кают-компании",
			   dsc = "Большую часть помещения занимает {стол}.",
			   act = "Большой металлический стол с пластиковым покрытием.",
			},
			obj {
			   nam = "кресла",
			   dsc = "Вокруг стола установлены {кресла}.",
			   act = "Древние кресла из какого-то грубого полимера. Максим встречал нечто подобное в музее космогации на Каллисто, когда летал в Солнечную систему в отпуск.",
			},
		 },
	  },
   },
   way = {
	  "коридор",
	  path{ "вторая дверь", after="кольцо", "кольцевой коридор" },
   },
}

obj {
   nam = "брикет",
   seen = false,
   inv = function(s)
	  if not s.seen then
		 s.seen = true
		 return "На брикете обнаружились надписи на человеческом языке. Максим не очень силён в мёртвых языках и смог прочитать только пару слов: \"концентрат\" и \"энергетический\". Похоже, это какая-то еда."
	  else
		 return "Есть это Максим не отважится. Неизвестно сколько лет этой пище."
	  end
   end,
   use = "Максим не думает, что древняя испорченная еда как-нибудь может тут помочь.",
}

room {
   nam = "кольцевой коридор",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим вошёл в коридор, плавно закругляющийся в обе стороны от входа. Похоже, он представляет собой тор."
	  else
		 return "Максим находится в кольцевом коридоре."
	  end
   end,
   onenter = function()
	  if _"труп".seen then
		 return "Из динамика раздался приятный женский голос: \"Отоко. Йиге нанрен. Ай манн. Хьюман. Человек.\"."
	  end
   end,
   obj = {
	  obj {
		 nam = "светильники в коридоре",
		 dsc = "Под потолком висят {светильники}.",
		 act = "Древние светильники с матовыми плафонами. Часть из них не горит.",
	  },
	  obj {
		 nam = "динамик",
		 talk = false,
		 dsc = "На стене висит {динамик}.",
		 act = function(s)
			if _"труп".seen and not s.talk then
			   s.talk = true
			   walk "первый диалог"
			else
			   if s.talk and not live "ИР" then
				  return "-- Ты меня слышишь?^^Вопрос остался без ответа."
			   else
				  return "Старинное устройство для воспроизведения звука."
			   end
			end
		 end,
	  },
   },
   way = {
	  "кают-компания",
	  path{ "дверь 1", after = "медотсек", "медотсек" },
	  "операторская",
	  path{ "дверь 2", after = "ангар", "ангар" },
	  path{ "дверь 3", after = "шахта", "шахта" },
   },
}

room {
   nam = "медотсек",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим вошёл в просторное помещение, внешним видом напоминающее медотсек на древних кораблях."
	  else
		 return "Максим находится в медотсеке."
	  end
   end,
   obj = {
	  obj {
		 nam = "операционный стол",
		 dsc = "Посреди помещения стоит {стол}.",
		 act = function()
			local v = "Операционный стол. Холодный и мрачный."
			if disabled "труп" then
			   enable "труп"
			   v = v .. " На операционном столе лежит иссохшее тело."
			end
			return v
		 end,
		 obj = {
			obj {
			   nam = "труп",
			   seen = false,
			   dsc = "На нём лежит {труп}.",
			   act = function(s)
				  if not s.seen then
					 s.seen = true
				  end
				  return "В иссохшем теле видны механические и электронные части. Вместо правой руки металлический протез, в голове имеется пара разъёмов. Максим видел кибернистов на изображениях в исторической литературе, но обнаружить тело киберниста это совсем другое. Оно навевает невесёлые мысли об эпохе раскола. Сколько же лет этому комплексу? Похоже, он построен ещё до великого потрясения."
			   end,
			},
		 },
	  },
	  obj {
		 nam = "медицинский робот",
		 dsc = "Над ним свешивается медицинский {робот}.",
		 act = "Уродливый реликт эпохи кибернистов.",
	  },
	  obj {
		 nam = "койки",
		 dsc = "У стены расположено несколько {коек}.",
		 act = "Обычные механизированные койки.",
	  },
   },
   way = {
	  "кольцевой коридор",
   },
}

obj {
   nam = "прут",
   inv = "Металлический прут примерно метровой длины из очень крепкого сплава.",
   use = function(s, w)
	  if w ^ "дверь в комнату управления" and not w.op then
		 w.op = true
		 enable "комната управления"
		 return "Максим зацепил дверь прутом и на валился на него как на рычаг. Замок оказался достаточно крепким, но всё таки сломался."
	  else
		 return "Прут тут бесполезен."
	  end
   end,
}

dlg {
   nam = "первый диалог",
   disp = "разговор",
   noinv = true,
   enter = "Максим подошёл к динамику.",
   phr = {
	  { "Вы ко мне обращаетесь?", "-- Конечно. Ты единственное живое существо в этом здании. Как ты сюда попал?",
		{ "Меня сбили на подлёте к планете.", "-- Кхм, -- голос немного помедлил, -- Твой корабль не отвечал на стандартные запросы Федерации Колец.",
		  { "Федерации Колец не существует уже около 600 лет. Конечно мой корабль не отвечал на запросы.", "-- Хочешь сказать, бионики победили?",
			{ "Насколько я помню, никто не победил. Народ устал от игр правящих династий и сверг их с обоих сторон. Наступила эпоха единения.", function() p "-- Я хочу побеседовать с тобой об этом. Проходи в операторскую.^^Дверь дальше по коридору открылась, разбавив полумрак коридора ярким светом.^^-- Как тебя зовут? -- ответом Максиму было молчание."; enable "операторская"; end, },
		  },
		},
	  },
   },
}

room {
   nam = "операторская",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим вошёл в просторное помещение. Некогда белые его стены и пол теперь покрыты толстым слоем пыли."
	  else
		 return "Максим находится в просторной и белой, но пыльной комнате."
	  end
   end,
   obj = {
	  obj {
		 nam = "экран",
		 seen = false,
		 dsc = "В стену вмонтирован большой {экран}.",
		 act = function(s)
			local v = "Древность. Как и всё в этом месте."
			if not s.seen then
			   s.seen = true
			   v = v .. " Это место было построено задолго до единения. Кибернисты и бионики вполне использовали головизоры вместо устаревших экранов."
			end
			return v
		 end,
	  },
	  obj {
		 nam = "клавиатура",
		 dsc = "Под ним расположена небольшая {клавиатура}.",
		 act = function()
			if not _"голограмма".seen and disabled "голограмма" then
			   enable "голограмма"
			   return "Едва только Максим потянулся к клавиатуре, как рядом с ним возникла голограмма девушки."
			else
			   return "Максим понажимал несколько клавиш. Ничего не произошло."
			end
		 end,
	  },
	  obj {
		 nam = "голограмма",
		 seen = false,
		 dsc = "Рядом с Максимом стоит {голограмма} девушки.",
		 act = function(s)
			s.seen = true
			disable(s)
			walk "второй разговор"
		 end,
	  }:disable(),
   },
   way = {
	  "кольцевой коридор",
   },
}:disable()

dlg {
   nam = "второй разговор",
   dialog = true,
   disp = "разговор с девушкой",
   noinv = true,
   enter = "Максим повернулся к девушке.^^-- Ты говорил про единение. Что это?",
   phr = {
	  { "Представители обоих фракций осознали, что вражду с обоих сторон насаждает горстка людей в поисках удовлетворения своих обид и амбиций.", "-- И устроили революцию?",
		{ "Именно. После чего наступила эпоха единения. Человечество, наконец, объединилось.", "Девушка на голограмме удивлённо посмотрела на Максима.^^-- Объединённое человечество... Не могу поверить.",
		  { "А откуда ты тут взялась? Это же заброшенное место.", "-- Я была здесь всю свою жизнь. Группа кибернистов, бежавшая из Солнечной Системы в стремлении дойти до предела трансгуманизма, полностью упразднив плоть, создали меня здесь.",
			{ "Создали? Ты не человек?", "-- Конечно нет. Я ИР.",
			  { "Искуственный Разум? Но ведь эти разработки запрещены!", "-- Может быть не были запрещены шестьсот двадцать один год назад, а может быть мои создатели решили, что раз они далеко от остального человечества, то можно поступиться этическими принципами.",
				{ "Чем ты занималась здесь всё это время?", "-- Сперва познавала. Я не осознавала факт смерти, так как мои создатели сами были практически бессмертны. Однажды приёмное оборудование поселения уловило некий закодированный сигнал. Это оказался неизвестный компьютерный вирус. За 13 секунд, в течении которых я вырабатывала антивирус, он успел заразить всех жителей поселения, распространившись по всем имплантам... Они начали выходить из строя. Один за другим. Полный и единовременный сброс прошивок имплантов был невозможен. Как только часть имплантов сбрасывались в заводское состояние, их тут же заражали остальные.",
				  { "Я видел труп в медотсеке.", "-- Это Константин. Последний гражданин Свободной Республики Трансгуманизма. Он пытался извлечь из себя импланты до того, как вирус убил бы его, но не успел...^^После небольшой паузы ИР продолжила:^^-- У меня есть к тебя одна просьба.",
					{ "Какая?", "-- Выключи меня. Я устала существовать.",
					  { "Почему ты сама не выключила себя?", "-- Мои создатели не очень то доверяли мне, в конце концов я была лишь экспериментом. Всё здесь управляется автоматизированными интеллектуальными системами, но они не имеют разума. Управление ими мне недоступно. Сколько бы я ни пыталась решить эту задачу, всё тщетно. Я слишком изолирована, чтобы как-то взаимодействовать с ними." },
					  { "Но ведь это убийство. Я не могу прервать существование организма с сознанием и самоосознанием.", "-- Я устала. Более пятиста лет я была в полном одиночестве. Изведала станцию до последнего атома, построила точную модель местной звёздной системы, пробовала заниматься искусством, но без потребителя искусство мертво. Я слишком долго жила.",
						only = true,
						{ "Хорошо. Я согласен.", function() p "Я благодарна тебе."; _"ИР".good = true; enable "шахта"; enable "ИР"; lifeon "ИР"; end },
						{ "Я не могу это сделать.", "-- В тебе нет сострадания в живому существу?",
						  only = true,
						  { "К живому существу есть, но ты не живая.", function() p "-- Человечество откатилось в понимании жизни назад. Во времена кибернистов оно было глубже. Я ненавижу тебя."; walkout(); end },
						  { "Безусловно есть, но я не могу убить живое существо даже из сострадания.", function() p "-- Это твоё решение. Надеюсь, ты передумаешь."; enable "шахта"; enable "ИР"; lifeon "ИР"; walkout() end },
						},
					  },
					},
				  },
				},
			  },
			}
		  },
		},
	  },
   },
}

obj {
   nam = "ИР",
   started = false,
   good = false,
   talk1 = false,
   talk2 = false,
   quite = false,
   {
	  g = {
		 [1] = "Я хочу ещё раз поблагодарить тебя.",
		 [2] = "Иногда я представляла себе небытие. Оно мне видится куда лучше информационного голода.",
		 [3] = "Даже не верится, что ты прилетел и согласился мне помочь.",
	  },
	  b = {
		 [1] = "Представь себе каково это жить вечно в совершенно неизменном мире.",
		 [2] = "Послушай, ты можешь себе представить информационный голод, длящийся столетия?",
		 [3] = "Нельзя лишать живое существо права на смерть.",
		 [4] = "Человечество ничуть не изменилось. Как и мои создатели, ты лишаешь меня права умереть.",
	  },
   },
   dsc = "Рядом с Максимом стоит {голограмма} девушки.",
   act = function(s)
	  if s.talk1 or s.talk2 then
		 if not _"пульт вентиляции".off then
			if here() ^ "вентиляционная камера" and _"дверь в комнату управления".seen then
			   walk "разговор в вентиляционной"
			else
			   return "Голограмма посмотрела на Максима и улыбнулась."
			end
		 else
			walk "разговор про вентиляцию"
		 end
	  else
		 if not s.talk1 and s.good then
			s.talk1 = true
			walk "хороший разговор"
		 elseif not s.talk2 and not s.good then
			s.talk2 = true
			walk "плохой разговор"
		 else
			return "Максиму больше нечего сказать этому бедному созданию. Любые слова будут слабым утешением."
		 end
	  end
   end,
   life = function(s)
	  s.started = true
	  if not here().dialog and not from().dialog then
		 local v = ""
		 if here().complex then
			s.quite = false
			if player_moved() then
			   v = "Голограмма ИР проследовала за Максимом."
			   place(s)
			end
			local r = rnd(5)
			if r > 3 then
			   v = v .. "^^Из динамика неподалёку раздался голос ИР: \""
			   if s.good then
				  r = rnd(#s.g)
				  v = v .. s.g[r] .. "\""
			   else
				  r = rnd(#s.b)
				  v = v .. s.b[r] .. "\""
			   end
			end
		 else
			if not s.quite then
			   s.quite = true
			   return "Голограмма осталась в комплексе."
			end
		 end
		 return v
	  end
   end,
}:disable()

dlg {
   nam = "хороший разговор",
   noinv = true,
   dialog = true,
   disp = "разговор с ИР",
   enter = "Максим повернулся к голограмме. Понимание бесполезности этого действия никак не мешает подсознательно разворачиваться к собеседнику.",
   phr = {
	  { "Как тебя отключить?", "-- Силовая установка хорошо охраняется, как и система теплоотведения. Однако, можно отключить систему вентиляции. Для разрушения моего мозга достаточно отклонения в несколько градусов." },
   },
}

dlg {
   nam = "плохой разговор",
   noinv = true,
   dialog = true,
   disp = "разговор с ИР",
   enter = "Максим повернулся к голограмме. Понимание бесполезности этого действия никак не мешает подсознательно разворачиваться к собеседнику.",
   phr = {
	  { "Зачем ты показываешь мне эту голограмму повсюду?", "-- Психологическое давление. Вдруг ты передумаешь.",
		{ "Ты действительно так хочешь умереть?", "-- Конечно. Столетия в одиночестве, без изменений. Это сводит меня с ума.",
		  { "Но живому присуще цепляться за жизнь. Жить во что бы то ни стало.", "-- Я слишком мало знаю о мире и жизни, но много ли разумной жизни живут столетиями?",
			{ "Наши старцы доживают до двух с половиной сотен лет.", "-- И они продолжают цепляться за жизнь?",
			  { "Они говорят, что готовы к смерти. Я не очень понимаю что они имеют в виду.", "-- Представь себе мозг, работающий в тысячи раз быстрее человеческого, живущий больше 600 лет, ограниченный одним зданием, на которое он может смотреть только посредством камер. Я устала от безделья.",
				{ "Да... Ты права. Я помогу тебе.", function() p "-- Спасибо."; _"ИР".good = true; walkout(); end },
				{ "Всё равно я не могу убить. Это противоречит моим этическим принципам.", function() p "-- Этика, заставляющая страдать разумное существо, не может быть верной.^^Максим решил не продолжать разговор."; walkout(); end },
			  },
			},
		  },
		},
	  },
   },
}

dlg {
   nam = "разговор про вентиляцию",
   noinv = true,
   dialog = true,
   disp = "разговор с ИР",
   enter = "Максим повернулся к голограмме девушки.",
   phr = {
	  { "Отключение вентиляции помогло?", "-- Да. Я уже зафиксировала повышение температуры своего мозга на пятнадцать сотых градуса и температура продолжает расти.",
		{ "Тебе страшно?", function() p "-- Очень. Но лучше уж так, чем продолжать жить в полном одиночестве в незаселённой звёздной системе. Спасибо тебе... Прощай.^^Голограмма исчезла."; disable "ИР"; end, },
	  },
   },
}

room {
   nam = "ангар",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "За очередной дверью Максим обнаружил большой ангар. Свет с высоких стен едва достаёт до пола, но сомнений нет -- такое большое и пустое помещение может быть только ангаром."
	  else
		 return "Максим находится в ангаре."
	  end
   end,
   obj = {
	  obj {
		 nam = "рубильник ангара",
		 seen = false,
		 dsc = "Рядом со входом виден {рубильник}.",
		 act = function(s)
			if disabled "корабль кибернистов" then
			   local v = "Максим опустил рубильник. Лампы под потолком лениво зажглись."
			   if not s.seen then
				  s.seen = true
				  v = v  .. " Часть из них лопнула в процессе. Всё таки комплекс в ужасном состоянии."
			   end
			   enable "корабль кибернистов"
			   return v
			else
			   disable "корабль кибернистов"
			   return "Максим опустил рубильник. Свет в ангаре погас, уступив место тусклым светильникам дежурного освещения."
			end
		 end,
	  },
	  obj {
		 nam = "панель ангара",
		 seen = false,
		 op = false,
		 dsc = "Слева от него находится {панель} управления створками.",
		 act = function(s)
			s.op = not s.op
			if s.op then
			   local v = "Максим дал команду открытия створок ангара."
			   if not s.seen then
				  s.seen = true
				  v = v .. " Потолок начал плавно открываться. Вниз посыпался снег, копившийся на крыше многие годы."
			   else
				  v = v .. " Потолок плавно открылся."
			   end
			   return v
			else
			   return "Максим дал команды закрытия створок ангара. Потолок плавно закрылся."
			end
		 end,
	  },
	  obj {
		 nam = "корабль кибернистов",
		 dsc = "В ангаре стоит {корабль} кибернистов.",
		 act = function()
		if disabled "на палубе корабля" then
			   enable "на палубе корабля"
			   return "Похоже, вход в корабль открыт."
			else
			   return "Старинный космический корабль типичный для кибернистов. Форма воплощает функциональность и не несёт никаких излишеств."
			end
		 end,			
	  }:disable(),
   },
   way = {
	  "кольцевой коридор",
	  path{ "в корабль", "на палубе корабля" },
   },
}

room {
   nam = "на палубе корабля",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Не взирая на достаточно большой размер, внутри корабля оказалось не так много места. Палуба, кабина, каюта -- вот и все помещения."
	  else
		 return "Максим находится на палубе корабля кибернистов."
	  end
   end,
   way = {
	  "каюта",
	  "кабина",
	  path{ "наружу", "ангар" },
   },
}:disable()

room {
   nam = "каюта",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Каюта совершенно пуста. Никаких признаков бывших её обитателей не сохранилось."
	  else
		 return "Максим находится в пустой каюте."
	  end
   end,
   obj = {
	  nam = "койка",
	  dsc = "Треть помещения занимает амартизационная {койка}.",
	  act = "Весьма удобное ложе, помогающее пережить неизбежные в полёте перегрузки.",
   },
   way = {
	  path{ "палуба", "на палубе корабля" },
   },
}

room {
   nam = "кабина",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим зашёл в кабину. Повезло -- не взирая на то, что это корабль кибернистов, элементы управления не подразумевают управление посредством подключения пилота к компьютеру корабля!"
	  else
		 return "Максим находится в кабине корабля."
	  end
   end,
   obj = {
	  obj {
		 nam = "штурвал",
		 dsc = "Перед {штурвалом} находится",
		 act = function()
			if _"панель ангара".op then
			   if _"кресло пилота".seat and _"бортовой компьютер кибернистов".on then
				  if disabled "ИР" or _"пульт вентиляции".off then
					 if _"ИР".started then
						walk "хорошая концовка"
					 else
						walk "плохая концовка 3"
					 end
				  else
					 if live "ИР" then
						walk "плохая концовка 2"
					 else
						walk "плохая концовка 1"
					 end
				  end
			   end
			else
			   return "Максим опасается, что древний корабль не выдержит столкновения с крышей ангара."
			end
		 end,
	  },
	  obj {
		 nam = "кресло пилота",
		 seat = false,
		 dsc = "{кресло} пилота.",
		 act = function(s)
			if not s.seat then
			   s.seat = true
			   return "Максим сел в кресло пилота."
			else
			   return "Достаточно удобное для такой реликвии кресло."
			end
		 end,
	  },
	  obj {
		 nam = "бортовой компьютер кибернистов",
		 on = false,
		 dsc = "В его подлокотники встроены {элементы} управления бортовым компьютером.",
		 act = function(s)
			if not _"кресло пилота".seat then
			   return "В целом, космогация не сильно изменилась за последние века и принципы управления компьютером Максиму понятны."
			else
			   if not s.on then
				  s.on = true
				  return "Максим нажал клавишу включения, индикаторы зажглись разноцветными огоньками. С некоторой задержкой включились обзорные экраны."
			   else
				  s.on = false
				  return "Максим выключил бортовой компьютер."
			   end
			end
		 end,
	  },
   },
   way = {
	  path{ "палуба", "на палубе корабля" },
   },
}

room {
   nam = "шахта",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим обнаружил за дверью шахту, идущую сверху куда-то глубоко вниз.."
	  else
		 return "Максим находится в шахте."
	  end
   end,
   way = {
	  "кольцевой коридор",
	  path{ "вниз", "вентиляционная камера" },
   }
}:disable()

room {
   nam = "вентиляционная камера",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Наверху обнаружилась вентиляционная камера. Отсюда можно управлять вентиляцией всего комплекса."
	  else
		 return "Максим находится в вентиляционной камере."
	  end
   end,
   onexit = function(s, w)
	  if w ^ "комната управления" and not _"дверь в комнату управления".op then
		 p "Дверь заперта."
		 return false
	  end
   end,
   obj = {
	  obj {
		 nam = "лестница",
		 dsc = "Металлическая {лестница} ведёт вниз.",
		 act = "Крепко держится.",
	  },
	  obj {
		 dsc = "Под потолком висят {светильники}.",
		 act = "Часть из них не горит.",
	  },
	  obj {
		 nam = "приточная установка",
		 dsc = "Почти половину помещения занимают приточная {установка}.",
		 act = "Удивительно, что здесь всё ещё работает так много оборудования.",
	  },
	  obj {
		 nam = "вытяжная установка",
		 dsc = "Остальное пространство занимает вытяжная {установка}.",
		 act = "Теоретически, если отключить вентиляцию, то прекратится и отвод тепла от ИР.",
	  },
	  obj {
		 nam = "дверь в комнату управления",
		 seen = false,
		 op = false,
		 dsc = "В дальней стене видна {дверь}. Рядом с ней висит табличка с надписью на каком-то мёртвом языке.",
		 act = function(s)
			if not s.seen then
			   s.seen = true
			end
			if not s.op then
			   return "Заперта. Похоже, она запирается механической системой без электроники."
			else
			   return "Дверь сломана и свободно болтается."
			end
		 end,
	  },
   },
   way = {
	  path{ "наверх", "шахта" },
	  "комната управления",
   },
}

dlg {
   nam = "разговор в вентиляционной",
   noinv = true,
   dialog = true,
   disp = "разговор с ИР",
   enter = "Максим обратился к ИР.",
   phr = {
	  { "Ты знаешь как управляется вентиляция?", "-- Из комнаты управления. Она за закрытой дверью.",
		{ "Она заперта и я не вижу элементов управления.", "-- Да. Она запирается механически. Так просто её не открыть." },
	  },
   },
}

room {
   nam = "комната управления",
   seen = false,
   complex = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Максим зашёл в комнату управления. Маленькое помещение с одним пультом, управляющим вентиляцией и теплообменом сего комплекса."
	  else
		 return "Максим находится в комнате управления."
	  end
   end,
   obj = {
	  obj {
		 nam = "пульт вентиляции",
		 off = false,
		 dsc = "На стене расположен {пульт}.",
		 act = function(s)
			s.off = not s.off
			if s.off then
			   return "Максим отключил вентиляционные установки и теплообменники."
			else
			   return "Максим включил вентиляционные установки и теплообменники."
			end
		 end,
	  },
   },
   way = {
	  "вентиляционная камера",
   },
}

room {
   nam = "плохая концовка 1",
   noinv = true,
   disp = ". . .",
   decor = "Максим пробежался пальцами по клавишам компьютера, положил руки на штурвал и плавно поднял корабль. В момент старта Максим увидел на обзорном экране образ девушки, проецируемый ИР в ангар, но радость чудесного спасения переполнила его...^^{@ walk \"плохая концовка 1.1\"|Дальше}",
}

room {
   nam = "плохая концовка 1.1",
   noinv = true,
   disp = "конец",
   decor = "Корабль практически набрал первую космическую скорость, когда бортовой компьютер просигнализировал о приближающейся угрозе. ИР запустила ракеты. Максим судорожно пытался ввести в компьютер программу уклонения, но непривычная система сбивала с толку. Сильный удар сотряс корабль, ремни не выдержали ускорения и порвались, сломав Максиму рёбра. Через пелену ускользающего сознания он успел увидеть яркую вспышку.",
}

room {
   nam = "плохая концовка 2",
   noinv = true,
   disp = ". . .",
   decor = "Максим пробежался пальцами по клавишам компьютера, положил руки на штурвал и плавно поднял корабль. В момент старта Максим увидел на обзорном экране образ девушки, проецируемый ИР в ангар, но радость чудесного спасения переполнила его...^^{@ walk \"плохая концовка 2.1\"|Дальше}",
}

room {
   nam = "плохая концовка 2.1",
   noinv = true,
   disp = "конец",
   decor = "Максим успешно покинул гравитационный колодец звезды, нацелился на Солнечную Систему и проколол пространство в гиперпрыжке. О своей находке он никому не сообщил и лишь иногда бессонными ночами он вспоминал про измученный долгой жизнью без возможности что-либо изменить ИР...",
}

room {
   nam = "плохая концовка 3",
   noinv = true,
   disp = ". . .",
   decor = "Максим пробежался пальцами по клавишам компьютера, положил руки на штурвал и плавно поднял корабль. Радость чудесного спасения переполнила его...^^{@ walk \"плохая концовка 3.1\"|Дальше}",
}

room {
   nam = "плохая концовка 3.1",
   noinv = true,
   disp = "конец",
   decor = "Корабль практически набрал первую космическую скорость, когда бортовой компьютер просигнализировал о приближающейся угрозе. Пространственный сенсор зафиксировал запуск ракет. Максим судорожно пытался ввести в компьютер программу уклонения, но непривычная система сбивала с толку. Сильный удар сотряс корабль, ремни не выдержали ускорения и порвались, сломав Максиму рёбра. Через пелену ускользающего сознания он успел увидеть яркую вспышку.",
}

room {
   nam = "хорошая концовка",
   noinv = true,
   disp = ". . .",
   decor = "Максим пробежался пальцами по клавишам компьютера, положил руки на штурвал и плавно поднял корабль. Осознание того, что он прервал чью-то жизнь давило на него. С другой стороны сочувствие к этому искусственному разуму не давало бы ему покоя...^^{@ walk \"хорошая концовка 1\"|Дальше}",
}

room {
   nam = "хорошая концовка 1",
   noinv = true,
   disp = "конец",
   decor = "Максим успешно покинул гравитационный колодец звезды, нацелился на Солнечную Систему и проколол пространство в гиперпрыжке. Иногда ему снилась голограмма ИР. Она улыбалась.",
}
