function init()
   take "корзина"
   lifeon "корабль"
   snd.music("mus/ages.xm")
   std.cut_delim = fmt.c "^***^"
end

obj {
   nam = "$nl",
   act = "\n",
}

obj {
   nam = "корзина",
   inv = "Пластиковая корзина. Очень удобна для сбора грибов. Сейчас в ней лежит несколько штук.",
   use = "Ни к чему это.",
}

obj {
   nam = "корабль",
   n = 0,
   dsc = function(s)
	  if s.n < 3 then
		 if here() ^ "main" then
			return "Сквозь густые ветви в небе видно космический {корабль}, летящий в сторону космопорта."
		 else
			return "В небе виден {корабль}, летящий в сторону космопорта."
		 end
	  else
		 return "На посадочной площадке стоит незнакомый {корабль}."
	  end
   end,
   act = function(s)
	  return "Интересно, кто бы это мог быть. Корабль регулярного сообщения должен прилететь только к концу недели."
   end,
   life = function(s)
	  if s.n == 2 then
		 place(s, "космопорт")
		 lifeoff(s)
	  end
	  s.n = s.n + 1
   end,
}

room {
   nam = "main",
   seen = false,
   disp = "лес",
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я гулял по лесу, собирая грибы, когда послышался звук приближающегося космического корабля. Странно, сегодня никто не должен был прилететь, ведь наша провинциальная колония мало кому интересна."
	  else
		 return "Я нахожусь в лесу."
	  end
   end,
   pic = "img/forest.png",
   obj = {
	  obj {
		 nam = "деревья",
		 dsc = "В этой части лес достаточно густой и {деревья} растут весьма плотно.",
		 act = "Большие, некоторые я даже не смог бы обхватить.",
	  },
	  "корабль",
   },
   way = {
	  path{"опушка", "опушка леса"},
   },
}

room {
   nam = "опушка леса",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вышел на опушку. Отсюда уже видно здание космопорта."
	  else
		 return "Я нахожусь на опушке леса."
	  end
   end,
   pic = "img/forest.png",
   obj = {
	  "корабль",
	  obj {
		 nam = "деревья на опушке",
		 dsc = "{Деревья} тут растут гораздо реже, чем в глубине леса.",
		 act = "Молодые тонкие деревца.",
	  },
	  obj {
		 nam = "кустарник",
		 dsc = "Между ними тут и там растут {кусты}.",
		 act = "Ничем не примечательные кусты.",
	  },
   },
   way = {
	  "main",
	  "космопорт",
   },
}

room {
   nam = "космопорт",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вышел к космопорту. Всё-таки это здание из бетона и стекла выглядит весьма красиво."
	  else
		 return "Я нахожусь у здания космопорта."
	  end
   end,
   pic = "img/spaceport.png",
   obj = {
	  obj {
		 nam = "здание космопорта",
		 dsc = "{Здание} порта выглядит очень скромно.",
		 act = "Космопорт у нас маленький, рассчитан на приём до четырёх кораблей одновременно, причём посадочная площадка как правило пустует, а штат порта составляет один человек -- Борис.",
	  },
	  obj {
		 nam = "посадочная площадка",
		 dsc = "Рядом с ним находится посадочная {площадка}.",
		 act = "Ровная площадка, залитая пластобетоном.",
	  },
	  obj {
		 nam = "Борис",
		 dsc = "На ней стоят {Борис}",
		 act = function(s)
			walk "разговор с Борисом"
		 end,
	  },
	  obj {
		 nam = "лейтенант",
		 dsc = "с {лейтенантом} армии человеческого содружества.",
		 act = function(s)
			walk "разговор с лейтенантом"
		 end,
	  },
   },
   way = {
	  "опушка леса",
   },
}

dlg {
   nam = "разговор с Борисом",
   noinv = true,
   pic = "img/spaceport.png",
   enter = "Я подошёл к Борису.",
   phr = {
	  { "Привет.", function() p "-- Привет. Тут такое творится..."; walk "разговор с лейтенантом"; end },
   },
}

dlg {
   nam = "разговор с лейтенантом",
   noinv = true,
   pic = "img/spaceport.png",
   enter = function(s)
	  if from() ^ "космопорт" then
		 return "Я подошёл к лейтенанту."
	  else
		 return "{$nl|}{$nl|}Лейтенант перебил Бориса:^^-- Ситуация непростая и необычная. Если вкратце, то зафиксирован вход корабля сайлонов в систему."
	  end
   end,
   phr = {
	  { cond = function() return not from() ^ "разговор с Борисом"; end, "Здравствуйте.", "-- Здравствуйте. Некогда с каждым разговаривать отдельно. Ситуация непростая и необычное. Если вкратце, то зафиксирован вход в систему корабля сайлонов.",
		{ "Но они же не одну сотню лет как закрылись в своей части пространства.", "-- И, судя по данным разведки, ситуация до сих пор осталась такой же. Сигнатура говорит о том, что это корабль времён войны. Соберите жителей колонии -- нужно спланировать оборону.",
		  { "Где собрать?", function() p "После небольшой паузы Борис сказал:^^-- Лучше всего в баре..."; walk "бар"; end },
		},
	  },
	  { cond = function() return from() ^ "разговор с Борисом"; end, "Но они же не одну сотню лет, как закрылись в своей части пространства.", "-- И, судя по разведданным, ситуация до сих пор осталась такой же. Судя по сигнатуре, это корабль времён войны. Соберите жителей колонии -- нужно спланировать оборону.",
		{ "Где собрать?", function() p "После небольшой паузы Борис сказал:^^-- Лучше всего в баре..."; walk "бар"; end },
	  },
   },
}

cutscene {
   nam = "бар",
   noinv = true,
   pic = "img/bar.png",
   decor = function(s)
	  pn "Спустя некоторое время в баре собрались практически все жители нашей небольшой колонии. Свободного места почти не осталось. Лейтенант расположился за стойкой и начал свою речь."
	  pn "[cut]"
	  pn "-- Здравствуйте. Меня зовут лейтенант Кормильцев, я представляю военные силы человеческого содружества в вашей системе. Возможно некоторые из вас уже слышали, что на границе системы обнаружен корабль сайлонов."
	  pn "[cut]"
	  pn "Из зала послышались выкрики:^^-- Брехня!^-- И из-за этой глупой шутки вы отрываете нас от работы!"
	  pn "[cut]"
	  pn "Лейтенант продолжил:^^-- В это действительно трудно поверить, особенно с учётом того, что это корабль времён войны. По данным из архивов, поднятыми штабом, установлено, что это корабль, отступивший во время битвы в созвездие Лебедя при Кеплер-33. Согласно этим данным, подпространственный двигатель корабля был повреждён непосредственно перед прыжком."
	  pn "[cut]"
	  pn "Толпа заметно поутихла. Одинокий голос старого пропойцы Питерсона прозвучал как скрип двери на несмазанных петлях:^^--Как же они смогли прыгнуть?"
	  pn "[cut]"
	  pn "-- Неизвестно. Экстренное собрание учёного совета решило, что повреждение повлекло за собой маловероятный эффект и по локальному времени корабля прошло лишь несколько дней. Так что к нам сейчас летит корабль с сайлонами, которые всё ещё на войне и готовы на всё."
	  pn "[cut]"
	  pn "Когда все присутствующие поняли серьёзность положения, началось обсуждение возможных вариантов действия. Теперь всё зависело только от нас и того, насколько хорошо корабль сайлонов потрепали в битве при Кеплер-33 два с лишним века назад...^^{@ gamefile game.lua, 1|Продолжить}"
   end,
}
