dofile "deaths.lua"

function init()
   snd.music("mus/back from shell.xm")
end

function check_health(w)
   if _"здоровье".hp <= 0 then
	  game:reaction(false)
	  game:events(false, false)
	  walk "смерть2"
	  return false
   else
	  return "Сайлон выстрелил в меня."
   end
end

obj {
   nam = "$nl",
   act = "\n",
}

game.player = player {
   room = "бункер",
   obj = { "здоровье", "рация" },
}

const {
   scaner = 2,
   first_attack = 3,
   second_attack = 5,
   third_attack = 9,
   bot_fall = 2,
}

stat {
   nam = "здоровье",
   hp = 10,
   disp = function(s)
	  local v =  "здоровье: " .. tostring(s.hp)
	  if theme.name() ~= ".mobile" then
		 v = v .. "{$nl}"
	  end
	  return v
   end,
}

menu {
   nam = "рация",
   act = function(s)
	  if here() ^ "бункер" then
		 walk "интерфейс рации"
	  else
		 return "Не стоит нарушать радиомолчание -- сайлоны наверняка засекут сигнал и тогда мне точно крышка."
	  end
   end,
}

room {
   nam = "интерфейс рации",
   noinv = true,
   f = "",
   seen = false,
   title = "рация",
   Katherine_talked = false,
   Nikolai_talked = false,
   pic = "img/radio.png",
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "В бункере имеется ретранслятор, передающий сигнал с рации, на вторую оборонную станцию по кабелю поэтому я могу отсюда связаться с Катей."
	  else
		 return false
	  end
   end,
   onenter = function(s, f)
	  if f:type "room" then
		 s.f = f.nam
	  end
   end,
   decor = function(s)
	  local v = ""
	  if not s.Katherine_talked then
		 v = v .. "{@ walk \"разговор с Катей\"|Связаться с Катей}^"
	  end
	  if not s.Nikolai_talked then
		 v = v .. "{@ walk \"разговор с Колей\"|Связаться с Колей}^^"
	  end
	  if not s.Katherine_talked and s.Nikolai_talked then
		 v = v .. "^"
	  end
	  if s.Katherine_talked and s.Nikolai_talked and not from():type "dlg" then
		 v = v .. "Мне не хочется ни с кем разговаривать.^^"
	  end
	  v = v .. "{@ walk " .. s.f .. "|Назад}"
	  return v
   end,
}

dlg {
   nam = "разговор с Катей",
   noinv = true,
   pic = "img/radio.png",
   enter = "Я нажал кнопку вызова.",
   phr = {
	  { "Кать, как ты там?", "-- Страшно и сыро. Бункер подтопило немного, видимо.",
		{ "Порядок действий помнишь?", "-- Конечно. Засечь сигнал корабля, навестись, нажать на кнопку активации. Это же военная штука -- она не может быть сложной.",
		  { "Стреляй по второму сигналу сканера. Надеюсь, у них не много ботов на борту. Лейтенант сказал, что так у нас ещё есть шанс.", function(s) p "-- Я помню, Серёжа, я там была, -- она сделала долгую паузу, -- Знаешь, мне не хочется сейчас болтать. Давай лучше ты угостишь меня пивом когда всё закончится. Конец связи.^^Я снова остался один на один с тишиной и темнотой бункера."; _"интерфейс рации".Katherine_talked = true; end },
		},
	  },
   },
}

dlg {
   nam = "разговор с Колей",
   noinv = true,
   pic = "img/radio.png",
   enter = "Я нажал кнопку вызова.",
   phr = {
	  { "Коля, ты тут?", function(s) p "-- Серёг, не хочу сейчас говорить. Давай лучше в баре поболтаем, когда эта заварушка закончится?^^Мне бы его оптимизм."; _"интерфейс рации".Nikolai_talked = true; end },
   },
}

obj {
   nam = "десантный бот",
   t = 0,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Высоко в небе видна маленькая чёрная клякса сбитого {бота} сайлонов. Нам всё-таки удалось его подстрелить!"
	  else
		 return "В небе виден дымный след десантного {бота} сайлонов."
	  end
   end,
   act = function(s)
	  if here() ^ "космопорт" then
		 return "Бот падает прямо в лес! Там же прячутся дети!"
	  else
		 return "Маловероятно, что падение как-то навредит сайлонам, сидящим в боте. По сохранившейся со времён войны информации, их скафандры способны выдержать и не такое."
	  end
   end,
   life = function(s)
	  if s.t < bot_fall then
		 s.t = s.t + 1
	  else
		 if here() ^ "космопорт" then
			p "Бот медленно, как во сне, упал в лес. Сильный удар сотряс многострадальную нашу планету уже в третий раз за сегодня и очередная вспышка озарила небо. Только бы дети остались живы."
		 elseif here() ^ "лес" then
			p "Страшный удар сотряс лес. Деревья со стоном покачнулись, земля под ногами задрожала. Началось самое страшное."
		 else
			p "Низкий гул прокатился по окрестностям, земля под ногами задрожала. Бот упал. Началось самое страшное."
		 end
		 disable(s)
	  end
   end,
}

obj {
   nam = "корабль сайлонов",
   dsc = "В небе видна громада {корабля} сайлонов.",
   act = "Гигантский корабль медленно опускается на планету.",
}:disable()

room {
   nam = "бункер",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "После очень краткого инструктажа были распределены роли каждого жителя планеты. Мне досталось место на посту защитного комплекса, и вот я уже трясусь в грузовике по пути из бара на свой пост. В затхлом и пыльном бункере, где едва может разместиться оператор вместе с оборудованием, сканирующем пространство и управляющим орудиями, холодно и тихо. Тишину нарушают только моё дыхание и сигналы пространственного сканера."
	  else
		 return "Я нахожусь в бункере."
	  end
   end,
   pic = "img/sensor.png",
   enter = function(s, f)
	  if not visited() then
		 snapshots:make()
	  end
   end,
   onexit = function(s, t)
	  if not t ^ "интерфейс рации" and _"кнопка активации".t == 0 then
		 p "Я не могу покинуть свой пост. Судьба планеты зависит от каждого."
		 return false
	  end
   end,
   obj = {
	  obj {
		 nam = "сканер",
		 t = 0,
		 dsc = "Примерно половину стены передо мной занимает {экран}.",
		 act = function(s)
			if not live(s) then
			   if s.t < scaner then
				  lifeon(s)
			   else
				  return "На фоне помех на экране сканера видна точка корабля. Я бы её не заметил, если бы не знал что искать."
			   end
			end
			return "На экране сканера видны только помехи от множества астероидов и обломков кораблей, сбитых давным-давно во времена войны."
		 end,
		 life = function(s)
			if s.t < scaner - 1 then
			   s.t = s.t + 1
			elseif s.t == scaner - 1 then
			   s.t = s.t + 1
			   return "Звуковой сигнал пространственного сканера изменился."
			else
			   lifeoff(s)
			end
		 end,
	  },
	  obj {
		 nam = "орудие",
		 pointed = false,
		 dsc = "Под ним расположен {пульт} наведения орудий.",
		 act = function(s)
			if not s.pointed then
			   if _"сканер".t == scaner then
				  s.pointed = true
				  return "Дрожащими руками я ввёл команды наведения орудия."
			   else
				  return "Неизвестно на что следует наводить орудие."
			   end
			else
			   return "Орудия уже наведены на корабль сайлонов."
			end
		 end,
	  },
	  obj {
		 nam = "кнопка активации",
		 t = 0,
		 dsc = "Рядом с ним находится {кнопка} активации орудий.",
		 act = function(s)
			if _"орудие".pointed then
			   if s.t == 0 then
				  lifeon(s)
				  return "Я нажал кнопку. Тишину бункера наполнило низкочастотное гудение -- силовая установка вышла на полную мощность."
			   else
				  return "Выстрел уже неминуем. Время делать ноги!"
			   end
			else
			   return "Выстрел вслепую всё равно что выкрикнуть в эфир мои координаты. Стоит дождаться, когда корабль сайлонов появится в радиусе действия пространственного сканера."
			end
		 end,
		 life = function(s)
			s.t = s.t + 1
			if s.t == third_attack then
			   enable "корабль сайлонов"
			   lifeoff(s)
			   return "Ещё один удар заставил землю дрожать. Скорее всего был уничтожен третий бункер."
			elseif s.t == second_attack - 1 then
			   if here() ^ "поле" or here() ^ "опушка леса" or here() ^ "космопорт" then
				  return "Над вторым бункером мелькнул луч, уходящий в небо -- Катя дала свой залп по противнику."
			   end
			elseif s.t == second_attack then
			   lifeon "десантный бот"
			   return "Земля снова задрожала, но несколько слабее, чем в первый раз. Надеюсь, Катя успела выбраться."
			elseif s.t == first_attack then
			   if here() ^ "бункер" or here() ^ "у входа в бункер" then
				  walk "смерть1"
			   elseif here() ^ "поле" then
				  snapshots:remove()
				  snapshots:make()
				  return "Луч ответного удара вонзился в то место, где находился бункер. Земля под ногами задрожала, а над бункером поднялся густой дым."
			   else
				  snapshots:remove()
				  snapshots:make()
				  return "Низкий гул прокатился по окрестностям, земля под ногами задрожала."
			   end
			end
		 end,
	  },
   },
   way = {
	  path{"наверх", "у входа в бункер"},
   },
}

room {
   nam = "у входа в бункер",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "То и дело спотыкаясь на ступеньках лестницы, ведущей из бункера, я выбрался наружу."
	  else
		 return "Я стою у входа в бункер."
	  end
   end,
   pic = "img/bunker.png",
   obj = {
	  "десантный бот",
	  obj {
		 nam = "кусты у бункера",
		 dsc = "У входа в бункер растут {кусты}.",
		 act = "Ничем не примечательный кустарник.",
	  },
	  obj {
		 nam = "люк бункера",
		 op = false,
		 dsc = "В их тени находится {люк} бункера.",
		 act = function(s)
			s.op = not s.op
			if s.op then
			   enable "бункер"
			   return "Я открыл люк."
			else
			   disable "бункер"
			   return "Я закрыл люк."
			end
		 end,
	  },
	  obj {
		 nam = "излучатели",
		 dsc = "Чуть в стороне видны решётчатые конструкции {излучателей} оборонной установки.",
		 act = "От их вида мне всегда было не по себе. Древнее и грозное орудие -- наследие эпохи войны.",
	  },
   },
   way = {
	  "бункер",
	  "поле",
   },
}

room {
   nam = "поле",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я выбежал в поле. Его вид всегда действовал на меня успокаивающе и даже сейчас страх немного отступил, стоило мне оказаться здесь."
	  else
		 return "Я нахожусь в поле."
	  end
   end,
   pic = "img/field.png",
   onexit = function(s, t)
	  if t ^ "у входа в бункер" and _"кнопка активации".t >= first_attack then
		 p "На месте бункера сейчас озеро расплавленной почвы и камня, над которым в небо стремится столб едкого дыма."
		 return false
	  end
   end,
   obj = {
	  "десантный бот",
	  "корабль сайлонов",
	  obj {
		 nam = "пшеница",
		 dsc = "На ветру колышется почти созревшая {пшеница}.",
		 act = "Уцелеет ли урожай в этом году? И будет ли кому его собирать?..",
	  },
   },
   way = {
	  path{"к бункеру", "у входа в бункер"},
	  "космопорт",
   },
}

room {
   nam = "космопорт",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я подошёл к зданию космопорта. Вечерами я любил приходить сюда к Борису и болтать с ним обо всём на свете, попивая чай."
	  else
		 return "Я нахожусь у здания космопорта."
	  end
   end,
   pic = "img/spaceport.png",
   obj = {
	  "десантный бот",
	  "корабль сайлонов",
	  obj {
		 nam = "здание космопорта",
		 dsc = "{Здание} порта выглядит очень скромно.",
		 act = "Космопорт у нас маленький, рассчитан на приём до четырёх кораблей одновременно, причём посадочная площадка как правило пустует, а штат порта составляет один человек -- Борис.",
	  },
	  obj {
		 nam = "посадочная площадка",
		 dsc = "Рядом с ним находится посадочная {площадка}.",
		 act = "Ровная площадка залитая пластобетоном.",
	  },
	  obj {
		 nam = "корабль",
		 dsc = "На ней стоит {корабль} лейтенанта.",
		 act = "Быстрый одноместный корабль.",
	  },
   },
   way = {
	  path{"в здание", "первый этаж"},
	  "поле",
	  path{"лес", "опушка леса"},
	  "окраина города",
   },
}

room {
   nam = "первый этаж",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я зашёл в здание порта. Первый этаж представляет собой смесь ангара для вездехода, и кабинета, в котором оформлялись необходимые документы по прибытию кораблей."
	  else
		 return "Я нахожусь в здании порта. Без привычного вездехода помещение кажется каким-то пустым и голым."
	  end
   end,
   pic = "img/1floor.png",
   obj = {
	  obj {
		 nam = "стол",
		 dsc = "В углу стоит {стол}.",
		 act = "За ним Борис обычно заполнял документы. Иногда за этим столом мы пили чай.",
	  },
	  obj {
		 nam = "ящик стола",
		 dsc = function(s)
			if s:closed() then
			   return "{Ящик} стола закрыт."
			else
			   return "{Ящик} стола открыт."
			end
		 end,
		 act = function(s)
			if s:closed() then
			   s:open()
			   return "Я выдвинул ящик стола."
			else
			   s:close()
			   return "Я закрыл ящик стола."
			end
		 end,
		 obj = {
			obj {
			   nam = "бланки",
			   dsc = "В нём лежат {бумаги}.",
			   act = function(s)
				  local v = "Пустые бланки документов."
				  if closed(s) then
					 open(s)
					 v = v .. " Под ними нашёлся небольшой ключ."
				  end
				  return v
			   end,
			   obj = {
				  obj {
					 nam = "ключ от шкафа",
					 disp = "ключ",
					 dsc = "Среди бумаг лежит {ключ}.",
					 tak = "Я взял ключ.",
					 inv = "Небольшой бесконтактный пластиковый ключ.",
					 use = function(s, w)
						if w ^ "оружейный шкаф" then
						   w.op = true
						   disable(s)
						   return "Я приложил ключ к считывателю шкафа, прозвучал сигнал открытия замка."
						else
						   return "Вряд ли тут что-то получится сделать ключом."
						end
					 end,
				  },
			   },
			}:close(),
		 },
	  }:close(),
	  obj {
		 nam = "стеллажи",
		 dsc = "Вдоль стены установлены {стеллажи}.",
		 act = "Простые металлические конструкции.",
	  },
	  obj {
		 nam = "колёса",
		 dsc = "На них лежат {колёса}.",
		 act = "Запасные колёса для вездехода Бориса.",
	  },
   },
   way = {
	  "медотсек",
	  path{"наверх", "второй этаж"},
	  path{"наружу", "космопорт"},
   },
}

room {
   nam = "второй этаж",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я поднялся на второй этаж. Здесь весьма уютно. Из окна открывается замечательный вид."
	  else
		 return "Я нахожусь на втором этаже космопорта."
	  end
   end,
   pic = "img/2floor.png",
   obj = {
	  obj {
		 nam = "диван",
		 dsc = "У стены стоит большой {диван}.",
		 act = "Не время отдыхать!",
	  },
	  obj {
		 nam = "окно",
		 dsc = "Напротив него {окно} во всю стену.",
		 act = function(s)
			local v = "За окном видно краешек пшеничного поля и лес."
			if disabled "десантный бот" then
			   v = v .. " Над лесом бьёт в небо столб густого дыма от упавшего десантного бота."
			else
			   v = v .. " Над лесом видна чёрная клякса падающего бота сайлонов."
			end
			return v
		 end,
	  },
	  obj {
		 nam = "оружейный шкаф",
		 op = false,
		 dsc = "В углу стоит металлический {шкаф}.",
		 act = function(s)
			if not s.op then
			   return "Шкаф заперт."
			else
			   if closed(s) then
				  s:open()
				  return "Я открыл шкаф."
			   else
				  s:close()
				  return "Я закрыл шкаф."
			   end
			end
		 end,
		 obj = {
			obj {
			   nam = "винтовка",
			   loaded = 0,
			   dsc = "В шкафу лежит {винтовка}.",
			   tak = "Я взял винтовку. Удивительно, что Борис оставил её тут.",
			   inv = function(s)
				  if s.loaded == 0 then
					 return "Старая лазерная винтовка военного образца. Вроде как досталась Борису от его деда, но я не уверен."
				  else
					 local str
					 if s.loaded == 1 then
						str = " выстрел."
					 elseif s.loaded > 1 and s.loaded < 5 then
						str = " выстрела."
					 else
						str = " выстрелов."
					 end
					 return "Я включил индикатор заряда. Хватит на " .. tostring(s.loaded) .. str
				  end
			   end,
			   use = function(s, w)
				  if w ^ "Катя" then
					 return "Я не буду направлять винтовку на Катю даже в шутку."
				  elseif s.loaded > 0 then
					 if w ^ "сайлон1" then
						if w.hp > 0 then
						   s.loaded = s.loaded - 1
						   if where "Катя" == here() and disabled "винтовка Кати" then
							  w.hp = w.hp - 2
							  p "Я выстрелил в сайлона. Катя не растерялась и тоже успела произвести выстрел."
						   else
							  w.hp = w.hp - 1
							  p "Я выстрелил в сайлона."
						   end
						   if w.hp <= 0 then
							  if live(w) then
								 lifeoff(w)
								 p " Сайлон с грохотом повалился на бок."
								 snapshots:make()
								 return true
							  else
								 return "Сайлон и так мёртв. Лучше поберечь заряд."
							  end
						   end
						else
						   return "Сайлон повержен."
						end
					 elseif w ^ "сайлон2" then
						if w.hp > 0 then
						   s.loaded = s.loaded - 1
						   if not _"сайлон2".notice then
							  _"сайлон2".notice = true
							  lifeon "сайлон2"
						   end
						   if where "Катя" == here() and disabled "винтовка Кати" then
							  p "Я выстрелил в сайлона. Катя не растерялась и тоже успела произвести выстрел."
							  w.hp = w.hp - 2
						   else
							  p "Я выстрелил в сайлона."
							  w.hp = w.hp - 1
						   end
						   if w.hp <= 0 then
							  if live(w) then
								 lifeoff(w)
								 p " Сайлон с грохотом повалился на бок."
								 snapshots:make()
								 return true
							  else
								 return "Сайлон и так мёртв. Лучше поберечь заряд."
							  end
						   end
						else
						   return "Сайлон повержен."
						end
						return true
					 else
						return "Нет смысла бездумно тратить заряд аккумулятора."
					 end
				  else
					 return "В винтовке нет заряда."
				  end
			   end,
			},
			obj {
			   nam = "аккумулятор",
			   dsc = "На полке лежит {аккумулятор}.",
			   tak = "Я взял аккумулятор.",
			   inv = "Аккумулятор для лазерной винтовки. Интересно, заряжен ли он.",
			   use = function(s, w)
				  if w ^ "винтовка" then
					 disable(s)
					 w.loaded = 5
					 return "Я вставил аккумулятор в винтовку."
				  else
					 return "Аккумулятор тут не принесёт пользы."
				  end
			   end,
			},
		 },
	  }:close(),
   },
   way = {
	  path{"вниз", "первый этаж"},
   },
}

room {
   nam = "медотсек",
   building = true,
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вошёл в медотсек. На моей памяти он не пригодился ни разу, а сейчас, скорее всего, его возможностей не хватит на наши нужды."
	  else
		 return "Я нахожусь в медотсеке."
	  end
   end,
   pic = "img/med.png",
   obj = {
	  obj {
		 nam = "шкафы медотсека",
		 dsc = "Вдоль стен стоять {шкафы}.",
		 act = function(s)
			if closed(s) then
			   open(s)
			   return "Я открыл шкаф."
			else
			   close(s)
			   return "Я закрыл шкаф."
			end
		 end,
		 obj = {
			obj {
			   nam = "бинт",
			   seen = false,
			   mode = true,
			   dsc = "В шкафу лежит {баллончик} с бинтом.",
			   inv = function(s)
				  local v = "Баллончик с полимерным бинтом."
				  if not s.seen then
					 s.seen = true
					 v = v .. " Может служить для остановки кровотечений и для фиксации конечностей. Плотность бинта регулируется небольшим рычажком на боку баллона."
				  end
				  s.mode = not s.mode
				  if s.mode then
					 v = v .. "^^Я переключил баллончик в режим бинта."
				  else
					 v = v .. "^^Я переключил баллончик в режим гипса."
				  end
				  return v
			   end,
			   tak = "Я взял бинт.",
			   use = function(s, w)
				  if w ^ "Катя" then
					 if s.mode then
						return "Наложение повязки не самое первоочерёдное сейчас."
					 else
						disable(s)
						return "Я зафиксировал руку Кати густой пеной полимерного бинта."
					 end
				  else
					 return "Лучше использовать баллончик когда он действительно нужен."
				  end
			   end,
			},
			obj {
			   nam = "аптечка",
			   dsc = function(s)
				  if where "бинт" ^ "шкафы медотсека" then
					 return "Рядим лежит {аптечка}."
				  else
					 return "В шкафу лежит {аптечка}."
				  end
			   end,
			   tak = "Я взял аптечку.",
			   inv = function(s)
				  if _"здоровье".hp == 8 then
					 return "Одноразовая аптечка со смесью медикаментов. Применяется в экстренных ситуациях. Проста в использовании: просто прикладывается к коже и препарат автоматически впрыскивается в организм через кожу. Говорят, что помогает дожить до серьёзного хирургического вмешательства людям с оторванными конечностями, однако на нашей спокойной захолустной планетке убедиться в этом не было никакой возможности. Оно и к лучшему."
				  else
					 _"здоровье".hp = 8
					 disable(s)
					 return "Я приложил аптечку к предплечью. Лёгкий укол и смесь препаратов широкого спектра действия всосалась в кровь."
				  end
			   end,
			   use = function(s, w)
				  if w ^ "Катя" then
					 disable(s)
					 return "Я приложил аптечку к Катиному предплечью. Индикатор показал, что стимулирующие, обезболивающие и обеззараживающие препараты были доставлены."
				  else
					 return "Стоит приберечь аптечку для экстренного случая."
				  end
			   end,
			},
		 },
	  }:close(),
	  obj {
		 nam = "медробот",
		 u = false,
		 dsc = "Большую часть отсека занимает {медробот}.",
		 act = function(s)
			if where "Катя" == s and not s.u then
			   _"Катя".healed = true
			   s.u = true
			   return "Я активировал медробота. Матовая крышка опустилась с потолка и накрыла кушетку вместе с Катей. Спустя некоторое время крышка поднялась обратно."
			else
			   return "Замечательная штука, способная справиться практически с любой медицинской проблемой. Разве что оживлять мёртвых не может."
			end
		 end,
	  },
   },
   way = {
	  path{"обратно", "первый этаж"},
   },
}

room {
   nam = "опушка леса",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вышел на опушку леса. Всю свою жизнь я ходил по этим местам с Катей или Борисом."
	  else
		 return "Я нахожусь на опушке леса."
	  end
   end,
   pic = "img/forest.png",
   obj = {
   },
   way = {
	  "второй бункер",
	  path{"вглубь леса", "лес"},
	  "космопорт",
   },
}

room {
   nam = "второй бункер",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я подошёл к тому месту, где находился второй бункер. Наверняка Катя смогла выбраться. Нужно её поискать."
	  else
		 return "Я нахожусь у огненного озера расплавленной почвы и породы на месте второго бункера."
	  end
   end,
   pic = "img/bushes.png",
   onexit = function(s, w)
	  if have "Катя" and not disabled "винтовка Кати" and not have "винтовка Кати" then
		 p "Лучше взять винтовку с собой."
		 return false
	  end
   end,
   obj = {
	  "корабль сайлонов",
	  obj {
		 nam = "огненное озеро",
		 dsc = "Ничего не осталось. Поле излучателей, сам бункер, почва и порода превратились в огненное {озеро}.",
		 act = "Зрелище поражает воображение. С детства бункер и мачты излучателей казались монументальными и нерушимыми, а сейчас в один миг они уничтожены.",
	  },
	  obj {
		 nam = "дым над бункером",
		 dsc = "Над ним столбом в небо поднимается густой {дым}.",
		 act = "Нет времени смотреть на свидетельство мощи сайлонов. Нужно двигаться дальше.",
	  },
	  obj {
		 nam = "кустарник у бункера",
		 dsc = "{Кустарник} вокруг бункера сильно обгорел, но чем дальше, тем больше растений уцелело.",
		 act = function(s)
			if disabled "Катя" then
			   enable "Катя"
			   enable "винтовка Кати"
			   return "Я осмотрел уцелевший кустарник. Под одним из них лежит тело!"
			else
			   return "Раньше тут было очень красиво, но сейчас кустарник обгорел и зрелище навевает совсем невесёлые мысли."
			end
		 end,
	  },
	  obj {
		 nam = "Катя",
		 healed = false,
		 wake = false,
		 talked = false,
		 dsc = function(s)
			if not s.wake then
			   if where(s) ^ "второй бункер" then
				  return "Под одним из кустов лежит {Катя}."
			   else
				  return "На его кушетке лежит {Катя}."
			   end
			else
			   return "Рядом со мной стоит {Катя}."
			end
		 end,
		 tak = function(s)
			if not s.healed then
			   if not (disabled "аптечка" and disabled "бинт") then
				  p "Катя лежит без сознания. Кажется, у неё сломана рука."
				  return false
			   else
				  return "Я взвалил Катю на плечо."
			   end
			else
			   if not s.wake then
				  s.wake = true
				  place(s, "медотсек")
				  lifeon(s)
				  p "Я легонько потряс Катю за плечо. Она очнулся и встала."
				  return false
			   else
				  if not s.talked then
					 s.talked = true
					 walk "второй разговор с Катей"
					 return false
				  else
					 walk "третий разговор с Катей"
					 return false
				  end
			   end
			end
		 end,
		 use = function(s, w)
			if w ^ "медробот" then
			   place(s, w)
			   return "Я аккуратно положил Катю на кушетку медробота."
			else
			   return "Кате нужно оказать медицинскую помощь."
			end
		 end,
		 life = function(s)
			if player_moved() and not here().without_Ktherine and not from().without_Ktherine then
			   place(s)
			   return "Катя пошла со мной."
			end
		 end,
	  }:disable(),
	  obj {
		 nam = "винтовка Кати",
		 dsc = function(s)
			if where(s) == where "Катя" then
			   return "Рядом с ней лежит {винтовка}."
			else
			   return "На земле лежит {винтовка}."
			end
		 end,
		 tak = "Я взял винтовку.",
		 inv = function(s)
			local v = "Старинная плазменная винтовка. Такие стояли на вооружении несколько веков назад."
			if _"Катя".wake then
			   v = v .. " Лучше вернуть её Кате."
			end
			return v
		 end,
		 use = function(s, w)
			if w ^ "Катя" then
			   if w.wake then
				  disable(s)
				  return "Я отдал винтовку Кате."
			   else
				  return "Катя без сознания."
			   end
			else
			   return "Лучше поберечь заряд."
			end
		 end,
	  }:disable(),
   },
   way = {
	  "опушка леса",
   },
}

dlg {
   nam = "второй разговор с Катей",
   pic = function(s)
	  return from().pic
   end,
   without_Ktherine = true,
   noinv = true,
   disp = "разговор с Катей",
   onenter = "Я заговорил с Катей.",
   phr = {
	  { "Как себя чувствуешь?", "-- Для человека, едва не погибшего под орбитальной атакой сайлонов, очень хорошо.",
		{ "Откуда у тебя винтовка?", "-- Досталась от деда. Своего рода семейная реликвия, хранимая со времён войны.",
		  { "Здорово. Красивая вещь.", "-- Ага. Мне она с детства нравится." },
		},
	  },
   },
}

dlg {
   nam = "третий разговор с Катей",
   without_Ktherine = true,
   noinv = true,
   disp = "разговор с Катей",
   onenter = "Я попытался заговорить с Катей.^^-- Серёжа, я сейчас не хочу разговаривать.",
   phr = { "Хорошо", "" },
}

room {
   nam = "лес",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я углубился в лес. С детства знакомый, сейчас он меня пугает. Ведь где-то в нём древнее зло ждёт удобный момент, чтобы напасть."
	  else
		 return "Я нахожусь в лесу."
	  end
   end,
   pic = "img/forest.png",
   onenter = function(s)
	  if _"сайлон1".hp > 0 then
		 lifeon "сайлон1"
	  end
   end,
   onexit = function(s, t)
	  if t ^ "вглубь леса" then
		 p "Мне нечего делать в лесу. Укрывшиеся в его дебрях дети выйдут сами, когда получат соответствующий сигнал по рации."
		 return false
	  end
   end,
   obj = {
	  obj {
		 nam = "деревья",
		 dsc = "В этой части леса {деревья} растут не очень плотно и пространство достаточно хорошо просматривается.",
		 act = "В основном сосны.",
	  },
	  obj {
		 nam = "сайлон1",
		 hp = 3,
		 dsc = function(s)
			if s.hp > 0 then
			   if here() ^ "лес" or here() ^ "опушка леса" then
				  return "Среди деревьев стоит {сайлон}."
			   else
				  return "Неподалёку стоит {сайлон}."
			   end
			else
			   if here().builing then
				  return "На полу лежит {сайлон}."
			   else
				  return "На земле лежит {сайлон}."
			   end
			end
		 end,
		 act = function(s)
			if s.hp == 3 then
			   return "Совершенно невредимый. Корпус из матового сплава как будто и вовсе холодный. И это после падения в сбитом боте!"
			elseif s.hp == 2 then
			   return "Сайлон немного повреждён. Видимо, его оболочка была повреждена при падении бота."
			elseif s.hp == 1 then
			   return "Как это ни удивительно, но его удалось заметно потрепать."
			else
			   return "Не верится, что удалось его одолеть!"
			end
		 end,
		 life = function(s)
			if player_moved() then
			   place(s)
			else
			   _"здоровье".hp = _"здоровье".hp - 4
			   return check_health(s)
			end
		 end,
	  },
   },
   way = {
	  "опушка леса",
	  "вглубь леса",
   },
}

room {
   nam = "вглубь леса"
}

room {
   nam = "окраина города",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вышел к окраине города. Удивительно, но всё выглядит так, как будто всё в порядке, как будто не пришлось всем скрываться с оружием за чертой города, как будто не вернулось эхо давно прошедшей войны."
	  else
		 return "Я нахожусь на окраине города."
	  end
   end,
   pic = "img/outskirts.png",
   obj = {
	  "десантный бот",
	  "корабль сайлонов",
	  obj {
		 nam = "дома на окраине",
		 dsc = "{Дома} выглядят как будто ничего не случилось.",
		 act = "Меня не покидает ощущение, что сейчас откроются двери и на улицу выбегут стайки детишек, хозяйки начнут судачить о своих делах, а мужики соберутся в бар или обсудить сбор урожая в этом году.",
	  },
   },
   way = {
	  "космопорт",
	  "площадь",
   },
}

room {
   nam = "площадь",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вышел на площадь. Конечно, население нашей колонии невелико, но всё равно её опустевший вид навевает тоску."
	  else
		 return "Я нахожусь на площади."
	  end
   end,
   pic = "img/outskirts.png",
   onexit = function(s, t)
	  if not _"сайлон2".notice then
		 _"сайлон2".notice = true
		 lifeon "сайлон2"
		 if where "Катя" == here() then
			return "Сайлон заметил наше присутствие!"
		 else
			return "Сайлон заметил моё присутствие!"
		 end
	  end
   end,
   obj = {
	  "десантный бот",
	  "корабль сайлонов",
	  obj {
		 nam = "здание ратуши",
	  },
	  obj {
		 nam = "памятник первым поселенцам",
		 dsc = "По центру площади стоит {памятник} первым поселенцам.",
		 act = "Группа людей в скафандрах в какой-то настороженной позе. Этот памятник всегда казался мне странным.",
	  },
	  obj {
		 nam = "Боб",
		 dead = false,
		 dsc = "Рядом с ним лежит {Боб}.",
		 act = function(s)
			if _"сайлон2".hp <= 0 then
			   if not s.dead then
				  s.dead = true
				  take "ключ от бункера"
				  walk "разговор с Бобом"
			   else
				  return "Боб выглядит так спокойно. Если бы не страшная рана в животе, можно было бы подумать, что он перебрал в баре и мирно уснул по дороге домой."
			   end
			else
			   return "Сайлон не даст подойти к Бобу."
			end
		 end,
	  },
	  obj {
		 nam = "сайлон2",
		 notice = false,
		 hp = 4,
		 dsc = function(s)
			if s.hp > 0 then
			   if not s.notice then
				  if where "Катя" == here() then
					 return "Возле него стоит {сайлон}. Пока что он нас не видит."
				  else
					 return "Возле него стоит {сайлон}. Пока что он меня не видит."
				  end
			   else
				  return "Неподалёку стоит {сайлон}."
			   end
			else
			   return "{Сайлон} лежит грудой металлолома."
			end
		 end,
		 act = function(s)
			if s.hp > 0 then
			   return "Грозная фигура из древних хроник. Опасная и смертоносная. Нужно скорее что-нибудь предпринять для спасения."
			else
			   return "Исполосованный лазером, лежащий на боку сайлон всё равно выглядит грозно."
			end
		 end,
		 life = function(s)
			if player_moved() then
			   place(s)
			else
			   _"здоровье".hp = _"здоровье".hp - 4
			   return check_health(s)
			end
		 end,
	  },
   },
   way = {
	  "окраина города",
	  "ратуша",
	  "бар",
   },
}

function wbob()
   if live "Катя" then
	  return "Держись. Мы сейчас отнесём тебя в медотсек и подлатаем."
   else
	  return "Держись. Сейчас я отнесу тебя в медотсек и подлатаем."
   end
end

dlg {
   nam = "разговор с Бобом",
   pic = "img/outskirts.png",
   without_Ktherine = true,
   noinv = true,
   enter = "Я подбежал к Бобу.",
   phr = {
	  { "Бобби, ты как?", "-- Хреново, Серёг. Эта тварь приземлилась прямо передо мной и я не успел отреагировать.",
		{ wbob(), "-- Нет времени. Возьми этот ключ. Ратуша... Третий шкаф...^^Глаза Бобби остекленели, договорить он не успел." },
	  },
   },
}

obj {
   nam = "ключ от бункера",
   disp = "ключ",
   inv = "Этот ключ дал мне Бобби. Он должен открывать что-то в ратуше.",
   use = function(s, w)
	  if w ^ "шкафы медотсека" then
		 return "Шкафы медотсека не запираются."
	  elseif w ^ "оружейный шкаф" then
		 return "Оружейный шкаф уже отперт. Да и не должен этот ключ к нему подходить."
	  elseif w ^ "замочная скважина" then
		 disable "третий шкаф"
		 enable "бункер под ратушей"
		 disable(s)
		 return "Я вставил ключ в замочную скважину и провернул. Шкаф отъехал в сторону, открыв тёмный проход в стене."
	  else
		 return "Вряд ли это можно открыть."
	  end
   end,
}

room {
   nam = "ратуша",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вошёл в ратушу."
	  else
		 return "Я нахожусь в ратуше."
	  end
   end,
   pic = "img/town_hall.png",
   onexit = function(s, t)
	  if t ^ "эпилог" then
		 lifeoff "Катя"
	  end
   end,
   obj = {
	  obj {
		 nam = "кресла",
		 dsc = "Ровными рядами стоят {кресла}",
		 act = "Выглядят удобными.",
	  },
	  obj {
		 nam = "столы",
		 dsc = "со {столами}.",
		 act = "За этими столами принимаются все важные решения в нашей колонии.",
	  },
	  obj {
		 nam = "лестница в ратуше",
		 dsc = "У стены находится {лестница}, ведущая на второй этаж.",
		 act = "Узкая деревянная и совершенно ничем не примечательная лестница.",
	  },
   },
   way = {
	  path{"наружу", "площадь"},
	  path{"наружу", "эпилог"},
	  path{"наверх", "второй этаж ратуши"},
   },
}

room {
   nam = "второй этаж ратуши",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я поднялся на второй этаж. Никогда ещё не доводилось мне быть здесь. И хотя я никогда не испытывал трепет перед управленцами и властью, всё равно мне тут несколько не по себе."
	  else
		 return "Я нахожусь на втором этаже ратуши."
	  end
   end,
   pic = "img/books.png",
   onexit = function(s, w)
	  if w ^ "бункер под ратушей" then
		 if not (_"фонарик".on or _"панель управления".on) then
			p "Проход слишком тёмный."
			return false
		 end
	  end
	  return true
   end,
   obj = {
	  obj {
		 nam = "шкафы",
		 dsc = "Вдоль стен стоят {шкафы} с книгами.",
		 act = function(s)
			if disabled "третий шкаф" and disabled "бункер под ратушей" and _"Боб".dead then
			   enable "третий шкаф"
			   return "Бобби говорил что-то про третий шкаф."
			else
			   return "Строгие деревянные шкафы с большим количеством различных бумажных книг. Архаика, конечно, но красиво."
			end
		 end,
	  },
	  obj {
		 nam = "третий шкаф",
		 moved = false,
		 dsc = "Третий {шкаф} от лестницы ничем не выделяется на фоне остальных",
		 act = "Массивный деревянный шкаф.",
		 obj = {
			obj {
			   nam = "книги",
			   dsc = "В шкафу стоит множество {книг}.",
			   act = function(s)
				  open(s)
				  return "В шкафу стоят книги по инженерным системам и истории. Хм... Странное сочетание."
			   end,
			   obj = {
				  obj {
					 nam = "книга",
					 dsc = "Моё внимание привлекла {книга} с названием \"Системы обороны в войне с сайлонами\".",
					 act = function(s)
						if closed(s) then
						   open(s)
						   return "Я потянул книгу на себя, но она только немного сдвинулась. Сбоку на ней обнаружилась замочная скважина!"
						else
						   return "Это точно не книга."
						end
					 end,
					 obj = {
						obj {
						   nam = "замочная скважина",
						   dsc = "В ней имеется замочная {скважина}.",
						   act = "Простая замочная скважина прямо в обложке книги.",
						},
					 },
				  }:close(),
			   },
			}:close(),
		 },
	  }:disable(),
   },
   way = {
	  path{"вниз", "ратуша"},
	  path{"проход", "бункер под ратушей"},
   },
}

room {
   nam = "бункер под ратушей",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "В проходе оказалась узкая лестница, которая вела глубоко вниз, скорее всего под землю. Внизу обнаружился бункер системы обороны. Древний -- явно старше того, в который сегодня попал я."
	  else
		 return "Я нахожусь в бункере под ратушей."
	  end
   end,
   pic = "img/bunker.png",
   obj = {
	  obj {
		 nam = "сенсор",
		 finded = false,
		 dsc = "{Экран} сенсора висит на стене.",
		 act = function(s)
			if _"панель управления".on then
			   s.finded = true
			   return "На экране сенсора виден крупный сигнал основного корабля сайлонов."
			else
			   return "Всё обесточено."
			end
		 end,
	  },
	  obj {
		 nam = "панель управления",
		 on = false,
		 aimed = false,
		 dsc = "Под экраном расположена {панель} управления.",
		 act = function(s)
			if s.on then
			   if _"сенсор".finded then
				  s.aimed = true
				  return "Я быстро навёл орудие на корабль сайлонов."
			   else
				  return "Сперва нужно считать координаты для наведения."
			   end
			else
			   return "Всё обесточено."
			end
		 end,
		 obj = {
			obj {
			   nam = "кнопка",
			   shoot = false,
			   dsc = "На её краю находится большая {кнопка} залпа.",
			   act = function(s)
				  if _"панель управления".aimed then
					 if not s.shoot then
						s.shoot = true
						disable "площадь"
						enable "эпилог"
						return "Я нажал на кнопку. Из-за стены послышалось низкое гудение силовой установки. Если я попал, то стоит выйти и посмотреть что из этого получилось, а если промазал, то лучше поскорее делать отсюда ноги пока не нанесли ответный удар."
					 else
						return "Я уже произвёл выстрел."
					 end
				  else
					 return "Если я сейчас выстрелю наугад, то город будет просто сметён с лица планеты, а сайлоны приземлятся и уничтожат всех выживших."
				  end
			   end,
			},
		 },
	  },
   },
   way = {
	  path{"наверх", "второй этаж ратуши"},
   },
}:disable()

room {
   nam = "бар",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вошёл в совершенно пустой бар. Зрелище оказалось крайне удручающим. Буквально вчера он был полон весёлыми людьми и беззаботной атмосферой."
	  else
		 return "Я нахожусь в баре."
	  end
   end,
   pic = "img/bar.png",
   obj = {
   },
   way = {
	  path{"наружу", "площадь"},
	  path{"наверх", "второй этаж бара"},
	  "подвал",
   },
}

room {
   nam = "второй этаж бара",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я поднялся на второй этаж. Никогда не был в помещениях над баром. Здесь живёт Денис -- хозяин бара и, по совместительству, один из управляющих колонией."
	  else
		 return "Я нахожусь на втором этаже над баром."
	  end
   end,
   pic = "img/bar_2floor.png",
   obj = {
   },
   way = {
	  path{"вниз", "бар"},
	  path{"комната", "комната Дениса"},
   },
}

room {
   nam = "комната Дениса",
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я вошёл в комнату Дениса. Она оказалась более чем скромной."
	  else
		 return "Я нахожусь в комнате Дениса."
	  end
   end,
   pic = "img/bar_room.png",
   obj = {
	  obj {
		 nam = "кровать",
		 dsc = "Большую часть комнаты занимает {кровать}.",
		 act = "Не время отдыхать.",
	  },
	  obj {
		 nam = "тумбочка",
		 dsc = "Рядом с ней стоит {тумбочка}.",
		 act = function(s)
			if closed(s) then
			   open(s)
			   return "Я открыл тумбочку."
			else
			   close(s)
			   return "Я закрыл тумбочку."
			end
		 end,
		 obj = {
			obj {
			   nam = "451",
			   dsc = "В тумбочке лежит {книга}.",
			   act = "Рэй Брэдбери \"451 градус по Фаренгейту\".",
			},
		 },
	  }:close(),
	  obj {
		 nam = "картина",
		 dsc = "На стене висит {картина}.",
		 act = function(s)
			if closed(s) then
			   open(s)
			   return "Я отодвинул картину."
			else
			   close(s)
			   return "Я подвинул картину обратно."
			end
		 end,
		 obj = {
			obj {
			   nam = "сейф",
			   dsc = "В стену вмонтирован {сейф}.",
			   act = function(s)
				  if closed(s) then
					 walk "кодовый замок"
				  else
					 return "Денису стоило бы чаще проявлять фантазию."
				  end
			   end,
			   obj = {
				  obj {
					 nam = "ключ-карта",
					 dsc = "В сейфе лежит {ключ-карта}.",
					 tak = "Я взял ключ-карту.",
					 inv = "Ключ-карта для какой-то электронной системы.",
					 use = function(s, w)
						if w ^ "панель управления" then
						   w.on = true
						   disable(s)
						   return "Я вставил ключ-карту в прорезь панели управления -- система активировалась."
						else
						   return "Думаю, ключ-карта тут бесполезна."
						end
					 end,
				  },
			   },
			}:close(),
		 },
	  }:close(),
   },
   way = {
	  path{"выйти", "второй этаж бара"},
   },
}

function check_pass(pass)
   here().n = here().n + 1
   here().decor = "На дисплее отображается:" .. pass
   if here().n == 4 then
	  if pass == "0451" then
		 walkout()
		 open "сейф"
		 p "Раздался щелчок и сейф открылся."
	  else
		 here().pass = ""
		 here().n = 0
		 here().decor = ""
		 p "Пароль не подошёл."
	  end
   end
end

room {
   nam = "кодовый замок",
   without_Ktherine = true,
   noinv = true,
   pass = "",
   n = 0,
   decor = "",
   pic = "img/lock.png",
   obj = {
	  obj {
		 dsc = "{1}",
		 act = function(s)
			here().pass = here().pass .. "1"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{2}",
		 act = function(s)
			here().pass = here().pass .. "2"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{3}{$nl|}",
		 act = function(s)
			here().pass = here().pass .. "3"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{4}",
		 act = function(s)
			here().pass = here().pass .. "4"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{5}",
		 act = function(s)
			here().pass = here().pass .. "5"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{6}{$nl|}",
		 act = function(s)
			here().pass = here().pass .. "6"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{7}",
		 act = function(s)
			here().pass = here().pass .. "7"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{8}",
		 act = function(s)
			here().pass = here().pass .. "8"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{9}{$nl|}",
		 act = function(s)
			here().pass = here().pass .. "9"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{#}",
		 act = function(s)
			here().pass = ""
			here().n = 0
			here().decor = here().pass
		 end,
	  },
	  obj {
		 dsc = "{0}",
		 act = function(s)
			here().pass = here().pass .. "0"
			check_pass(here().pass)
		 end,
	  },
	  obj {
		 dsc = "{*}",
		 act = function(s)
			here().pass = ""
			here().n = 0
			here().decor = here().pass
		 end,
	  }
   },
   way = {
	  path{"отойти", "комната Дениса"},
   },
}

room {
   nam = "подвал",
   seen = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return "Я спустился в подвал. Приятная прохлада и полумрак."
	  else
		 return "Я нахожусь в подвале."
	  end
   end,
   pic = "img/basement.png",
   obj = {
	  obj {
		 nam = "стеллажи в подвале",
		 dsc = "Большую часть подвала занимают {стеллажи}",
		 act = "Тут можно разместить очень много добра.",
		 obj = {
			obj {
			   nam = "бутылки",
			   dsc = "с {бутылками}.",
			   act = "Вот ведь хитрец наш Денис -- поднял цены на выпивку, оправдываясь дефицитом. Подвал практически под завязку забит бутылками!",
			},
		 },
	  },
	  obj {
		 nam = "полка",
		 dsc = "Рядом со входом на стене висит {полка}.",
		 act = "Небольшая деревянная полка. Ничего примечательного.",
		 obj = {
			obj {
			   nam = "фонарик",
			   on = false,
			   disp = function(s)
				  if s.on then
					 return "фонарик (вкл)"
				  else
					 return "фонарик (выкл)"
				  end
			   end,
			   dsc = "На ней лежит {фонарик}.",
			   tak = "Я взял фонарик.",
			   inv = function(s)
				  if s.on then
					 s.on = false
					 return "Я выключил фонарик."
				  else
					 s.on = true
					 return "Я включил фонарик."
				  end
			   end,
			},
		 },
	  },
   },
   way = {
	  path{"наверх", "бар"},
   },
}

room {
   nam = "эпилог",
   noinv = true,
   title = "площадь",
   decor = "Я вышел на площадь. Звенящая тишина опустевшего города действует угнетающе, но ещё больше пугает картина падающего корабля сайлонцев. Эта громадина даже отсюда на таком расстоянии выглядит впечатляюще.^^Взяв Катю за руку, я пошёл в сторону леса на поиски укрывшихся там детей...^^^^" .. fmt.c "КОНЕЦ",
   pic = "img/outskirts.png",
   onenter = function(s)
	  snd.music("mus/comtemplated.xm")
   end,
}:disable()
