--$Name: R01$
--$Version: 0.995$
--$Author: Андрей Лобанов$

local function get_bool(o, nam)
	if type(o[nam]) == 'boolean' then
		return o[nam]
	end
	if type(o[nam]) == 'function' then
		return o:nam()
	end
	return nil
end

instead.get_inv = std.cacheable('inv', function(horiz)
	if get_bool(instead, 'noinv') then
		return
	end
	local str = iface:cmd("inv");
	if str then
		str = std.string.gsub(str, '\n$','');
		str = std.string.gsub(str, '\\?['.. std.delim ..']',
							  { [std.delim] = instead.hinv_delim, ['\\'..std.delim] = std.delim });
		str = string.gsub(str, instead.hinv_delim, '', 1)
		return str
	end
end)

global {
   score = 0,
   max_inv = 1,
   leg_fixed = false,
   on_ladder = false,
   nice_hand = false,
   ship_time = 0,
   airlock_time = 0,
   dmitry = false,
}

obj {
   nam = '$nl',
   act = function(s)
      return '\n'
   end,
}

stat {
   nam = 'счёт',
   disp = function()
	  return 'СЧЁТ: ' .. tostring(score) .. ' / 80{$nl}'
   end,
}

require 'fmt'
require 'noinv'
require 'snd'
require 'lib/cutscene'

fmt.para_space = '        '
xact.walk = walk
instead.fading_value = 6

function init()
   take 'счёт'
   take 'инструменты'
end

function start()
   snd.music('mus/little forest spider.it')
end

game.ontak = function(s, w)
   if w.tak then
	  dprint(#inv())
	  dprint(max_inv)
	  if #inv() - 1 == max_inv then
		 p 'Робот не может взять больше предметов.'
		 return false
	  end
   else
	  return true
   end
end,

obj {
   nam = 'инструменты',
   space = false,
   inv = 'Различные инструменты, необходимые для небольшого ремонта корабля во время полёта.',
   use = function(s, w)
	  if w ^ 'космос' or w ^ 'звёзды' or w ^ 'планета' then
		 if not s.space then
			s.space = true
			return 'Если робот выбросит инструменты, то не сможет починить солнечные панели.'
		 else
			disable(s)
			local v = 'Робот размахнулся и швырнул ящик с инструментами. Тот начал стремительно удаляться от корабля.'
			if not _'солнечные панели'.fixed then
			   v = v .. ' Теперь он не сможет починить солнечные панели.'
			end
			return v
		 end
	  elseif w ^ 'солнечные панели' then
		 if w.fixed then
			return 'Робот уже отремонтировал солнечные панели.'
		 else
			w.fixed = true
			score = score + 5
			return 'Робот аккуратно демонтировал повреждённый сегмент и установил на его место новый.'
		 end
	  else
		 return 'Инструментами тут ничего не сделать.'
	  end
   end,
}

room {
   nam = 'main',
   noinv = true,
   disp = 'R01',
   pic = 'img/robot.png',
   decor = fmt.c('Сказка о маленьком роботе, помощнике принцессы, попавшем в беду.^' ..
					fmt.em 'Специально для шестого паровозика.^^' ..
					'{@ walk "возле шлюза"|Начать игру}^' ..
					'{@ walk "ОБ ИГРЕ"|Об игре}'),
}

room {
   nam = 'ОБ ИГРЕ',
   noinv = true,
   enter = function(s)
	  fmt.para = true
   end,
   exit = function(s)
	  fmt.para = false
   end,
   decor = fmt.imgl 'img/robot.png' ..
	  fmt.b 'Версия:' .. fmt.tab '50%' .. '0.995^' ..
      fmt.b 'Автор:' .. fmt.tab '50%' .. 'Андрей Лобанов^' ..
      fmt.b 'Автор Instead:' .. fmt.tab '50%' .. 'Пётр Косых^^' ..
	  fmt.b 'Изображение робота:' .. fmt.tab '50%' .. 'Krypton / Doragon^' ..
	  fmt.b 'Музыка:' .. fmt.tab '50%' .. 'Manwe - Little Forest Spider^^' ..
	  fmt.b 'Тестирование:' .. fmt.tab '50%' .. 'Артур А.^' ..
	  fmt.tab '50%' .. 'Khaelenmore Thaal^' ..
	  fmt.tab '50%' .. 'Пётр Косых^' ..
	  fmt.tab '50%' .. 'Lucky Ook^^' ..
	  fmt.em 'Игра имеет некоторую степень вариативности и некоторые ваши действия влияют на дальнейшее прохождение и конечный счёт.^' ..
	  fmt.c '^{@ walk main|Назад}',
}

obj {
   nam = 'космос',
   dsc = 'На многие световые годы вокруг распростёрлась чернота {космоса},',
   act = 'Робот не боится бездонной пустоты. Он вообще ничего не боится, ведь его на это не программировали.',
   obj = {
	  obj {
		 nam = 'звёзды',
		 dsc = 'на которой раскинулись мириады {звёзд}.',
		 act = 'Такие далёкие, но такие близкие. Где-то там находится дом принцессы, к которому она с роботом и путешествует.',
	  },
	  obj {
		 nam = 'планета',
		 dsc = 'Далеко внизу находится {планета}, на орбите которой в данный момент находится корабль.',
		 act = 'Робот не знает что это за планета. Какая-то очередная провинциальная планетка.',
	  },
   },
}

obj {
   nam = 'скобы',
   dsc = 'На поверхности обшивки находятся {скобы}, позволяющие перемещаться по поверхности корабля.',
   act = 'Хватаясь за них, робот может оказаться на любой части поверхности корабля, что очень помогает в ремонте.',
}

room {
   nam = 'возле шлюза',
   seen = false,
   enter = function(s)
	  fmt.para = true
   end,
   dsc = function(s)
      if not s.seen then
		 s.seen = true
		 return 'После попадания небольшого метеорита в корабль, принцесса Амалия отправила робота заняться ремонтом. Этот маленький камушек пробил солнечную панель, без которой не удастся накопить достаточно энергии для дальнейшего путешествия.'
      else
		 return 'Робот находится на обшивке корабля возле шлюза.'
      end
   end,
   obj = {
	  'космос',
	  'скобы',
   },
   way = {
	  path{'к панелям', 'у солнечных панелей'},
   },
}

room {
   nam = 'у солнечных панелей',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Перебирая скобы, робот добрался до солнечных панелей. Один сегмент пробит мелким астероидом и требует замены.'
	  else
		 return 'Робот находится возле солнечных панелей.'
	  end
   end,
   onexit = function(s, t)
	  if _'солнечные панели'.fixed then
		 walk 'падение'
	  end
   end,
   obj = {
	  'космос',
	  'скобы',
	  obj {
		 nam = 'солнечные панели',
		 fixed = false,
		 dsc = 'Солнечные {панели} раскинулись в стороны.',
		 act = function(s)
			if s.fixed then
			   return 'Панели в отличном состоянии.'
			else
			   return 'Один сегмент панели пробит астероидом и требует замены.'
			end
		 end,
	  },
   },
   way = {
	  path{'к шлюзу', 'возле шлюза'},
   },
}

cutscene {
   nam = 'падение',
   noinv = true,
   disp = '. . .',
   decor = function(s)
	  pn 'Робот направился к шлюзу корабля, чтобы сообщить принцессе, что ремонт закончен.'
	  p '[cut]'
	  pn 'Однако, скоба в его руке оторвалась от обшивки корабля.'
	  p '[cut]'
	  pn 'Робот начал своё падение на провинциальную планету...'
	  p('[cut]')
	  pn '[code inv():del("инструменты")]'
	  pn '[code walk "диагностика"]'
   end,
}

cutscene {
   nam = 'диагностика',
   noinv = true,
   disp = '. . .',
   onenter = function(s, f)
	  max_inv = 1
   end,
   decor = function(s)
	  pn('Питание...' .. fmt.tab '20%' .. 'Восстановлено')
	  p('[cut]')
	  pn('Ядро...' .. fmt.tab '20%' .. 'Неисправности не обнаружены')
	  p('[cut]')
	  pn('Память...' .. fmt.tab '20%' .. 'Недоступно пространство с 0x3c53ab55e4fc')
	  p('[cut]')
	  pn('Ноги...' .. fmt.tab '20%' .. 'Повреждена левая нога, движение ограничено')
	  p('[cut]')
	  pn('Руки...' .. fmt.tab '20%' .. 'Не функционирует левая рука')
	  p('[cut]')
	  pn('Визоры...' .. fmt.tab '20%' .. 'Повреждена левая линза')
	  pn('[cut]')
	  pn('Запуск...')
	  pn('[cut]')
	  pn('[code walk "болото"]')
   end,
}

obj {
   nam = 'небо',
   dsc = 'Тёмное {небо}',
   act = 'Иссиня-чёрное как на родной планете принцессы, что находится в тысячах световых лет отсюда.',
   obj = {
	  obj {
		 dsc = 'усеяно {звёздами}.',
		 act = 'После бездны открытого космоса кажется, что их существенно меньше. Атмосфера заставляет звёзды немного мерцать и это по-своему красиво.',
	  },
   },
}

room {
   nam = 'болото',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот обнаружил себя в болоте в клубах пара. Не самое удачное место для приземления, но оно смягчило его падение. Нужно найти способ вернуться к принцессе, ведь робот служит ей всю свою жизнь.'
	  else
		 return 'Робот находится на болоте.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Чёрная {вода} болота окружает робота, представляя большую опасность.',
		 act = 'Наверняка, там кроется трясина.',
	  },
	  obj {
		 dsc = 'Однако, редкие {кочки} представляются весьма надёжными.',
		 act = 'Роботу кажется, что прыгая по кочкам, он сможет выбраться с болота.',
	  },
	  'небо',
	  obj {
		 nam = 'огонёк',
		 dsc = 'Вдали виднеется какой-то {огонёк}.',
		 act = 'Возможно, там найдётся кто-нибудь, кто поможет роботу.',
	  },
   },
   way = {
	  path{'к огоньку', after=function() if visited('у подножия холма') then return 'к холму' else return 'к огоньку' end; end, 'болото2'},
   },
}

room {
   nam = 'болото2',
   seen = false,
   disp = 'болото',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Идти по топкой почве довольно тяжело, тем более с повреждённой ногой, но робот неутомимо движется к своей цели -- огонёк стал значительно ближе.'
	  else
		 return 'Робот находится на болоте.'
	  end
   end,
   obj = {
	  obj {
		 dsc = '{Воды} здесь значительно меньше,',
		 act = 'Вода уже не кажется роботу такой бездонной и опасной, но всё же стоит быть осторожнее.',
	  },
	  obj {
		 dsc = 'а {кочек} больше.',
		 act = function(s)
			local v = 'Идти по ним значительно легче.'
			if leg_fixed then
			   v = v .. ' Теперь, когда повреждённая нога заменена, робот может передвигаться и вовсе без усилий.'
			end
			return v
		 end,
	  },
	  'небо',
	  'огонёк',
   },
   way = {
	  path{'к огоньку', after='к холму', 'у подножия холма'},
	  path{'вглубь болота', 'болото'},
   },
}

room {
   nam = 'у подножия холма',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот наконец выбрался из болота к подножию холма.'
	  else
		 return 'Робот находится у подножия холма.'
	  end
   end,
   onexit = function(s, t)
	  if t ^ 'холм' and not leg_fixed then
		 p 'Робот попытался подняться на холм, но повреждённая нога недостаточно сгибается и он упал обратно.'
		 return false
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Вдоль болота тянется {дорога}, поднимающаяся на холм.',
		 act = 'Ухабистая дорога требует ремонта.',
	  },
	  obj {
		 dsc = 'В отдалении стоит небольшой {домик}.',
		 act = 'Над его крыльцом приветливо светит лампочка. Это её робот видел с болота.',
	  },
	  'небо',
   },
   way = {
	  path{'болото', 'болото2'},
	  'холм',
	  'домик',
   },
}

room {
   nam = 'домик',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот подошёл к небольшому домику.'
	  else
		 return 'Робот находится около небольшого домика.'
	  end
   end,
   obj = {
	  obj {
		 dsc = '{Домик} сделан из дерева, но явно требует больше ухода, чем получает.',
		 act = 'Все окна в доме тёмные и только лампочка над крыльцом светит тёплым светом.',
		 obj = {
			obj {
			   dsc = 'Небольшое {крыльцо} ведёт к входной двери.',
			   act = 'Краска на досках облупилась, но они всё равно выглядят достаточно крепкими.',
			   obj = {
				  obj {
					 nam = 'Ия',
					 dsc = 'На ступеньках сидит маленькая {девочка}.',
					 act = function(s)
						walk 'разговор с девочкой'
					 end,
				  },
			   },
			},			   
		 },
	  },
	  'небо',
   },
   way = {
	  path{'к холму', 'у подножия холма'},
   },
}

dlg {
   nam = 'разговор с девочкой',
   noinv = true,
   onenter = 'Робот подошёл к крыльцу поближе и девочка его заметила:^^-- Привет. Ты кто?',
   phr = {
	  { 'Я R01 -- помощник принцессы Амалии. А ты кто?', '-- А меня Ия зовут. Я тут с дедушкой живу... А она настоящая принцесса?^^Глаза девочки азартно заблестели.',
		{ 'Это правда. А почему ты не спишь?', '-- Скучаю по маме и папе. С дедушкой здорово, но я хочу домой.',
		  { 'А где твои родители?', '-- На орбите. Строят новую станцию ну... Чтобы корабли ремонтировать. Они вернутся, но это ещё нескоро... А что с тобой случилось? Ты какой-то сломанный.',
			{ 'Я ремонтировал корабль принцессы и упал. Сломались рука и нога.', '-- Мой дедушка ремонтирует роботов, работающих в городе. Правда он говорит, что после открытия мастерской в городе дела идут неважно... Давай я тебе новую ногу дам?',
			  { 'А дедушка не заругается?', '-- Нет. У него много всякого в мастерской.^^С этими словами девочка убежала в дом и вернулась с ногой. Вместе они смогли отсоединить старую ногу и установить новую. Вполне сносно.',
				{ 'Спасибо тебе, Ия. Я передам принцессе, что ты мне помогла.', '-- Правда?^^Девочка просияла от счастья.',
				  { 'Конечно. Роботы не умеют врать. Теперь иди спать. Не грусти о родителях -- они обязательно вернутся.', function() p '-- Спасибо, -- сказала Ия и, заметно повеселев, пошла в дом. '; leg_fixed = true; disable 'Ия'; score = score + 10; end },
				},
			  },
			}
		  },
		},
	  },
   },
}

room {
   nam = 'холм',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот взобрался на холм. Сверху открывается удивительный вид на город.'
	  else
		 return 'Робот находится на вершине холма.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Ночной {город} сияет несчётным множеством огней.',
		 act = 'Линии дорог ярко освещены фонарями, во многих домах горит свет.',
	  },
	  obj {
		 dsc = '{Небо} над городом выглядит существенно светлей, чем над болотом.',
		 act = 'Звёзд на небе видно ещё меньше. Прямо как во дворце.',
	  },
	  obj {
		 dsc = 'Вниз ведёт широкая {дорога}.',
		 act = 'Здесь она в гораздо лучшем состоянии, чем внизу.',
	  },
	  obj {
		 dsc = 'В отдалении виднеется {космопорт}.',
		 act = 'То, что нужно! Возможно, удастся пробраться туда и попасть на орбиту. Правда, нужно ещё как-то добраться до корабля принцессы.',
	  },
   },
   way = {
	  path{'к болоту', 'у подножия холма'},
	  path{'город', 'окраина города'},
   },
}

room {
   nam = 'окраина города',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот спустился с холма. Ночной город оказался более пустынным, чем представлялся с холма.'
	  else
		 return 'Робот находится на окраине города.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Невысокие {дома} стоят на большом расстоянии друг от друга.',
		 act = 'В некоторых окнах горит свет.',
	  },
	  obj {
		 dsc = 'На первых этажах горят {вывески} магазинов.',
		 act = 'Практически все они закрыты на ночь.',
	  },
	  obj {
		 dsc = 'Среди них видна {вывеска} мастерской.',
		 act = '"Ремонт вашего робота" гласит надпись. Похоже, мастерская открыта.',
	  },
	  obj {
		 nam = 'фонари',
		 dsc = 'Вдоль улицы стоят {фонари}.',
		 act = 'Яркие фонари хорошо освещают пространство.',
	  },
   },
   way = {
	  'холм',
	  'мастерская',
	  'город'
   },
}

room {
   nam = 'мастерская',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот зашёл в лавку. Это оказалась мастерская по ремонту роботов. Наверное, Ия говорила про неё.'
	  else
		 return 'Робот находится в мастерской по ремонту роботов.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'На стене висят различные {запчасти} для роботов.',
		 act = 'Видимо, образцы продаваемых запчастей.',
	  },
	  obj {
		 dsc = 'В углу стоит блестящий {корпус} робота.',
		 act = 'Новёхонький современный корпус рабочего робота.',
	  },
	  obj {
		 nam = 'продавец',
		 talk = 0,
		 dsc = 'За прилавком стоит молодой {парень}.',
		 act = function(s)
			if s.talk == 0 then
			   s.talk = 1
			   walk 'разговор с продавцом'
			elseif s.talk == 1 then
			   if not _'свёрток'.given then
				  return '-- Ты ещё не отнёс посылку?'
			   else
				  s.talk = 2
				  walk 'второй разговор с продавцом'
			   end
			elseif s.talk == 2 then
			   if not _'инструмент'.taken and _'инструмент'.seen and not _'свёрток'.opened then
				  s.talk = 3
				  walk 'третий разговор с продавцом'
			   else
				  return 'Дима ремонтирует ногу робота. Похоже, что-то случилось с цепью обратной связи.'
			   end
			end
		 end,
	  },
	  obj {
		 nam = 'инструмент',
		 seen = false,
		 taken = false,
		 dsc = 'На прилавке лежит разнообразный {инструмент}.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			end
			if not s.taken then
			   if _'продавец'.talk == 3 then
				  take 'кусачки'
				  s.taken = true
				  score = score + 5
				  return 'Робот взял кусачки.'
			   end
			   return 'Среди прочего, на прилавке лежат большие кусачки. Можно {взять|взять} их, пока продавец не видит.'
			else
			   return 'Разнообразный ручной инструмент.'
			end
		 end,
		 obj = {
			obj {
			   nam = 'взять',
			   act = function(s)
				  _'инструмент'.taken = true
				  take 'кусачки'
				  score = score + 3
			   end,
			},
		 },
	  },
   },
   way = {
	  path{'выйти', 'окраина города'},
   },
}

obj {
   nam = 'кусачки',
   dsc = 'На ней лежат {кусачки}.',
   tak = 'Робот взял кусачки.',
   inv = 'Большие кусачки. Такими можно легко перекусить толстую проволоку.',
   use = function(s, w)
	  if w ^ 'верстак' then
		 place(s, w)
		 return 'Робот положил кусачки на верстак.'
	  elseif w ^ 'забор' then
			return 'Охранник заметит, если робот будет резать забор прямо здесь.'
	  elseif w ^ 'забор космопорта' then
		 if nice_hand then
			enable 'космопорт'
			score = score + 15
			return 'Робот аккуратно разрезал кусачками забор.'
		 else
			if max_inv == 2 then
			   max_inv = 1
			   return 'Робот попробовал прорезать дыру в заборе, но старая рука, установленная Димой, не выдержала нагрузки и сломалась.'
			else
			   return 'Робот не может пользоваться кусачками одной рукой.'
			end
		 end
	  elseif w ^ 'продавец' then
		 if disabled 'космопорт' then
			return 'Роботу ещё нужны кусачки.'
		 else
			disable(s)
			score = score + 5
			return 'Робот отдал кусачки Диме.'
		 end
	  else
		 return 'Кусачками удобно что-нибудь перекусить. А тут они бесполезны.'
	  end
   end,
}

dlg {
   nam = 'разговор с продавцом',
   noinv = true,
   onenter = '-- О! Я вижу тебя знатно потрепало. Как это ты умудрился?',
   phr = {
	  { 'Я упал.', '-- Откуда ж ты так упал?',
		{ 'С корабля.', '-- Ты из космопорта пришёл?',
		  { 'Нет. Я с орбиты упал.', '-- И при этом можешь функционировать? Удивительно!',
			{ 'Мне девочка помогла -- дала новую ногу. Там, за холмом.', '-- Та, что у старого Рэна живёт? Как у деда дела?',
			  { 'Я не знаю. Ия сказала, что дела у него идут плохо.', '-- Я предлагал ему объединиться, но он говорит, что привык жить так, как живёт. Надеюсь, всё-таки мы будем работать вместе.^^Парень немного помолчал, а потом продолжил:^^-- Я ведь из-за него открыл свою мастерскую. Ещё когда совсем мелким мальчуганом был, обожал роботов, а сломанных роботов Рэн быстро и ловко приводил в порядок.',
				{ 'Надеюсь, вы всё-таки договоритесь.', '-- Слушай, давай я тебе руку заменю. Только ты сделай кое-что для меня.',
				  { 'Что сделать?', '-- Я тут одному товарищу обещал кое что передать, да всё некогда -- мастерская всё время занимает. Спать-то не каждый день удаётся. Отнеси ему этот свёрток, скажи, что это от Димы, а я тебе руку поменяю.',
					{ 'Хорошо. Куда отнести?', function() p '-- Да тут недалеко. Пройдёшь в город и там увидишь радиомастерскую. Хозяина зовут Гейб -- передай свёрток ему и возвращайся.'; take 'свёрток'; _'продавец'.talk = 1; end },
				  }
				},
			  },
			},
		  },
		},
	  },
   },
}

dlg {
   nam = 'второй разговор с продавцом',
   noinv = true,
   disp = 'Разговор с Димой',
   onenter = 'Дима повернулся к роботу и сказал:^^-- Отнёс мою посылку?',
   phr = {
	  {
		 cond = function()
			return _'свёрток'.opened
		 end,
		 'Да. Гейб был очень благодарен.',
		 function()
			max_inv = 2
			dmitry = true
			return '-- Однако, он мне написал, что свёрток был вскрыт. Хорошо, хоть, что всё осталось на месте. Ладно. Главное, что доставил. Иди сюда -- поставлю тебе руку на замену сломанной.^^Дима установил старую изношенную руку вместо сломанной.'
		 end
	  },
	  { cond = function()
		   return not _'свёрток'.opened
	  end,
		'Да. Гейб был очень благодарен.',
		function()
		   nice_hand = true
		   max_inv = 2
		   return '-- Да, он мне написал, что всё в порядке. Иди сюда -- поставлю тебе новую руку на замену сломанной.^^Дима установил новую руку вместо сломанной.'
		end
	  },
   },
}

dlg {
   nam = 'третий разговор с продавцом',
   noinv = true,
   disp = 'разговор с Димой',
   onenter = 'Робот обратился к Диме.',
   phr = {
	  { 'Можно одолжить у тебя кусачки?', '-- Конечно. Только не забудь вернуть.' },
   },
}

obj {
   nam = 'свёрток',
   opened = false,
   given = false,
   inv = function(s)
	  if not s.opened then
		 return 'Небольшой свёрток. Что находится внутри, непонятно, но можно {открыть|открыть} его и посмотреть. Наверное, ничего плохого не случится.'
	  else
		 return 'Небольшой свёрток с микросхемами.'
	  end
   end,
   use = function(s, w)
	  if w ^ 'радиолюбитель' then
		 _'радиолюбитель'.talked = true
		 s.given = true
		 remove(s)
		 if s.opened then
			score = score + 5
		 else
			score = score + 15
		 end
		 walk 'разговор с Гейбом'
	  else
		 return 'Свёрток нужно отнести в радиомастерскую и отдать тамошнему хозяину.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'открыть',
		 disp = false,
		 act = function(s)
			_'свёрток'.opened = true
			p 'Робот открыл свёрток. Внутри обнаружились микросхемы.'
		 end,
	  },
   },
}

room {
   nam = 'город',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот пошёл вглубь города. Дома здесь стоят гораздо плотнее, чем на окраине.'
	  else
		 return 'Робот находится в городе.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Плотными рядами стоят {дома}.',
		 act = 'Практически во всех окнах не горит свет.',
	  },
	  obj {
		 dsc = 'Дальше по улице видна вывеска радиомастерской.',
		 act = function(s)
			if _'свёрток'.given then
			   return 'В ней сейчас трудится над неведомым прибором Гейб.'
			else
			   return 'Видимо, это и есть мастерская Гейба.'
			end
		 end,
	  },
	  'фонари',
   },
   way = {
	  'окраина города',
	  path{'космопорт', 'у входа в космопорт'},
	  'склады',
	  path{'дальше по улице', 'у радиомастерской'},
   },
}

room {
   nam = 'склады',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот подошёл к огромным складам. Видимо, здесь хранятся разные товары перед отправкой на космопорт.'
	  else
		 if on_ladder then
			return 'Робот стоит на лестнице.'
		 else
			return 'Робот находится у складов.'
		 end
	  end
   end,
   onexit = function(s, t)
	  on_ladder = false
	  if t ^ 'город' and not _'стеллаж'.moved then
		 disable 'внутри склада'
	  elseif t ^ 'внутри склада' and not dmitry and max_inv == 2 then
		 p 'Роботу не нужно на склад.'
		 return false
	  end
	  if have 'лестница' then
		 place('лестница', 'склад')
		 return 'Уходя, робот положил лестницу к стене склада.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'склад',
		 dsc = 'На ближайшем {здании}',
		 act = 'Ничем не отличается от остальных складов.',
		 obj = {
			obj {
			   dsc = 'висит {табличка}.',
			   act = 'Склад ремонтной мастерской космопорта.',
			},
			obj {
			   nam = 'окно',
			   dsc = 'Под самой крышей есть {окно}.',
			   act = function(s)
				  if where 'лестница' ^ 'окно' then
					 if on_ladder then
						return 'Робот стоит на лестнице.'
					 else
						on_ladder = true
						enable 'внутри склада'
						return 'Робот взобрался на лестницу.'
					 end
				  else
					 return 'Окно открыто. Видимо, работники склада забыли его закрыть.'
				  end
			   end,
			},
		 },
	  },
	  obj {
		 nam = 'лестница',
		 dsc = function(s)
			if where(s) ^ 'окно' then
			   return 'К стене склада прислонена {лестница}.'
			else
			   return 'Рядом со складом лежит {лестница}.'
			end
		 end,
		 tak = 'Робот взял лестницу.',
		 inv = 'Приставная лестница из какого-то лёгкого сплава.',
		 use = function(s, w)
			if w ^ 'окно' then
			   place(s, w)
			   return 'Робот приставил лестницу к стене склада. Теперь по ней можно забраться в окно.'
			else
			   return 'Лестница тут бесполезна.'
			end
		 end,
	  },
	  obj {
		 nam = 'верстак',
		 dsc = 'Чуть в стороне стоит {конструкция}, напоминающая верстак.',
		 act = 'На неё можно положить что-нибудь.',
	  },
   },
   way = {
	  'город',
	  path{'внутрь', 'внутри склада'},
   },
}

room {
   nam = 'внутри склада',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот с грохотом упал внутрь склада. В темноте трудно что-либо различить и он включил инфракрасные фонари.'
	  else
		 return 'Робот находится на складе.'
	  end
   end,
   onenter = function(s, f)
	  disable 'склады'
   end,
   obj = {
	  obj {
		 dsc = 'Ровными рядами стоят {стеллажи}.',
		 act = function(s)
			if disabled 'коробка с руками' then
			   enable 'коробка с руками'
			   return 'На стеллажах лежат коробки. На одной из них робот прочёл надпись "руки".'
			else
			   return 'На стеллажах лежат коробки.'
			end
		 end,
	  },
	  obj {
		 nam = 'стеллаж',
		 moved = false,
		 dsc = function(s)
			if not s.moved then
			   return '{Один} из них стоит почти около окна.'
			else
			   return '{Один} из них стоит под самым окном.'
			end
		 end,
		 act = function(s)
			if max_inv == 2 then
			   if not s.moved then
				  s.moved = true
				  enable 'склады'
				  return 'Робот подвинул стеллаж к окну.'
			   else
				  return 'По нему можно взобраться к окну и выбраться наружу.'
			   end
			else
			   return 'Одной рукой робот не может сдвинуть стеллаж.'
			end
		 end,
	  },
	  obj {
		 nam = 'коробка с руками',
		 taken = false,
		 dsc = 'На другом  лежит {коробка} с руками.',
		 act = function(s)
			if not nice_hand and not s.taken then
			   s.taken = true
			   take 'рука робота'
			   return 'Робот взял одну руку.'
			else
			   return 'Роботу не нужны запасные руки.'
			end
		 end,
	  }:disable(),
   },
   way = {
	  path{'наружу', 'склады'},
   },
}:disable()

obj {
   nam = 'рука робота',
   disp = 'рука',
   inv = function(s)
	  disable(s)
	  nice_hand = true
	  if max_inv == 1 then
		 max_inv = 2
		 score = score + 5
		 return 'Робот установил себе новую руку. Работает отлично.'
	  else
		 return 'Робот заменил руку, установленную Димой на новую. Работает отлично.'
	  end
   end,
}

room {
   nam = 'у радиомастерской',
   seen = true,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот подошёл к радиомастерской. Удивительно, но в столь поздний час в её окнах горит свет.'
	  else
		 return 'Робот находится у радиомастерской.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'На первом этаже безликого многоэтажного дома, как и в других домах, расположились различные заведения.',
		 act = 'Магазины, кафетерии, мастерские.',
	  },
	  obj {
		 dsc = 'Над входной дверью одного из них горит {вывеска}.',
		 act = 'Вывеска гласит "Радиомастерская Смитта".',
	  },
   },
   way = {
	  'город',
	  'радиомастерская'
   },
}

room {
   nam = 'радиомастерская',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот вошёл в мастерскую. Здесь царит удивительная атмосфера новой жизни сломавшихся устройств.'
	  else
		 return 'Робот находится в мастерской.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Тут и там лежат какие-то {платы},',
		 act = 'Платы самых разнообразного назначения и происхождения.',
	  },
	  obj {
		 dsc = 'коробочки с {радиодеталями}',
		 act = 'Всё, что может только понадобится при ремонте электроники.',
	  },
	  obj {
		 dsc = 'и различные измерительные приборы.',
		 act = 'От мультиметра до осциллографа. Чего тут только нет.',
	  },
	  obj {
		 nam = 'радиолюбитель',
		 talked = false,
		 dsc = 'Над одной из плат склонился немолодой {мужчина} с щупом осциллографа в руках.',
		 act = function(s)
			if have 'свёрток' then
			   if not s.talked then
				  s.talked = true
				  _'свёрток'.given = true
				  remove 'свёрток'
				  if _'свёрток'.opened then
					 score = score + 5
				  else
					 score = score + 15
				  end
				  walk 'разговор с Гейбом'
			   else
				  return 'Гейб сильно увлечён настройкой какой-то платы.'
			   end
			else
			   return 'Мужчина слишком увлечён своим занятием.'
			end
		 end,
	  },
   },
   way = {
	  path{'наружу', 'у радиомастерской'},
   },
}

dlg {
   nam = 'разговор с Гейбом',
   noinv = true,
   onenter = 'Робот обратился к мужчине.',
   phr = {
	  { cond = function() return not _'свёрток'.opened; end, 'Здравствуйте, Дима просил передать вам этот пакет.', 'Мужчина вздрогнул, обернулся и сказал:^^-- О! Спасибо. Я очень ждал эту посылку. Мне как раз очень нужны эти микросхемы для ремонта... А не важно. Спасибо ещё раз.' },
	  { cond = function() return _'свёрток'.opened; end, 'Здравствуйте, Дима просил передать вам этот пакет.', 'Мужчина вздрогнул, обернулся и сказал:^^-- О! Спасибо. Я очень ждал эту посылку. Мне как раз очень нужны эти микросхемы для ремонта... А не важно.^^Гейб осмотрел свёрток и сказал:^^-- Странно... Обычно Дима закрывает посылки... Ладно, не важно. Спасибо ещё раз.' },
   },
}

room {
   nam = 'у входа в космопорт',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот подошёл к космопорту.'
	  else
		 return 'Робот находится у входа в космопорт.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'забор',
		 dsc = 'За сетчатым {забором}',
		 act = 'Забор окружает космопорт со всех сторон.',
	  },
	  obj {
		 nam = 'корабли',
		 dsc = 'высятся громады космических {кораблей},',
		 act = 'В основном это грузовые суда, доставляющие груз на орбиту.',
	  },
	  obj {
		 nam = 'роботы',
		 dsc = 'по посадочной площадке снуют портовые {роботы}.',
		 act = 'Простые рабочие роботы, таскающие грузы, занимающиеся предстартовой подготовкой.',
	  },
	  obj {
		 dsc = 'У входа на территорию космопорта в {будке}',
		 act = 'Небольшая ярко освещённая будочка охраны.',
		 obj = {
			obj {
			   dsc = 'сидит {охранник}.',
			   talked = false,
			   act = function(s)
				  if not s.talked then
					 s.talked = true
					 walk 'разговор с охранником'
				  else
					 return 'Охранник не будет слушать робота. Нужно придумать как попасть в космопорт.'
				  end
			   end,
			},
		 },
	  },
   },
   way = {
	  'город',
	  path{'за угол', 'за космопортом'},
   },
}

dlg {
   nam = 'разговор с охранником',
   noinv = true,
   onenter = 'Робот подошёл к охраннику.',
   onexit = function(s, t)
	  enable 'за космопортом'
   end,
   phr = {
	  { 'Извините, я могу пройти в порт?', '-- Ты работаешь на погрузке?',
		{ 'Нет.', '-- Тогда где сопровождающий?',
		  { 'Какой сопровождающий?', '-- Роботы, не являющиеся собственностью компании, могут проходить только в сопровождении своих хозяев.',
			{ 'Я упал с орбиты, а моя хозяйка осталась на корабле.', '-- Ну тогда она должна вернуться за тобой.',
			  { 'Она не может -- корабль остался без энергии.', '-- Я не знаю кто тебя такого хитрого программировал, но без сопровождающего не пропущу.' },
			},
		  },
		},
	  },
   },
}

room {
   nam = 'за космопортом',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот обогнул космопорт. Здесь его не видит охранник из своей будки.'
	  else
		 return 'Робот находится за космопортом.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'забор космопорта',
		 dsc = 'Космопорт отгорожен от города {забором}, за ним',
		 act = 'Высокий сетчатый забор. Робот не может через него перелезть.',
	  },
	  'корабли',
	  'роботы',
   },
   way = {
	  path{'ко входу в космопорт', 'у входа в космопорт'},
	  'космопорт',
   },
}:disable()

room {
   nam = 'космопорт',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот пролез в дыру в заборе и оказался на посадочной площадке космопорта.'
	  else
		 return 'Робот находится на посадочной площадке космопорта.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'На площадке стоят {корабли}.',
		 act = 'Преимущественно грузовые корабли, доставляющие грузы на орбиту.',
	  },
	  obj {
		 dsc = 'Тут и там снуют многочисленные {роботы}.',
		 act = 'Портовые рабочие роботы. Большие. Предназначены в основном для переноски грузов.',
	  },
	  obj {
		 dsc = 'Сейчас они заняты погрузкой на сравнительно небольшой {корабль}.',
		 act = function(s)
			if disabled 'грузовой отсек' then
			   enable 'грузовой отсек'
			   return 'Видимо, он скоро отправляется. Шлюз грузового отсека открыт настежь.'
			else
			   return 'Небольшой грузовой корабль, подготавливается к взлёту.'
			end
		 end,
	  }
   },
   way = {
	  path{'в город', 'за космопортом'},
	  path{'в корабль', 'грузовой отсек'},
   },
}:disable()

function check_times()
   ship_time = ship_time + 1
   if ship_time == 3 then
	  walk 'старт корабля'
   elseif ship_time == 6 then
	  enable 'инженер'
	  pn 'В грузовой отсек зашёл человек.'
   end
end

room {
   nam = 'грузовой отсек',
   seen = false,
   scored = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот незаметно пробрался в грузовой отек корабля.'
	  else
		 return 'Робот находится в грузовом отсеке корабля.'
	  end
   end,
   onenter = function(s, f)
	  if not s.scored then
		 s.scored = true
		 score = score + 5
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Большую часть пространства грузового отсека занимают какие-то {ящики}.',
		 act = function(s)
			check_times()
			p 'Робот не знает что в них, и не хочет их ломать.'
		 end,
	  },
	  obj {
		 dsc = 'Помимо ящиков, объёмные {мешки} лежат ровными рядами.',
		 act = function(s)
			check_times()
			p 'Интересно что в них.'
		 end,
	  },
	  obj {
		 nam = 'инженер',
		 talked = false,
		 n = 0,
		 dsc = 'Здесь стоит {человек}.',
		 act = function(s)
			if not s.talked then
			   s.talked = true
			   walk 'разговор с инженером'
			else
			   return 'Робот уже поговорил с инженером.'
			end
		 end,
		 life = function(s)
			if player_moved() then
			   place(s)
			end
			s.n = s.n + 1
			if s.n == 5 then
			   s.n = 0
			   return 'Нам нужно идти к капитану. Идём.'
			end
		 end,
	  }:disable(),
   },
   way = {
	  path{'наружу', 'космопорт'},
	  'коридор',
   },
}

cutscene {
   nam = 'старт корабля',
   noinv = true,
   decor = function(s)
	  pn 'Роботы-погрузчики закончили свои работы и покинули корабль.'
	  p '[cut]'
	  pn 'Люк грузового отсека медленно закрылся.'
	  p '[cut]'
	  pn 'Корабль затрясся мелкой дрожью, преодолевая притяжение планеты.'
	  p '[cut]'
	  pn 'Спустя некоторое время тряски и перегрузки всё успокоилось -- корабль вышел на орбиту.'
	  p '[cut]'
	  p '[code disable("космопорт")]'
	  p '[code walkout()]'
   end,
}

dlg {
   nam = 'разговор с инженером',
   noinv = true,
   onenter = 'Робот повернулся к человеку, но тот опередил его и спросил:^^-- Как ты сюда попал?',
   phr = {
	  { 'Пробрался сюда во время погрузки.', '-- Понятно. А зачем? Ты диверсионный дроид?',
		{ 'Нет. Я помощник принцессы Амалии и мне нужно вернуться к ней на орбиту.', '-- И ты выбрал наш корабль для этого путешествия?',
		  { 'Ну вы же летите на орбиту?', function() p '-- Так то оно так... Пойдём к капитану -- пусть он принимает решение.'; enable 'коридор'; lifeon 'инженер'; end },
		},
	  },
   },
}

room {
   nam = 'коридор',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот вышел в главный коридор вместе с инженером.'
	  else
		 return 'Робот находится в главном коридоре корабля.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Автоматические {перегородки} ведут в различные помещения.',
		 act = 'Каюты, камбуз, кают-кампания, мостик, грузовой отсек, шлюз -- всё связано этим коридором.',
	  },
	  obj {
		 dsc = 'Под ногами лязгает металлический {пол}.',
		 act = 'Пол представляет собой металлическую решётку, за которой видны разные кабели и трубы.',
	  },
   },
   way = {
	  'грузовой отсек',
	  'шлюз',
	  'мостик',
   },
}:disable()

function check_airlock_times()
   airlock_time = airlock_time + 1
   if airlock_time == 4 then
	  _'внешние створки'.opened = true
	  disable 'смотровое окно'
	  enable 'открытый космос'
	  pn 'Робот принял радиосигнал: "Подлетаем к кораблю принцессы. Готовься к выходу из корабля.'
   end
end

room {
   nam = 'шлюз',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот прошёл в шлюз.'
	  else
		 return 'Робот находится в шлюзе.'
	  end
   end,
   onenter = function(s)
	  if _'капитан'.talked then
		 disable 'коридор'
		 return 'Едва робот вошёл в шлюз, как за ним закрылись внутренние створки.'
	  else
		 p 'Сперва нужно встретиться с капитаном.'
		 return false
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Внутренние {створки} шлюза закрыты.',
		 act = function(s)
			check_airlock_times()
			p 'Их очень трудно открыть вручную, если не повреждена система управления. Да и не хочет робот обратно на корабль. Ему хочется скорее вернуться к принцессе и продолжить их путешествие.'
		 end,
	  },
	  obj {
		 nam = 'смотровое окно',
		 dsc = 'Смотровое {окно} во внешней створке зияет чернотой космоса.',
		 act = function(s)
			check_airlock_times()
			p 'В смотровое окно заглядывают мириады немигающих звёзд.'
		 end,
	  },
	  obj {
		 nam = 'внешние створки',
		 opened = false,
		 dsc = function(s)
			if s.opened then
			   return 'Внешние {створки} открыты.'
			else
			   return 'Внешние {створки} закрыты.'
			end
		 end,
		 act = function(s)
			check_airlock_times()
			if s.opened then
			   p 'Створки чуть-чуть выступают из пазов в стене.'
			else
			   p 'Только тонкие закрытые створки отделяют помещение шлюза от бездонны космоса.'
			end
		 end,
	  },
   },
   way = {
	  'коридор',
	  'открытый космос',
   },
}

room {
   nam = 'мостик',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот с инженером вошли на мостик. Отсюда открывается отличный вид через обзорные экраны.'
	  else
		 return 'Робот находится на мостике.'
	  end
   end,
   onenter = function(s, f)
	  lifeoff 'инженер'
   end,
   obj = {
	  obj {
		 dsc = 'В {кресле}, расположенном в центре помещения',
		 act = 'Большое и удобное кресло.',
	  },
	  obj {
		 nam = 'капитан',
		 dsc = 'сидит {человек}.',
		 talked = false,
		 act = function(s)
			if not s.talked then
			   s.talked = true
			   walk 'разговор с капитаном'
			else
			   return 'Капитан уже предложил свою помощь. Осталось выйти в шлюз и ждать.'
			end
		 end,
	  },
	  obj {
		 dsc = 'Большую часть стены занимают обзорные {экраны}.',
		 act = 'На экранах видна бездонная глубина космоса.',
	  },
   },
   way = {
	  'коридор',
   },
}

dlg {
   nam = 'разговор с капитаном',
   noinv = true,
   onenter = 'Капитан критически осмотрел робота и спросил:^^-- Откуда ты такой взялся?',
   phr = {
	  { 'С корабля принцессы Амалии.', '-- Это не принцесса лесного народа Ориона?',
		{ 'Да. Это она.', '-- Ну. Если ты замолвишь за нас словечко перед ней, то мы, конечно, поможем. Расположение лесного народа было бы очень полезным для нашей планеты.',
		  { 'Я расскажу ей, что вы мне помогли.', '-- По рукам. Иди в шлюз. Как только будем проходить рядом с её кораблём, мы тебе сообщим.' },
		},
	  },
   },
}

room {
   nam = 'открытый космос',
   seen = false,
   scored = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот оттолкнулся от стенки шлюза и вынырнул в открытый космос навстречу своей цели.'
	  else
		 return 'Робот находится в открытом космосе.'
	  end
   end,
   onenter = function(s, f)
	  if not s.scored then
		 s.scored = true
		 score = score + 10
	  end
   end,
   obj = {
	  'космос',
   },
   way = {
	  path{'корабль принцессы', 'возле шлюза корабля принцессы'},
   },
}:disable()

room {
   nam = 'возле шлюза корабля принцессы',
   seen = false,
   disp = 'возле шлюза',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот долетел до корабля принцессы. Довольно быстро он подлетел к нему и ухватился за скобы.'
	  else
		 return 'Робот находится возле шлюза корабля принцессы.'
	  end
   end,
   obj = {
	  'космос',
	  'скобы',
	  obj {
		 dsc = '{Люк} шлюза открыт.',
		 act = 'В таком состоянии робот его и оставил.',
	  },
   },
   way = {
	  'шлюз корабля принцессы',
   },
}

room {
   nam = 'шлюз корабля принцессы',
   seen = true,
   disp = 'шлюз',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Робот втолкнул себя в пространство шлюза.'
	  else
		 return 'Робот находится в шлюзе.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'внутренние створки',
		 opened = false,
		 dsc = function(s)
			if s.opened then
			   return 'Внутренние {створки} открыты.'
			else
			   return 'Внутренние {створки} закрыты.'
			end
		 end,
		 act = function(s)
			if s.opened then
			   return 'Проход в корабль открыт. Нужно поспешить к принцессе.'
			else
			   return 'За ними принцесса ждёт возвращения робота.'
			end
		 end,
	  },
	  obj {
		 nam = 'внешние створки шлюза',
		 opened = true,
		 dsc = function(s)
			if s.opened then
			   return 'Внешние {створки} открыты.'
			else
			   return 'Внешние {створки} закрыты.'
			end
		 end,
		 act = function(s)
			local v =  ' провинциальная планета, на которой робот познакомился с новыми друзьями.'
			if s.opened then
			   return 'Снаружи видна' .. v
			else
			   return 'В смотровое окошко створок видна' .. v
			end
		 end,
	  },
	  obj {
		 pulled = false,
		 scored = false,
		 dsc = 'На стене расположен {переключатель}, отвечающий за работу шлюза.',
		 act = function(s)
			if not s.scored then
			   s.scored = true
			   score = score + 10
			end
			s.pulled = not s.pulled
			if s.pulled then
			   _'внутренние створки'.opened = true
			   _'внешние створки шлюза'.opened = false
			   disable 'возле шлюза корабля принцессы'
			   enable 'конец'
			   return 'Робот закрыл внешние створки и открыл внутренние.'
			else
			   _'внутренние створки'.opened = false
			   _'внешние створки шлюза'.opened = true
			   enable 'возле шлюза корабля принцессы'
			   disable 'конец'
			   return 'Робот закрыл внутренние створки и открыл внешние.'
			end
		 end,
	  },			   
   },
   way = {
	  path{'внутрь', 'конец'},
	  path{'наружу', 'возле шлюза корабля принцессы'},
   },
}

room {
   nam = 'конец',
   noinv = true,
   decor = function(s)
	  return 'Робот вошёл внутрь корабля, где его ждала принцесса Амалия. Он обязательно расскажет ей о своих приключениях...^^' .. 'Ваш счёт: ' .. tostring(score) .. ' / 80' .. fmt.c(fmt.b '^^КОНЕЦ')
   end,
}:disable()
