--$Name: Новогодняя сказка$
--$Version: 1.1a$
--$Author: Андрей Лобанов$

instead_version "1.9.1"

require "quotes"
require "dash"
require "hideinv"
require "snapshots"
require "lib/cutscene"
require "lib/fonts"

stead.phrase_prefix = '-- '

game.act = 'Не работает.';
game.use = 'Это не поможет.';

s1 = font('theme/MarckScript_Regular.ttf', 18)

main = room {
   nam = "Новогодняя сказка",
   disp = function ()
      p (s1:txt ("Новогодняя сказка", "#333388"))
   end,
   pic = "img/00.png",
   dsc = "Маленькая игра для новогоднего настроения.^^" .. txtb ("Сценарий:") .. " Андрей Лобанов и Сергей Башкиров^" .. txtb ("Оформление и программирование:") .. " Андрей Лобанов^" .. txtb ("Иллюстрации: ") .. "Сергей Башкиров^" .. txtb ("Музыка:^") .. "F. R. Ellis - tubular bells 4 part 1^Quazz - acid bells",
   act = function (s, w)
      if w == "start" then
	 set_music("mus/tubular_bells_4_part_1.it")
	 walk (start)
      end
   end,
   obj = { vobj ("start", "{Начать игру}") },
}

start = cutscene {
   nam = "Новогодняя сказка",
   disp = function ()
      p (s1:txt ("Новогодняя сказка", "#333388"))
   end,
   pic = "img/00.png",
   dsc = function (s)
      pn "Эта история произошла давным давно. Когда я был ещё маленьким и жил с мамой и папой в Великом Устюге."
      pn "{cut}"
      pn "Оставался всего один день до Нового Года, было раннее утро и я безмятежно спал...{fading}"
      p "{cut}"
      pn "{cls}Я проснулся от сильного шума.{fading}"
      pn "{cut}"
      pn "Шум раздавался в квартире сверху. Наверное опять хулиган Колька что-то учудил.{fading}"
      pn "{cut}{walk myroom}"
   end,
}

myroom = room {
   var {
      first = true,
   },
   nam = "Моя комната",
   disp = function ()
      p (s1:txt ("Моя комната", "#333388"))
   end,
   dsc = function (s)
      if s.first then
	 s.first = false
	 v = "Я проснулся "
      else
	 v = "Я нахожусь "
      end
      v = v .. "в своей комнате. Хулиган Колька топочет и хохочет без устали."
      return v
   end,
   pic = "img/01.png",
   exit = function ()
      if not cabinet.used then
	 p "Хотя дома у нас и есть батареи, но без одежды всё равно холодно. Можно и простыть."
	 return false
      end
   end,
   obj = { "window", "cabinet" },
   way = { vroom ("Коридор", "corridor") },
}

window = obj {
   nam = "окно",
   dsc = "За {окном} происходит что-то несусветное.",
   act = "Я выглянул в окно. Все местные хулиганы и незнакомые мне ребята хулиганистого вида носятся по двору, швыряют друг в друга снежки и кричат.",
}

cabinet = obj {
   var {
      used = false,
   },
   nam = "шкаф",
   dsc = "В углу комнаты стоит {шкаф}.",
   act = function (s)
      if not s.used then
	 s.used = true
	 return "Я достал тёплые штаны, носки и свитер. Помедлил немного и надел это всё на себя."
      else
	 return "Я уже оделся."
      end
   end,
}

corridor = room {
   var {
      seen = false,
   },
   nam = "Коридор",
   disp = function ()
      p (s1:txt ("Коридор", "#333388"))
   end,
   dsc = function (s)
      if not s.seen then
	 s.seen = true
	 return "Я стою в коридоре. Мама и папа, похоже, уже ушли на работу. Шум, старательно производимый хулиганом Колькой слышно и тут."
      else
	 return "Я стою в коридоре. Шум, старательно производимый хулиганом Колькой слышно и тут."
      end
   end,
   pic = "img/02.png",
   way = { vroom ("Моя комната", "myroom"), vroom ("Кухня", "kitchen"), vroom ("На улицу", "yard") },
}

kitchen = room {
   nam = "Кухня",
   disp = function ()
      p (s1:txt ("Кухня", "#333388"))
   end,
   dsc = "Я стою на кухне.",
   pic = "img/03.png",
   obj = { "cabinets", "gas_stove", "matches" },
   way = { vroom ("Коридор", "corridor") },
}

cabinets = obj {
   nam = "шкафы",
   dsc = "Вдоль одной стены висят {шкафы}.",
   act = "Мама в них хранит всякую всячину. И вкусные конфеты и невкусную манку.",
}

gas_stove = obj {
   nam = "плита",
   dsc = "Между раковиной и столом стоит {плита}.",
   act = "Родители не разрешают её включать.",
}

matches = obj {
   nam = "спички",
   dsc = "Рядом с плитой лежит коробок {спичек}.",
   tak = function ()
      if not moroz_house.seen then
	 p "Спички детям не игрушка. Мне так папа сказал."
	 return false
      else
	 return "Я взял спички."
      end
   end,
   inv = "Нужно с ними быть аккуратней.",
   use = function (s, w)
      if w == spiritlamp then
	 spiritlamp.burn = true
	 return "Я аккуратно разжёг спиртовку."
      elseif w == torch then
	 w.burn = true
	 disable (s)
	 return "Я зажёг факел."
      else
	 return "Не надо баловаться спичками."
      end
   end,
}

yard = room {
   nam = "Двор",
   disp = function ()
      p (s1:txt ("Двор", "#333388"))
   end,
   pic = "img/04.png",
   dsc = "Я стою во дворе.",
   obj = { "showdrifts", "bullys" },
   way = { vroom ("Домой", "corridor"), vroom ("К Деду Морозу", "moroz_house"):disable() },
}

bullys = obj {
   var {
      talked = false,
   },
   nam = "хулиганы",
   dsc = "По двору бегают {хулиганы}.",
   act = function (s)
      if not s.talked then
	 s.talked = true
	 walk ("bullys_dlg")
      else
	 return "Вряд ли они мне что-нибудь ещё скажут."
      end
   end,
}

showdrifts = obj {
   nam = "сугробы",
   dsc = "По бокам от вытоптанных тропинок лежат высокие {сугробы}.",
   act = "В этом году зима выдалась снежная.",
}

bullys_dlg = dlg {
   nam = "Разговор с хулиганом",
   disp = function ()
      pn (s1:txt ("Разговор с хулиганом", "#333388"))
   end,
   pic = "img/04.png",
   entered = "Я подошёл к Петьке из соседнего подъезда.",
   phr = {
      { "Чего такое творится?", "-- Злой маг-чародей украл Деда Мороза и теперь не только мы, но и хорошие дети останутся без подарков!, -- выкрикнул он.", [[ pon (2) ]] },
      { 2, false, "То есть как так украл?", "-- А вот так. Прокрался ночью в город и украл спящего Деда Мороза, -- выкрикнул он, убегая.", [[ enable (path ("К Деду Морозу", yard)); back () ]] },
   },
}

moroz_house = room {
   var {
      seen = false,
   },
   nam = "Дома у Деда Мороза",
   disp = function ()
      pn (s1:txt ("Дома у Деда Мороза", "#333388"))
   end,
   pic = "img/05.png",
   dsc = "В доме Деда Мороза полный кавардак.",
   enter = function (s)
      if not s.seen then
	 s.seen = true
      end
   end,
   obj = { "table", "things" },
   way = { vroom ("Домой", "yard") },
}

things = obj {
   var {
      placed = false,
   },
   nam = "вещи",
   dsc = "Тут и там валяются самые неожиданные {вещи}.",
   act = function (s)
      if not s.placed then
	 s.placed = true
	 place (thread)
	 place (beaker)
	 place (tinsel)
	 place (pollen)
	 return "Среди хлама я обнаружил подозрительные вещи."
      else
	 return "Просто вещи Деда Мороза раскиданные по всему дому."
      end
   end,
}

table = obj {
   nam = "стол",
   dsc = "У стены стоит большой стол.",
   act = "Красивый деревянный стол.",
   obj = { "spiritlamp" },
}

spiritlamp = obj {
   var {
      burn = false,
   },
   nam = "спиртовка",
   dsc = "На столе стоит {спиртовка}.",
   act = function (s)
      if not s.burn then
	 return "Маленькая спиртовка. И зачем она Деду Морозу?"
      else
	 return "Маленькая спиртовка. Фитиль горит бледным пламенем."
      end
   end,
}

beaker = obj {
   var {
      full = false,
      ready = false,
   },
   nam = "мензурка",
   disp = function (s)
      if not s.ready then
	 if not s.full then
	    return "мензурка"
	 else
	    return txtem ("мензурка")
	 end
      else
	 return txtb ("мензурка")
      end
   end,
   dsc = function (s)
      if where (s) == moroz_house then
	 return "Среди хлама валяется чудом уцелевшая {мензурка}."
      else
	 return "На спиртовке стоит {мензурка}."
      end
   end,
   tak = function (s)
      if not s.ready and where(s) == spiritlamp then
	 p "Мензурка ещё слишком горячая."
	 return false
      else
	 return "Я взял мензурку."
      end
   end,
   inv = function (s)
      if not s.full then
	 return "Стеклянная мензурка."
      elseif s.full and not s.ready then
	 return "Мензурка со снегом"
      end
      if s.ready then
	 disable (s)
	 walk (journey)
      end
   end,
   use = function (s, w)
      if not s.ready then
	 if w == spiritlamp then
	    if w.burn then
	       if not s.full then
		  return "Мензурка пуста."
	       end
	       drop (s, w)
	       return "Я поставил мензурку на спиртовку. Снег превратился в воду."
	    else
	       return "Сперва нужно разжечь спиртовку."
	    end
	 elseif w == showdrifts then
	    if not s.full then
	       s.full = true
	       return "Я зачерпнул снег мензуркой."
	    else
	       if not s.ready then
		  return "В мензурке уже есть снег."
	       else
		  return "Я пролью или испорчу волшебное зелье. Лучше этого не делать."
	       end
	    end
	 else
	    return "Мне она может пригодиться."
	 end
      else
	 return "В мензурке находится волшебное зелье."
      end
   end,
}

thread = obj {
   nam = "нить",
   dsc = "У самого порога я вижу красную {нить}.",
   tak = "Я взял нить.",
   inv = "Похоже на нить из шубы Деда Мороза.",
   use = function (s, w)
      if w == wolf then
	 wolf.sniffing = true
	 ways():add (vroom ("Опушка леса", "edge"))
	 lifeon (wolf)
	 disable (s)
	 return "Волк понюхал нитку с шубы Деда Мороза и определил направление."
      else
	 return "Хм..."
      end
   end,
}

tinsel = obj {
   nam = "блестящая пыльца",
   dsc = "На столе лежит волшебная {пыльца} Дедушки.",
   tak = "Я взял блестящую пыльцу.",
   inv = "Волшебная пыльца Деда Мороза. Заставит кататься по полу от смеха кого угодно.",
   use = function (s, w)
      if w == liliputian then
	 w.laugh = true
	 ways():add (vroom ("В замок", "castle_corridor"))
	 disable (s)
	 return "Я швырнул пыльцу в сторону карликов. Ветер подхватил её и через несколько секунд они уже катались прямо по дороге от смеха."
      else
	 return "Мне кажется что пыльца мне ещё когда-нибудь пригодится."
      end
   end,
}

pollen = obj {
   nam = "волшебная пыльца",
   dsc = "Посреди бардака я вижу небольшую горку странной {пыльцы}.",
   tak = "Я взял пыльцу",
   inv = "Никогда такой не видел. На вкус горькая.",
   use = function (s, w)
      if w == beaker and beaker.full and exist (beaker, spiritlamp) then
	 w.ready = true
	 spiritlamp.burn = false
	 disable (s)
	 return "Я высыпал пыльцу в мензурку, перемешавшись с водой, она засияла тёплым светом. Получилось какое-то волшебное зелье! Спиртовка погасла."
      else
	 return "Эта пыльца может мне помочь в освобождении Деда Мороза."
      end
   end,
}

journey = room {
   hideinv = true,
   nam = "Путешествие",
   disp = function ()
      pn (s1:txt ("Путешествие", "#333388"))
   end,
   pic = "img/12.png",
   dsc = "Я выпил зелье. Тёплый свет из мензурки окружил меня и я почувствовал что лечу. Через несколько мгновений я очутился в незнакомом месте.",
   act = function (s, w)
      walk (forest)
   end,
   obj = { vobj ("Next", "{Далее}") },
}

forest = room {
   var {
      seen = false,
   },
   nam = "Лес",
   disp = function ()
      pn (s1:txt ("Лес", "#333388"))
   end,
   pic = "img/06.png",
   dsc = function (s)
      if not s.seen then
	 s.seen = true
	 return "Я очутился в заснеженном лесу."
      else
	 return "Я стою в заснеженном лесу."
      end
   end,
   obj = { "pathway", "trees" },
   way = { vroom ("По тропинке", "forest2") },
}

pathway = obj {
   nam = "тропинка",
   dsc = function ()
      if here() == forest then
	 return "С поляны, на которой я очутился, куда-то в даль уводит {тропинка}."
      else
	 return "{Тропинка} всё тянется и тянется дальше."
      end
   end,
   act = "Обычная протоптанная в снегу тропинка.",
}
   
trees = obj {
   nam = "ёлки",
   dsc = "Со всех сторон тропинку окружают {ёлки}.",
   act = "Все деревья покрыты инеем. Очень красиво.",
}

forest2 = room {
   nam = "Лес",
   disp = function ()
      pn (s1:txt ("Лес", "#333388"))
   end,
   pic = "img/06.png",
   dsc = "Я стою в заснеженном лесу.",
   enter = function ()
      if not wolf.talked then
	 walk (wolf_dlg)
      end
   end,
   obj = { "pathway", "trees", "wolf" },
   way = { vroom ("Назад", "forest") },
}

wolf = obj {
   var {
      talked = false,
      sniffing = false,
   },
   nam = "Серый Волк",
   dsc = function ()
      if here() == castle_storeroom and not torch.burn then
	 return ""
      else
	 return "Рядом со мной стоит {Серый Волк}."
      end
   end,
   act = function (s)
      if not s.sniffing then
	 return "-- Есть у тебя какая-нибудь вещь Деда Мороза? Я бы смог найти его по запаху, -- сказал Серый Волк."
      else
	 return "Большой и немного страшный Серый Волк."
      end
   end,
   life = function (s)
      if player_moved() then
	 move (s, here (), where (s))
      end
   end,
}

wolf_dlg = dlg {
   nam = "Разговор с Серым Волком",
   disp = function ()
      pn (s1:txt ("Разговор с Серым Волком"))
   end,
   pic = "img/06.png",
   enter = "Внезапно на встречу мне выскочил большой Серый Волк!^^-- Стой, мальчик! Я тебя съем!, -- крикнул он и оскалился.",
   exit = function ()
      wolf.talked = true
   end,
   phr = {
      { 1, true, "Не ешь меня, Серый Волк! Лучше помоги мне освободить Деда Мороза!", "-- Дед меня всю жизнь без подарков оставлял. Не буду я тебе помогать!", [[ pon (2) ]] },
      { 2, false, "Но его похитил злой маг-чародей и теперь все хорошие дети останутся без подарков!", "-- Маг-чародей мне много плохого сделал..., -- он задумался, -- Так и быть, мальчик, помогу я тебе.", [[ pon (3) ]] },
      { 3, false, "Спасибо тебе, Серый Волк. Дедушка наверняка не забудет твоей доброты.", "-- Не благодари. Пока не за что.", [[ back () ]] },
   },
}

edge = room {
   var {
      seen = false,
   },
   nam = "Опушка леса",
   disp = function ()
      pn (s1:txt ("Опушка леса", "#333388"))
   end,
   pic = "img/07.png",
   dsc = function (s)
      if not s.seen then
	 s.seen = true
	 return "Мы вышли на опушку леса."
      else
	 return "Я стою на опушке леса."
      end
   end,
   obj = { "snowdrift2" },
   way = { vroom ("Лес", "forest2"), vroom ("Ворота замка", "near_castle") },
}

snowdrift2 = obj {
   var {
      touched = false,
   },
   nam = "снег",
   dsc = "Лес поредел, но между деревьев лежат большущие {сугробы}.",
   act = function (s)
      if not s.touched then
	 s.touched = true
	 place (snow, s)
      end
      return "В одном из сугробов снег взрыхлён как будто там кто-то боролся."
   end,
}

snow = obj {
   var {
      touched = false,
   },
   nam = "снег",
   dsc = "В одном из сугробов {снег} взрыхлён.",
   act = function (s)
      if not s.touched then
	 s.touched = true
	 place (staff, s)
	 return "Кажется в снегу что-то есть."
      else
	 return "Свалянный снег."
      end
   end,
}

staff = obj {
   nam = "посох",
   dsc = "В снегу валяется {посох} Деда Мороза.",
   tak = "Я взял посох.",
   inv = "Это волшебный посох Деда Мороза. Я не умею им пользоваться.",
   use = function (s, w)
      if w == father_frost then
	 if mage.paralized and not seen (liliput, castle_hall) then
	    delete_snapshot()
	    lifeoff (wolf)
	    walk (happy_end1)
	 end
	 if not mage.paralized then
	    lifeoff (wolf)
	    walk (frozen2)
	 end
	 if exist (lilput, castle_hall) then
	    lifeoff (wolf)
	    walk (caugh2)
	 end
      else
	 return "Не стоит использовать посох. Я ведь не умею им пользоваться."
      end
   end,
}

near_castle = room {
   nam = "Ворота замка",
   disp = function ()
      pn (s1:txt ("Ворота замка", "#333388"))
   end,
   pic = "img/08.png",
   dsc = "Посреди бескрайнего снега стоит замок злого чародея. Я стою у ворот.",
   entered = function ()
      if not liliputian.laugh then
	 make_snapshot()
      end
   end,
   exit = function (s)
      if not liliputian.laugh then
	 lifeoff (wolf)
	 walk (caugh)
	 return
      end
      if liliputian.laugh then
	 delete_snapshot()
      end
   end,
   obj = { "liliputian" },
   way = { vroom ("Опушка леса", "edge") },
}

liliputian = obj {
   var {
      laugh = false,
   },
   nam = "карлики",
   dsc = function (s)
      if not s.laugh then
	 return "Вход охраняют {карлики}. Кажется, они нас заметили."
      else
	 return "{Карлики}, охранявшие вход в замок катаются по снегу от смеха."
      end
   end,
   act = "Маленькие человечеки в доспехах.",
}

castle_corridor = room {
   nam = "Коридор замка",
   disp = function ()
      pn (s1:txt ("Коридор замка", "#333388"))
   end,
   pic = "img/09.png",
   dsc = "Я стою в коридоре.",
   obj = { "torch" },
   way = { vroom ("Ворота замка", "near_castle"), vroom ("Кладовая", "castle_storeroom"), vroom ("Холл", "castle_hall") },
}

torch = obj {
   var {
      burn = false,
   },
   nam = "факел",
   dsc = "На стене висит {факел}.",
   tak = "Я взял факел.",
   inv = "Никогда раньше не видел факелов. Не думал что они такие большие.",
   use = "Я не хочу устраивать пожар.",
}

castle_storeroom = room {
   nam = "Кладовая",
   disp = function ()
      pn (s1:txt ("Кладовая", "#333388"))
   end,
   pic = function ()
      if have (torch) and torch.burn then
	 return "img/10_1.png"
      else
	 return "img/10_0.png"
      end
   end,
   dsc = function ()
      if have (torch) and torch.burn then
	 return "Я стою в кладовой."
      else
	 return "Я стою в тёмной комнате."
      end
   end,
   obj = { "trash", "mirror" },
   way = { vroom ("Коридор", "castle_corridor") },
}

trash = obj {
   nam = "хлам",
   dsc = function ()
      if have (torch) and torch.burn then
	 return "Здесь лежит множество разных {вещей}."
      else
	 return ""
      end
   end,
   act = "Чего только тут нет.",
}

mirror = obj {
   var {
      seen = false,
   },
   nam = "зеркало",
   dsc = function (s)
      if exist (s, mage) then
	 return "Напротив него стоит {зеркало}."
      else
	 if have (torch) and torch.burn then
	    return "Среди них выделяется {зеркало} почти с меня высотой."
	 else
	    return ""
	 end
      end
   end,
   act = function (s)
      if not s.seen then
	 s.seen = true
	 return "Я посмотрел в зеркало и замер. Как будто что-то схватило меня и не отпускало. Так бы я и стоял, если б Серый Волк не оттолкнул меня в сторону. Страшная вещь это зеркало."
      else
	 if not exist (s, mage) then
	    take (s)
	    return "Я взял зеркало."
	 else
	    return "Зеркало парализовало злодея!"
	 end
      end
   end,
   inv = "Страшное зеркало. Парализует того, кто в него смотрит.",
   use = function (s, w)
      if w == mage then
	 w.paralized = true
	 drop (s, w)
	 lifeon (liliput)
	 return "Я повернул зеркало к чародею. Он обернулся на шум, увидел зеркало и замер."
      elseif w == liliput then
	 walk (frozen)
      elseif w == liliputian then
	 return "Карлики уже обезврежены."
      else
	 return "Зеркало опасно, но оно может стать грозным оружием против злого мага-чародея. Не стоит его портить."
      end
   end,
}

castle_hall = room {
   nam = "Холл",
   disp = function ()
      pn (s1:txt ("Холл", "#333388"))
   end,
   pic = "img/11.png",
   dsc = "Я стою внутри замка.",
   enter = function ()
      make_snapshot()
   end,
   left = function (s, w)
      if w == frozen then
	 lifeoff (wolf)
      end
   end,
   obj = { "father_frost", "liliput", "mage" },
   way = { vroom ("Коридор", "castle_corridor") },
}

father_frost = obj {
   nam = "Дед Мороз",
   dsc = function ()
      if not mage.paralized then
	 return "Под бдительным присмотром злого мага-колдуна на стуле сидит {Дед Мороз}."
      else
	 return "На стуле сидит {Дед Мороз}."
      end
   end,
   act = function ()
      if disabled (liliput) then
	 return "Дедушка обрадованно смотрит на нас."
      else
	 return "Дедушка сидит и грустит."
      end
   end,
}

mage = obj {
   var {
      paralized = false,
   },
   nam = "злой маг-колдун",
   dsc = function (s)
      if not s.paralized then
	 return "{Злодей} стоит неподалёку и не замечает нас."
      else
	 return "{Злодей} стоит неподалёку. Он парализован."
      end
   end,
   act = function (s)
      if not disabled (liliput) and disabled (bag) then
	 delete_snapshot()
	 make_snapshot()
	 enable (bag)
	 if liliput.ltime > 0 then
	    liliput.ltime = liliput.ltime - 1
	 end
	 return "На поясе злого мага-чародея что-то висит."
      else
	 if s.paralized then
	    return "Злой колдун парализован и не может пошевелиться."
	 else
	    return "Высокая фигура злого мага-колдуна внушает страх."
	 end
      end
   end,
   obj = { "bag" },
}

liliput = obj {
   var {
      ltime = 0,
   },
   nam = "карлик",
   dsc = "Деда Мороза охраняет {карлик}.",
   life = function (s)
      s.ltime = s.ltime + 1
      if s.ltime > 1 then
	 walk (caugh2)
      end
   end,
   act = "Маленький приспешник злого мага-чародея.",
}

bag = obj {
   nam = "мешочек",
   dsc = "На его поясе висит маленький {мешочек}.",
   tak = function ()
      if not mage.paralized then
	 p "Колдун точно меня заметит. Тогда мне несдобровать и Новый Год не наступит."
	 return false
      else
	 liliput.ltime = liliput.ltime - 1
	 return "Я взял мешочек."
      end
   end,
   inv = function ()
      liliput.ltime = liliput.ltime - 1
      return "В мешочке лежит пыльца. В точности такая же, из которой я сварил волшебное зелье."
   end,
   use = function (s, w)
      if w == liliput then
	 lifeoff (liliput)
	 disable (liliput)
	 disable (s)
	 return "Я бросил мешочек в лилипута; пыльца высыпалась на него и лилипут пропал."
      else
	 walk (caugh2)
      end
   end,
}:disable()

caugh = room {
   hideinv = true,
   nam = "Пойманы!",
   disp = function ()
      pn (s1:txt ("Пойманы!", "#333388"))
   end,
   pic = "img/13.png",
   dsc = "Карлики отважно набросились на нас и быстро нас связали.",
   act = function ()
      restore_snapshot ()
   end,
   left = function ()
      lifeon (wolf)
   end,
   obj = { vobj ("back", "{Неужели в этом году дети останутся без подарков?}") },
}

caugh2 = room {
   hideinv = true,
   nam = "Пойманы!",
   disp = function ()
      pn (s1:txt ("Пойманы!", "#333388"))
   end,
   pic = "img/13.png",
   dsc = "Карлик громко закричал, прибежала подмога и нас быстро связали.",
   act = function ()
      restore_snapshot ()
   end,
   left = function ()
      lifeon (wolf)
   end,
   obj = { vobj ("back", "{Неужели в этом году дети останутся без подарков?}") },
}

frozen = room {
   hideinv = true,
   nam = "Заморожены!",
   disp = function ()
      pn (s1:txt ("Заморожены!", "#333388"))
   end,
   pic = "img/14.png",
   dsc = "Я направил зеркало на карлика, он замер и упал. Злой колдун обернулся на шум, увидел нас и произнёс заклинание...",
   act = function ()
      restore_snapshot ()
   end,
   left = function ()
      lifeon (wolf)
   end,
   obj = { vobj ("back", "{Неужели в этом году дети останутся без подарков?}") },
}

frozen2 = room {
   hideinv = true,
   nam = "Заморожены!",
   disp = function ()
      pn (s1:txt ("Заморожены!", "#333388"))
   end,
   pic = "img/14.png",
   dsc = "Я попытался передать посох Деду Морозу, но злой маг-чародей заметил меня и произнёс заклинание...",
   act = function ()
      restore_snapshot ()
   end,
   left = function ()
      lifeon (wolf)
   end,
   obj = { vobj ("back", "{Неужели в этом году дети останутся без подарков?}") },
}

happy_end1 = room {
   hideinv = true,
   nam = "Конец",
   disp = function ()
      pn (s1:txt ("Конец", "#333388"))
   end,
   pic = "img/11.png",
   dsc = "Я отдал посох Деду Морозу. Он обрадовался и ударил посохом об пол...",
   enter = function ()
      set_music("mus/acid_bells.it")
   end,
   act = function ()
      walk (happy_end2)
   end,
   obj = { vobj ("Далее", "{Далее}") },
}

happy_end2 = room {
   hideinv = true,
   nam = "Конец",
   disp = function ()
      pn (s1:txt ("Конец", "#333388"))
   end,
   pic = "img/06.png",
   dsc = "Мы очутились в лесу. Дедушка поблагодарил Серого Волка и подарил ему подарок.^^-- С Новым Годом тебя, Серый Волк. Не мог себе представить что ты примешь участие в спасении праздника, -- сказал он и снова ударил посохом оземь...",
   act = function ()
      walk (happy_end3)
   end,
   obj = { vobj ("Далее", "{Далее}") },
}

happy_end3 = room {
   hideinv = true,
   nam = "Конец",
   disp = function ()
      pn (s1:txt ("Конец", "#333388"))
   end,
   pic = "img/15.png",
   dsc = "Я и Дед Мороз очутились в моей комнате. Дедушка подарил мне подарок, поблагодарил за спасение, пожелал счастливого Нового Года, после чего ударил посохом об пол и исчез.^^Родители не поверили мне, когда я рассказал им свою историю и просто отправили меня в школу на последние уроки в этом году.",
}
