--$Name: Славный город Лудд$
--$Version: 0.91$
--$Author: Андрей Лобанов$

--Brenna означает меч.

instead_version "1.9.1"

require "dash"
require "quotes"
require "para"
require "snapshots"
require "hideinv"
require "lib/cutscene"

format.para_space = "        "

main = room {
   nam = "Славный город Лудд",
   pic = "gfx/ludd.png",
   dsc = txtr( "When the power of love overcomes^the love of power the world will know peace.^ " .. txtem( "Jimi Hendrix^^" ) ) .. "Джошуа сидел на бетонной плите перекрытия рядом с грудой кирпичей и размышлял о случившемся...",
   act = function( s, w )
      if w == "Start" then
	 walk "prologue"
      else
	 walk "about"
      end
   end,
   obj = { vobj( "Start", "{Начать игру}^" ), vobj( "About", "{Об игре}" ) },
}

about = room {
   nam = "Славный город Лудд",
   dsc = "Игра написана специально для конкурса IF-3D.^Данная версия отличается от конкурсной.^^" .. txtb( "Сценарий и программирование: " ) .. "Андрей Лобанов^" .. txtb( "Вычитка: " ) .. "Анна Лобанова^" .. txtb( "Музыка: " ) .. "[interrupt:Jumper] -- Rebuildings^" .. txtb( "Платформа INSTEAD: " ) .. "Пётр Косых",
   act = function()
      back()
   end,
   obj = { vobj( "Back", "{Назад}" ) },
}

prologue = room {
   nam = "Славный город Лудд",
   dsc = "Всё началось не так давно. Всего пару лет назад японский концерн \"Масуда Индастриз\" подарил миру технологию дешёвого и простого расширения и изменения возможностей тела. Так незатейливо и просто началась новая эра человечества. Сперва это были безобидные импланты для подключения банков памяти или вычислительные модули, искусственные глаза способные видеть в инфракрасном спектре и слуховые импланты, расширяющие слышимый диапазон. Но человек по своей природе ненасытен, и вскоре изменения стали носить более фундаментальный характер.^Джошуа поднялся с плиты и вздохнул. Надо продолжать поиски Бренны.",
   enter = function( s )
      set_music "mus/_interrupt_Jumper__-_rebuildings.ogg"
   end,
   act = function()
      take "ring"
      walk "factory"
   end,
   obj = { vobj( "Next", "{Далее}" ) },
}

ring = obj {
   var {
      seen = false,
   },
   nam = "кольцо",
   inv = function( s )
      if not s.seen then
	 s.seen = true
	 walk "Brenna1"
      else
	 return "Медное кольцо, которое едва надевается на мизинец Джошуа. Бренна подарила его Джошуа давным давно, когда люди ещё оставались людьми."
      end
   end,
}

Brenna1 = room {
   hideinv = true,
   nam = true,
   dsc = "На Джошуа обрушились воспоминания. Давным давно, когда люди ещё оставались людьми, а мир не получил ужасный подарок от \"Масуда Индастриз\", Джошуа и Бренна познакомились. Очень быстро они совершили переход от приятелей к друзьям, а уже от друзей к самым важным друг для друга человеческим существам. Когда это новое их качество ещё казалось зыбким, а радость от перехода в это состояние затмевала весь окружающий мир, Бренна подарила это кольцо Джошуа и попросила хранить его всегда. Чтобы воспоминания о ней никогда его не покидали.^С тех пор они не расставались, а кольцо служило лишь как напоминание о тех наивных страхах, которые они испытывали в самом начале своего общего пути.^Сейчас кольцо действительно служит напоминанием о самом важном для Джошуа человеке, и подстёгивает его без устали продолжать поиски.",
   act = function()
      back()
   end,
   obj = { vobj( "Back", "{Далее}" ) },
}

factory = room {
   nam = "Заброшенная фабрика",
   dsc = "Не взирая на подъём производства, тут и там по миру раскиданы вот такие полуразрушенные заводы и фабрики, которые стали не нужны в силу отпавшей необходимости в продуктах их производства.",
   obj = {
      obj {
	 nam = "плита",
	 dsc = "Джошуа стоит возле бетонной {плиты}.",
	 act = "Здание настолько обветшало, что перекрытия между этажами начали обваливаться, но даже такое укрытие было лучше, чем ничего. Позавчера начался дождь и только ближе к сегодняшнему утру наконец прекратился. Джошуа не хотел провести вторую ночь, укрывшись от дождя всего лишь непромокаемым плащом, без возможности развести огонь.",
      },
      obj {
	 nam = "кирпичи",
	 dsc = "Стена рядом с рухнувшим перекрытием обвалилась и лежит теперь грудой битого {кирпича}.",
	 act = "Эти кирпичи хорошо защитили Джошуа от ночного холодного ветра, задувающего со стороны рухнувшей стены и гуляющего по просторному помещению цеха.",
      },
   },
   way = { vroom( "на запад", "near_factory1" ) },
}

near_factory1 = room {
   var {
      seen = false,
   },
   nam = "Около фабрики",
   dsc = function( s )
      v = ""
      if from() == factory then
	 v = v .. "Джошуа вышел через проём в разрушенной стене."
      else
	 v = v .. "Джошуа подошёл к фабрике."
      end
      v = v .. "^Старая фабрика являет собой удручающее зрелище: рухнувшая стена, валяющиеся тут и там осколки стекла, оставшиеся от пустых нынче окон. Металлические конструкции неизвестного назначения уродуют и без того безжизненный пейзаж своими ржавыми останками."
      if not s.seen then
	 s.seen = true
	 v = v .. "^Джошуа до сих пор ни на минуту не сомневался, что движется в правильном направлении и вот-вот нагонит похитителей, но сейчас его переполнили сомнения. За четыре дня преследования он прошёл большое расстояние. Следы, оставленные охотниками за органами, были явственно видны и вели на север. Но дождь основательно смыл все признаки существования похитителей поэтому и половину предыдущего дня Джошуа шёл практически наугад."
      end
      return v
   end,
   way = { vroom( "на восток", "factory" ), vroom( "на север", "near_factory2" ) },
}

near_factory2 = room {
   nam = "Около фабрики",
   dsc = "Удручающая картина, которую представляют собой окрестности фабрики не отличаются разнообразием. Тусклый утренний свет и обширные тени только усугубляют общую картину.",
   obj = {
      obj {
	 nam = "стекло",
	 dsc = "Всё то же битое {стекло},",
	 act = "Такое ощущение, что кто-то старательно разбивал каждое окно специально.",
      },
      obj {
	 nam = "ящики",
	 dsc = "деревянные {ящики}",
	 act = "Как это ни странно, но даже в век повсеместной модификации человека дерево ещё не вытеснено разнообразными полимерными материалами.",
      },
      obj {
	 var {
	    seen = false,
	 },
	 nam = "металлолом",
	 dsc = "и разнообразнейший {металлолом}.",
	 act = function( s )
	    if not s.seen then
	       s.seen = true
	       place "feather"
	       return "Под этой грудой ржавого железа нечто знакомое привлекло внимание Джошуа."
	    else
	       return "Трудно сказать чем это нагромождение разнородных ржавых металлических сооружений было раньше."
	    end
	 end,
      },	 
   },
   way = { vroom( "на юг", "near_factory1" ), vroom( "на север", "highway" ):disable() },
}

feather = obj {
   var {
      seen = false,
   },
   nam = "перо",
   dsc = "В тени этой груды груды металлического хлама лежит {что-то}, что не очень вписывается в общую обстановку.",
   tak = "Это оказалось до боли в груди знакомое Джошуа перо. Значит они проходили здесь.",
   inv = function( s )
      if not s.seen then
	 s.seen = true
	 enable( path( "на север", near_factory2 ) )
	 walk "Brenna2"
      else
	 return "Это перо, потрёпанное временем и украшенное маленькими деревянными бусинами, принадлежит Бренне."
      end
   end,
}

Brenna2 = room {
   hideinv = true,
   nam = true,
   dsc = "Это перо Бренна нашла в одном из многочисленных лесов, которые они с Джошуа пересекали в течение их путешествия. Оно ей настолько понравилось, что она сохранила его, а впоследствии украсила маленькими деревянными бусинами, найденными на старой заброшенной ферме, и вплела в волосы.^Тогда Джошуа ещё только вынашивал план, который подарил бы их скитаниям цель и сделал бы Бренну хоть немного счастливее. Во всяком случае, он до сих пор надеется, что судьба оказаться в числе луддитов, гонимых обществом, могла бы быть скрашена такой незамысловатой, призрачной и в целом глупой идеей.^Джошуа вздохнул. \"Надеюсь, с ней всё в порядке\", -- подумал он.",
   act = function()
      back()
   end,
   obj = { vobj( "Back", "{Далее}" ) },
}

highway = room {
   nam = "Заброшенное шоссе",
   dsc = "Эту дорогу забросили задолго до начала деформации человечества.",
   obj = {
      obj {
	 nam = "трава",
	 dsc = "Через широкие трещины в покрытии пробивается {растительность},",
	 act = "Высокая и кустистая она достаёт Джошуа до колена.",
      },
      obj {
	 var {
	    seen = false,
	 },
	 nam = "дорога",
	 dsc = "а разметка, соскобленная с {поверхности} степными ветрами, едва угадывается.",
	 act = function( s )
	    if not s.seen then
	       enable( path( "на запад" ) )
	       return "Рядом с дорожным полотном едва виднеется след, указывающий на то, что похитители свернули на запад."
	    else
	       return "Теперь когда след найден, он уже не кажется едва заметным."
	    end
	 end,
      },
      obj {
	 nam = "небо",
	 dsc = "Над степью висит низкое пасмурное {небо}.",
	 act = "Тучи висят так низко, что Джошуа начинает казаться, что весь мир зажат в узкой щели между землёй и небом. От этих мыслей дыхание сдавливает, а голова начинает слегка кружиться.",
      },
   },
   way = { vroom( "на юг", "near_factory2" ), vroom( "на запад", "forest" ):disable() },
}

forest = room {
   var {
      seen = false,
   },
   nam = "Лес",
   dsc = function( s )
      v = "В какой-то степени хорошо, что охотники за органами пошли через лес -- здесь легко найти их следы. Но и самому Джошуа двигаться в лесу будет тяжелее."
      if not s.seen then
	 s.seen = true
	 v = v .. " К тому же, сильный голод начал сковывать желудок, а тело, после ночёвки под дождём, начало лихорадить."
      end
      return v
   end,
   obj = {
      obj {
	 var {
	    seen = false,
	 },
	 nam = "деревья",
	 dsc = "Старые {деревья} стояли здесь ещё когда люди не были изуродованы технологиями.",
	 act = function( s )
	    if not s.seen then
	       s.seen = true
	       place "brooch"
	       return "Кора на одном из деревьев была недавно оторвана. Под этим деревом во мху лежит что-то блестящее."
	    else
	       return "Кора на одном из деревьев была недавно оторвана."
	    end
	 end,
      },
   },
   way = { vroom( "на восток", "highway" ), vroom( "на запад", "forest2" ) },
}

brooch = obj {
   var {
      seen = false,
   },
   nam = "брошь",
   dsc = "Во мху под деревом лежит {что-то} блестящее.",
   tak = "Это брошь Бренны! Значит они прошли этим путём и Джошуа всё ещё на правильном пути.",
   inv = function( s )
      if not s.seen then
	 s.seen = true
	 walk "Brenna3"
      else
	 return "Медная брошь Бренны."
      end
   end,
}

Brenna3 = room {
   hideinv = true,
   nam = true,
   dsc = "Эта медная брошь досталась Бренне по наследству от её матери. Старая, потускневшая и потёртая брошь всегда нравилась Джошуа. Она смотрелась неуместным анахронизмом в современном мире, где всё было отдано в жертву функциональности, и напоминала о тех временах когда простота не была обязательной спутницей красоты. Бренна ни за что бы не рассталась с этой брошью просто так. Наверняка, она оставляла едва заметные следы специально для Джошуа, в надежде что он её найдёт.^Пока Джошуа разглядывал брошь, на него обрушился несокрушимый поток воспоминаний. Как же давно они жили нормально. Пока они удирали от сошедшего с ума человечества, мир казался мрачным и ужасным местом. Смутная, сперва, идея, обрела форму и до сих пор причиняет немало боли Джошуа. Однажды, забравшись в поисках припасов в один из многочисленных заброшенных домов, он устроил пожар. Выбежав из горящего здания, он что-то наплёл Бренне про ловушку, якобы оставленную внутри неизвестно кем, а потом рассказал, что успел полистать чей-то дневник, в котором упоминался чудесный город, в котором обитают луддиты. Пророненное зерно надежды быстро проросло и вскоре у их скитаний появилась цель -- славный город Лудд, пристанище людей, не пожелавших становиться чем-то иным.^Джошуа с большим усилием вырвался из цепких лап воспоминаний. Нужно продолжать преследование.",
   act = function()
      back()
   end,
   obj = { vobj( "Back", "{Далее}" ) },
}

forest2 = room {
   nam = "Лес",
   dsc = "Джошуа вышел на небольшую прогалину.",
   obj = {
      obj {
	 nam = "кострище",
	 dsc = "В центре поляны находится {кострище}, аккуратно обложенное камнями. Странно видеть такое явление в современных реалиях, когда человек уже мало похож на человека.",
	 act = "Джошуа протянул руку к углям -- ещё тёплые. Он и не надеялся, что ему удастся настолько приблизиться к своей цели.",
      },
      obj {
	 nam = "следы",
	 dsc = "Тут и там видны {следы} пребывания похитителей.",
	 act = "Джошуа внимательно осмотрел оставленные следы. Их было очень много. Как будто охотники провели здесь больше одной ночи.",
      },
   },
   way = { vroom( "на восток", "forest" ), vroom( "на запад", "base" ) },
}

base = room {
   nam = "База охотников за органами",
   dsc = function()
      if from() == forest2 then
	 return "После долгого пути Джошуа вышел к базе охотников за органами."
      else
	 return "Джошуа отошёл от здания."
      end
   end,
   obj = {
      obj {
	 var {
	    seen = false,
	 },
	 nam = "здания",
	 dsc = "База представляет собой несколько бетонных {зданий}. Складывается впечатление, что территория базы не охраняется.",
	 act = function( s )
	    v = "Ничем не примечательные бетонные коробки."
	    if not s.seen then
	       s.seen = true
	       enable( path( "к зданию" ) )
	       v = v .. " Разве что у одной открыто окно."
	    end
	    return v
	 end,
      },
   },
   enter = function( s )
      delete_snapshot()
      make_snapshot()
   end,
   way = { vroom( "на восток", "forest2" ), vroom( "к зданию", "near_building" ):disable() },
}

near_building = room {
   nam = "У здания",
   dsc = "Джошуа подошёл к зданию с открытым окном.",
   obj = {
      obj {
	 var {
	    seen = 0,
	 },
	 nam = "окно",
	 dsc = "Примерно в двух метрах над землёй находится открытое {окно}.",
	 act = function( s )
	    if s.seen == 0 then
	       s.seen = 1
	       return "Джошуа заглянул в окно. Ему повезло -- внутри стоит клетка, в которой сидит Бренна. Рядом с клеткой стоит охранник."
	    elseif s.seen == 1 then
	       s.seen = 2
	       inside.free = true
	       return "Джошуа снова заглянул в окно. На этот раз охранника в помещении не оказалось. Похоже он куда-то ушёл, Бренна лежит на полу клетки. Похоже она без сознания."
	    else
	       return "Джошуа заглянул в окно. Бренна лежит на полу клетки."
	    end
	 end,
      },
      "rod",
   },
   way = { vroom( "отойти", "base" ), vroom( "в окно", "inside" ) },
}

rod = obj {
   nam = "прут",
   dsc = "Рядом со стеной лежит ржавый железный {прут}.",
   tak = "Джошуа взял тяжёлый прут.",
   inv = "Тонкий, но тяжёлый железный прут.",
   use = function( s, w )
      if w == lock then
	 Brenna.prisoned = false
	 return "Джошуа вставил прут в замок, зацепил штифт и открыл замок."
      end
   end,
}

inside = room {
   var {
      free = false,
      seen = false,
      n = 0,
   },
   nam = "Внутри",
   dsc = function( s )
      if not s.seen then
	 s.seen = true
	 return "Джошуа перелез через подоконник и оказался в просторной и пустой комнате."
      else
	 return "Джошуа стоит в просторной пустой комнате."
      end
   end,
   enter = function( s )
      if not s.free then
	 walk "end1"
      end
      lifeon( s )
   end,
   life = function( s )
      s.n = s.n + 1
      if s.n == 7 then
	 end1.variant = 1
	 walk "end1"
      end
   end,
   exit = function( s )
      lifeoff( s )
   end,
   obj = {
      obj {
	 nam = "клетка",
	 dsc = "Большую часть помещения отгорожено {решёткой}.",
	 act = "Прутья настолько толстые, что даже перепилить, была бы у Джошуа пила, их было бы непросто.",
	 obj = { "lock" },
      },
      "Brenna",
      obj {
	 nam = "окно",
	 dsc = "{Окно} через которое влез Джошуа, расположено очень низко, почти у самого пола.",
	 act = function()
	    if Brenna.prisoned then
	       return "Джошуа не мог бы представить себе такую ситуацию, когда он бросил бы Бренну в беде и сбежал."
	    else
	       walk "outside"
	    end
	 end, 
      },
   },
}

lock = obj {
   nam = "замок",
   dsc = "На решётке висит тяжёлый {замок}.",
   act = function()
      if Brenna.prisoned then
	 if Brenna.lies then
	    return "Тяжёлый замок. Джошуа не уверен что сможет его открыть без ключа."
	 else
	    return "Тяжёлый замок выглядит устрашающе, но Бренна сказала, что открыть его будет не сложно."
	 end
      else
	 return "Замок оказался не таким уж и страшным препядствием."
      end
   end,
}

end1 = room {
   hideinv = true,
   var {
      variant = 0,
   },
   nam = "Внутри",
   dsc = function( s )
      if s.variant == 0 then
	 v = "Джошуа залез через окно в просторную комнату. Охранник увидел его и "
      else
	 v = "Дверь открылась и в комнату вошёл охранник. Не оставив никаких шансов на спасение, он "
      end
      v = v .. "выстрелил из протеза-пушки, который заменял ему левую руку. Грудь Джошуа пронзила сильная боль, которая, впрочем, быстро угасла. Вслед за ней угасло и сознание."
      return v
   end,
   act = function()
      walk "bad_end"
   end,
   obj = { vobj( "Next", "{Далее}" ) },
}

Brenna = obj {
   var {
      prisoned = true,
      lies = true,
   },
   nam = "Бренна",
   dsc = function( s )
      if s.prisoned then
	 if s.lies then
	    return "{Бренна} лежит на полу, отвернушись к стене."
	 else
	    return "{Бренна} стоит в клетке."
	 end
      else
	 return "{Бренна} стоит рядом с Джошуа."
      end
   end,
   act = function( s )
      if s.lies then
	 s.lies = false
	 walk "Brenna_dlg"
      else
	 if s.prisoned then
	    return "Бренна стоит в клетке и с надеждой смотрит на Джошуа."
	 else
	    return "Джошуа чуть было не залюбовался своей возлюбленной, но вовремя спохватился -- время действовать."
	 end
      end
   end,
}

Brenna_dlg = room {
   nam = "Разговор с Бренной",
   dsc = function()
      v = "Джошуа тихонько позвал Бренну. Она вздрогнула и обернулась. Растрёпанная, с глубокой царапиной на лбу, но живая. Самое главное что она жива.^-- Джошуа! Я уже потеряла всякую надежду снова увидеть тебя, -- она еле удержалась чтоб не закричать."
      if Brenna.prisoned then
	 v = v .."^-- Подожди пока радоваться, сперва надо придумать как тебе отсюда выбраться.^-- Знаешь, они настолько полагаются на свои импланты и протезы, что особо не беспокоятся о состоянии замков. Замок на клетке совсем хлипкий и если бы они оставили мне хоть что-нибудь, я бы смогла его открыть и сама.^-- Подожди. Сейчас попробую."
      end
      return v
   end,
   act = function()
      back()
   end,
   obj = { vobj( "Back", "{Далее}" ) },
}

bad_end = room {
   hideinv = true,
   nam = "...",
   dsc = "Полуденное солнце ярко освещало всё вокруг, но не пекло, а приятно пригревало. Джошуа и Бренна шли по заброшенному шоссе, продолжая побег от человечества и болтая ни о чём. Больше им ничего не оставалось. Вдали показался какой-то дорожный знак, но разглядеть что на нём написано было пока невозможно.^Спустя минут двадцать знак стал легко различим. Красивая надпись гласила \"Добро пожаловать в славный город Лудд\".",
   act = function()
      restore_snapshot()
   end,
   obj = { vobj( "Back", "{Повернуть время вспять}" ) },
}

outside = room {
   var {
      seen = false,
   },
   nam = "Снаружи",
   dsc = function( s )
      if not s.seen then
	 v = "Джошуа помог Бренне выпрыгнуть в окно, а потом вылез сам. "
      else
	 v = ""
      end
      v = v .. "Пока что всё тихо. Джошуа и Бренна стоят рядом со зданием, в котором Бренну держали в неволе."
      return v
   end,
   way = { vroom( "в лес", "happy_end" ) },
}

happy_end = cutscene {
   hideinv = true,
   nam = true,
   dsc = function()
      p "Погони за ними не было долго, а когда Джошуа и Бренна подбегали к лесу, тучи снова разродились дождём. Бежать под дождём было сложнее, но его шум заглушал звуки их передвижения, а вода смывала следы. Джошуа был искренне удивлён тем, что им удалось так легко убежать.^{cut}"
      p "Вскоре их побег от охотников за органами превратился в привычный уже побег от человечества. Точнее, от того, во что человечество превратилось.^{cut}"
      p "Джошуа понимал, что продолжать обещать Бренне пусть красивую, но сказку, это неправильно. В конце концов он всё таки рассказал всю правду. Вопреки его опасениям, из этого не вышло ничего плохого и Бренна спокойно восприняла это признание.^{cut}"
      p "Они продолжали свой побег ещё несколько лет, пока не добрались до совершенно безлюдной местности. Таких мест осталось ничтожно мало на материке, но ещё не весь мир был отвоёван человеком.^{cut}"
      p "Они остановились в своём бегстве. Построили дом, развели огород, надеялись встретить других не модифицированных людей. Так они ждали и жили. И возле дома своего поставили табличку, на которой Бренна красивым шрифтом вывела одну простую надпись.^{cut}"
      pn "\"ДОБРО ПОЖАЛОВАТЬ В СЛАВНЫЙ ГОРОД ЛУДД\"^"
      pn( txtc( txtb( "Конец" ) ) )
   end,
}
