--$Name: Библиотека 3: Вторжение$
--$Version: 0.9$
--$Author: Андрей Лобанов$

require "dbg"

require "cutscene"
require "fmt"
require "fonts"
require "link"
require "noinv"
require "snapshots"
require "snd"
require "timer"

xact.walk = walk

local fnt = _'$fnt'
fnt:face ('sans', 'theme/sans.ttf', 33)

const {
	tracks = {
		"mus/hole a new see.xm",
		"mus/slowmotionbreathin.xm",
	}
}

declare {
	current_track = 0
}

obj {
	nam = "пулемёт",
	inv = "Пулемёт калибра 7.62. Такие установлены на всех десантных скафандрах.",
	use = function(s, w)
		if w ^ "дверь склада" and not w.broken then
			w.broken = true
			enable "хранилище"
			return "Я дал очередь по двери. Град пуль изрешетил замок вместе с большей частью двери."
		elseif w ^ "десантники" or w ^ "Моро" or w ^ "техник" then
			return "Я не буду стрелять в своих товарищей."
		elseif w ^ "сервитор" then
			lifeoff(w)
			disable(w)
			_"поверженный сервитор":enable()
			return "Я буквально разрезал сервитора надвое очередью из пулемёта."
		elseif w ^ "танк" then
			return "Я выпустил очередь по танку, но его броне это что слону дробина."
		else
			return "Лучше не тратить боезапас впустую."
		end
	end,
}

obj {
	nam = "скафандр",
	checked = false,
	inv = function(s)
		walk "интерфейс скафандра"
	end,
}

room {
	nam = "интерфейс скафандра",
	disp = "скафандр",
	f = false,
	decor = function(s)
		return "{@ walk диагностика|Диагностика}" ..
			[[^{@ walk прыжок|Включить прыжковой ранец}]] ..
			[[^^{@ walk "]] .. s.f.nam .. [["|Назад}]]
	end,
	onenter = function(s, f)
		if not f ^ "диагностика" then
			s.f = f
		end
	end,
	onexit = function(s, t)
		if _"скафандр".checked and t ^ "диагностика" then
			return "Я уже провёл диагностику.", false
		end
	end,
}

cutscene {
	nam = "диагностика",
	decor = function()
		pn(fmt.b "СТАРТ ДИАГНОСТИКИ")
		pn "[cut]"
		pn "ЦЕЛОСТНОСТЬ ЭКЗОСКЕЛЕТА... ОК"
		pn "[cut]"
		pn "АКТИВНОСТЬ МУСКУЛАТУРЫ... В НОРМЕ"
		pn "[cut]"
		pn "ЦЕЛОСТНОСТЬ БРОНИ... ОК"
		pn "[cut]"
		pn "СВЕТОФИЛЬТРЫ... ОК"
		pn "[cut]"
		pn "СИСТЕМА СВЯЗИ... ОК"
		pn "[cut]"
		pn "СКАНЕР МЕСТНОСТИ... ОК"
		pn "[cut]"
		pn "ВСЕ СИСТЕМЫ В НОРМЕ"
		pn "[cut]"
		pn "[code _\"скафандр\".checked = true]"
		pn "[walk интерфейс скафандра]"
	end,
}

room {
	nam = "прыжок",
	jump = false,
	onenter = function(s, f)
		if from() ^ "капсула перед приземлением" then
			if not s.jump then
				s.jump = true
				walk "крыша здания"
			end
		elseif from() ^ "крыша здания" or from() ^ "лестница" then
			walk "перекрёсток"
		elseif from() ^ "руины комната" then
			if _"сервитор".count > 0 and not disabled "сервитор" then
				walk "смерть2"
				return
			end
			walk "сквер"
		elseif from() ^ "сквер" then
			if not _"танк".dead then
				disable "сквер"
				disable "танк"
				walk "смерть3"
				return
			end
			walk "руины комната"
		else
			return "Не стоит включать ранец тут.", false
		end
	end,
}

function init()
	take "скафандр"
	take "пулемёт"
end

function game.timer()
	if not snd.music_playing() then
		current_track = current_track + 1
		if current_track > #tracks then
			current_track = 0
		end
		dprint(tracks[current_track])
		snd.music(tracks[current_track], 1)
	end
	return false
end

function make_cut(t, w)
	return "[cls]^" ..
		"[fading 16]^" ..
		fmt.y("50%", "middle") .. fmt.c("{$fnt sans|" .. string.upper(t) .. "}^") ..
		"[fading 16]^" ..
		"[pause 2000]^" ..
		"[cls]^" ..
		"[fading 16]^" ..
		"[walk " .. w .. "]"
end

room {
	nam = "main",
	noinv = true,
	disp = "БИБЛИОТЕКА 3: ВТОРЖЕНИЕ",
	decor = fmt.b "Версия:" .. fmt.tab("25%") .. "0.9^^" ..
		fmt.b "Автор:" .. fmt.tab("25%") .. "Андрей Лобанов^" ..
		fmt.b "Движок:" .. fmt.tab("25%") .. "Петр Косых^" ..
		fmt.b "Музыка:" .. fmt.tab("25%") .. "nagz - eastern nature ,.xm^" ..
		fmt.tab("25%") .. "nagz - hole a new see.xm^" ..
		fmt.tab("25%") .. "nagz - slowmotionbreathin'.xm^^" ..
		"Специально для восьмого паровозика.^^" ..
		"{@ walk начало|Начать игру}^" ..
		"{@ walk обигре|Об игре}",
	onenter = function()
		snd.music "mus/eastern nature.xm"
	end,
	exit = function(s, t)
		if t ^ "начало" then
			snd.stop_music()
			timer:set(100)
		end
	end,
}

room {
	nam = "обигре",
	noinv = true,
	disp = "ОБ ИГРЕ",
	decor = "Это третья серия истории про планету Библиотеку, на этот раз поданная от лица нового персонажа. Для понимания сюжета рекомендуется пройти первые две части, которые вы можете найти по адресу {$link|http://instead-games.ru}.^^Как всегда, эта игра должна была быть больше и сложнее, но по независящим от меня причинам её пришлось нещадно резать и перекраивать, чтобы уложиться в срок. В своё дурацкое оправдание могу сказать, что в общей сложности я смог заниматься игрой меньше двух дней. Прошу понять и простить :)^^Большое спасибо Петру Косых за прекрасный движок, дружному Instead-сообществу за творческую и техническую атмосферу, Ajenta Arrow за паровозик и за то, что разрешила выпустить релиз с опозданием, и всем многочисленным авторам и игрокам Interactive Fiction, которые создают и разделяют со мной этот увлекательный и притягательный мир текстовых приключений.^^О найденных ошибках, опечатках и багах можно написать мне на почту: {$link|spline1986@yandex.ru}.^^{@ walk main|Назад}",
}

cutscene {
	nam = "начало",
	noinv = true,
	disp = "",
	decor = make_cut("СИГНАЛ БЫЛ ПРИНЯТ", "отсек сброса"),
}

room {
	nam = "отсек сброса",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = false
			return "Я стою в отсеке сброса. Капсулы уже подготовлены и остались считанные минуты до отстрела. Каждый раз перед самым сбросом меня одолевает мандраж. Это не панические атаки, не страх, но и не нетерпение. Корабельный психолог сказал, что я в порядке, но мне всё равно кажется, что я один так себя чувствую перед высадкой."
		else
			return "Я стою в отсеке сброса."
		end
	end,
	obj = {
		obj {
			nam = "десантники",
			dsc = "В отсеке сброса в две шеренги вдоль стен выстроились {десантники}.",
			act = "Мои боевые товарищи! Эти узы крепче семейных.",
		},
		obj {
			act = "Моро",
			dsc = "Между ними стоит лейтенант {Моро}.",
			act = function(s)
				walk "брифинг"
			end,
		},
	},
	way = {
		path {"капсула", "около капсулы"},
	},
}

cutscene {
	nam = "брифинг",
	noinv = true,
	disp = ". . .",
	decor = function()
		pn "Лейтенант прохаживается вдоль шеренг -- есть у него такая привычка перед сбросом."
		pn "[cut]"
		pn "Наконец, он остановился, осмотрел нас как будто видит в первый раз, и начал свою речь."
		pn "[cut]"
		pn "-- Дикобразы!"
		pn "[cut]"
		pn "-- Военные силы объединённого человечества уже две сотни лет патрулировали закрытый сектор в окрестностях Библиотеки."
		pn "[cut]"
		pn "-- Две недели назад с планеты был получен сигнал, отправленный человеком."
		pn "[cut]"
		pn "-- Мы не знаем кто его отправил, как он попал на планету, некоторые даже считают, что это потомки выживших, но сигнал содержал информацию о готовящемся нападении искусственного интеллекта Библиотеки."
		pn "[cut]"
		pn "-- Ваша задача высадиться на планету, провести разведку и вернуться на катерах."
		pn "[cut]"
		pn "-- По капсулам, солдаты!"
		pn "[cut]"
		pn "[walk около капсулы]"
	end,
}

room {
	nam = "около капсулы",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Последние минуты перед сбросом. По уставу положено провести предстартовую диагностику скафандра."
		else
			return "Я нахожусь перед капсулой."
		end
	end,
	onexit = function(s, w)
		if w ^ "капсула" and not _"скафандр".checked then
			return "Сначала нужно провести диагностику скафандра. Механики, конечно, проверяют и восстанавливают его после каждого задания, но если с ним что-то не так, то до поверхности я могу и не долететь.", false
		end
	end,
	obj = {
		obj {
			dsc = "Десантная {капсула} блестит пластиковым боком.",
			act = "Очень маленькая штука. Первые сбросы я думал, что у меня разовьётся клаустрофобия. Потом привык, конечно.",
		},
		obj {
			nam = "люк",
			dsc = "Прямо передо мной находится {люк}.",
			act = "Люк отдраен. Когда я буду внутри, его задраят снаружи. Сама же капсула разрушится во время сброса и мне не понадобится выбираться из неё. Последний этап торможения осуществляется посредством прыжкового ранца скафандра.",
		},
	},
	way = {
		"капсула",
	},
}

room {
	nam = "капсула",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Тесная десантная капсула не имеет каких-либо органов управления -- всё, что мне нужно, находится в моём скафандре. Тем не менее, это высокотехнологичное устройство, здорово помогающее дёшево и быстро спуститься на поверхность планеты."
		else
			return "Я нахожусь в десантной капсуле."
		end
	end,
	obj = {
		obj {
			dsc = "Внутри не так много всего. Пластиковые {стены} да",
			act = "На самом деле внутренний слой прозрачный. В процессе сброса на планеты с атмосферой стенки сгорают слой за слоем и остаются только каркас да пластиковое ложе. Ну ещё верхний слой раскрывается в тормозные лепестки.",
		},
		obj {
			dsc = "{амортизатор}, занимающий чуть ли не половину объёма.",
			act = "Своеобразное ложе из вспененного полимерного материала, несколько смягчающее перегрузку во время отстрела.",
		},
		obj {
			nam = "техник",
			dsc = "Через незадраенный люк я вижу {техника}.",
			act = function(s)
				walk "сброс"
			end,
		},
	},
}

cutscene {
	nam = "сброс",
	noinv = true,
	disp = false,
	decor = function(s)
		pn "-- Готов, -- сказал я технику."
		pn "[cut]"
		pn "Техник кивнул и задраил люк."
		pn "[cut]"
		pn "Он постучал по люку."
		pn "[cut]"
		pn "Я постучал по люку в ответ."
		pn "[cut]"
		pn "Потянулись долгие минут ожидания закрытия всех капсул."
		pn "[cut]"
		pn "Послышался грохот выстреливаемой капсулы. Началось."
		pn "[cut]"
		pn "Снова грохот. Вторая капсула пошла."
		pn "[cut]"
		pn "Третья."
		pn "[cut]"
		pn "Четвёртая. С каждым сбросом грохот всё громче -- приближается моя очередь."
		pn "[cut]"
		pn "Пятая."
		pn "[cut]"
		pn "Грохот сотряс мою капсулу и меня вдавило в амартизационное покрытие."
		pn "[cut]"
		pn "[walk приземление]"
	end,
}

cutscene {
	nam = "приземление",
	noinv = true,
	disp = false,
	decor = function(s)
		pn "Пока капсула летит в безвоздушном пространстве полёт совсем не ощущается. Разве что искусственное тяготение корабля сменяется невесомостью, что приводит в замешательство новичков, но я уже давно привык к этому бесконечному падению."
		pn "[cut]"
		pn "Капсула начала мелко дрожать -- вхожу в верхние слои атмосферы."
		pn "[cut]"
		pn "Дрожь, плавно усиливаясь, переросла в настоящую тряску. Внешняя оболочка начала сгорать, высвобождая лепестки средней оболочки капсулы, работающие как парашют."
		pn "[cut]"
		pn "Лепестки раскрылись и меня здорово тряхнуло -- началось торможение о плотные слои атмосферы."
		pn "[cut]"
		pn "Отлетела предпоследняя оболочка -- теперь осталась только внутренняя прозрачная стенка, каркас, амортизатор и лепестки. Поверхность Библиотеки стремительно приближается ко мне."
		pn "[cut]"
		pn "Внутренняя оболочка сгорела, а падение замедлилось настолько, что компенсировать скорость можно прыжковым ранцем."
		pn "[cut]"
		pn "[walk капсула перед приземлением]"
	end,
}

room {
	nam = "капсула перед приземлением",
	seen = false,
	disp = "десантная капсула",
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Капсула неприятно раскачивается. Видимо, лепестки износились неравномерно. Пора тормозить."
		else
			return "Я нахожусь в капсуле."
		end
	end,
	obj = {
		obj {
			nam = "каркас",
			dsc = "Лёгкий полимерный {каркас} держит сейчас всю конструкцию и меня заодно.",
			act = "Просто пластиковые трубки.",
		},
		obj {
			nam = "амортизатор",
			dsc = "К нему прикреплён {амортизатор}.",
			act = "Своеобразное ложе из вспененного полимерного материала, несколько смягчающее перегрузку во время отстрела.",
		},
		obj {
			nam = "лепестки",
			dsc = "Наверху видны тормозные {лепестки}.",
			act = "Они заметно истрепались, но это не имеет значения -- капсула одноразовая.",
		},
	},
}

obj {
	nam = "здания",
	dsc = "Соседние {здания} выглядят сильно заброшенными.",
	act = "Две сотни лет без присмотра ни одному сооружению на пользу не пойдут.",
}

room {
	nam = "крыша здания",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я приземлился на крышу какого-то здания. Удар о поверхность чувствительно отдался в ноги -- я слишком поздно включил ранец, но скафандр справился с амортизацией своей искусственной мускулатурой. Остатки капсулы упали куда-то в сторону."
		else
			return "Я нахожусь на крыше какого-то здания."
		end
	end,
	obj = {
		"здания",
		obj {
			dsc = "В отдалении видны {руины}.",
			act = "Выглядит как будто здание взорвали. Неужели тут велись боевые действия?",
		},
		obj {
			seen = false,
			dsc = "Вниз ведёт пожарная {лестница}.",
			act = function(s)
				if not s.seen then
					s.seen = true
					enable "лестница"
				end
				return "Лестница старая и выглядит не слишком надёжно."
			end,
		},
		obj {
			dsc = "В небе видны {следы} других капсул.",
			act = "Капсулы при сгорании слоёв оставили тёмные дымные кляксы в небе.",
		},
	},
	way = {
		"лестница",
	},
}

room {
	nam = "лестница",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я осторожно спустился на пожарную лестницу. Конструкция неприятно заскрипела под весом боевого скафандра. Может, стоит прыгнуть пока она не обвалилась?"
		else
			return "Я нахожусь на пожарной лестнице."
		end
	end,
	onenter = function(s, f)
		snapshots:make()
	end,
	onexit = function(s, w)
		if not w ^ "смерть1" then
			snapshots:remove()
		end
	end,
	obj = {
		"здания",
		obj {
			dsc = "Металлические {ступени} выглядят не очень надёжными.",
			act = "Старые, как и всё на Библиотеке, ступени из металлических решёток.",
		},
		obj {
			dsc = "{Перила} выглядят ещё хуже.",
			act = "Я бы побоялся облокачиваться на них и без скафандра.",
		},
		obj {
			dsc = "{Лестница} как будто едва выдерживает вес моего скафандра.",
			act = "Старая, изъеденная коррозией металлическая лестница неприятно пошатывается и скрипит при каждом моём шаге.",
		},
	},
	way = {
		path {"наверх", "крыша здания"},
		path {"вниз", "смерть1"},
	},
}

room {
	nam = "перекрёсток",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я спустился на землю."
		else
			return "Я нахожусь на перекрёстке."
		end
	end,
	obj = {
		obj {
			dsc = "Вдоль дороги стоят {фонари}.",
			act = "Наверное, это было красиво, когда Библиотека ещё была библиотекой.",
		},
		obj {
			dsc = "На дорожном покрытии валяются {осколки} бетона",
			act = "Похоже, что это обломки, занесённые сюда взрывной волной.",
		},
		obj {
			dsc = "и {обломки} арматуры.",
			act = "Согнутые, скрученные, с кусками бетона куски арматуры.",
		},
	},
	way = {
		"руины комната",
		"железная дорога",
	},
}

room {
	nam = "руины комната",
	disp = "руины",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я подошёл к руинам. Похоже, раньше это был узел связи. Видимо, ИИ весьма активно препятствовал отправке сигнала.^^За руинами виден одичавший сквер."
		else
			return "Я нахожусь возле руин."
		end
	end,
	onenter = function(s)
		snapshots:make()
	end,
	onexit = function(s, w)
		if w ^ "сквер" then
			return "Я не хочу рисковать, карабкаясь по обломкам -- они выглядят слишком ненадёжными.", false
		end
		if _"сервитор".count > 0 and not disabled "сервитор" then
			walk "смерть2"
		elseif _"сервитор".count == 0 and disabled "сервитор" then
			enable "сервитор"
			lifeon "сервитор"
			return "Из-за горы бетонных обломков с натужным гудением механики вышел сервитор.", false
		end
	end,
	obj = {
		obj {
			dsc = "Неаккуратными кучами лежат {обломки}.",
			act = "Бетонное крошево и куски арматуры. Тут и там попадаются обломки пластика.",
		},
		obj {
			dsc = "Среди них лежит искорёженная параболическая {антенна}.",
			act = "Это подтверждает мои догадки о назначении разрушенного здания.",
		},
		obj {
			nam = "сервитор",
			count = 0,
			dsc = "{Сервитор} явно проявляет враждебные намерения.",
			act = "Сервитор целится в меня из уродливой пушки, заменяющей ему одну руку.",
			life = function(s)
				s.count = s.count + 1
				if s.count == 3 then
					walk "смерть2"
				end
			end,
		}:disable(),
		obj {
			nam = "поверженный сервитор",
			dsc = "На обломках здания лежит поверженный {сервитор}.",
			act = "Довольно нелепая, но всё таки смертоносная машина.",
		}:disable(),
	},
	way = {
		"перекрёсток",
		"сквер",
	},
}

room {
	nam = "сквер",
	seen = false,
	count = 0,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я приземлился в самый центр сквера. Где-то в отдалении слышны звуки выстрелов -- мои товарищи тоже встретились с местным агрессором."
		else
			return "Я нахожусь в сквере."
		end
	end,
	onenter = function(s)
		snapshots:make()
		lifeon(s)
	end,
	onexit = function(s, t)
		if t ^ "руины комната" then
			return "Я не хочу рисковать, карабкаясь по обломкам здания.", false
		end
	end,
	life = function(s)
		s.count = s.count + 1
		if s.count == 2 then
			pn "Издали доносится металлический лязг и грохот."
		elseif s.count == 3 then
			enable "выжившие"
			pn "Грохот становится ближе."
			pn "Из-за угла вышло два человека в штатском."
		elseif s.count == 4 then
			lifeon "танк"
			enable "танк"
			disable "выжившие"
			enable "выжившие2"
			pn "Проломив стену, сминая деревья как прутики, в сквер въехал танк!"
			pn "Обломок стены ударил одного выжившего, сбив его с ног. Плохо дело."
		elseif s.count > 4 then
			lifeoff(s)
		end
	end,
	obj = {
		obj {
			dsc = "{Кустарник} разросся сверх всякой меры.",
			act = "Удивительно как природа не сдаётся не смотря ни на что. Нам есть чему у неё поучиться.",
		},
		obj {
			dsc = "{Деревья} растут плотно, бесконечно борясь за жизненное пространство и свет.",
			act = "Выглядит как будто посреди мегаполиса пророс лес.",
		},
		obj {
			nam = "выжившие",
			dsc = "В мою сторону торопливо идут два {человека} в штатском.",
			act = "Идут они кое как, поддерживая друг друга и то и дело спотыкаясь.",
		}:disable(),
		obj {
			nam = "выжившие2",
			dsc = "В некотором отдалении находятся {выжившие}.",
			act = function(s)
				walk "финал"
			end,
		}:disable{},
		obj {
			nam = "танк",
			count = 0,
			dead = false,
			dsc = "{Танк} остановился и направляет орудие в мою сторону.",
			act = "У Библиотеки появилась бронетехника!",
			life = function(s)
				s.count = s.count + 1
				if s.count == 3 then
					walk "смерть3"
				end
			end,
		}:disable(),
		obj {
			nam = "разрушенный танк",
			dsc = "Посреди сквера стоит {танк}.",
			act = "Неуклюжая, но страшная конструкция. Хотя, после попадания гранаты он выглядит не столь угрожающе.",
		}:disable(),
	},
	way = {
		"руины комната",
	},
}

room {
	nam = "железная дорога",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я подошёл к железнодорожным путям."
		else
			return "Я нахожусь возле железнодорожных путей."
		end
	end,
	obj = {
		obj {
			dsc = "Вдоль дороги стоят какие-то служебные {здания}.",
			act = "Скорее всего, склады. Библиотека снабжалась через космопорты и распределяла ресурсы по железной дороге.",
		},
		obj {
			dsc = "В отдалении виден {поезд}.",
			act = "Поезд сошёл с рельс и разрушил всё вокруг. Может, это как-то связано с руинами?",
		},
	},
	way = {
		"перекрёсток",
		path {"поезд", "около поезда"},
	},
}

room {
	nam = "около поезда",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я подошёл к поезду. Картина разрушения меня не сильно тронула -- сказывается боевой опыт, но масштаб всё равно произвёл некоторое впечатление."
		else
			return "Я нахожусь рядом с поездом."
		end
	end,
	obj = {
		obj {
			dsc = "{Вагоны} смяты и опрокинуты.",
			act = "Как и всё вокруг, они выглядят достаточно потрёпанными, но такое ощущение, что поезд сошёл с рельс относительно недавно -- на краске блестят свежие, не изъеденные коррозией царапины.",
		},
		obj {
			dsc = "Перед поездом лежат {колонны}.",
			act = "Похоже, их сбили перед поездом.",
		},
		obj {
			dsc = "{Здания} по сторонам от путей сильно пострадали.",
			act = "Вагоны просто вспороли стены. Удивительно порой сколько разрушений могут принести вполне мирные вещи.",
		},
		obj {
			dsc = "В одном из них видна открытая {дверь}.",
			act = function(s)
				if _"склад".seen then
					return "Дверь ведёт на склад."
				else
					return "Интересно, что находится по ту сторону дверного проёма?"
				end
			end,
		},
	},
	way = {
		path {"к перекрёстку", "железная дорога"},
		path {"в дверь", after = "склад", "склад"},
	},
}

room {
	nam = "склад",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я вошёл в тёмное помещение."
		else
			return "Я нахожусь на складе."
		end
	end,
	onenter = function(s, f)
		if f ^ "около поезда" then
			return "Скафандр включил оптический усилитель."
		end
	end,
	onexit = function(s, w)
		if w ^ "около поезда" then
			return "Скафандр выключил оптический усилитель."
		end
	end,
	obj = {
		obj {
			dsc = "Всё помещение занимают ровные ряды {стеллажей}.",
			seen = false,
			act = function(s)
				if not s.seen then
					s:open()
					return "На стеллажах лежат армейские ящики. Откуда они на Библиотеке?"
				else
					return "Пластиковые стеллажи."
				end
			end,
			obj = {
				obj {
					dsc = "На них лежат {ящики}.",
					act = "Армейские ящики. Судя по маркировке, это вооружение. Точнее не могу определить -- маркировка отличается от современной. Кто привёз его сюда?",
				},
			},
		}:close(),
		obj {
			nam = "дверь склада",
			broken = false,
			dsc = function(s)
				if not s.broken then
					return "В дальней стене видна закрытая {дверь}."
				else
					return "В дальней стене находится {дверь}."
				end
			end,
			act = function(s)
				if not s.broken then
					return "Заперто."
				else
					return "От двери мало что осталось."
				end
			end,
		},
	},
	way = {
		path {"наружу", "около поезда"},
		path {"дверь", after = "хранилище", "хранилище"},
	},
}

room {
	nam = "хранилище",
	seen = false,
	dsc = function(s)
		if not s.seen then
			s.seen = true
			return "Я вошёл в ещё одно складское помещение."
		else
			return "Я нахожусь в хранилище."
		end
	end,
	obj = {
		obj {
			seen = false,
			dsc = "Вдоль стен стоят {стеллажи}.",
			act = function(s)
				if not s.seen then
					s.seen = true
					s:open()
					return "На стеллажах уложены армейские ящики."
				else
					return "Пластиковые стеллажи."
				end
			end,
			obj = {
				obj {
					dsc = "На них лежат {ящики}.",
					seen = false,
					act = function(s)
						if not s.seen then
							s.seen = true
							take "гранатомёт"
							return "Судя по маркировке, это гранатомёты. Очень неплохо. Может пригодиться. В соседних ящиках нашлись бронебойные снаряды для него."
						else
							return "Ящики с тяжёлым оружием."
						end
					end,
				},
			},
		}:close(),
	},
	way = {
		"склад",
	},
}:disable()

obj {
	nam = "гранатомёт",
	inv = "Старинный гранатомёт. Впрочем, в приличном ещё состоянии.",
	use = function(s, w)
		if w ^ "сервитор" then
			disable(s)
			lifeoff(w)
			disable(w)
			return "Я выстрелил в сервитора из гранатомёта. Его просто разорвало на кучу мелких частей."
		elseif w ^ "танк" then
			disable(s)
			lifeoff(w)
			disable(w)
			w.dead = true
			enable "разрушенный танк"
			return "Я вскинул гранатомёт и нажал гашетку. Отдачу полностью компенсировала мускулатура скафандра, граната пробила броню танка и взорволась внутри. Похоже, этого оказалось достаточно."
		else
			return "Лучше поберечь заряд на всякий случай."
		end
	end,
}

obj {
	nam = "restart",
	dsc = "{А может, всё сложилось иначе?}",
	act = function(s)
		snapshots:restore()
	end,
}

room {
	nam = "смерть1",
	disp = ". . .",
	noinv = true,
	decor = "Я продолжил спуск по лестнице. Со страшным скрежетом анкеры вырвались из стены, видимо сотни лет без присмотра оказались слишком долгим сроком или для них или для стены.^^Автоматика скафандра не успела адекватно сработать и прыжковый ранец направил меня в стену соседнего здания. Тут же откуда-то появились странного вида сервиторы и пока я пытался подняться на ноги, расстреляли меня из своих жутких кинетических пушек.^^Броня не смогла долго выдерживать их огонь...",
	obj = {
		"restart",
	},
}

room {
	nam = "смерть2",
	noinv = true,
	disp = ". . .",
	decor = "Сервитор выстрелил из своей кинетической пушки и попал мне в голову. Скафандр выдержал удар, но меня повалило с ног, а забрало всё таки треснуло от тяжёлой болванки, исполнявшей роль пули. Пока я пытался встать, откуда-то появились ещё сервиторы и тоже открыли по мне огонь. Сквозь боль и красную пелену я смотрел на расплывающиеся чёрные кляксы в небе пока сознание моё не угасло...",
	obj = {
		"restart",
	},
}

room {
	nam = "смерть3",
	noinv = true,
	disp = ". . .",
	decor = "Танк выстрелил в меня из своей пушки. Скафандр смяло как бумагу, я ещё успел почувствовать и услышать как ломаются мои кости, после чего сознание покинуло меня...",
	obj = {
		"restart",
	},
}

cutscene {
	nam = "финал",
	noinv = true,
	disp = ". . .",
	decor = function(s)
		pn "Я подошёл к выжившим."
		pn "[cut]"
		pn "-- Кто вы такие?"
		pn "[cut]"
		pn "-- Меня зовут Леонид, а это мой товарищ по экспедиции."
		pn "[cut]"
		pn "-- Что за экспедиция? На Библиотека закрыта для посещений уже две сотни лет."
		pn "[cut]"
		pn "-- Я знаю, но соблазн был слишком велик."
		pn "[cut]"
		pn "-- Не важно. Нужно выбираться."
		pn "[cut]"
		pn "Товарищ Леонида плох. Я просканировал его медицинским модулем скафандре -- позвоночник цел, есть многочисленные повреждения, но он должен выдержать транспортировку."
		pn "[cut]"
		pn "Взяв раненого в одну руку, а Леонида в другую, я направился в зону сбора нашего взвода -- катера должны скоро прилететь."
		pn "[cut]"
		pn "Скафандр не замедлил сообщить мне, что мускулатура работает на пределе возможного, но я уверен, что до катера мы доберёмся."
		pn "[cut]"
		pn "-- Приготовьтесь, сейчас нас тряхнёт, -- сказал я и включил прыжковой ранец..."
		pn "[cut]"
		pn "[walk конец]"
	end,
}

cutscene {
	nam = "конец",
	noinv = true,
	disp = false,
	decor = function(s)
		pn "[cls]"
		pn "[fading 16]"
		pn(fmt.y("50%", "middle") .. fmt.y("50%", "middle") .. fmt.c("{$fnt sans |КОНЕЦ}"))
		pn "[fading 16]"
	end,
}
