room {
   nam = 'Леонид 4',
   talked = false,
   n = 0,
   dsc = 'Рядом со мной стоит {Леонид}.',
   act = function(s)
	  if s.talked then
		 return 'Лучше скорее отправить сообщение.'
	  else
		 walk 'разговор с Леонидом 4'
	  end
   end,
   life = function(s)
	  if s.n > 0 then
		 if player_moved() then
			place(s)
			return 'Леонид последовал за мной.'
		 end
	  end
	  s.n = s.n + 1
   end,
}

dlg {
   nam = 'разговор с Леонидом 4',
   noinv = true,
   disp = 'разговор с Леонидом',
}

room {
   nam = 'у входа в узел связи',
   seen = false,
   onenter = function(s)
	  lifeon 'Леонид 4'
   end,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Мы подошли к башне связи. Наконец, нам удалось опередить противника. Остался последний рывок.'
	  else
		 return 'Я нахожусь у входа в узел связи.'
	  end
   end,
   obj = {
	  obj {
		 dsc = '{Башня} узла связи высится над нами.',
		 act = 'Гигантская конструкция. Узел космической связи.',
	  },
	  obj {
		 dsc = '{Пространство} вокруг неё совершенно свободно.',
		 act = 'Большая бетонная площадка, в центре которой расположен узел связи.',
	  },
   },
   way = {
	  path { 'внутрь', 'первый этаж' },
   },
}

room {
   nam = 'первый этаж',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Мы вошли в узел связи. Тесное помещение, не несущее особой функциональной нагрузки..'
	  else
		 return 'Я нахожусь на первом этаже узла связи.'
	  end
   end,
   onenter = function(s)
	  if not live 'сервиторы' then
		 snapshots:remove()
		 snapshots:make()
	  end
	  lifeon 'сервиторы'
   end,
   obj = {
	  obj {
		 dsc = 'Наверх ведёт узкая {лестница}.',
		 act = 'Металлическая лестница с перилами. Ничего особенного.',
	  },
	  obj {
		 dsc = 'На стене висит {план} эвакуации.',
		 act = 'Думаю, пока что я и без него найду выход.',
	  },
   },
   way = {
	  path { 'наружу', 'у входа в узел связи' },
	  path { 'наверх', 'второй этаж' },
   },
}

room {
   nam = 'второй этаж',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Мы поднялись на второй этаж. После нескольких дней без нормального сна, с концентратами вместо еды, найденными на складах, почти без воды, подниматься по лестнице оказалось очень тяжело.'
	  else
		 return 'Я нахожусь на втором этаже узла связи.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Вниз и вверх уходит узкая {лестница}.',
		 act = 'Узкая металлическая лестница. Ничего особенного.',
	  },
	  obj {
		 nam = 'план эвакуации',
		 dsc = 'На стене висит неизменный {план} эвакуации.',
		 act = 'Довольно забавно видеть здесь план эвакуации. Заблудиться тут просто невозможно.',
	  },
	  obj {
		 nam = 'окно башни',
		 dsc = 'Рядом с ним находится узкое {окно}.',
		 act = function(s)
			if not live 'сервиторы' then
			   lifeon 'сервиторы'
			end
			return servitors()
		 end,
	  },
   },
   way = {
	  path { 'вниз', 'первый этаж' },
	  path { 'наверх', 'третий этаж' },
   },
}

function servitors()
   if _'сервиторы'.n < 4 then
	  return 'Далеко в небе видны чёрные точки подлетающих сервиторов. Нужно спешить.'
   elseif _'сервиторы'.n < 9 then
	  return 'В небе видны летающие сервиторы. Нужно спешить.'
   end
end

obj {
   nam = 'сервиторы',
   n = 0,
   life = function(s)
	  s.n = s.n + 1
	  if s.n == 9 then
		 lifeoff(s)
		 lifeoff 'Леонид 4'
		 walk 'смерть 4'
	  end
   end,
}

room {
   nam = 'третий этаж',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Мы поднялись на третий этаж. Цель достигнута. Осталось лишь отправить сообщение.'
	  else
		 return 'Я нахожусь на третьем этаже узла связи.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Вниз уходит узкая {лестница}.',
		 act = 'Узкая металлическая лестница. Ничего особенного.',
	  },
	  'план эвакуации',
	  'окно башни',
	  obj {
		 dsc = 'Почти всё пространство помещения занимает {передатчик}.',
		 act = function(s)
			if closed(s) then
			   open(s)
			end
			return 'На панели управления расположено множество различных переключателей и ручек, но мне нужны всего несколько.'
		 end,
		 obj = {
			obj {
			   nam = 'поворотное устройство',
			   rot = false,
			   dsc = 'На нём сразу бросился в глаза {блок} управления поворотным устройством антенны.',
			   act = function(s)
				  if s.rot then
					 return 'Антенна уже направлена на ближайший спутник связи.'
				  else
					 s.rot = true
					 return 'Я запустил автоматическую наводку на ближайший спутник связи. Громкие щелчки работы старых механизмов действовали на нервы. Но антенна всё таки повернулась на нужный угол. Теперь можно начинать передачу.'
				  end
			   end,
			},
			obj {
			   dsc = 'Чуть в стороне от него находится {микрофон} и блок управления передачей.',
			   act = function(s)
				  if _'поворотное устройство'.rot then
					 lifeoff 'сервиторы'
					 lifeoff 'Леонид 4'
					 walk 'конец'
				  else
					 return 'Сперва нужно повернуть антенну на спутник связи.'
				  end
			   end,
			},
		 },
	  },
   },
   way = {
   },
}

room {
   nam = 'смерть 4',
   noinv = true,
   disp = '. . .',
   decor = 'Башня сильно затряслась, после чего последовала ослепительная вспышка. Последней моей мыслью было то, что мы всё таки не успели...^^' ..
	  '{@ restore|А может всё было иначе?}',
}

cutscene {
   nam = 'конец',
   noinv = true,
   disp = false,
   decor = function(s)
	  pn 'Я нажал на кнопку передачи и постарался максимально коротко и ёмко объяснить, что ситуация на Библиотеке требует пристального внимания.'
	  pn '[cut]'
	  pn 'Как только я закончил, мы с Леонидом бросились на лестницу. Нужно успеть унести ноги пока сервиторы не подлетели достаточно близко. Отбиться будет непросто.'
	  pn '[cut]'
	  pn 'Когда мы уже почти спустились на первый этаж, башню сильно тряхнуло. Этот узел связи сервиторы не успели уничтожить до того, как мы совершим передачу...'
	  pn '[cut]'
	  pn 'Когда мы отбежали на несколько десятков метров, взрыв, раздавшийся за нашими спинами, швырнул нас в воздух как тряпичные куклы...'
	  pn '[cut]'
	  pn 'Сознание угасло...'
	  pn '[cut]'
	  pn '[code bg = "bg.png"; set_bg()]'
	  pn '[cls]'
	  pn '[fading 16]'
	  pn '[pause 1000]'
	  pn(fmt.y('50%') .. fmt.c('{$fnt play|КОНЕЦ}'))
	  pn '[fading 16]'
   end,
}
