cutscene {
   nam = 'вагон 3_',
   noinv = true,
   disp = 'вагон',
   decor = function(s)
	  pn 'Я спал, неудобно устроившись на сидениях. Конечно, полноценному сну такой отдых не замена, но выбирать не приходится.'
	  pn '[cut]'
	  pn 'Из этого зыбкого полузабытья меня вырвал крик Леонида:^^-- Вставай! Сервиторы нас догоняют!..'
	  pn '[cut]'
	  pn 'Его слова были прерваны грохотом, обрушившимся на поезд. В вагон из кабины локомотива брызнули осколки полимерного стекла.'
	  pn '[cut]'
	  pn '[code walk "вагон 3"]'
   end,
}

obj {
   nam = 'Леонид 3',
   n = 0,
   talked = false,
   dsc = 'Рядом со мной стоит {Леонид}.',
   act = function(s)
	  if _'сервитор 3'.dead then
		 if s.talked then
			return 'Не время болтать. Нужно скорее двигаться к башне.'
		 else
			lifeoff(s)
			walk 'разговор с Леонидом 3'
		 end
	  else
		 return 'Сейчас не время разговаривать.'
	  end
   end,
   life = function(s)
	  if player_moved() then
		 place(s)
		 s.n = s.n + 1
	  end
	  if s.n > 1 then
		 return 'Леонид последовал за мной.'
	  end
   end,
}

dlg {
   nam = 'разговор с Леонидом 3',
   noinv = true,
   disp = 'разговор с Леонидом',
   onenter = 'Я обратился к Леониду:',
   phr = {
	  { 'Ты видел? Они теперь и летать могут!', '-- Ещё как видел. Они и опрокинули на нас колонну, но потом остался только один, а остальные улетели куда-то.',
		{ 'Хорошо, что нашли пушки.', '-- Что-то мне подсказывает, что пушки не решат всех наших проблем.',
		  { 'Пожалуй, ты прав. Ладно, надо двигаться дальше.', function() p '-- Пойдём.'; _'Леонид 3'.talked = true; lifeon 'Леонид 3'; end },
		},
	  },
   },
}

room {
   nam = 'вагон 3',
   seen = false,
   disp = 'вагон',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Ещё не до конца выйдя из дрёмы, дезориентированный таким развитием событий, я пытаюсь понять что происходит.'
	  else
		 return 'Я нахожусь в вагоне.'
	  end
   end,
   enter = function(s, f)
	  if not live 'Леонид 3' then
		 lifeon 'Леонид 3'
	  end
	  snapshots:remove()
	  snapshots:make()
   end,
   obj = {
   },
   way = {
	  path { 'в кабину', 'локомотив 3' },
   },
}

room {
   nam = 'локомотив 3',
   seen = false,
   disp = 'кабина локомотива',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я вышел в кабину локомотива. Через выбитое лобовое окно проще всего выбраться наружу.'
	  else
		 return 'Я нахожусь в кабине локомотива.'
	  end
   end,
   onenter = function(s, f)
	  if live 'сервитор 3' then
		 _'сервитор 3'.n = 0
		 lifeoff 'сервитор 3'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'За выбитым {окном} видны какие-то здания.',
		 act = 'Отсюда не разобрать, что там снаружи.',
	  },
	  obj {
		 nam = 'башня связи',
		 dsc = 'В отдалении виднеется {башня} станции связи.',
		 act = 'Цель нашего путешествия. Мы должны предупредить человечество.',
	  },
	  obj {
		 dsc = 'Почти всё пространство перед креслом машиниста занимает {пульт} управления поездом.',
		 act = 'Система обесточена -- пульт управления бесполезен.',
	  },
   },
   way = {
	  'вагон 3',
	  path { 'наружу', 'возле поезда' },
   },
}

room {
   nam = 'возле поезда',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я выбрался из локомотива наружу. Всё тело болит после такой жёсткой остановки, но руки и ноги целы.'
	  else
		 return 'Я нахожусь возле поезда.'
	  end
   end,
   onenter = function(s, f)
	  if not live 'сервитор 3' then
		 lifeon 'сервитор 3'
	  end
   end,
   onexit = function(s, t)
	  if live 'сервитор 3' and t ^ 'на пути к башне' then
		 walk 'смерть 3'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Смятая туша {поезда} растянулась на несколько десятков метров.',
		 act = 'Удивительно, что при таких сильных повреждениях поезда, мы практически не пострадали.',
	  },
	  obj {
		 dsc = 'Локомотив упёрся в огромную {колонну}.',
		 act = 'Такие колонны стоят вдоль путей. Видимо, эту опрокинули на нашем пути намеренно.',
	  },
	  'башня связи',
	  obj {
		 dsc = 'В ближайшей ко мне стене видна {дверь}.',
		 act = function(s)
			if disabled 'склад' then
			   enable 'склад'
			end
			return 'Дверь не заперта! Можно поискать укрытие за ней.'
		 end,
	  },
	  obj {
		 nam = 'сервитор 3',
		 n = 0,
		 dead = false,
		 dsc = 'На некотором удалении от нас в воздухе парит {сервитор}.',
		 act = 'Теперь они и так умеют? Это становится всё большей проблемой.',
		 life = function(s)
			s.n = s.n + 1
			if s.n == 4 then
			   lifeoff(s)
			   lifeoff 'Леонид 3'
			   walk 'смерть 3'
			end
		 end,
	  },
   },
   way = {
	  'локомотив 3',
	  path { 'здание', after='склад', 'склад' },
	  path { 'к башне', 'на пути к башне' },
   },
}

room {
   nam = 'склад',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я вошёл в какое-то складское помещение.'
	  else
		 return 'Я нахожусь на складе.'
	  end
   end,
   onenter = function(s, f)
	  snapshots:remove()
	  snapshots:make()
	  if live 'сервитор 3' then
		 _'сервитор 3'.n = 0
		 lifeoff 'сервитор 3'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Высокие {стеллажи} ровными рядами заполняют всё пространство склада.',
		 act = 'Полимерные стеллажи. Ничего примечательного.',
	  },
	  obj {
		 seen = false,
		 n = 0,
		 dsc = 'На них ровными рядами уложены {ящики}.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   return 'Я заглянул в ближайший ящик. Оружие. Древнее оружие. Хотя, на момент инцидента оно было вполне актуальным. Непонятно, откуда оно взялось на Библиотеке. Непонятно, почему ИИ не использовал его для модернизации сервиторов.'
			else
			   local v = 'В ящиках лежит оружие.'
			   if not have 'пушка' then
				  v = v .. ' То, что надо! Леонид взял пушку.'
				  take 'пушка'
			   else
				  if not have 'аккумулятор' and not _'пушка'.charged then
					 if s.n < 3 then
						v = v .. ' Наверняка где-то среди них есть и аккумулятор.'
					 elseif s.n == 3 then
						v = v .. ' Нашёл! Ящик с аккумуляторами. Леонид взял аккумулятор и зарядил свою пушку..'
						take 'аккумулятор'
					 end
					 s.n = s.n + 1
				  end
			   end
			   return v
			end
		 end,
	  },
   },
   way = {
	  path { 'к путям', 'возле поезда'},
   },
}:disable()

cutscene {
   nam = 'на пути к башне',
   noinv = true,
   disp = false,
   onenter = function(s)
	  lifeoff 'Леонид 3'
   end,
   decor = function(s)
	  pn '{$nl}{$nl}Прячась в тенях, мы с Леонидом пошли в сторону станции связи.^'
	  pn '[cut]'
	  pn 'Сперва мы увидели вспышку, а потом с грохотом до нас донеслась ударная волна. Бетон под ногами затрясся, я не удержал равновесие и упал.^'
	  pn '[cut]'
	  pn 'Не так то просто будет добраться до другой башни. К тому же, нужно быть всё осторожнее -- ИИ учится и модернизирует сервиторов очень быстро...^'
	  pn '[cut]'
	  pn '[code bg = "bg.png"; set_bg()]'
	  pn '[cls]'
	  pn '[fading 16]'
	  pn '[pause 1000]'
	  pn(fmt.y('50%') .. fmt.c('{$fnt play|. . .}'))
	  pn '[fading 16]'
	  pn '[pause 2000]'
	  pn '[cls]'
	  pn '[fading 16]'
	  pn '[code bg = "antenn.png"; set_bg()]'
	  pn '[fading 16]'
	  pn '[code walk "у входа в узел связи"]'
   end,
}

obj {
   nam = 'пушка',
   charged = false,
   inv = function(s)
	  local v = 'Древняя плазменная пушка. '
	  if s.charged then
		 v = v .. 'Заряжена.'
	  else
		 v = v .. 'Разряжена.'
	  end
	  return v
   end,
   use = function(s, w)
	  if s.charged then
		 if w ^ 'сервитор 3' then
			lifeoff(w)
			disable(w)
			w.dead = true
			return 'Я выстрелил в сервитора и, к своему удивлению, попал. С грохотом он свалился на землю.'
		 elseif w ^ 'сервиторы' then
			if w.n < 4 then
			   return 'Они ещё слишком далеко. Я не попаду.'
			else
			   return 'Я выстрелил в одного сервитора и он плавно начал заваливаться на бок, падая на землю.'
			end
		 else
			return 'Не стоит палить во что попало.'
		 end
	  else
		 return 'Пушка разряжена.'
	  end
   end,
}

obj {
   nam = 'аккумулятор',
   inv = 'Аккумулятор для старой плазменной пушки.',
   use = function(s, w)
	  if w ^ 'пушка' then
		 w.charged = true
		 disable(s)
		 return 'Я вставил аккумулятор в пушку. Готова к использованию.'
	  elseif w ^ 'Леонид 3' then
		 return 'Ему ни к чему аккумулятор.'
	  else
		 return 'Аккумулятор тут бесполезен.'
	  end
   end,
}

room {
   nam = 'смерть 3',
   disp = '. . .',
   decor = 'Пролетающий надо мной сервитор выстрелил из своего монструозного орудия. Я не успел отреагировать...' ..
   '{@ restore|А может всё было иначе?}',
}
