global {
   ep1_times = 0,
}

room {
   nam = 'ангар',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'В этой части Библиотеки по ночам холодно. Уже несколько дней мы с Леонидом путешествуем к своей цели, но она кажется всё так же практически недостижимой. Нет возможности бороться с сервиторами -- можно только убегать и вряд ли эта история закончится хорошо.^^Заброшенный ангар кажется весьма хорошим укрытием. Перед привалом не попадалось ни одного сервитора, что даёт надежду на возможность хорошо поспать. Тем не менее, мы всё равно дежурим по очереди. Через пару часов я смогу наконец поспать -- закончится моё ночное бдение.'
	  else
		 return 'Я нахожусь в ангаре.'
	  end
   end,
   onexit = function(s, t)
	  if t ^ 'возле ангара' and _'первый сервитор'.n > 0 then
		 lifeon 'первый сервитор'
	  end
   end,
   obj = {
	  obj {
		 nam = 'рельсы',
		 dsc = 'Вдоль ангара проложены {рельсы}.',
		 act = 'Старые и ржавые рельсы, по которым некогда в ангар закатывали челноки на ремонт.',
	  },
	  obj {
		 nam = 'фермы',
		 dsc = 'Под потолком находятся едва различимые в темноте ангара {фермы}.',
		 act = 'Фермы использовались для поднятия и опускания крупных узлов кораблей.',
	  },
	  obj {
		 nam = 'лестница',
		 dsc = function(s)
			if here() ^ 'ангар' then
			   return 'В дальнем от входа углу находится {лестница},'
			else
			   return 'Вниз ведёт {лестница}.'
			end
		 end,
		 act = 'Примитивная металлическая конструкция.',
	  },
	  obj {
		 nam = 'площадка',
		 dsc = 'ведущая на {площадку}.',
		 act = 'Площадка тянется вдоль торцевой стены.',
	  },
	  obj {
		 nam = 'тряпьё',
		 dsc = 'Под ней свалена куча {тряпья}.',
		 act = function(s)
			local v = 'Сорванные в разных залах портьеры, используемые нами вместо спальных мешков.'
			if disabled 'Леонид' then
			   v = v .. ' Где-то в этой куче спит Леонид.'
			   enable 'Леонид'
			end
			return v
		 end,
	  },
	  obj {
		 nam = 'Леонид',
		 sleep = true,
		 talked = false,
		 dsc = function(s)
			if s.sleep then
			   return 'В ней спит {Леонид}.'
			else
			   if here() ^ 'ангар' then
				  return 'Рядом с ней стоит {Леонид}.'
			   else
				  return 'Рядом со мной стоит {Леонид}.'
			   end
			end
		 end,
		 life = function(s)
			if player_moved() then
			   place(s)
			   if from() ^ 'площадка ангара' and here() ^ 'за ангаром' then
				  return 'Леонид спрыгнул вслед за мной.'
			   elseif from() ^ 'за ангаром' and here() ^ 'за забором' then
				  return 'Леонид перелез через забор.'
			   elseif not from() ^ 'первый разговор с Леонидом' then
				  return 'Леонид последовал за мной.'
			   end
			end
		 end,
		 act = function(s)
			if s.sleep then
			   if _'первый сервитор'.n == 0 then
				  return 'Пока ещё рано его будить. Отдых стал жизненно необходим для нас.'
			   else
				  s.sleep = false
				  return 'Я разбудил Леонида. Он быстро поднялся -- события последних дней сделали нас быстрыми и осторожными.'
			   end
			else
			   if not s.talked then
				  s.talked = true
				  walk 'первый разговор с Леонидом'
			   else
				  return 'Леонид выглядит уставшим. Наверное, я выгляжу не лучше.'
			   end
			end
		 end,
	  }:disable(),
	  obj {
		 nam = 'ворота',
		 dsc = '{Ворота} ангара закрыты.',
		 act = 'Большие ворота, через которые в ангар доставлялись челноки.',
	  },
	  obj {
		 nam = 'дверь',
		 dsc = 'Рядом с воротами находится {дверь}.',
		 act = 'Дверь открыта.',
	  },
   },
   way = {
	  path{'наверх', 'площадка ангара'},
	  path{'наружу', 'возле ангара'},
   },
}

dlg {
   nam = 'первый разговор с Леонидом',
   disp = 'разговор с Леонидом',
   noinv = true,
   enter = 'Я сказал Леониду.',
   phr = {
	  { 'Они нашли нас.', '-- Чёрт. Они стали очень быстрыми.',
		{ 'Это точно. Нужно бежать. Попробуем двинуться к узлу связи с другой станции.', function() p '-- Надеюсь, они не догадываются, что мы собираемся делать.'; lifeon 'Леонид'; end },
	  },
   },
}

room {
   nam = 'площадка ангара',
   seen = false,
   disp = 'площадка',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я осторожно поднялся на площадку. Вопреки моим опасениям, и лестница и площадка оказались в хорошем состоянии.'
	  else
		 return 'Я нахожусь на узкой площадке.'
	  end
   end,
   obj = {
	  'рельсы',
	  'фермы',
	  'лестница',
	  obj {
		 nam = 'окно',
		 dsc = 'В стене расположено небольшое {окно}.',
		 act = function(s)
			if _'Леонид'.talked and disabled 'за ангаром' then
			   enable 'за ангаром'
			end
			return 'За окном видна стена. В некотором отдалении от неё проходят железнодорожные пути. На платформе стоит поезд, на котором мы сюда добрались.'
		 end,
	  },
   },
   way = {
	  path{'вниз', 'ангар'},
	  path{'в окно', 'за ангаром'},
   },
}

function ep1_check(n)
   ep1_times = ep1_times + n
   if ep1_times == 31 then
	  enable 'первый сервитор'
	  lifeon 'первый сервитор'
   end
end

room {
   nam = 'возле ангара',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я вышел из ангара. Холодная ночь вызывает желание закутаться во что-нибудь тёплое и уснуть крепким сном.'
	  else
		 return 'Я нахожусь возле ангара.'
	  end
   end,
   onenter = function(s, f)
	  if _'первый сервитор'.n == 0 then
		 snapshots:remove()
		 snapshots:make()
	  end
   end,
   onexit = function(s, t)
	  lifeoff 'первый сервитор'
   end,
   obj = {
	  obj {
		 nam = 'ангары',
		 seen = false,
		 dsc = 'Несколько {ангаров} стоят в ряд.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   ep1_check(1)
			end
			return 'Во многих частях Библиотеки есть вот такие ремонтные базы. Некогда на них осуществлялся ремонт челноков, на которых посетители спускались на поверхность.'
		 end,
	  },
	  obj {
		 nam = 'наш ангар',
		 seen = false,
		 dsc = 'В {одном} из них мы остановились на ночлег.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   ep1_check(2)
			end
			return 'Мы выбрали ближайший ко входу на территорию базы. На случай, если придётся спасаться бегством.'
			end,
	  },
	  obj {
		 nam = 'забор вокруг базы',
		 seen = false,
		 dsc = 'Территория базы окружена {забором}.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   ep1_check(4)
			end
			return 'Высокий забор из бетона, декорированный снаружи под каменную кладку.'
		 end,
	  },
	  obj {
		 nam = 'кусты',
		 seen = false,
		 dsc = 'Одичалые за двести лет {кусты} растут тут и там на территории базы.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   ep1_check(8)
			end
			return 'Такие кусты тут и там растут на Библиотеке.'
		 end,
	  },
	  obj {
		 nam = 'звёзды',
		 seen = false,
		 dsc = 'Мерцающие {звёзды} над головой выглядят величественно.',
		 act = function(s)
			if not s.seen then
			   s.seen = true
			   ep1_check(16)
			end
			return 'Редко когда мне доводилось видеть столько звёзд, находясь на любой из планет, на которых мне довелось побывать. Обычно цивилизация даёт столько света, что небо выглядит пустым.'
		 end,
	  },
	  obj {
		 nam = 'первый сервитор',
		 n = 0,
		 dsc = function(s)
			if here() ^ 'возле ангара' then
			   if s.start == 1 then
				  return 'В воротах стоит {сервитор}.'
			   else
				  return 'Ко мне приближается {сервитор}.'
			   end
			end
		 end,
		 act = 'Очередной некогда безобидный библиотечный сервитор переделанный в боевую машину.',
		 life = function(s)
			if s.n < 1 then
			   p 'Со стороны ворот раздалось знакомое натужное механическое жужжание.'
			elseif s.n == 1 then
			   p 'Со стороны ворот доносится знакомое натужное механическое жужжание.'
			else
			   lifeoff(s)
			   walk 'смерть 1'
			end
			s.n = s.n + 1
		 end,
	  }:disable()
   },
   way = {
	  'ангар',
   },
}

room {
   nam = 'за ангаром',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я выпрыгнул в окно. Земля больно ударила по пяткам. Леонид последовал за мной.'
	  else
		 return 'Я нахожусь за ангаром.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'забор за ангаром',
		 dsc = 'Почти вплотную к стене ангара тянется {забор}.',
		 act = function(s)
			if disabled 'за забором' then
			   return 'Я попытался взобраться на забор, но не смог. Нужно что-то придумать.'
			else
			   return 'Теперь через забор можно перелезть.'
			end
		 end,
	  },
	  obj {
		 nam = 'решётка',
		 dsc = function(s)
			if where(s) ^ 'забор за ангаром' then
			   return 'К забору прислонена {решётка}.'
			else
			   return 'Возле стены ангара лежит какая-то {решётка}.'
			end
		 end,
		 tak = function(s)
			disable 'за забором'
			return 'Я взял решётку. Тяжёлая.'
		 end,
		 inv = 'На удивление крепкая, не взирая на свой возраст, решётка.',
		 use = function(s, w)
			if w ^ 'забор за ангаром' then
			   place(s, w)
			   enable 'за забором'
			   return 'Я прислонил решётку к забору. Теперь можно перелезть через него.'
			else
			   return 'Не стоит размахивать такой тяжёлой штукой.'
			end
		 end,
	  },
   },
   way = {
	  path{'через забор','за забором'},
   },
}:disable()

room {
   nam = 'за забором',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я аккуратно спрыгнул с забора на землю.^^Местность здесь достаточно пустынна.'
	  else
		 return 'Я наожусь за территорией ремонтной станции.'
	  end
   end,
   obj = {
	  obj {
		 nam = 'забор вокруг ангаров',
		 dsc = 'Рядом со мной тянется {забор}, окружающий территорию ремонтной станции.',
		 act = 'Забор слишком высокий -- не перелезть.',
	  },
	  obj {
		 nam = 'Ж/Д платформа в отдалении',
		 dsc = 'В отдалении видна железнодорожная {платформа}.',
		 act = 'Обычная железнодорожная платформа. Такие встречаются по всей Библиотеке.',
		 obj = {
			obj {
			   dsc = 'На ней стоит {поезд}.',
			   act = 'Старинный монорельсовый поезд.',
			},
		 },
	  },
   },
   way = {
	  'Ж/Д платформа',
   },
}:disable()

room {
   nam = 'Ж/Д платформа',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я подошёл к железнодорожной платформе.'
	  else
		 return 'Я нахожусь на железнодорожной платформе.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Широкий {перрон} тянется вдоль путей.',
		 act = 'Ничего особенного.',
	  },
	  obj {
		 dsc = 'На платформе стоит {поезд}.',
		 act = 'На этом поезде мы и приехали сюда. Подразумевалось, что мы сможем пешком добраться до ближайшей станции связи и захватить управление, чтобы послать сообщение наружу.',
	  },
   },
   way = {
	  path{'к ангарам', 'за забором'},
	  'вагон',
   },
}

room {
   nam = 'вагон',
   seen = false,
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я вошёл в вагон поезда. Обычный пассажирский вагон, рассчитанный на не слишком длительные поездки.'
	  else
		 return 'Я нахожусь в вагоне поезда.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'Вдоль вагона установлены {сидения}.',
		 act = 'Старые потрескавшиеся сидения.',
	  },
	  obj {
		 dsc = 'На потолке подвешены {плафоны}.',
		 act = 'Освещение в поезде включается автоматически.',
	  },
   },
   way = {
	  path{'наружу', 'Ж/Д платформа'},
	  path{'локомотив', 'локомотив 1'},
   },
}

room {
   nam = 'локомотив 1',
   seen = false,
   disp = 'локомотив',
   dsc = function(s)
	  if not s.seen then
		 s.seen = true
		 return 'Я прошёл в кабину локомотива.'
	  else
		 return 'Я нахожусь в кабине локомотива.'
	  end
   end,
   obj = {
	  obj {
		 dsc = 'За лобовым {стеклом} вдаль уходят пути.',
		 act = 'Обычное полимерное стекло.',
	  },
	  obj {
		 nam = 'пульт управления 1',
		 dsc = 'Почти всё пространство перед креслом машиниста занимает {пульт} управления поездом.',
		 act = function(s)
			lifeoff 'Леонид'
			walk 'конец эпизода 1'
		 end,
	  },
	  way = {
		 'вагон',
	  },
   },
}

room {
   nam = 'смерть 1',
   disp = '. . .',
   decor = 'Сервитор направил на меня свою смертоносную пушку. Я успел услышать громкий хлопок кинетического орудия и почувствовать как металлические обломки врезаются в мою плоть...^^' ..
	  '{@ restore|А может всё было иначе?}',
}

cutscene {
   nam = 'конец эпизода 1',
   noinv = true,
   disp = false,
   decor = function(s)
	  pn '{$nl}{$nl}Я коснулся сенсора и поезд начал ускорение.^^Спустя некоторое время мы неслись дальше, навстречу следующему пункту связи...^'
	  pn '[cut]'
	  pn '[code bg = "bg.png"; set_bg()]'
	  pn '[cls]'
	  pn '[fading 16]'
	  pn '[pause 1000]'
	  pn(fmt.y('50%') .. fmt.c('{$fnt play|ТРЕМЯ ДНЯМИ РАНЕЕ}'))
	  pn '[fading 16]'
	  pn '[pause 2000]'
	  pn '[cls]'
	  pn '[fading 16]'
	  pn '[code bg = "alley.png"; set_bg()]'
	  pn '[fading 16]'
	  pn '[code change_pl "тогда"]'
   end,
}
