--$Name: Гражданин$
--$Version: 0.945$
--$Author: Андрей Лобанов$
--$Info: Специально для "Паровозик 8: Вперёд, в будущее"$

require "fmt"
require "parser/mp-ru"
if not (instead.reinstead or instead.tiny) then
	require "sprite"
	require "theme"
	require "timer"
	require "snd"
end

VerbExtend {
	"#Talk",
	"{noun}/дт,live : Talk",
}

VerbExtendWord {
	"#Talk",
	"[ |по]звонить",
}

Verb {
	"#TalkPhone",
	"набрать",
	"{noun}/рд,live : Talk",
}

declare {
   tracks = {"mus/click3.it",
			 "mus/finite automat.it"},
   track = 0,
}

local font
local font_height
local font_color
local cursor
local blank
local cursor_visible
local spr

if not (instead.reinstead or instead.tiny) then
	font = sprite.fnt(theme.get "inv.fnt.name", theme.get "win.fnt.size")
	font_height = math.floor(sprite.font_scaled_size(font:height()) * 7 / 8)
	font_color = theme.get "inv.col.fg"
	cursor = ""
	blank = fmt.bottom(fmt.img("pad:0 0 0 1,blank:" .. math.floor(tostring(font_height / 2)) .. "x" ..
									 tostring(font_height)))
	
	instead.fading = false
	mp.prompt = "➤ "
	mp.cursor = cursor
end
mp.clear_on_move = false
mp:pager_mode(true)

function mp:pre_input(input)
	if input == "идти домой" then
		if here() ^ "парк" then
			return "идти к дому"
		else
			return "До дома далеко."
		end
	end
	return input
end

if not (instead.reinstead or instead.tiny) then
	game.dsc = fmt.imgr "pad:0 16 2 0,img/city.png" ..
		fmt.b "ГРАЖДАНИН " ..
		"версия 0.945^^" ..
		fmt.b "Движок: " .. fmt.tab"25%" .. "Петр Косых^" ..
		fmt.b "Игра: " .. fmt.tab "25%" .. "Андрей Лобанов^^" ..
		fmt.b "Тестирование: " .. fmt.tab "25%" .. "Бош Олег^" ..
		fmt.tab "25%" .. "Lucky Ook^" ..
		fmt.tab "25%" .. "Глеб Кузьмин^" ..
		fmt.tab "25%" .. "Петр Косых^^" ..
		fmt.b "Музыка: " .. fmt.tab "25%" .. "MAM - Click3^" ..
		fmt.tab "25%" .. "MAM - Finite Automat^^" ..
		"По мотивам романа Джеймса Блиша \"Жизнь ради звёзд\".^^" ..
		"Огромное спасибо моей жене за то, что помогла мне выделить время на создание этой игры.^^" ..
		"Если вам необходима справка по игре, наберите \"помощь\".^^" ..
		fmt.c "* * *"
else
	game.dsc = fmt.b "ГРАЖДАНИН " ..
		"версия 0.945^^" ..
		fmt.b "Движок: " .. "Петр Косых^" ..
		fmt.b "Игра: " .. "Андрей Лобанов^^" ..
		fmt.b "Тестирование: " .. "Бош Олег, Lucky Ook, Глеб Кузьмин, Петр Косых^^" ..
		fmt.b "Музыка: " .. "MAM - Click3, MAM - Finite Automat^^" ..
		"По мотивам романа Джеймса Блиша \"Жизнь ради звёзд\".^^" ..
		"Огромное спасибо моей жене за то, что помогла мне выделить время на создание этой игры.^^" ..
		"Если вам необходима справка по игре, наберите \"помощь\".^^" ..
		fmt.c "* * *"
end

function init()
	pl.word = -"я/мр,1л"
	if not (instead.reinstead or instead.tiny) then
		mp.msg.HELP = mp.msg.HELP():gsub(">", "➤")
		cursor = fmt.bottom(fmt.img("pad:0 0 0 1,box:" .. math.floor(tostring(font_height / 2)) .. "x" ..
									tostring(font_height) .. "," .. font_color))
		timer:set(500)
	end
end

function start(load)
	if not load then
		move(pl, "пролог")
	end
end

function game:timer()
   if cursor_visible then
	  mp.cursor = cursor
   else
	  mp.cursor = blank
   end
   cursor_visible = not cursor_visible
   if not snd.music_playing() then
	  track = track + 1
	  if track > #tracks then
		 track = 1
	  end
	  local n = tracks[track]
	  snd.music(n, 1);
   end
   return true, false
end

game.Sleep = function()
	if here() ^ "камера" and disabled "Роберт" then
		if _"Роберт".talk < 2 then
			open "дверь камеры"
			enable "Роберт"
			return "Не найдя чем занять себя, я лёг на койку и сам не заметил как заснул.^^Лязг замка и скрип открываемой двери разбудили меня. В камеру вошёл полицейский."
		end
	end
	return "Я не хочу спать."
end

game.Wait = function()
	if here() ^ "камера" and disabled "Роберт" then
		if _"Роберт".talk < 2 then
			open "дверь камеры"
			enable "Роберт"
			return "Лязгнул замок, дверь со скрипом открылась. В камеру вошёл полицейский."
		end
	end
	return "Прошло немного времени"
end

cutscene {
	nam = "пролог",
	text = {
		"Всё получилось совсем не так, как я себе представлял.",
		"Конечно, на гражданство я не рассчитывал, но был уверен, что без проблем стану пассажиром.",
		"Лейтенант сказал, что пассажиры должны отрабатывать своё пребывание в городе, а зайцы должны быть ликвидированы.",
		"Однако, мне принесли обед ничуть не хуже, чем был у меня на нашей ферме. Вряд ли меня бы покормили, если бы хотели убить.",
		"После обеда прошло достаточно много времени, но ко мне так никто и не пришёл.",
	},
	next_to = "камера",
}

obj {
		-"стена,стены",
	nam = "стены тюрьмы",
	description = "Серые бетонные стены. Ничего примечательного.",
	before_Take = "Как взять стену?",
	Smell = "Пахнет бетоном.",
	Taste = "Я не хочу пробовать стены на вкус.",
	Talk = "Я ещё не потерял рассудок, чтобы говорить со стенами.",
}:attr "scenery"

obj {
		-"потолок",
	nam = "потолок тюрьмы",
	description = "Серый бетонный потолок с одной лампой.",
	before_Take = "Взять потолок? Какие-то дурные идеи приходят в голову.",
	Smell = "Я не дотягиваюсь до потолка, чтобы понюхать его, но уверен, что ничем интересным он не пахнет.",
	Taste = "Даже если бы я мог дотянуться до потолка, я бы не стал пробовать его на вкус.",
	Talk = "Вряд ли с потолком получится вести содержательную беседу.",
}:attr "scenery"

obj {
		-"пол,покрытие",
	nam = "пол тюрьмы",
	description = "На полу какое-то тёмное немного пружинящее покрытие.",
	before_Take = "Невозможно взять пол.",
	Smell = "Пахнет чем-то незнакомым.",
	Taste = "Я ни за что не буду пробовать пол на вкус.",
}:attr "scenery"

room {
		-"камера,комната",
	nam = "камера",
	dsc = function(s)
		if s:once() then
			return "Не знаю сколько я нахожусь в этой камере. Чувство голода пока не очень сильное, так что наверняка прошло меньше суток... Интересно, как считают время в летающих городах? Раньше я об этом никогда не задумывался."
		else
			return "Я нахожусь в тесной камере."
		end
	end,
	onexit = function(s, t)
		if _"Роберт".talk < 2 and t ^ "коридор тюрьмы" then
			if disabled "Роберт" then
				return "Дверь заперта.", false
			else
				local name = "Полицейский"
				if _"Роберт".known then
					name = "Роберт"
				end
				return name .. " окликнул меня:^^-- Куда ты собрался, парень?", false
			end
		end
	end,
	obj = {
		obj {
				-"койка,кровать,нара",
			nam = "койка в камере",
			dsc = "Почти половину пространства занимает койка.",
			description = "Узкая жёсткая койка. По крайней мере нет клопов.",
			before_Take = "Койка намертво прикручена к полу.",
			Smell = "Пахнет каким-то синтетическим материалом.",
			Taste = "Я не буду пробовать койку на вкус. Я ещё не настолько проголодался.",
			Touch = "Податливая шершавая поверхность.",
		}:attr "static,supporter,enterable",
		obj {
				-"унитаз,туалет",
			nam = "унитаз",
			dsc = "В углу стоит унитаз.",
			description = "Я однажды видел такое устройство, когда был в был в городе. В обычном, а не летающем. У нас то на ферме туалеты были простыми будками над ямами.",
			before_Take = "Взять с собой унитаз? Без инструментов это сделать невозможно, да и не хочу я его брать.",
			Smell = "Хотя туалет и выглядит чистым, принюхиваться к нему у меня нет никакого желания.",
			Taste = "Фу... Порой в голову приходят фантастически дурацкие мысли.",
			Touch = "Холодный металл.",
			Use = "Я не хочу в туалет.",
		}:attr "static,supporter,enterable",
		door {
				-"дверь",
			nam = "дверь камеры",
			when_closed = function(s)
				if here() ^ "камера" then
					return "Дверь едва угадывается в стене."
				else
					return "Дверь в мою камеру ничем не отличается от остальных -- массивная металлическая дверь и внушительного вида механический замок."
				end
			end,
			when_open = function(s)
				if here() ^ "камера" then
					return "Открытая дверь ведёт из камеры."
				else
					return "Открытая дверь ведёт в камеру."
				end
			end,
			description = "Металлическая массивная дверь. Запирается снаружи, внутри нет даже ручки.",
			before_Take = "Дверь слишком крепка и тяжела, чтобы я мог её взять.",
			Smell = "Дверь не пахнет ничем примечательным.",
			Taste = "Я не настолько голоден, чтобы пробовать дверь на вкус.",
			Touch = "Гладкая и холодная дверь.",
			door_to = function(s)
				if here() ^ "камера" then
					return "коридор тюрьмы"
				else
					return "камера"
				end
			end,
		}:attr "static,close,openable,locked",
		obj {
				-"Роберт,Коннорс,Роберт Коннорс,полицейский,коп",
			nam = "Роберт",
			known = false,
			talk = 0,
			dsc = function(s)
				if s.known then
					return  "Рядом со мной стоит Роберт."
				else
					return "Рядом со мной стоит полицейский."
				end
			end,
			daemon = function(s)
				if player_moved() and not from() ^ "второй разговор с Робертом" then
					move(s, here())
					if here() ^ "мэрия" then
						DaemonStop(s)
					end
					local name = "Полицейский"
					if s.known then
						name = "Роберт"
					end
					p(fmt.em(name .. " пошёл со мной."))
				end
			end,
			description = function(s)
				if not s.known then
					s.known = true
					return "На груди полицейского есть нашивка с именем \"лт. Роберт Коннорс\"."
				else
					return "Роберт строго смотрит на меня."
				end
			end,
			before_Take = "Ему это вряд ли понравится.",
			Smell = "Мне не хочется принюхиваться к полицейскому.",
			Taste = "Ещё чего!",
			Touch = "Мне кажется неразумным трогать полицейского.",
			Talk = function(s)
				if s.talk == 0 then
					walk "разговор с Робертом"
				elseif s.talk == 1 then
					walk "второй разговор с Робертом"
				else
					local name = "Полицейский"
					if s.known then
						name = "Роберт"
					end
					if here() ^ "сквер около тюрьмы" then
						return name .. " остановил меня и сказал:^^-- Сейчас прилетит такси -- полетим в мэрию."
					elseif here() ^ "аэротакси" then
						return name .. " посмотрел на меня и сказал:^^-- Ну как тебе, парень?"
					elseif here() ^ "посадочная площадка" then
						return name .. " сказал мне:^^-- Пошли в мэрию."
					elseif here() ^ "мэрия" then
						if not disabled "мэр" then
							return name .. " сказал мне:^^-- Мэр ждёт разговора с тобой."
						else
							return name .. " посмотрел на меня и сказал:^^-- Вот и всё, парень."
						end
					end
					return name .. " посмотрел на меня и сказал:^^-- Давай скорее, парень."
				end
			end,
		}:attr "animate":dict {
			["Коннорс/рд"] = "Коннорса",
			["Коннорс/дт"] = "Коннорсу",
			["Коннорс/вн"] = "Коннорса",
			["Коннорс/тв"] = "Коннорсом",
			["Коннорс/пр"] = "Коннорсе",
			["Роберт Коннорс/рд"] = "Роберта Коннорса",
			["Роберт Коннорс/дт"] = "Роберту Коннорсу",
			["Роберт Коннорс/вн"] = "Роберта Коннорса",
			["Роберт Коннорс/тв"] = "Робертом Коннорсом",
			["Роберт Коннорс/пр"] = "Роберте Коннорск",
									  }:disable(),
		"стены тюрьмы",
		"потолок тюрьмы",
		"пол тюрьмы",
	},
	out_to = "коридор тюрьмы",
}

dlg {
	nam = "разговор с Робертом",
	disp = false,
	enter = "Я собрался было что-то сказать, но вошедший меня опередил:^^-- Кто ты и как проник в город?",
	onexit = function(s)
		_"Роберт".talk = 1
		disable "Роберт"
	end,
	phr = {
		{
			"Меня зовут Остин. Я сын фермера и пробрался в город тайком перед отлётом, чтобы сбежать со своей планеты и посмотреть мир.", "-- Сын фермера, говоришь. Сколько тебе лет?",
			{
				"14, сэр.", "-- Гхм... В защитном поле есть только одна брешь и она надёжно охраняется на всём протяжении срока исполнения контракта. Так как ты пробрался в город?",
				{
					"Я спрятался в ящике с оборудованием.", "-- Что ж. Я предупреждал мэра об этой проблеме с безопасностью. Нужно тщательнее досматривать груз. Теперь ответь на кого ты работаешь и какова твоя цель.",
					{
						"Я ни на кого не работаю. Надеялся найти работу у вас в городе.", "-- Ты же понимаешь, что город достаточно сильно ограничен в ресурсах и каждый пассажир должен хорошенько отрабатывать своё проживание?",
						{
							"Да. Я готов работать.", "-- Также ты должен понимать, что на твоё проживание никто не рассчитывал.",
							{
								"Вы меня высадите?", "-- Мы уже слишком далеко от твоего родного мира. Лучше запихнуть тебя в шлюз и открыть наружные створки или пустить на переработку. Но это лишь моё мнение -- твою судьбу буду решать не я и даже не мэр.",
								{
									"А кто же тогда?", "-- Отцы-основатели.",
									{
										"Отцы-основатели? Но я думал, ваш город старше антинекротиков. Неужели основатели настолько стары?", "-- Конечно они не основывали наш город на Земле. Это суперкомпьютеры, помогающие принимать все важные решения и регулировать жизнь города. Что ты за диверсант такой?",
										{
											"Я не диверсант! Я простой фермер, которому опостылело пыльное прозябание на отсталой аграрной планете.", "-- Как скажешь, приятель. Отцы разберутся.^^С этими словами он развернулся и вышел из камеры. Дверь со скрипом и лязгом закрылась обратно...",
										},
									},
								},
							},
						},
					}
				},
			},
		},
	},
}

dlg {
	nam = "второй разговор с Робертом",
	disp = false,
	enter = "Прежде, чем я успел заговорить, полицейский снова опередил меня:^^-- Отцы основатели вынесли решение о твоём будущем.",
	onexit = function(s)
		_"Роберт".talk = 2
		DaemonStart "Роберт"
	end,
	phr = {
		{
			"Что они решили?", "-- Тебе присвоен статус пассажира. Но не думай радоваться, по мне так лучше бы тебя отправили в переработку или вышвырнули за борт.",
			{
				"Почему? Я же ничего не сделал.", "-- Ну, во-первых, потому что твоя жизнь стоит ресурсов, а их не в избытке. А во-вторых, потому что работёнка тебя ждёт очень непростая и здоровью твоему она на пользу не пойдёт. Но с Отцами-основателями не спорят. Так что пойдём -- я отведу тебя в общежитие.",
			},
		},
	},
}

room {
		-"коридор",
	nam = "коридор тюрьмы",
	dsc = function(s)
		if s:once() then
			return "Я вышел в тесный коридор. Освещён он слабо и какой-то красотой и уютом не наделён. Наверное, примерно так тюрьмы выглядели всегда."
		else
			return "Я нахожусь в тюремном коридоре."
		end
	end,
	onenter = function(s, f)
		if s:once() then
			local name = "Полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return name .. " сказал:^^-- Вперёд по коридору."
		end
	end,
	onexit = function(s, t)
		if not t ^ "сквер около тюрьмы" then
			local name = "Полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return name .. " окликнул меня:^^-- Эй, парень! Тебе в другую сторону.", false
		end
	end,
	obj = {
		obj {
				-"замок",
			description = "Массивный механический замок.",
			before_Take = "Замок вмонтирован в дверь. Я бы не смог его взять даже если бы был тут один.",
			Smell = "Пахнет смазкой металлом.",
			Taste = "Я не хочу пробовать замок на вкус.",
			Touch = "Я потрогал рукоятку замка - тугая.",
			Talk = "Я ещё не в том состоянии, чтобы разговаривать с замком.",
		}:attr "scenery",
		obj {
				-"двери,камеры",
			dsc = "С обеих сторон коридора находятся двери.",
			description = "Насколько я понимаю, эти двери ведут в другие камеры.",
			before_Take = "Невозможно взять двери.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Я не буду пробовать двери на вкус.",
			Touch = "Гладкие и холодные двери.",
			Talk = "Я не хочу разговаривать с дверью.",
		}:attr "static",
		"дверь камеры",
		"стены тюрьмы",
		"потолок тюрьмы",
		"пол тюрьмы",
		door {
				-"выход,дверной проём",
			nam = "выход из тюрьмы",
			dsc = "В дальнем конце коридора виднеется светлый проём -- выход из тюрьмы.",
			description = "После полумрака камеры свет со стороны выхода кажется очень ярким.",
			before_Take = "Нельзя взять дверной проём.",
			Smell = "В коридоре ничем особенным не пахнет.",
			Taste = "Как можно попробовать на вкус дверной проём?",
			Touch = "В дверном проёме обычный воздух -- ничем не отличается от воздуха в коридоре.",
			Talk = "Не стоит разговаривать с дверными проёмами. Особенно при посторонних.",
			out_to = "сквер около тюрьмы",
		}:attr "static,open",
		door {
				-"камера",
			description = "Из коридора камера выглядит ещё меньше, чем изнутри.",
			before_Take = "Как можно взять тюремную камеру?",
			Smell = "В камере воздух пахнет так же, как и в камере.",
			Taste = "Пробовать тюремную камеру на вкус?",
			Touch = "Не хочу больше там находиться ни секунды.",
			Talk = "Говорить с камерой я совершенно не хочу.",
			door_to = "камера",
		}:attr "scenery,open",
	},
	in_to = "камера",
	out_to = "сквер около тюрьмы",
}

obj {
		-"небо,купол,силовое поле",
	nam = "небо",
	seen = false,
	description = function(s)
		s.seen = true
		return "Небо над городом всегда тёмное и полно света звёзд, сумевших затмить огни фонарей и окон. Лишь едва уловимое свечение силового поля, накрывающего город тонким защитным колпаком, немного светится, если посмотреть на небо боковым зрением."
	end,
	before_Take = function(s)
		if not s.seen then
			return "Невозможно взять небо."
		else
			return "Невозможно взять силовое поле, заменяющее небо в летающих городах."
		end
	end,
	Smell = "Воздух в городе пахнет редкой зеленью, пылью и чем-то непривычным.",
	Taste = "Воздух на вкус мало чем отличается от воздуха моей родной планеты.",
	Touch = "Я не могу дотянуться до неба.",
	Talk = "Мне нечего сказать этому незнакомому небу.",
}:attr "scenery"

obj {
		-"земля,асфальт",
	nam = "асфальт",
	description = "Под ногами обычный асфальт.",
	before_Take = "Невозможно взять {#first/им}.",
	Smell = "Асфальт пахнет пылью.",
	Taste = "Я не буду пробовать асфальт на вкус. Надеюсь никогда и не придётся.",
	Touch = "Я дотронулся до асфальта. Твёрдый и шершавый.",
	Talk = "Говорить с асфальтом?",
}:attr "scenery"

room {
	-"сквер*",
	nam = "сквер около тюрьмы",
	n = 0,
	dsc = function(s)
		if s:once() then
			return "Я вышел из тюрьмы в небольшой сквер. Яркий свет, который я видел из коридора, оказался лишь светом уличных фонарей."
		else
			return "Я нахожусь в небольшом сквере около здания тюрьмы."
		end
	end,
	enter = function(s)
		if s.n == 0 then
			lifeon(here())
			local name = "полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return "Как только мы вышли, " .. name .. " проговорил что-то неразборчивое в своё переговорное устройство."
		end
	end,
	onexit = function(s, t)
		if t ^ "коридор тюрьмы" then
			local name = "Полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return name .. " окликнул меня:^^-- Эй, парень! Ты куда?", false
		end
	end,
	life = function(s)
		if s.n < 3 then
			s.n = s.n + 1
		else
			lifeoff(s)
			enable "дверь аэротакси"
			return "На площадку в центре сквера опустилось округлое аэротакси."
		end
	end,
	obj = {
		obj {
				-"тюрьма,здание,здание тюрьмы",
			nam = "тюрьма",
			description = "Серое невзрачное здание тюрьмы. Приятно оттуда выйти.",
			before_Take = "Невозможно взять большое здание. Разве что штурмом.",
			Smell = "Ничем примечательным не пахнет.",
			Taste = "Пробовать здания на вкус -- странная идея.",
			Talk = "Не хочу ничего говорить этому гнусному зданию",
		}:attr "scenery",
		obj {
				-"трава,газоны",
			nam = "трава",
			dsc = "На газонах растёт трава.",
			description = "Аккуратно подстриженная газонная трава.",
			before_Take = "Рука было уже потянулась сорвать несколько травинок, но строгий взгляд полицейского остановил мой порыв.",
			Smell = "Пахнет совсем как дома.",
			Taste = "Меня не так давно кормили, чтобы я решил попробовать есть траву с газона.",
			Talk = "Дома я иногда разговаривал с растениями, но в присутствии полицейского почему-то стесняюсь.",
		}:attr "static",
		obj {
				-"деревья,дерево",
			nam = "деревья",
			dsc = "Вдоль дорожек растут аккуратно посаженные деревья.",
			description = "Самые обычные деревья. Совсем как дома.",
			before_Take = "Наверное, если бы я мог выкорчевать дерево голыми руками, я бы смог его и взять с собой, но я не супермен.",
			Smell = "Пахнет молодой листвой. Наверное, тут есть какое-то подобие времён года. Нужно будет спросить об этом у кого-нибудь при случае.",
			Taste = "Я не готов грызть древесину.",
			Talk = "Дома я иногда разговаривал с растениями, но в присутствии полицейского почему-то стесняюсь.",
		}:attr "static",
		obj {
				-"дорожки,тропинки,дороги",
			nam = "дорожки в сквере",
			description = "Узкие дорожки -- только вдвоём пройти.",
			before_Take = "Взять асфальтовую дорожку? Это как?",
			Smell = "Пахнет пылью.",
			Taste = "Я не хочу пробовать асфальт на вкус. Надеюсь никогда и не придётся.",
			Talk = "Говорить с асфальтом?",
		}:attr "scenery",
		door {
				-"такси,аэротакси",
			nam = "дверь аэротакси",
			description = "Красивый округлый аппарат.",
			before_Take = "Аэротакси большое и тяжёлое. Мне его даже не сдвинуть.",
			Taste = "Я не хочу пробовать такси на вкус.",
			Smell = "Пахнет какой-то пластмассой.",
			Talk = "Я не хочу разговаривать с такси.",
			door_to = "аэротакси",
		}:attr "static,open":disable(),
		"небо",
		"асфальт",
	},
	in_to = "коридор тюрьмы",
}

room {
		-"аэротакси",
	nam = "аэротакси",
	n = 0,
	dsc = function(s)
		if s:once() then
			return "Я сел в аэротакси."
		else
			return "Я нахожусь в аэротакси."
		end
	end,
	enter = function(s)
		if s.n == 0 then
			lifeon(s)
		end
	end,
	onexit = function(s, t)
		if disabled(t) then
			return "Такси находится в воздухе -- из него нельзя выйти.", false
		end
	end,
	life = function(s)
		if s.n < 5 then
			s.n = s.n + 1
		else
			lifeoff(s)
			enable "посадочная площадка"
			enable "мэрия объект"
			disable "аэротакси в полёте"
			disable "здания в полёте"
			return "Такси плавно приземлилось перед высоким красивым зданием."
		end
	end,
	obj = {
		obj {
				-"сидения,сидение",
			dsc = "Четыре пассажирских сидения занимают всё пространство такси.",
			description = "Мягкие сидения с обивкой из неизвестного мне материала.",
			before_Take = "Сидения крепко прикреплены к стенам такси.",
			Taste = "Я не хочу пробовать сидения на вкус.",
			Smell = "Пахнет странно.",
			Talk = "Я не буду разговаривать с сидениями.",
		}:attr "static,supporter,enterable",
		obj {
				-"окно,стекло",
			dsc = function(s)
				if here().n < 5 then
					return "За окном проносятся красивые здания."
				else
					return "За окном видно небольшое, но очень красивое здание."
				end
			end,
			description = "Твёрдое и холодное.",
			before_Take = "Возможно, мне бы и удалось выломать хотя бы кусочек окна, но я не хочу ничего ломать в городе. Тем более, когда рядом находится полицейский.",
			Taste = "Я не буду пробовать на вкус окно.",
			Smell = "Не пахнет ничем особенным.",
			Talk = "Говорить с окнами? Странная идея.",
		}:attr "static",
		obj {
				-"такси,аэротакси",
			nam = "аэротакси в полёте",
			dsc = "В воздухе видно множество других аэротакси.",
			description = "Красивые округлые аппараты без пилотов, летающие над всем городом.",
			before_Take = "Они большие и тяжёлые. К тому же я сам сижу в одном из них.",
			Taste = "Такси снаружи, а я внутри. Но даже будь это не так, я бы не хотел пробовать их на вкус.",
			Smell = "Вряд ли их запах отличается от того, что я чувствую сидя в одном из них.",
			Talk = "Я не хочу разговаривать с такси.",
		}:attr "static",
		obj {
				-"здания,город",
			nam = "здания в полёте",
			description = "Строгие и высокие здания. Не думал, что в городе живёт столько народу.",
			before_Take = "Поднять даже небольшую хижину человек не смог бы. А тут большие здания.",
			Taste = "Пробовать дома на вкус? Зачем?",
			Smell = "Я не могу узнать чем они пахнут, сидя в такси.",
			Talk = "Говорить с домами... Пожалуй, нет.",
		}:attr "scenery",
		obj {
				-"здание,мэрия",
			nam = "мэрия объект",
			dsc = "Из такси видно небольшое, но красивое здание.",
			description = "Трёхэтажное и красивое здание с колоннами перед входом.",
			before_Take = "Невозможно взять даже небольшое здание.",
			Taste = "Я не стал бы пробовать здание на вкус, даже если бы стоял рядом с ним.",
			Smell = "Я не знаю чем пахнет это здание.",
			Talk = "Говорить с домами... Пожалуй, нет.",
		}:attr "static",
	},
	out_to = "посадочная площадка",
}

room {
		-"посадочная площадка",
	nam = "посадочная площадка",
	entered = false,
	dsc = function(s)
		if s:once() then
			return "Я вышел из такси."
		else
			return "Я нахожусь на посадочной площадке."
		end
	end,
	onenter = function(s)
		if not s.entered then
			s.entered = true
			local name = "Полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return name .. " подошёл ко мне и сказал:^^-- Это мэрия. Сейчас мэр официально объявит решение о твоей будущей судьбе. Просто формальность."
		else
			if disabled "мэр" then
				walk "новая жизнь"
			end
		end
	end,
	obj = {
		door {
				-"мэрия,здание",
			dsc = "Прямо передо мной стоит красивое здание.",
			description = "Трёхэтажное и красивое здание с колоннами перед входом.",
			before_Take = "Невозможно взять даже небольшое здание.",
			Taste = "Я не стал бы пробовать здание на вкус, даже если бы стоял рядом с ним.",
			Smell = "Я не знаю чем пахнет это здание.",
			Talk = "Говорить с домами... Пожалуй, нет.",
			door_to = "мэрия",
		}:attr "static,open",
		obj {
				-"трава,газоны",
			dsc = "На газонах возле него растёт трава.",
			description = "Аккуратно подстриженная газонная трава.",
			before_Take = "Рука было уже потянулась сорвать несколько травинок, но строгий взгляд полицейского остановил мой порыв.",
			Smell = "Пахнет совсем как дома.",
			Taste = "Меня не так давно кормили, чтобы я решил попробовать есть траву с газона.",
			Talk = "Дома я иногда разговаривал с растениями, но в присутствии полицейского почему-то стесняюсь.",
		}:attr "static",
	},
	in_to = "мэрия",
}:disable()

room {
	nam = "второй этаж мэрии",
}

room {
		-"мэрия",
	nam = "мэрия",
	dsc = function(s)
		if s:once() then
			return "Я вошёл в красивое здание мэрии."
		else
			return "Я нахожусь в здании мэрии."
		end
	end,
	onexit = function(s, w)
		if w ^ "второй этаж мэрии" then
			local name = "полицейский"
			if _"Роберт".known then
				name = "Роберт"
			end
			return "Я собрался подняться на второй этаж, но " .. name .. " жестом остановил меня.", false
		elseif w ^ "посадочная площадка" then
			if not disabled "мэр" then
				local name = "полицейский"
				if _"Роберт".known then
					name = "Роберт"
				end
				return "Я собрался выйти на посадочную площадку, но " .. name .. " мягко взял меня за плечо и спросил:^^-- Куда это ты собрался?", false
			end
		end
	end,
	obj = {
		obj {
				-"люстра,лампа",
			nam = "люстра",
			dsc = "С потолка свисает огромная красивая люстра.",
			description = "Большое количество стекла заставляет люстру фантастически сверкать.",
			before_Take = "Люстра огромная и тяжёлая.",
			Smell = "Люстра не пахнет ничем особенным.",
			Taste = "Люстра висит высоко, но даже если бы это было не так,",
			Talk = "Я не думаю, что это хорошая идея.",
		}:attr "static",
		door {
				-"лестница",
			nam = "лестница мэрии",
			dsc = "Широкая лестница ведёт на второй этаж.",
			description = "Красивая широкая лестница.",
			before_Take = "Невозможно взять лестницу -- это же часть здания.",
			Smell = "Ничем особенным лестница не пахнет.",
			Taste = "Я не хочу пробовать лестницу на вкус.",
			Talk = "Я не буду разговаривать с лестницей.",
			door_to = "второй этаж мэрии",
		}:attr "static,open",
		obj {
				-"мэр,мужчина,Джейкоб,Пирси,Джейкоб Пирси",
			nam = "мэр",
			dsc = "У лестницы стоит какой-то мужчина в строгом костюме.",
			description = "Солидный мужчина средних лет. Мне почему-то кажется, что это мэр города.",
			before_Take = "Не думаю, что ему это понравится.",
			Smell = "Мужчина не пахнет ничем особенным.",
			Taste = "Я не буду пробовать людей на вкус.",
			Talk = function(s)
				walk "разговор с мэром"
			end,
		}:attr "animate",
		obj {
				-"пол,паркет",
			description = "Чистый паркетный пол.",
			before_Take = "Пол невозможно взять.",
			Smell = "Пол ничем особенным не пахнет.",
			Taste = "Я не хочу пробовать пол на вкус.",
			Talk = "Я не думаю, что разговаривать с полом хорошая идея.",
		}:attr "scenery",
		obj {
				-"стены",
			description = "Стены покрашены в приятный тёплый цвет.",
			before_Take = "Я не могу взять стены -- это же часть здания.",
			Smell = "Стены ничем не пахнут.",
			Taste = "Я не буду пробовать стены на вкус.",
			Talk = "Разговаривать со стенами -- верный признак сумасшествия. Так говорил мой папаша.",
		}:attr "scenery",
		door {
				-"второй этаж",
			description = "Отсюда мало что можно рассмотреть.",
			before_Take = "Невозможно просто взять целый этаж.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Я не хочу пробовать на вкус никакую часть здания.",
			Talk = "Говорить лучше с людьми, а не с этажами.",
			door_to = "второй этаж мэрии",
		}:attr "scenery,open",
	},
	u_to = "второй этаж мэрии",
	out_to = "посадочная площадка",
}

dlg {
	nam = "разговор с мэром",
	disp = false,
	onenter = "Я почувствовал робость и кое как выдавил из себя:^^-- Здравствуйте.^^-- Здравствуй, Остин, -- мэр облокотился о перила лестницы и продолжил, -- Я мэр этого города Джейкоб Пирси. Отцы-основатели решили, что от тебя в качестве пассажира будет толк.",
	onexit = function(s)
		disable "мэр"
	end,
	phr = {
		{ "Рад это слышать, сэр.", "-- Не спеши с выводами. Перелёт будет длиться почти полторы сотни лет и только граждане увидят настоящее небо над головой. Если, конечно, нам повезёт заключить контракт по прибытию.",
		  { "Я знаю, что города летают быстро, но недостаточно, чтобы обычный человек побывал больше, чем в одном мире. Но, сэр, я уверен, что жизнь в городе гораздо лучше, чем на ферме.", "-- Возможно. Однако, я обязан тебя известить: существует лотерея, проводящаяся среди избранных пассажиров, сдавших экзамен на гражданство. Победитель лотереи получает доступ к антинекротикам. Правда проводится эта лотерея нечасто и требует довольно тяжёлого обучения.",
			{ "Я готов учиться. В школе я был весьма сообразителен, сэр.", "-- Результат обучения мало зависит от личных качеств, сынок. Готов спорить, с такими учителями тебе сталкиваться не доводилось... Кхм. Обучением занимаются Отцы-основатели, напрямую работая с твоим мозгом. А вот результаты экзамена уже полностью зависят от человека.",
			  { "Людей обучают машины? Невероятно!", "-- Не более невероятно, чем всё остальное, чем они занимаются в нашем городе. И второе: пассажир может получить гражданство за особые заслуги перед городом. Но это ещё более редкое явление.",
				{ "Особые заслуги?", "-- Например, спася город от опасности, угрожающей уничтожением городу. Но не думаю, что ты увидишь нечто такое. За семьсот лет, что я являюсь мэром, не было ни одного прецедента. Хотя, мой первый советник получил гражданство именно таким способом.",
				  { "Понятно. Статус пассажира меня более чем устраивает.", "-- Рад это слышать, сынок. Роберт, -- мэр кивнул в сторону полицейского, -- проводит тебя в общежитие. Сперва получишь специальность и начнёшь работать, а как только начнёшь приносить городу пользу, получишь полноценный статус пассажира. Удачи.^^С этими словами Пирси поднялся на второй этаж." },
				},
			  },
			},
		  },
		},
	},
}

cutscene {
	nam = "новая жизнь",
	disp = false,
	onenter = function(s)
		p(fmt.c "* * *")
	end,
	text = {
		"Так началась моя новая жизнь.",
		"Жизнь пассажира летающего города Бостон.",
		"Джейкоб Пирси и Роберт Коннорс не соврали -- работёнка мне досталась та ещё.",
		"Меня взяли на очистку нагревательных колодцев и работа оказалась достаточно тяжёлой, чтобы иногда после смены я задумывался -- а не прав ли был Коннорс, когда говорил, что лучше бы меня отправили на переработку.",
		"Впрочем, я достаточно быстро привык к монотонному и тяжёлому труду.",
		"Коннорс взял на себя опеку надо мной пока я не достигну совершеннолетия. Он оказался неплохим человеком, хоть и копом.",
		"Каждый день, после двенадцатичасовой смены, я иду учиться у Отцов-основателей.",
		"Это трудно назвать обучением в привычном понимании -- эти огромные компьютеры загружают море информации прямо в мой задурманенный специальными препаратами мозг.",
		"По хорошему после сеанса такого обучения следует хорошенько поспать, но это удаётся мне далеко не всегда.",
		"Во-первых, у меня есть обязанности по дому.",
		"А во-вторых, моё маленькое секретное хобби. Я нашёл способ таскать книги из публичной библиотеки. Те книги, к которым у меня пока нет доступа.",
		"Прямо сейчас я вместо отдыха после смены собираюсь пойти в свой тайник в складах и заняться чтением. Благо учёбы у меня сегодня нет.",
	},
	next_to = "раздевалка",
}

obj {
		-"полотенце",
	nam = "полотенце",
	description = "Простое полотенце неопределённого цвета.",
	Smell = "Пахнет влажной тканью.",
	Taste = "Лучше поем попозже что-нибудь больше съедобное.",
	Talk = "Я не настолько одинок, чтобы разговаривать с куском ткани.",
}:attr "clothing"

obj {
		-"стены",
	nam = "стены завода",
	description = "Стены покрашены синей краской.",
	before_Take = "Взять стены? Это как?",
	Smell = "Пахнет пылью.",
	Taste = "Я не хочу пробовать пыльные стены на вкус.",
	Talk = "Разговаривать со стенами -- признак умственного недуга.",
}:attr "scenery"

obj {
		-"пол",
	nam = "пол завода",
	description = "Бетонный пол с каменной крошкой. Совершенно ничем не примечателен.",
	before_Take = "Взять пол? Вряд ли я смогу.",
	Smell = "Пахнет пылью.",
	Taste = "Пробовать пол на вкус? Ну уж нет!",
	Talk = "Вряд ли пол сможет мне что-то сказать.",
}:attr "scenery"

obj {
		-"потолок",
	nam = "потолок завода",
	description = "Когда-то белый, а сейчас серый от пыли потолок. Через равные промежутки на нём висят лампы.",
	before_Take = "До потолка не дотянуться -- слишком высоко.",
	Smell = "Вряд ли он пахнет чем-то необычным, но проверять мне не хочется.",
	Taste = "Даже если бы я мог дотянуться до потолка, мне бы не пришла в голову такая идея.",
	Talk = "Потолок не ответит.",
	obj = {
		obj {
				-"лампы,лампа,лампочка,лампочки",
			description = "Белые плафоны, светящие ярким желтоватым светом.",
			before_Take = "Слишком высоко.",
			Smell = "Вряд ли лампы пахнут чем-то необычным.",
			Taste = "Отец рассказывал мне анекдот про лампочку во рту.",
			Talk = "Разговаривать с лампочками слишком странная идея, чтобы он пришла мне в голову, но она пришла. Правда говорить всё равно не хочется.",
		}:attr "static",
	},
}:attr "scenery"

room {
	-"раздевалка",
	nam = "раздевалка",
	first = false,
	dsc = function(s)
		if s:once() then
			return "После смены так приятно принять прохладный душ. В нагревательных колодцах жутко жарко и обильно потеть в асбестовом костюме очень неприятно... В общем, я вышел в раздевалку после душа, учёбы сегодня не было, а значит меня не будет мутить и тошнить до глубокой ночи. Может, даже удастся лечь спать пораньше."
		else
			return "Я нахожусь в раздевалке."
		end
	end,
	onenter = function(s, f)
		if not s.first then
			s.first = true
			take "полотенце"
			_"полотенце":attr "worn"
		end
	end,
	onexit = function(s, t)
		if _"одежда":hasnt "worn" then
			return "Стоит одеться перед выходом.", false
		elseif not where "полотенце" ^ "мой шкаф" then
			return "Нужно убрать полотенце перед уходом.", false
		end
	end,
	obj = {
		obj {
				-"шкафчики,шкафы",
			dsc = "Ровными рядами здесь стоят шкафчики.",
			description = "Металлические шкафы с кодовыми замками.",
			before_Take = "Шкафы соединены между собой в единое целое и их не так то просто поднять.",
			Smell = "Пахнет металлом.",
			Taste = "Я не собираюсь пробовать шкафы на вкус.",
			Talk = "Я не хочу разговаривать со шкафами.",
		}:attr "static,supporter",
		obj {
				-"шкафчик,шкаф,мой шкаф,мой шкафчик",
			nam = "мой шкаф",
			dsc = function(s)
				p "Один из них мой."
				mp:content(s)
			end,
			description = function(s)
				p "Обычный металлический шкаф в раздевалке. Такой же как и остальные."
				mp:content(s)
			end,
			before_Take = "Шкаф крепко соединён с соседними. Мне его не поднять.",
			Smell = "Пахнет металлом.",
			Taste = "Я не собираюсь пробовать свой шкаф на вкус.",
			Talk = "Я не буду разговаривать со своим шкафом.",
			obj = {
				obj {
						-"шкафчик,шкаф,мой шкаф, мой шкафчик",
					nam = "#вшкафу",
					dsc = function(s)
						if parent(s):has "open" then
							mp:content(s)
						end
					end,
					before_LetGo = function(s)
						if parent(s):hasnt "open" then
							return "Шкафчик закрыт."
						end
						return false
					end,
					obj = {
						obj {
								-"одежда,вещи,шмотки,карман",
							nam = "одежда",
							before_Wear = function(s)
								if have "полотенце" and _"полотенце":has "worn" then
									return "Надевать одежду поверх полотенца?"
								end
								return false
							end,
							description = function(s)
								local t = "Ничего примечательного. Простые брюки, рубашка, штаны и ботинки. Пассажиры одеваются достаточно скромно."
								if where("ключ-карта") == s then
									t = t .. " В кармане брюк лежит ключ-карта."
								end
								return t
							end,
							Smell = "Пахнет приятно. Сэнди, жена Роберта, вчера постирала мою одежду.",
							Taste = "Я не настолько голоден, чтобы есть свою одежду.",
							Talk = "Я не очень хочу разговаривать со своей одеждой.",
							obj = {
								obj {
										-"ключ-карта,карта,карточка,ключ",
									nam = "ключ-карта",
									description = "Пластиковая карточка для турникета на проходной.",
									Smell = "Пахнет пластмассой.",
									Taste = "Не хочу знать какова она на вкус.",
									after_Insert = function(s, t)
										if t ^ "турникет" then
											t:attr "~lock"
											t:attr "open"
											return "Я вставил ключ-карту в прорезь турникета и он открылся."
										elseif t ^ "одежда" then
											return "Я положил ключ-карту в карман."
										end
										return false
									end,
								}:dict {
									["ключ-карта/вн"] = "ключ-карту",
									["ключ-карта/рд"] = "ключ-карту",
									["ключ-карта/дт"] = "ключ-карте",
									["ключ-карта/тв"] = "ключ-картой",
									["ключ-карта/пр"] = "ключ-карте",
									   },
							},
						}:attr "clothing,transparent,container,open" ,
					},
				}:attr "static,container,open",
			},
		}:attr "static,supporter,openable",
		obj {
				-"лавки,лавочки",
			nam = "лавки в раздевалке",
			dsc = "Между шкафами стоят длинные лавки.",
			description = "Узкие пластмассовые лавки.",
			before_Take = "Они большие и тяжёлые. И нужны мне только в раздевалке. Пусть стоят на месте.",
			Smell = "Я не очень хочу их нюхать.",
			Taste = "Фу. Пробовать на вкус пластмассу, на которой сидят работяги после смены?",
			Talk = "Разговаривать с мебелью -- не очень здоровая идея.",
		}:attr "static,supporter",
		door {
				-"дверь,коридор",
			dsc = "Дверь ведёт в коридор.",
			door_to = "коридор завода",
		}:attr "static,open",
		"пол завода",
		"стены завода",
		"потолок завода",
	},
	out_to = "коридор завода",
}

room {
		-"коридор",
	nam = "коридор завода",
	dsc = function(s)
		if s:once() then
			return "Я вышел в коридор завода. Пусто... Окончание моей смены редко совпадает с другими сменами."
		else
			return "Я нахожусь в коридоре завода."
		end
	end,
	obj = {
		door {
				-"проходная",
			dsc = "Коридор ведёт из раздевалки к проходной.",
			door_to = "проходная",
		}:attr "static,open",
		door {
				-"раздевалка",
			dsc = false,
			door_to = "раздевалка",
		}:attr "static,open",
		obj {
				-"плакаты,плакат",
			dsc = "На одной стене висят плакаты.",
			description = "В основном это плакаты по технике безопасности и воодушевляющие лозунги про усердный труд.",
			before_Take = "Я не хочу заниматься вандализмом.",
			Smell = "Пахнет старой бумагой.",
			Taste = "Не хочется пробовать бумагу на вкус.",
			Talk = "Плакаты могут мне кое что сказать. Я им -- нет.",
		}:attr "static",
		obj {
				-"окна,окно,улица",
			dsc = "На другой расположены окна, выходящие на улицу.",
			description = "За окном видна улица. Движение в промзоне в это время суток практически отсутствует.",
			before_Take = "Я не могу взять {#first/тв}.",
			Smell = "{#First/им} ничем не пахнет.",
			Taste = "Я не хочу пробовать {#first/вн} на вкус.",
		}:attr "static",
		"пол завода",
		"стены завода",
		"потолок завода",
	},
	out_to = "проходная",
}

room {
		-"проходная",
	nam = "проходная",
	dsc = function(s)
		if s:once() then
			return "Я подошёл к проходной."
		else
			return "Я стою у проходной."
		end
	end,
	onexit = function(s, t)
		if not t ^ "разговор с охранником" then
			if _"турникет":has "lock" then
				return "Турникет закрыт.", false
			elseif where "ключ-карта" ^ "турникет" then
				return "Охранник окликнул меня:^^-- Остин, ты забыл карточку.", false
			end
			_"турникет".attr "lock"
		end
	end,
	obj = {
		obj {
				-"охранник",
			nam = "охранник",
			dsc = "Возле турникета сидит охранник.",
			description = "Рон -- один из четырёх охранников, работающих на проходной.",
			Smell = "Неприлично принюхиваться к людям.",
			Taste = "Думаю, Рон не оценит такой душевный порыв.",
			Talk = function(s)
				if s:once() then
					walk "разговор с охранником"
					return
				end
				return "Пожалуй, не буду его отвлекать от кроссворда."
			end,
			obj = {
				obj {
						-"кроссворд",
					description = "Охранники тратят на них уйму времени.",
					before_Take = "Рону это не понравится.",
					Smell = "Нюхать кроссворд и так странная идея, а когда его кто-то разгадывает.",
					Taste = "Жевать бумагу совсем не хочется.",
					Talk = "Разговаривать с кроссвордами?",
				}:attr "static",
			},
		}:attr "animate",
		obj {
				-"турникет",
			nam = "турникет",
			dsc = "Выход преграждает турникет.",
			description = "Незамысловатое устройство, блокирующее проход.",
			before_Take = "Турникет крепко закреплён. Да и вряд ли охранник одобрит такое действие.",
			Smell = "Пахнет металлом.",
			Taste = "Я не хочу пробовать турникет на вкус.",
			Talk = "Лучше поговорить с охранником.",
			with_key = "ключ-карта",
			after_Recieve = function(s, w)
				if w ^ "ключ-карта" then
					s:attr "~lock"
				end
			end,
		}:attr "container,open,lock",
		door {
				-"коридор",
			dsc = "Коридор ведёт к раздевалкам.",
			description = "Широкий и длинный коридор.",
			door_to = "коридор завода",
		}:attr "scenery,open",
		"пол завода",
		"стены завода",
		"потолок завода",
	},
	out_to = "улица Неизвестных Героев",
}

dlg {
	nam = "разговор с охранником",
	disp = false,
	phr = {
		{ "Привет, Рон. Как служба?", "-- Привет, Остин. Идёт. Куда она денется?",
		  { "Как семья?", "-- Малая скоро в школу пойдёт. Настоящая красавица растёт. А как у тебя дела?",
			{ "Сегодня свободный день -- думаю погулять по городу. Никак не насмотрюсь на него.", "-- Знаешь, я тут живу всю жизнь, но не устаю бродить по улицам и глазеть по сторонам. Слыхал, что Бостон -- не самый красивый город, но любовь слепа, -- Рон усмехнулся.",
			  { "Ладно, Рон, пока.", "-- Счастливо, парень." },
			},
		  },
		},
	},
}

obj {
		-"газоны|газон,трава,травка",
	nam = "газоны",
	dsc = function(s)
		if here() ^ "улица Неизвестных Героев" then
			return "Вдоль дороги тянутся ухоженные газоны."
		elseif here() ^ "парк" then
			return "Вдоль дорожек тянутся ухоженные газоны."
		end
	end,
	description = "Зелёная травка радует глаз даже в свете фонарей.",
	before_Take = "Я сорвал травинку, размял в руке, наслаждаясь ароматом, и бросил обратно на газон.",
	Smell = "Приятно пахнет зеленью.",
	Taste = "Лучше я поем дома.",
	Talk = "Я не думаю, что имеет смысл общаться с травой.",
}:attr "static"

room {
		-"улица",
	nam = "улица Неизвестных Героев",
	dsc = function(s)
		if s:once() then
			return "Я вышел с территории завода на улицу Неизвестных Героев. Это достаточно большая улица, на которой расположено несколько промышленных комплексов."
		else
			return "Я нахожусь на улице Неизвестных Героев."
		end
	end,
	onexit = function(s, t)
		if t ^ "тоннель под заводом" and _"люк":hasnt "open" then
			return "Люк закрыт.", false
		end
	end,
	obj = {
		door {
				-"завод,проходная",
			nam = "завод",
			dsc = "Прямо передо мной раскинулся огромный завод.",
			description = "На этом заводе я работаю на очистке нагревательных колодцев. Надеюсь, я смогу получить менее неприятную работу.",
			Smell = "Даже отсюда чувствуется запах горячего металла.",
			Taste = "Не хочу пробовать завод на вкус. Достаточно того, что я тут работаю.",
			Talk = "Я решил ничего не говорить заводу. Завод помолчал мне в ответ.",
			door_to = "проходная",
		}:attr "static,open",
		door {
				-"склады",
			nam = "склады объект",
			dsc = "В одну сторону улица ведёт к складам.",
			description = "Серые ничем не примечательные бетонные коробки для хранения всего на свете отсюда выглядят неясными серыми пятнами.",
			Smell = "Отсюда не унюхать чем пахнут склады.",
			Taste = "Пробовать склады на вкус? Да ещё издали?",
			Talk = "У меня нет желания общаться со складами.",
			door_to = "около складов",
		}:attr "static,open",
		door {
				-"парк",
			nam = "парк объект",
			dsc = "В другую -- к парку.",
			description = "Большой красивый парк со множеством уютных лавочек и тропинок отсюда кажется полоской зелени вдали.",
			Smell = "Отсюда не унюхать, но парк пахнет зеленью.",
			Taste = "Пробовать парк на вкус удалённо?",
			Talk = "Парк меня не услышит. А даже если бы и услышал, вряд ли ответил бы мне.",
			door_to = "парк",
		}:attr "static, open",
		"газоны",
		obj {
				-"дорога,улица",
			description = "Широкая асфальтовая дорога.",
			before_Take = "Дорогу невозможно взять.",
			Smell = "Пахнет асфальтом.",
			Taste = "Я не хочу пробовать дорогу на вкус.",
			Talk = "Не отвечает. Наверное, дороги не умеют разговаривать.",
		}:attr "scenery",
		door {
				-"люк,крышка люка,крышка,тоннель",
			nam = "люк",
			dsc = "Недалеко от завода в тротуаре виден люк.",
			description = "Люк ведёт в служебные тоннели. Роберт говорил, что через них можно попасть в сердце города -- машинные залы, в которых расположен спин-диззи двигатель, позволяющий городу летать по всей галактике.",
			before_Open = function(s)
				if not _"диверсант".was_active then
					return "Мне незачем спускаться в служебные тоннели."
				end
				return false
			end,
			before_Take = "Люк тяжёлый и неудобный для переноски.",
			Smell = "Пахнет металлом.",
			Taste = "Я не очень хочу пробовать на вкус люк в тротуаре.",
			Talk = "Не отвечает. Наверное, люки не очень разговорчивые.",
			door_to = "тоннель под заводом",
		}:attr "static,openable",
		"небо",
		"асфальт",
	},
	in_to = "проходная",
	d_to = "тоннель под заводом",
}

room {
		-"склады",
	nam = "около складов",
	dsc = function(s)
		local t = ""
		if s:once() then
			t = "Самый чувствительный недостаток статуса пассажира для меня -- недоступность аэротакси. С другой стороны, пешие прогулки вряд ли отслеживаются Отцами-основателями и моё тайное увлечение чтением могут не замечать ещё долго.^^"
		end
		t = t .. "Я подошёл к складам. Эти серые коробки не отличаются друг от друга ничем, кроме номеров. Моё убежище находится на одном из них."
		return t
	end,
	onenter = function(s)
		if _"Роберт2".talked then
			enable "диверсант"
			DaemonStart "диверсант"
		end
	end,
	obj = {
		door {
				-"улица Неизвестных Героев|завод",
			dsc = "Здесь кончается улица Неизвестных Героев, по которой можно дойти до завода.",
			description = function(s)
				if mp.words[2] == "улица" then
					return "Улица Неизвестных Героев -- самая большая в промзоне города."
				else
					return "Большой завод, на котором я работаю на очистке нагревательных колодцев."
				end
			end,
			door_to = "улица Неизвестных Героев",
		}:attr "static,open",
		obj {
				-"склады,здания",
			nam = "склады",
			dsc = "Ровными рядами стоят бесконечные ряды складов.",
			description = "Серые невзрачные коробки неотличимые друг от друга.",
			Smell = "Пахнет пылью и бетоном.",
			Taste = "Я не хочу пробовать на вкус бетонные здания.",
			Talk = "Вряд ли эти серые стены мне ответят.",
		}:attr "static",
		door {
				-"склад,склад 117,убежище",
			nam = "склад 117 объект",
			dsc = "Среди них один очень важен для меня. На его стене нанесён номер 117.",
			description = "Этот склад ничем не отличается от своих соседей кроме номера.",
			Smell = "Пахнет пылью и бетоном.",
			Taste = "Я не хочу пробовать на вкус бетонные здания.",
			Talk = "Вряд ли эти серые стены мне ответят.",
			obj = {
				obj {
						-"номер",
					description = "Номер нанесён на стену чёрной краской.",
					Smell = "Пахнет пылью и бетоном. И совсем чуть-чуть краской.",
					Taste = "Я не буду пробовать номер на стене на вкус.",
					Talk = "Я не хочу разговаривать с цифрами на стене.",
				}:attr "scenery",
			},
			door_to = "склад 117",
		}:attr "static,open",
		obj {
				-"фигура,диверсант,незнакомец,человек",
			nam = "диверсант",
			n = 0,
			was_active = false,
			known = false,
			dsc = function(s)
				local name = "Кто-то"
				if s.known then
					name = "Кайл Трент"
				end
				if here() ^ "около складов" then
					return name .. ", воровато оглядываясь идёт в сторону улицы Неизвестных Героев."
				elseif here() ^ "улица Неизвестных Героев" then
					return name .. ", настороженно оглядываясь, идёт в сторону люка."
				else
					return "ЕСЛИ ВЫ ЭТО ВИДИТЕ, СООБЩИТЕ РАЗРАБОТЧИКУ."
				end
			end,
			description = function(s)
				if not s.known then
					s.known = true
					return "Человек кажется смутно знакомым, но я не могу вспомнить где его видел... Точно! Это Кайл Трент -- он работает на том же заводе, что и я."
				else
					return "Кайл одет просто, как и все пассажиры. При его невзрачной внешности это создаёт странное ощущение человека из массовки -- как будто он просто фон."
				end
			end,
			before_Take = "Не стоит привлекать к себе внимание.",
			Smell = "Я не знаю чем он пахнет.",
			Taste = "Пробовать кого-либо на вкус очень странная идея.",
			Talk = function(s)
				walk "смерть1"
			end,
			daemon = function(s)
				s.was_active = true
				local name = "Неизвестный"
				if _"диверсант".known then
					name = "Кайл"
				end
				s.n = s.n + 1
				if s.n == 2 then
					move(s, "улица Неизвестных Героев")
					if here() ^ "около складов" then
						p(fmt.em(name .. " пошёл в сторону улицы Неизвестных Героев."))
					end
				elseif s.n == 5 then
					DaemonStop(s)
					disable(s)
					if here() ^ "улица Неизвестных Героев" then
						pn(fmt.em(name .. " спустился в люк."))
					end
				end
			end,
		}:attr "animate":dict {
			["незнакомец/рд"] = "незнакомца",
			["незнакомец/дт"] = "незнакомцу",
			["незнакомец/вн"] = "незнакомца",
			["незнакомец/тв"] = "незнакомцем",
			["незнакомец/пр"] = "незнакомце",
							  }:disable(),
		"небо",
		"асфальт",
	},
	n_to = "улица Неизвестных Героев",
	in_to = "склад 117",
}

room {
		-"склад,склад 117,убежище",
	nam = "склад 117",
	dsc = function(s)
		if s:once() then
			return "Я огляделся по сторонам -- не видит ли кто, и вошёл в полумрак складского помещения номер 117."
		else
			return "Я нахожусь на складе 117."
		end
	end,
	onexit = function(s, t)
		if t ^ "около складов" then
			enable "диверсант"
			return "Я заметил какую-то фигуру среди складов."
		end
	end,
	obj = {
		obj {
				-"стеллажи",
			nam = "стеллажи",
			dsc = "В глубину склада ровными рядами уходят стеллажи.",
			description = "Металлические высокие стеллажи заставлены ящиками и коробками.",
			before_Take = "Стеллажи очень большие и сами по себе тяжёлые, а со всеми этими ящиками мне их не поднять и подавно.",
			Smell = "Пахнет металлом.",
			Taste = "Я не хочу пробовать на вкус стеллажи.",
			Talk = "Они хранят молчание. Именно поэтому мой тайник на складе.",
			obj = {
				obj {
						-"ящики",
					description = "Пыльные пластиковые ящики, загруженные какими-то приборами.",
					before_Take = "Тяжёлые -- мне не поднять.",
					Smell = "Пахнет пылью.",
					Taste = "Я не хочу пробовать пыльные ящики на вкус.",
					Talk = "Я не буду разговаривать с ящиками. Это глупо.",
				}:attr "scenery",
				obj {
						-"коробки",
					description = "Небольшие коробки с разнообразными приспособлениями и механизмами, облегчающими быт жителей города.",
					before_Take = "Я не хочу заниматься воровством. В конце концов, город принял меня не взирая на то, что я пробрался в него нелегально.",
					Smell = "Пахнет пылью и чем-то ещё.",
					Taste = "Я не буду пробовать на вкус коробки.",
					Talk = "Я не буду разговаривать с коробками. Это глупо.",
				}:attr "scenery",
			},
		}:attr "static",
		door {
				-"тайник",
			dsc = "В дальнем углу за коробками находится мой тайник.",
			description = "За стеллажом есть пустое пространство, которое я загородил плотной тканью и бесхозными листами пластика. Там у меня есть лампа и книга.",
			before_Take = "Тайник не унести в кармане.",
			Smell = "Пахнет так же, как и на остальном складе.",
			Taste = "Я не имею представления как это сделать.",
			Talk = "Я не болтаю со своим тайником -- я пользуюсь им.",
			door_to = "тайник",
		}:attr "static,open",
	},
	in_to = "тайник",
	out_to = "около складов",
}

room {
		-"тайник",
	nam = "тайник",
	dsc = "Тесная выгородка, где я тайком читаю книги, которые заимствую из библиотеки.",
	obj = {
		obj {
				-"лампа,свет",
			dsc = "На стене висит электрическая лампа.",
			description = "Простая электрическая лампа. Такие можно встретить в городе на каждом шагу.",
			before_Take = "Лучше оставить её здесь.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Знаю я один старый анекдот про лампочку во рту.",
			Talk = "Я не думаю, что мне хочется разговаривать с лампочкой.",
			after_SwitchOn = function(s)
				here():attr "light"
				pl:need_scene()
				return false
			end,
			after_SwitchOff = function(s)
				here():attr "~light"
				pl:need_scene()
				return false
			end,
		}:attr "static,luminous,switchable",
		obj {
				-"лежак,лежанка,подстилка",
			dsc = "Под ней находится лежак из старого тряпья, найденного мной тут и там.",
			description = "Найти бесполезные тряпки, исчезновения которых никто не заметит, оказалось не так то просто.",
			before_Take = "Пусть лучше останется здесь.",
			Smell = "Ничем особенным не пахнет.",
			Taste = "Я не буду пробовать это на вкус.",
			Talk = "Я не хочу разговаривать с кучей тряпья.",
			obj = {
				obj {
						-"книга,1984",
					nam = "книга,книжка,старая книга,старая книжка",
					read = false,
					dsc = "Среди тряпья лежит старая книга.",
					description = "Джордж Оруэлл, 1984. Хорошая книга, хоть я её ещё и не дочитал. Интересно, почему её нельзя читать пассажирам?",
					Smell = "Книга пахнет старой бумагой.",
					Taste = "Я не хочу пробовать книгу на вкус. К тому же я собираюсь её вернуть.",
					Talk = "Я не могу поговорить с книгой, но книга может поговорить со мной.",
					Consult = function(s)
						if not s.read then
							s.read = true
							walk "чтение"
						else
							if not disabled "Роберт2" then
								return "Невежливо будет читать при Роберте."
							end
							return "Что-то мне уже не хочется читать."
						end
					end,
				},
			},
		}:attr "supporter,enterable",
		obj {
				-"Роберт,Коннорс,полицейский",
			nam = "Роберт2",
			talked = false,
			dsc = "У входа стоит Роберт Коннорс и с любопытством смотрит на меня.",
			description = "Роберт строго смотрит на меня.",
			Smell = "Невежливо нюхать людей.",
			Taste = "Я не буду пробовать на вкус своего опекуна.",
			Talk = function(s)
				walk "третий разговор с Робертом"
			end,
		}:attr "animate":disable(),
	},
	out_to = "склад 117",
}:attr "~light"

cutscene {
	nam = "чтение",
	onexit = function(s)
		enable "Роберт2"
	end,
	text = {
		"Я открыл книгу и перенёсся в мрачный, но захватывающий, мир...",
		"Джулия передала записку Уинстону...",
		"Они начинают встречаться на втором этаже антикварной лавки Чаррингтона...",
		"В моё тайное убежище кто-то вошёл!",
		"Я быстро убрал книгу под лежанку. И поднял глаза...",
		"Роберт нашёл мой тайник.",
	},
}

dlg {
	nam = "третий разговор с Робертом",
	disp = false,
	onenter = "Я смог придумать только максимально нелепую и бессмысленную фразу:^^-- Я всё могу объяснить.^^-- Не надо, Остин. Я всё понимаю.",
	onexit = function(s)
		_"Роберт2".talked = true
		disable "Роберт2"
	end,
	phr = {
		{ "Правда?", "-- Конечно. Чтение -- это магия и я не хочу лишать тебя этого волшебства, пусть и с некоторыми нарушениями правил города. Только...",
		  { "Только что?", "-- Только я хочу тебя предупредить, что не стоит принимать на веру и руководствоваться прочитанным без головы.",
			{ "То есть?", "-- То есть в книгах есть много хороших идей, много правильных идей, но и много неправильных мыслей. Романтическая натура может не разобраться в смысле прочитанного, но уверовать в какие-то идеалы, которые автор мог и не предполагать.",
			  { "Но я не романтик.", "-- Я этого не говорил, но тем не менее, если вдруг ты решишь что-то предпринять на основании почерпнутого из книг, сперва поговори со мной. Я твой опекун и обязан действовать в твоих интересах.",
				{ "Что это значит?", "-- Для меня это значит, что твои интересы для меня важнее моей работы и даже интересов города. Конечно, если ты не захочешь его разрушить.",
				  { "Не захочу.", "-- Вот и замечательно.",
					{ "Но как ты меня нашёл?", "-- Это было не очень сложно, но это не значит, что кто угодно сможет тебя найти. Будь осторожнее, Остин. Не все будут смотреть сквозь пальцы на твоё безобидное увлечение.",
					  { "Хорошо.", "-- Тогда я пойду. Вернись к ужину -- я знаю, что у тебя сегодня нет учёбы. Сэнди собирается готовить твою любимую запеканку.",
						{ "Буду вовремя, Роб.", "-- Вот и славно.^^Роберт ушёл так же беззвучно, как и пришёл. Интересно, их этому специально учат или это его личное качество?",
						},
					  },
					},
				  },
				},
			  },
			},
		  },
		},
	},
}

room {
		-"парк",
	nam = "парк",
	dsc = function(s)
		if s:once() then
			return "Я вышел в парк. Отсюда можно быстро дойти домой."
		else
			return "Я нахожусь в парке."
		end
	end,
	onexit = function(s, t)
		if t ^ "хода нет" then
			return "Пока ещё рано и не хочется идти домой.", false
		end
	end,
	obj = {
		obj {
				-"телефон,автомат,телефон-автомат",
			dsc = "У входа в парк стоит телефон-автомат.",
			description = "Обычный телефон-автомат. Такие встречаются по всему городу.",
			before_Take = "Это вандализм.",
			Smell = "Пахнет пластмассой и металлом.",
			Taste = "Я не хочу пробовать общественный телефон на вкус. Я не хотел бы пробовать на вкус даже личный телефон.",
		}:attr "static",
		door {
				-"улица|улица Неизвестных Героев|выход|выход из парка|завод",
			desciption = "Улица Неизвестных Героев хорошо видна отсюда.",
			before_Take = "{#First/им} невозможно взять.",
			Smell = "Отсюда не понюхать {#first/вн}.",
			Taste = "Даже если бы я и хотел, я бы не смог попробовать на вкус {#first/им}, находясь в парке.",
			Talk = "Нет ответа.",
			door_to = "улица Неизвестных Героев",
		}:attr "scenery,open",
		obj {
				-"Роберт|Коннорс|Роберт Коннорс|отец|опекун",
			talked = false,
			["description,before_Take,Smell,Taste"] = "{#First/рд} здесь нет.",
			Talk = function(s)
				if not _"бомба1".seen and not _"бомба2".seen then
					return "Не стоит его отвлекать от работы."
				end
				if not s.talked then
					s.talked = true
					lifeoff "бомба1"
					walk "четвёртый разговор с Робертом"
				else
					return "Я уже сообщил Роберту о диверсанте."
				end
			end,
		}:attr "scenery,animate":dict {
			["Коннорс/рд"] = "Коннорса",
			["Коннорс/дт"] = "Коннорсу",
			["Коннорс/вн"] = "Коннорса",
			["Коннорс/тв"] = "Коннорсом",
			["Коннорс/пр"] = "Коннорсе",
			["Роберт Коннорс/рд"] = "Роберта Коннорса",
			["Роберт Коннорс/дт"] = "Роберту Коннорсу",
			["Роберт Коннорс/вн"] = "Роберта Коннорса",
			["Роберт Коннорс/тв"] = "Робертом Коннорсом",
			["Роберт Коннорс/пр"] = "Роберте Коннорск",
									  },
		obj {
				-"Джейкоб|Пирси|Джейкоб Пирси|мэр",
			nam = "мэр по телефону",
			talked = false,
			["description,before_Take,Smell,Taste"] = "{#First/рд} здесь нет.",
			Talk = function(s)
				if not _"бомба1".seen and not _"бомба2".seen then
					return "Не стоит беспокоить мэра без причины."
				end
				if not s.talked then
					s.talked = true
					walk "второй разговор с мэром"
				else
					return "Я уже сообщил Пирси о диверсанте."
				end
			end,
		}:attr "scenery,animate":dict {
			["Джейкоб/рд"] = "Джейкоба",
			["Джейкоб/дт"] = "Джейкобу",
			["Джейкоб/вн"] = "Джейкоба",
			["Джейкоб/тв"] = "Джейкобом",
			["Джейкоб/пр"] = "Джейкобе",
									  },
		obj {
				-"деревья,дерево",
			dsc = "Этот парк очень старый -- тут много больших деревьев.",
			description = "Берёзы, ели, дубы и пихты. И ещё какие-то деревья, о которых я всё время забываю разузнать.",
			before_Take = "Даже если бы я мог голыми руками выкорчевать дерево, вряд ли я бы нашёл ему применение.",
			Smell = "Пахнет листвой.",
			Taste = "Не думаю, что древесина хороша на вкус.",
			Talk = "Деревья не умеют разговаривать. По крайней мере до сих пор со мной ни одно не заговорило.",
		}:attr "static",
		obj {
				-"кусты,кустарник",
			dsc = "Между деревьев аккуратными рядами растёт кустарник.",
			description = "Я не знаю как называются эти кусты. Интересно, на них растут ягоды?",
			before_Take = "Не думаю, что ломать кусты это хорошая идея.",
			Smell = "Приятно пахнет.",
			Taste = "Я не думаю, что кусты вкусные.",
			Talk = "Не думаю, что кусты умеют говорить.",
		}:attr "scenery",
		"газоны",
		obj {
				-"скамейки,лавки,лавочки",
			dsc = "Рядом с ними стоят скамейки",
			description = "Удобные пластиковые скамейки.",
			before_Take = "Зачем мне скамейка?",
			Smell = "Не очень хочется нюхать то, на чём сидят.",
			Taste = "Я не хочу пробовать на вкус то, на чём сидят.",
			Talk = "Скамейки вряд ли смогут поболтать со мной.",
		}:attr "static",
		obj {
				-"скамейка,лавка,лавочка",
			description = "Удобная пластиковая скамейка.",
			defore_Take = "Зачем мне скамейка?",
			Smell = "Не очень хочется нюхать то, на чём сидят.",
			Taste = "Я не хочу пробовать на вкус то, на чём сидят.",
			Talk = "Скамейка вряд ли сможет поболтать со мной.",
		}:attr "scenery,supporter,enterable",
		obj {
				-"дорожки,тропинки,дороги,тропы",
			description = "Узкие асфальтовые дорожки паутиной сплетаются по всему парку. По ним очень приятно бродить когда есть свободное время, а читать книги не хочется.",
			before_Take = "Дорожки не взять. По крайней мере мне так кажется.",
			Smell = "Пахнет асфальтом.",
			Taste = "Я не думаю, что есть асфальтовые дорожки разумно.",
			Talk = "Нет ответа. Наверное, это была глупая идея.",
		}:attr "scenery",
		door {
				-"дом",
			description = false,
			Smell = false,
			Taste = false,
			Talk = false,
			door_to = "хода нет",
		}:attr "scenery,open",
		"небо",
		"асфальт",
	},
	out_to = "улица Неизвестных Героев",
}

dlg {
	nam = "четвёртый разговор с Робертом",
	disp = false,
	onenter = "Я набрал номер Роберта. Гудки звучали как будто целую вечность. Наконец, голос на том конце сказал:^^-- Лейтенант Коннорс. Слушаю.",
	onexit = function(s)
		if _"бомба1".seen and _"бомба2".seen then
			walk "конец1"
		elseif _"бомба1".seen and not _"бомба2".seen then
			walk "конец2"
		elseif not _"бомба1".seen and _"бомба2".seen then
			walk "конец3"
		end
	end,
	phr = {
		{ "Пап, я нашёл диверсанта.", "-- Остин? О чём ты говоришь? Где?",
		  { "Я не знаю куда он делся, но это Кайл Трент с моей работы.", "-- Кайл Трент? Сейчас же начнём поиски.",
			{ cond = function(s) return _"бомба1".seen and not _"бомба2".seen end, "Он заложил бомбу в машинном отделении.", "-- Ты её видел? Ещё где-нибудь нашёл?",
			  { "Видел. Может быть есть ещё; я нашёл только эту.", "-- Хорошо. Немедленно отправлю сапёров. Ты сейчас где?",
				{ "В парке возле улицы Неизвестных Героев.", "-- Стой там -- я отправлю за тобой такси. Мне пора.",
				  { "Хорошо, пап. Удачи.", "-- Спасибо, Остин. Поговорим позже" },
				},
			  },
			},
			{ cond = function(s) return not _"бомба1".seen and _"бомба2".seen end, "Он заложил бомбу под Отцами-основателями.", "-- Ты её видел? Ещё где-нибудь нашёл?",
			  { "Видел. Может быть есть ещё; я нашёл только эту.", "-- Хорошо. Немедленно отправлю сапёров. Ты сейчас где?",
				{ "В парке возле улицы Неизвестных Героев.", "-- Стой там -- я отправлю за тобой такси. Мне пора.",
				  { "Хорошо, пап. Удачи.", "-- Спасибо, Остин. Поговорим позже" },
				},
			  },
			},
			{ cond = function(s) return _"бомба1".seen and _"бомба2".seen end, "Он заложил бомбы в машинном отделении и под Отцами-основателями.", "-- Ты их видел? Ещё где-нибудь нашёл?",
			  { "Видел. Может быть есть ещё; я нашёл только эти две.", "-- Хорошо. Немедленно отправлю сапёров. Ты сейчас где?",
				{ "В парке возле улицы Неизвестных Героев.", "-- Стой там -- я отправлю за тобой такси. Мне пора.",
				  { "Хорошо, пап. Удачи.", "-- Спасибо, Остин. Поговорим позже." },
				},
			  },
			},
		  },
		},
	},
}

dlg {
	nam = "второй разговор с мэром",
	disp = false,
	onenter = "Я набрал номер Роберта. Гудки звучали как будто целую вечность. В конце концов мне ответили. Строгий голос произнёс:^^-- Приёмная мэра. Слушаю вас.",
	onexit = function(s)
		_"мэр по телефону".talked = true
	end,
	phr = {
		{ "Я нашёл диверсанта.", "-- Диверсанта? Это шутка?",
		  { "Я серьёзно.", "-- Молодой человек, ваш розыгрыш не смешон. Прекратите хулиганство.^^Трубку повесили."
		  },
		},
	},
}

room {
	nam = "хода нет",
}

obj {
		-"стены,стена",
	nam = "стены тоннеля",
	description = "Стены выложены из кирпича.",
	before_Take = "Стены невозможно взять. Это же стены.",
	Smell = "Пахнет пылью.",
	Taste = "Я не хочу пробовать стены на вкус.",
}:attr "scenery"

obj {
		-"потолок,свод",
	nam = "потолок тоннеля",
	description = "Серый бетонный потолок. Через равные промежутки на нём висят лампы.",
	before_Take = "Взять потолок? Это как?",
	Smell = "Пахнет пылью.",
	Taste = "Я не буду пробовать потолок на вкус.",
	obj = {
		obj {
				-"лампы,лампочки,светильники",
			description = "Небольшие лампы, дающие достаточно света, чтобы ориентироваться в тоннелях, но недостаточно, чтобы разглядывать детали.",
			before_Take = "Без ламп в тоннеле будет жутко и я вряд ли смогу найти выход на поверхность.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Знаю я один старый анекдот про лампочку во рту.",
		}:attr "scenery",
	},
}:attr "scenery"

obj {
		-"пол",
	nam = "пол тоннеля",
	description = "Шершавый бетонный пол.",
	before_Take = "Пол невозможно взять. Это же пол.",
	Smell = "Пахнет пылью.",
	Taste = "Не горю желанием пробовать бетонный пол на вкус.",
}:attr "scenery"

room {
		-"тоннель",
	nam = "тоннель под заводом",
	tried = false,
	dsc = function(s)
		if s:once() then
			return "Я спустился в тоннель. Он тянется с севера на юг."
		else
			return "Тоннель тянется с севера на юг."
		end
	end,
	onenter = function(s, f)
		lifeon "бомба1"
	end,
	onexit = function(s, t)
		if t ^ "хода нет" then
			if not s.tried then
				s.tried = true
				return "Шаги слышны с другой стороны тоннеля.", false
			else
				return "Незнакомец пошёл в другую сторону.", false
			end
		end
	end,
	obj = {
		door {
				-"лестница",
			dsc = "Лестница ведёт наверх.",
			description = "Металлическая лестница, прикреплённая к стене.",
			before_Take = "Лестница надёжно прикручена к стене.",
			Smell = "Пахнет металлом.",
			Taste = "Я не хочу пробовать лестницу на вкус.",
			Talk = "Вряд ли получится содержательная беседа.",
			door_to = "улица Неизвестных Героев",
		}:attr "static,open",
		"пол тоннеля",
		"стены тоннеля",
		"потолок тоннеля",
	},
	n_to = "хода нет",
	s_to = "развилка тоннеля",
	u_to = "улица Неизвестных Героев",
}

room {
		-"поворот",
	nam = "развилка тоннеля",
	dsc = function(s)
		if s:once() then
			return "Я пошёл на звук шагов до места, где тоннель поворачивает на восток."
		else
			return "Я стою на повороте тоннеля. Идти можно на север и на восток."
		end
	end,
	obj = {
		obj {
				-"табличка,таблица,знак",
			dsc = "На стене висит табличка.",
			description = function(s)
				return s.Consult
			end,
			Consult = "СЕВЕР -- Выход на улицу Неизвестных героев.^ВОСТОК -- Машинное отделение.^ЗАПАД -- вычислительный центр.",
			Smell = "Пахнет пылью.",
			Taste = "Я не думаю, что пробовать пластмассовую табличку на вкус разумно.",
			Talk = "Табличку имеет смысл читать, а не разговаривать с ней.",
		}:attr "static",
		"пол тоннеля",
		"стены тоннеля",
		"потолок тоннеля",
	},
	n_to = "тоннель под заводом",
	e_to = "у входа в машинное отделение",
	w_to = "вычислительный центр",
}

room {
	nam = "у входа в машинное отделение",
	known = false,
	dsc = function(s)
		if s:once() then
			return "Если чувство пространства меня не подводит, я рядом с машинным отделением."
		else
			if s.known then
				return "Я нахожусь у входа в машинное отделение."
			else
				return "Я нахожусь в тоннеле."
			end
		end
	end,
	obj = {
		door {
				-"дверь,машинное отделение",
			when_open = "За дверью видны гигантские машины.",
			when_closed = "Здесь находится дверь.",
			description = "Невзрачная металлическая дверь.",
			before_Take = "Дверь крепко держится на петлях.",
			Smell = "Пахнет металлом.",
			Taste = "Я не хочу пробовать металлическую дверь на вкус.",
			Talk = "Вряд ли дверь мне ответит.",
			door_to = "машинное отделение",
		}:attr "static,openable,open",
		obj {
				-"табличка,таблица,знак",
			dsc = "Рядом на стене висит табличка.",
			description = function(s)
				s.Consult()
			end,
			Consult = function(s)
				if not here().known then
					here().known = true
				end
				return "Машинное отделение."
			end,
			before_Take = "Лучше оставить табличку на месте.",
			Smell = "Пахнет пылью и пластмассой.",
			Taste = "Я не хочу пробовать пластмассовую табличку на вкус.",
			Talk = "Табличка ничего мне не скажет, но её можно прочитать.",
		}:attr "static",
		"пол тоннеля",
		"стены тоннеля",
		"потолок тоннеля",
	},
	e_to = "машинное отделение",
	in_to = "машинное отделение",
	w_to = "развилка тоннеля",
}

room {
	nam = "машинное отделение",
	dsc = function(s)
		if s:once() then
			return "Я вошёл в машинное отделение. Тут гораздо светлее, чем в тоннеле."
		else
			return "Я нахожусь в машинном отделении."
		end
	end,
	obj = {
		obj {
				-"машины,спин-диззи",
			dsc = "Почти всё пространство занимают гигантские машины.",
			description = "Гигансткие машины. Сердце города, дающее ему возможность летать по всей галактике -- спин-диззи.",
			before_Take = "Они слишком огромны, чтобы их можно было взять.",
			Smell = "Пахнет горячим металлом и чем-то едва уловимым и непривычным.",
			Taste = "Пробовать гигантские гравитационные двигатели на вкус? Странная мысль.",
			Talk = "Зачем разговаривать с гигантскими машинами? Это же не Отцы-основатели. Да и с теми общаются через специальные терминалы.",
		}:attr "static":dict {
			["спин-диззи/рд"] = "спин-диззи",
			["спин-диззи/дт"] = "спин-диззи",
			["спин-диззи/вн"] = "спин-диззи",
			["спин-диззи/тв"] = "спин-диззи",
			["спин-диззи/пр"] = "спин-диззи",
							 },
		obj {
				-"бомба|устройство|взрывчатка",
			nam = "бомба1",
			seen = false,
			n = 0,
			dsc = function(s)
				local name = "устройство"
				if s.seen then
					name = "бомба"
				end
				local t = "На корпусе одной из машин висит " .. name .. "."
				return t
			end,
			description = function(s)
				if not s.seen then
					s.seen = true
					return "Устройство сильно похоже на бомбу как её изображают в фильмах, которые я иногда смотрю с Робертом и Сэнди. Нужно сообщить кому-нибудь."
				else
					return "Бомба -- угроза всему городу. Если мы останемся без спин-диззи, то не только не сможем летать -- исчезнет и защитное поле, удерживающее атмосферу."
				end
			end,
			before_Take = function(s)
				if s.seen then
					return "Лучше не трогать её, а сообщить властям о произошедшем."
				else
					return "Не стоит её трогать. В конце концов я хочу стать гражданином, а не взорваться вместе со спин-диззи и умереть без атмосферы."
				end
			end,
			Smell = function(s)
				if s.seen then
					return "Нет времени узнавать чем пахнет взрывчатка -- нужно скорее что-то предпринять."
				else
					return "Пахнет странно."
				end
			end,
			Taste = "Не горю желанием пробовать {#first/им} на вкус.",
			life = function(s)
				s.n = s.n + 1
				if s.n == 20 then
					walk "плохая концовка"
				end
			end,
		}:attr "static",
		obj {
				-"стены",
			description = "Стены тут выполнены из того же материала, что и в тоннеле -- кирпич. Правда выглядят они почище и поаккуратнее.",
			before_Take = "Невозможно взять стены.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Я не хочу пробовать на вкус кирпичные стены.",
			Talk = "Разговаривать со стенами -- признак проблем с мозгами.",
		}:attr "scenery",
		obj {
				-"пол",
			description = "Шершавый бетонный пол.",
			before_Take = "Невозможно взять пол -- это же часть помещения, в котором я нахожусь.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Я не горю желанием пробовать бетонный пол на вкус.",
			Talk = "Не думаю, что он мне ответит.",
		}:attr "scenery",
		obj {
				-"потолок",
			description = "Бетонный потолок тут существенно выше, чем в тоннеле. На нём висят светильники.",
			before_Take = "Невозможно взять потолок.",
			Smell = "Не пахнет ничем особенным.",
			Taste = "Я не знаю каков бетонный потолок на вкус, но и не сильно хочу узнать это.",
			obj = {
				obj {
						-"лампы,светильники",
					description = "Светильники в машинном отделении светят ярким белым светом.",
					before_Take = "Они слишком высоко.",
					Smell = "Не пахнет ничем особенным.",
					Taste = "Знаю я старый анекдот про лампочку во рту.",
					Talk = "Светильники хранят молчание.",
				}:attr "scenery",
			},
		}:attr "scenery",
	},
	out_to = "у входа в машинное отделение",
}

room {
	nam = "вычислительный центр",
	dsc = function(s)
		if s:once() then
			return "Я пришёл к лестницы, ведущей в вычислительный центр."
		else
			return "Я нахожусь у лестницы, ведущей в вычислительный центр."
		end
	end,
	onexit = function(s, t)
		if t ^ "хода нет" then
			return "Мне не пройти в сам вычислительный центр -- дверь заперта.", false
		end
	end,
	obj = {
		obj {
				-"дверь",
			description = "Массивная железная дверь.",
			Smell = "Пахнет пылью и металлом.",
			Taste = "Не хочу пробовать железную дверь на вкус.",
			Talk = "Думаю, мне не уговорить дверь открыться -- это же просто дверь.",
		}:attr "scenery",
		door {
				-"лестница,ступеньки",
			dsc = "Ступеньки широкой лестницы ведут наверх -- в недра Отцов-основателей.",
			description = "Широкая бетонная лестница. Без излишеств, как и многое в городе.",
			Smell = "Пахнет пылью.",
			Taste = "Я не буду пробовать лестницу на вкус.",
			Talk = "Не думаю, что есть смысл разговаривать с лестницей.",
			door_to = "хода нет",
		}:attr "static,open",
		obj {
					-"бомба|устройство|взрывчатка",
				nam = "бомба2",
				seen = false,
				n = 0,
				dsc = function(s)
					local name = "устройство"
					if s.seen then
						name = "бомба"
					end
					return "Под лестницей лежит " .. name .. "."
				end,
				description = function(s)
					if not s.seen then
						s.seen = true
						return "Устройство сильно похоже на бомбу как её изображают в фильмах, которые я иногда смотрю с Робертом и Сэнди. Нужно сообщить кому-нибудь."
					else
						return "Бомба -- угроза всему городу. Если мы останемся без Отцов-основателей, то управлять городом придётся людям, а управлять полётом лично мэру. Машины гораздо лучше справляются и с тем и с другим."
					end
				end,
				before_Take = function(s)
					if s.seen then
						return "Лучше не трогать её, а сообщить властям о произошедшем."
					else
						return "Не стоит её трогать. В конце концов я хочу стать гражданином, а не взорваться вместе с Отцами-основателями."
					end
				end,
				Smell = function(s)
					if s.seen then
						return "Нет времени узнавать чем пахнет взрывчатка -- нужно скорее что-то предпринять."
					else
						return "Пахнет странно."
					end
				end,
				Taste = "Не горю желанием пробовать {#first/им} на вкус.",
			}:attr "static",
		"пол тоннеля",
		"стены тоннеля",
		"потолок тоннеля",
	},
	e_to = "развилка тоннеля",
}

room {
	nam = "смерть1",
	noparser = true,
	disp = ". . .",
	dsc = function(s)
		local name = "незнакомца"
		if _"диверсант".known then
			nam = "Кайла"
		end
		return "Я окликнул " .. name .. ". Тот обернулся и навёл на меня какую-то странную пушку.^^Острая боль пронзила мою грудь, сознание угасло..."
	end,
}

room {
	nam = "плохая концовка",
	noparser = true,
	disp = ". . .",
	dsc = "Всё вокруг содрогнулось. Через несколько минут дрожь повторилась. Привычные настолько, что я уже давно их не замечал, гудение и лёгкая вибрация города прекратились... ^^Мы остались без спин-диззи. С ужасом я почувствовал как уходит воздух.^^" .. fmt.c(fmt.b "КОНЕЦ"),
}

cutscene {
	nam = "конец1",
	disp = ". . .",
	text = {
		"Вскоре у входа в парк опустилось пустое аэротакси.",
		"Я сел в него и оно направилось в сторону мэрии.",
		"Джейкоб Пирси лично встретил меня у входа.",
		"За то время пока я добирался сюда, Трента поймали и он находился тут же --  на посадочной площадке в сопровождении целой оравы полицейских.",
		"Тут же был проведён допрос.",
		"Его раскололи -- он работал на Гравитогорск-Марс. Я раньше не слышал об этом городе, но судя по лицам остальных они прекрасно знали о чём речь.",
		"Тут же Кайла Трента и казнили.",
		"Потом была череда каких-то малопонятных мне событий, мэр что-то кому-то втолковывал по гиперрадио -- я каким-то образом оказался у него в кабинете вместе с Робертом.",
		"Потом пришли какие-то люди в строгих костюмах.",
		"Потом я, совершенно потерянный, оказался в центре всеобщего внимания.",
		"Мне прямо тут же вручили новый паспорт и торжественно объявили о моём новом статусе.",
		"Я стал гражданином...",
	},
	next_to = "конец",
}

cutscene {
	nam = "конец2",
	disp = ". . .",
	text = {
		"Вскоре у входа в парк опустилось пустое аэротакси.",
		"Я сел в него и оно направилось в сторону мэрии.",
		"Джейкоб Пирси лично встретил меня у входа.",
		"За то время пока я добирался сюда, Трента поймали и он находился тут же --  на посадочной площадке в сопровождении целой оравы полицейских.",
		"Во время допроса, проводившегося тут же, по городу прокатился грохот и он весь содрогнулся.",
		"Кто-то в строгом костюме подбежал к мэру и что-то сообщил ему.",
		"После допроса и казни Роберт сказал мне, что была вторая бомба -- под вычислительным центром.",
		"Это значит, что город остался без Отцов-основателей.",
		"Неизвестно, сможет ли он оправиться после такой потери.",
		"Управлять городом могут и люди, а полётом -- мэр лично. Только вот безошибочные машины делали это намного лучше. Так мне объяснил Роберт.",
		"Моё обучение продолжилось под чутким руководством живых учителей.",
		"Об экзамене на звание гражданина пришлось надолго забыть.",
		"И неизвестно смогу ли я его сдать...",
	},
	next_to = "конец",
}

cutscene {
	nam = "конец3",
	disp = ". . .",
	text = {
		"Вскоре у входа в парк опустилось пустое аэротакси.",
		"Я сел в него и оно направилось в сторону мэрии.",
		"Джейкоб Пирси лично встретил меня у входа.",
		"За то время пока я добирался сюда, Трента поймали и он находился тут же --  на посадочной площадке в сопровождении целой оравы полицейских.",
		"Во время допроса, проводившегося тут же, по городу прокатился грохот и он весь содрогнулся.",
		"Привычные настолько, что я уже давно их не замечал, гудение и лёгкая вибрация города прекратились... ",
		"Мы остались без спин-диззи. С ужасом я почувствовал как уходит воздух.",
	},
	next_to = "конец",
}

room {
	nam = "конец",
	noparser = true,
	disp = false,
	dsc = fmt.c(fmt.b "КОНЕЦ")
}
