/*
	Peptalk 
	© Risto Holopainen 2021
	Licenced under Creative Commons
	Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) 
	https://creativecommons.org/licenses/by-nc-sa/4.0/

	peptalk -- functions
*/

#pragma once

#include "markovtext.h"
#include "oracle.h"
#include <time.h>
#include <ctype.h>
#include <stdbool.h>

void rndmsg(char *msg, int ln)
{
	probtable PP;
	readtable(PP);
	gibberish(PP, msg, ln);

	int K = ln, b, c, q;
	while( K > 8 + irand(10) )
		{
		K >>= 1;
		b = K + irand(5) - 2;
		c = ln - b;
		q = rand();
		if(q&4)
			msg[b] = ' ';
		if(q&2)
			msg[c] = ' ';
		}
}


void init_empty(char *string, int sz)
{
	time_t now = time(NULL);
	struct tm *tm_struct = localtime(&now);
	int day = tm_struct->tm_wday;
	
	int D = day % 4;
	switch (D)
		{
		case 0 :
			{
			for(int i=0; i<sz; i++)
				*(string + i) = '!' + i%7 - 3;
			break;
			}
		case 1 :
			{
			const char *faust = " \\m/ ";
			for(int i=0; i<sz; i++)
				*(string + i) = faust[i%5];
			break;
			}
		case 2 :
			{
			for(int i=0; i<sz; i++)	
				*(string + i) = 'a' + irand(26); 
			break;
			}
		default :
			for(int i=0; i<sz; i++)
				{
				*(string + i) = (irand(2)) ? '.' : '-';
				if (i % (4 + irand(5)) == 3) *(string + i) = ' ';
				}
		}

	string[sz/3] = '\0';
}

char * music()
{	
	const char *notes[] = {"-", /*"Cb",*/ "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", 
			"G", "D", "A", "E", "B", "F#", "C#", "G#", "D#", "A#", /*"E#",*/ "-"};

	int offset = irand(8);
	int NN = 2 + irand(3) + irand(9);
	int sz = 3*NN;
	char *melo = (char *) malloc( (50+sz) * sizeof(char));
	char *segm = (char *) malloc(sz * sizeof(char));

	#define N_tunes 15
	const char *tunes[N_tunes] = {"A popular new tune goes like this:", 
		"Listen to this tune:", "Your next hit song comes here:",
		"Just another radio hit:", "Repeat this to insanity.",
		"As fast as possible:", "Did you write this song?",
		"Music for any instrument.", "Like this, but also backwards:",
		"Maybe as a canon?", "Not too fast.", "Who wrote this song?",
		"Music:", "Slowly, sentimentally:", ""};

	for (int i=0, pc, k=0; i<NN; i++)
		{
		pc = offset + irand(12);
		sprintf( segm + k, "%s ", notes[pc]);
		k += (pc <= 5 || pc > 12) ? 3 : 2;
		}

	const char *rep[] = {"{", "}", "||:", ":||"};
	int rs = (irand(3) == 0) ? 0 : 2;
	int n = irand(N_tunes);
	if (n > 1 && n < 5)
		rs = 2;

	sprintf(melo, "\t%s \n\t%s %s%s\n", tunes[n], rep[rs], segm, rep[rs+1]);
	return melo;
}

void visuals()
{
	const int N = 40;
	char c[] = {' ', ' ', '{', '}', '(', ')', '/', '\\', '-', '=', 
				'+', '*', ':', '.', '|', '#', 'o', '^', '%', '<', 
				'>', '$', '@', '"', '!', '?', '&', '\'', ';', '_', 
				'O', '0', '~', '[', ']', '`', ',', ' ', '\b', '\f' };
	char skip[] = {' ', ' ', '\t', '\r', '\v', '\f', '\b', '\0'};	
	c[N-1] = skip[irand(9)]%8;
	int row = 9 + rand() % 21;
	int j = 0;
	const int lines = 5 + row/3 - irand(3);
	const int delay = 144000;	// ~ 1/4 sec.

	int q = rand() % 36;
	if (q & 1)
		{
		int k = q/3;
		int s = 1 + irand(3);
		if(q & 10)
			{
			char st = (q&4) ? 'A' : 'a' ;
			for(int n=1, p=0; n<k && p<N; n++)
				{
				p += s;
				c[p] = st + irand(26);
				}
			}
		else
			{
			for(int n=1, p=0; n<k && p<N; n++)
				{
				p += s;
				c[p] = '0' + irand(10);
				}
			}
		}
	bool boring = false;
	if (q < 31)
		{
		int m = q%N;
		char p = c[m];
		const int J = 1 + irand(4);
		if(J == 1) boring = true;
		const int st = irand(2);
		const int end = N - irand(2);
		for (int i=st; i<end; i += J)
			c[i] = p;
		}
	printf("\n\n");

	bool marg = (irand(3) == 0) ;	
	const char *left = (marg) ? "\t\t&" : "\t\t";
	const char *right = (marg) ? "&\n" : "\n"; 
	if (!boring)
		{
		while( j < lines )
			{
			printf("%s", left);
			for(int i=0, k; i<row; i++)
				{
				k = irand(N);
				printf("%c", c[k]);
				}
			usleep(delay);
			++j;
			printf("%s", right);
			}
		}
	else	// single character plot
		{
		while (j < lines)
			{
			printf("%s", left);
			char K = ' ';
			for(int i=0, n; i<row; i++)
				{
				n = i%30;
				K = ( irand(2) ) ? c[n] : ' ';
				printf("%c", K);
				}
			++j;
			usleep(delay/2);
			printf("%s", right);
			}
		}
	if (q < 10)
		{
		int p = q % 7;
		rndmsg(c, 7);
		char z = (c[0] == 'a' || c[0] == 'e' || c[0] == 'i' || c[0] == 'o' || c[0] == 'y') ? 'n' : 0 ;
		
		switch (p)
			{
			case 0 :
				{
				printf("\n\t(Any resemblance with a%c %s is purely coincidental.)\n", z, c);
				break;
				}
			case 1 :
				{
				const char *mode[] = {"Artistic", "Schematic", "Scale model"};
				printf("\n\t(%s rendering of the %s.)\n", mode[irand(3)], c);
				break;
				}
			case 2 :
				{
				const char *sketch[] = {"Sketch", "Rough draft", "...", "Preliminary idea"};
				const char *style[] = {"abstract expressionism", "impressionist painting",
										"conceptual art", "outsider art", "pop art", "op art",
										"a surreal engraving", "a rough draft", "ancient computer art"};
				printf("\t%s to be realised in the style of %s.", sketch[irand(4)], style[irand(9)]  );
				break;
				}
			case 3 :
				{
				printf("\n\t(Model of a%c %s.)\n", z, c);
				break;
				}

			case 4 :
				{
				const char *where[] = {"middle", "corner", "upper corner", "figure", "diagram", "lower part"};
				printf("\n\t(Notice the %s in the %s.)\n", c, where[irand(6)]);
				break;
				}
			case 5 :
				{
				char *num[] = {"one", "two", "three", "99", "hundred"};
				printf("\n\tYou are the %s ‱.", num[irand(5)]);
				break;
				}				
			case 6 :
				{
				int k = irand(5);
				printf("\n\t\tNo. %d. ■□◇◆∵◙⧯🁫 🀹 ⧂ \n", k+1);
				break;
				}
				
			default :
				{
				printf("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
				}
			}
		}
}



void web()
{
	int N_proto = 10;
	const char *pr[] = {"https://", "http://", "ftp://", "ipfs://", "gemini://",
						"dat://", "stuxnet://", "gnunet://", "telnet://", "gopher://"};
	int k = (irand(12)) % N_proto;
	
	probtable PP;
	readtable(PP);
	
	char net[60];
	const int L = 25;
	char strange[L], domain[8];
	int m = L - k/2 - irand(9) - 10;
	int dd = 2 + (k % 3);
	gibberish(PP, strange, m);

	if( rand() & 1 )
		{
		const char *TLD[60] = {"com", "net", "org", "info", "xyz", "abc", "home", "sux", "nu", "test", 
						"wip", "rip", "main", "cpp", "ussr", "sex", "nix", "i2p", "onion", "mail", 
						"quack", "invalid", "zone", "wrong", "work", "wobble", "example", "eu", "dixit", "lib", 
						"hack", "hax", "wax", "o", "pi", "rho", "mu", "nu", "beta", "iota", 
						"tau", "omega", "eta", "hyle", "space", "null", "fr", "be", "de", "se", 
						"no", "am", "ru", "op", "cc", "io", "jp", "cn", "uk", "top"} ;
		int p = irand(50);
		// domain = TLD[p];
		sprintf(domain, "%s", TLD[p]);
		}
	else
		{
		for(int i=0; i<dd; i++)
			{
			domain[i] = 'a'  + irand(26);
			}
		domain[dd] = '\0';
		}

	if (m > 14)
		{
		if(m&1)
			strange[m/2 - 1] = '.';
		else
			strange[m/2 + 1] = '/';
		}

	int q = irand(25);

	if(q > 9 && q < 21 )
		{
		char *S = (q & 4) ? "s" : "";
		printf("~Experimental internet %shopping~ ", S);
		}
	else if(q >= 21)
		{
		printf("~The Internet begins here~");
		}
	else
		{
		const char *port[] = {"Portal to", "Welcome to", "Join us in"};
		const char *place[] = {"the Noosphere", "nowhere", "Cyberspace", 
						"Gondwana", "another world", "Heaven", "Hell"};
		int j = irand(7);
		int k = irand(3);
		printf("~%s %s~ ...", port[k], place[j]);
		}
	if(m&4 && q%3==0)
		{
		usleep(250000);
		printf("\b\b\b BLEEP!");
		}
	printf("\n");
	sprintf(net, "%s%s.%s/", pr[k], strange, domain);
	printf("%s\n\n", net);

}


bool is_worktime()
{
// if working hours, go on to do oracle, otherwise quit

	time_t now = time(NULL);
	struct tm *tm_struct = localtime(&now);
	int hour = tm_struct->tm_hour;
	int secs = tm_struct->tm_sec;
	int min = tm_struct->tm_min;
	
	const char *postfix[4] = {"nd", "rd", "th", "st"};
	int j = 2;
	if (hour == 2 || hour == 22) j = 0;
	else if (hour == 3 || hour == 23) j = 1;
	else if (hour == 1) j = 3;
	int shoddiness = rand() % 5;
	
	sleep(1);

	if( (hour+shoddiness > 3 && hour+shoddiness < 10) || secs < 5 || min == 30)
		{
		printf("\nIn the %2d%s hour: \n", hour, postfix[j]);
		return false ; 
		}

	else
		return true ; 
}


#define N_lexwords 36		// #words in book.txt
#define N_lexwlen 25		// max-length of a word

typedef char lexform[N_lexwords][N_lexwlen] ;

int readbook(lexform lexique)
{
	FILE *buk;
	
	if( !(buk = fopen("book.txt", "r")) )
		{
		printf("Ling-Ling very good dog. Very much want book.txt back.\n");	
		exit(1);
		}

	char *words = (char *) malloc(N_lexwlen);
	char **lexicon = (char **) malloc(N_lexwlen*N_lexwords);
	int k = 0;
	while(1)
		{		
		if (fscanf(buk, "%s", words ) == EOF || k >= N_lexwords)
			break;
		lexicon[k] = words;
		sprintf( (lexique)[k], "%s", words);
		++k;
		}

	free(lexicon);
	free(words);
	fclose(buk);

	return k;
}


void talk(lexform lex, int wc)
{
	int x = rand();
	int K = x%wc;
	int j = x % 9;
	char *subject = *(lex + K);
	
	printf("\n");
	switch (j)
		{
		case 0 :
			{
			char Z = (x&1) ? 'D' : 'S' ;
			char ans;
			const char *S = (j > 4) ? "really " : "";
			printf("%co you %swant to talk about %s? [y/n]\n", Z, S, subject);
			printf("\t > ");
			scanf("%c", &ans);
			if(ans == 'n' || ans == 'N')
				printf("OK.\n");
			else if(ans == 'y' || ans == 'Y')
				{
				char *perm = anagram(subject);
				for(int i=0; i<12; i++)
					{
					printf("\t%s %s\n", subject, perm);
					subject = anagram(perm);
					perm = anagram(subject);
					}
				}
			else { printf("never mind.\n");}
			usleep(400000);
			break;	
			}
		case 1 :
			{
			const char *qualifier[] = {"\b", "not", "still", "very", "really"};
			int p = irand(5);
			char *anafrogged = anagram(subject);
			printf("Are you %s concerned with %s? ", qualifier[p], anafrogged);
			if (irand(7) > 4)
				printf("Let it go.\n");
			else printf("\n");
			usleep(600000);
			break;	
			}
		case 2 :
			{
			const char *add[] = {"soon it'll all be over.", "it won't hurt you", "it's just an illusion.", "it's not real",
				"there's no way such a thing can exist!", "blame it on the Dogs.", "nobody cares anyway."};
			int a = irand(7);
			int b = irand(3);
			const char *worry[] = {"Never mind", "Don't worry about", "Please ignore"} ;
			printf("%s %s, %s\n", worry[b], subject, add[a]);
			usleep(600000);
			break;	
			}
		case 3 : 
			{
			char *revved = (rand()&1) ? reverse(subject) : inverse(subject);
			int g = irand(8);
			int s = irand(6);
			const char *greet[] = {"Greet", "Hail", "Praise", "Welcome", "Obey", "Pray to", "Worship", "Banish"};
			const char *smile[] = {"a big smile", "caution", "arms raised", "your hat off", "all men on deck", "the usual precautions"};
			printf("%s %s with %s!\n", greet[g], revved, smile[s]);
			break;
			}
		default :
		usleep(200000);
		}
}

void dialogue(int ac, char **argv)
{
	FILE *reg;
	if( !(reg = fopen("adages.txt", "r")) )
		{
		printf("adages.txt, please exist!\n\n");
		exit(1);
		}

	const int maxword = 15;
	const int maxlines = 24;
	char msg[maxlines][maxword];
	int k = 0;

	while( k<maxlines )
		{
		if( (fscanf(reg, "%s", msg[k])) == EOF)
			break;
		++k;
		}
	#ifdef DEBUGGING
	printf("dialogue: k=%d \n", k);
	#endif

	fclose(reg);

// store commandline + previous ones
	reg = fopen("adages.txt", "w");

	for(int n=1; n<ac; n++)
		fprintf(reg, "%s\n", argv[n]);

// may temporarily grow to more than maxline entries if the patient is very talkative
	for(int i=0; i<k; i++)		
		fprintf(reg, "%s\n", msg[i]);

	fclose(reg);
	
	int m = (k > 0) ? irand(k) : 0;

	if(ac == 2)
		{
		if (!isdigit(*argv[1]))
			{
			if(irand(2))
				{
				char *name = argv[1];
				name[0] = toupper(name[0]);
				printf("Don't tell me your name is %s!", argv[1]);
				}
			else
				{
				//char *annablume;
				char *annablume = reverse(argv[1]);
				printf("!%s olleH", annablume);
				}
			}
		else
			printf("Who cares about numbers?");
		}

	else if (ac > 7)
		{
		printf("tl;dr\n\n");
		exit(0);	
		}
	else if (ac <= 7 && ac > 3 && irand(15) < ac)
		{
		printf("Yes! Talk some more dirty like that!\n\n");
		exit(0);
		}

	else
		if (k>0 && irand(6) < 2)
			{
			if( irand(2) == 1 )
				{
				int k = irand(4);
				const char *life[] = {"life", "session", "therapy session", "episode"};
				printf("In a previous %s you mentioned %s. ", life[k], msg[m]);
				const char *add[] = {"I'm not authorised to talk about that.",
								"Have you considered getting rid of it?",
								"Do you remember?", "We can't discuss that here.",
								"We should not talk about that now.",
								"", "\t---", "\t***", "Yes, you did.", ""};
				int K = irand(10);
				printf("\n%s", add[K]);
				}
			else
				{
				const char *verb[] = {"mean", "take", };
				const char *qual[] = {"too ", "very ", "", ""};
				printf("You don't %s \"%s\" %sseriously, do you?", verb[irand(2)], msg[m], qual[irand(4)]);
				}
			}
	printf("\n");
}



void morph()
{
	
	int q = irand(9);
	char *first = NULL;
	char *second = NULL;
	
	if(q>1)
		{
		lexform LEX;
		int N = readbook(LEX);
		int k = irand(N);
		int n = irand(N);
		first  = *(LEX + k);
		second = *(LEX + n);
		if(k==n)
			first = anagram(first);
		}

	else 
		{
		char *st1[] = 	{"totalitarian psycho bitch says:",
						"it seemed like a good idea at the time",
						"all else being equal,"};
		char *st2[] = 	{"Never forget to exist; fill the void!",
						"O tell me all about Anna Livia!",
						"Doubt all. Doubt even if thou doubtest all.",
						"the great work begins & ends here." };

		first = st1[irand(3)];
		second = st2[irand(4)];
		}
	
	int WL1 = get_length(first);
	int WL2 = get_length(second);
	bool firstlong = (WL1 > WL2);	
	const int M = firstlong ? WL1 : WL2;
	char *ip = (char *) malloc( (M) * sizeof(char) );	
	sprintf(ip, "%s", first);
	if ( WL2 > WL1 )
		for(int i=WL1-1; i<M-1; i++)
			ip[i] = '.';
	else if (WL1 > WL2)
		for(int i= WL2; i<M-1; second[i++] = '*')
			;

	ip[M-1] = '\0';
	char b;	
	for(int j=M+1, k=0, last=M+1; last >= 0; --j, k++)
		{		
		ip[last] = second[last];
		--last;
		printf("\t");
		for(int i=0; i<WL1 && k != 0; i++)
			{
			b = ip[i];
			if(i==k-1 && isalpha(b))
				b = toupper(ip[i]);
			
			printf("%c", b);
			}

		if(WL2 > WL1)
			{
			++WL1;
			}
		else if(WL1 > WL2)
			{
			--WL1;
			}
		printf("\n");
		}

	ip = NULL;
	free(ip);

	printf("\n");
}



