/*
	peptalk.c
	Version 1
	© Risto Holopainen 2022
	Licenced under Creative Commons
	Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) 
	https://creativecommons.org/licenses/by-nc-sa/4.0/
*/



#ifdef _WIN32
#include <Windows.h>
#else
#include <unistd.h>
#endif

#define DEBUGGING
#undef DEBUGGING

#include "peptalk.h"
#include "catchphrases.h"
#include <stdio.h>
#include <stdlib.h>





int main(int argc, char **argv)
{
	int t = time(0);
	srand(t);

	die HARD = randem_numbar();
	int x = HARD.x;	
	const int outsz = 140;
	char out[outsz]; 
	char nonce[32];
	char *whisper = NULL;
	bool display_visuals = true;


	{
	int d = irand(4);
	if(d&1 || (argc > 1 && argc < 5) )
		{
		dialogue(argc, argv);
		display_visuals = false;
		}
	if(d&2)
		{
		lexform lex;
		const int wordcount = readbook(lex);
		talk(lex, wordcount);
		display_visuals = false;
		}
	}

	init_empty(out, outsz);

	#ifdef DEBUGGING
		{
		printf("\n\t%s\n", out);
		const char *test = "\nDISGRUNTLING INFO:";
		printf("%s x=%d\ny: %d \tk: %d \t  thirteens: %d \nwordcount: %d \t t = %d\n\n", 
			test, x, y, k, HARD.thirteens, wordcount, t);
		}
	#endif


	if ( ! is_worktime() )
		{
		const char *bye[] = {"Service closed. Bye for now.", 
			"Quitting, this service is currently closed. Please try again later today."};
		int k = irand(7) < 3 ? 0 : 1;
			printf("%s\n\n", bye[k]);
		if(HARD.sevens < 2)
			{
			web();
			sleep(1);	
			}
		exit(0);
		}


	switch (HARD.thirteens)
		{
		case 0 :
			{
			morph();
			display_visuals = false;
			break;
			}
		case 1 :
			{
			rndmsg(nonce, 31-HARD.elevens);
			sprintf(out, "%s\n", nonce);
			break;
			}
		
		case 2 :
			{
			whisper = at_home();
			sprintf(out, "%s", whisper);
			break;
			}
		case 3 :
			{
			whisper = todays_task();
			sprintf(out, "%s", whisper);
			break;
			}
		case 4 :
			{
			const char *score = music();
			sprintf(out, "\n%s", score);
			break;	
			}
		
		case 5 :
			{
			whisper = utter();
			sprintf(out, "%s", whisper);
			break;	
			}
		case 6 :
			{
			lucky_number(HARD, t);
			break;
			}
		case 7 :
			{
			whisper = emulate();
			sprintf(out, "%s", whisper);
			break;
			}
		case 8 :
			{
			whisper = abstract_phrase();
			sprintf(out, "%s", whisper);
			break;	
			}
		case 9 :
			{
			whisper = particulars();
			sprintf(out, "%s", whisper);
			break;	
			}
		case 10 :
			{
			whisper = person_statement();
			sprintf(out, "%s", whisper);
			break;	
			}			
		case 11 :
			{
			char *str = camelify ( pepping() );
			sprintf(out, "%s\n\n", str);
			break;
			}
		default :
			{
			char *str = camelify( punchline() );
			sprintf(out, "%s\n\n", str);
			}
		}


	printf("\n----------------------------------------------------------------\n");
	bool BYPASS = (HARD.thirteens == 4) ? true : false;
	line_break(out, 50, BYPASS);
	sleep(1);
	int q = x%100;
	if ( q < 2 )
		printf("\n\tNever trust an oracle.");
	else if ( q > 5 && q < 8 )
		printf("\n\tAlways trust the Oracle!");

	else if (q > 64 && display_visuals)
		{
		visuals();
		}
		
	printf("\n----------------------------------------------------------------\n\n");

	return 0;
}
