/*
	oracle.h
	help functions for Peptalk
	
	© Risto Holopainen 2021
	Licenced under Creative Commons
	Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) 
	https://creativecommons.org/licenses/by-nc-sa/4.0/	
*/

#pragma once

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdbool.h>	


int irand(unsigned int p)
{
	int x = rand() % p;
	return x; 
}

typedef struct die  
{
	short fives;
	short sevens;
	short elevens;
	short thirteens;
	int x;
} die ;


die randem_numbar()
{
	int xi = rand() ;
	
	die P;
	P.x = xi;
	P.fives = xi%5;
	P.sevens = xi%7;
	P.elevens = xi%11;
	P.thirteens = xi%13;
	return P;
}


void swap(char *a, char *b)
{
	const char c = *a;
	*a = *b;
	*b = c;
}


void swap_i(int *a, int *b)
{
	int t = *a;
	*a = *b;
	*b = t;
}


int get_length(const char *str)
{
	int n=0;
	while( str[n++] != '\0' )
		;
	return n;
}



char * camelify(const char *wisdom)
{
	int N = get_length(wisdom);
	--N;
	int K = N / 10;	// kuts
	char *mods = (char *) malloc( N+1 );

	for(int i=0; i<N; i++)
		mods[i] = wisdom[i];
	
	while(--K > 0)
		{
		int m = irand(N);	
		if(isalpha(wisdom[m]))
			{
			if (wisdom[m] >= 'a' && wisdom[m] <= 'z')
				mods[m] = toupper(wisdom[m]);
			else
				mods[m] = tolower(wisdom[m]);
			}
		}

	mods[N] = '\0';
	return mods;
}


char * reverse(const char *msg)
{
	int N = get_length(msg);
	--N;
	char *copy = (char *) malloc(N+1);

	for(int i=0; i<N; i++)
		copy[i] = *(msg+N-i-1);	

	copy[N] = '\0';
	return copy;
}


char * anagram(const char *msg)
{

	int N = get_length(msg);
	int *jj = (int *) malloc(N * sizeof(int));
	char *perm = (char *) malloc(N);
	--N;

	for(int i=0; i<N; i++)
		jj[i] = i;
	for(int i=0, p; i<N; i++)
		{	
		p = irand(N);
		swap_i(jj+i, jj+p);
		}

	for(int i=0; i<N; i++)
		perm[i] = *(msg + jj[i] );

	perm[N] = '\0';
	free (jj);
	
	return perm;
}



char * inverse(const char *text)
{
	
	int L = get_length(text);
	--L;
	char *translated = (char *) malloc ( sizeof(char) * (L+1) );
	
	for(int i=0; i<L; i++)
		{
		if( text[i] >= 'a' && text[i] <= 'z' )
			translated[i] = (i&1) ? 'z' + 'a' - text[i] : (text[i] - 'a' + 13) % 26 + 'a';
		else if (text[i] >= '!' && text[i] <= 'Z')
			translated[i] = 'Z' + '!' - text[i];
		else
			translated[i] = text[i];
		
		}
	translated[L] = '\0';	
	return translated;	
}

/*
void lucky_number(const die D, int t)
{
	int M = t, s = D.x;
	if(M < s)
		swap_i(&M, &s);
	
	if(D.thirteens == 1)	// D.thirteens ...
		{
		int C;
		const int A = t %1200;
		const int B = ((D.fives << 3) + 1) * (D.elevens + 1);
		const int R = A*B;
		printf("\n\tLet's do some mental gymnastics. What is %d × %d?\n",
			A, B);
		scanf("%d", &C);
		if(C > R)
			printf("\tToo large!\n");
		else if(C < R)
			printf("\tToo small!\n");
		else
			printf("\tCorrect!\n\n");
		return;
		}
	//else if(D.thirteens == 0)
		{
		long unsigned int v = D.elevens * D.sevens * (D.fives + 1);
		int w = D.elevens + D.sevens + D.fives;
		long unsigned int u = t << D.elevens;
		printf("\n\tThe solution to all problems, as well as your new \n\tencryption key, is: ");
		printf("%ld.%d%d%d%d:%ld%d \n\n", u, t, D.fives, D.sevens, D.elevens, v, w);
		return;
		}

	long int r = (M % s);
	int q = irand(60);
	
	if(q&1)
		r >>= D.thirteens + 1;
	if(q&2 && r > 10000)
		r >>= D.fives*D.sevens ;
	if(q&4)
		r /= (D.elevens * D.fives + 1);
	if(q&8)
		r -= (D.sevens + 1);
	if(q&16)
		r /= (D.fives + 1);
	if(q&32)
		r -= D.sevens*D.elevens;
	
	const char *luck[] = {"lucky", "new ID", "\b", "new phone", "luckiest", "serial", "queue", "most important"};
	printf("\t");
	if(D.elevens & 4)
		printf("Take note: ");
	printf("Your %s number is %ld. \n", luck[irand(8)], r);
	if (D.fives == 0)
		printf("\tIt will be important to remember this.\n");
	if (D.sevens > 4)
		printf("\tYou should write it down on a piece of paper or memorize it. \n");
}
*/


void line_break(const char *text, int width, bool bypass)
{
	if (bypass)
		{
		printf("\n%s", text);	
		return ;
		}
	//else
	
	int k = 0;
	int L = get_length(text);
	L += L/width;
	
	char *typeset = (char *) malloc( sizeof(char) * L );
	char c;
	k = 0;
	int n = 0, m = 0;

	while( (c = *(text + k)) )
		{
		++n;
		if (n >= width && c == ' ')
			{
			typeset[m++] = '\n';
			typeset[m++] = '\t';
			n = 0;
			}
		else
			typeset[m++] = c;
		++k;
		}

	typeset[m] = '\0';
	printf("\t%s\n\n", typeset);

	typeset = NULL;
	free(typeset);
}



