/*
	© Risto Holopainen 2021
	Licenced under Creative Commons
	Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) 
	https://creativecommons.org/licenses/by-nc-sa/4.0/

	markovtext:
	read transition probability table
	generate string
*/

#pragma once

//#ifndef MARKOV_H
//#define MARKOV_H

#include <stdio.h>
#include <stdlib.h>

#define MAXTABLE 5000
#define NLETTERS 26


typedef double probtable[NLETTERS][NLETTERS] ;


void readtable(probtable P)
{
	FILE *data;
	if ( !(data = fopen("markovtext_table.txt", "r")) )
		{
		printf("cannot read table markovtext_table.txt\n\n");
		exit (1);	
		}

	
	double x;
	int i=0, j=0;
	
	while( ! feof(data) )
		{
		fscanf(data, "%lf ", &x);
		P[i][j] = x;

		if(++j >= NLETTERS)
			{
			++i;
			j = 0;
			}
		if(i >= NLETTERS)
			break;
		}

	fclose(data);
}

int ctoi(char c)
{
	return (int) c - 'a';
}

char itoc(int i)
{
	return (char) 'a' + i;
}

double rnd()
{
	return (double) rand() / RAND_MAX;
}




void gibberish(probtable lex, char *message, int sz)
{
	int p = rand() % NLETTERS ;
	double x = rnd();
	char c = itoc(p);
	int i=0, k;
	
	while(i<sz)
		{
		x = rnd();
		k = 0;		
		while(x > lex[p][k] && k < NLETTERS)
			++k;

		c = itoc(k);
		p = k;
		message[i] = c;
		++i;
		}
	message[sz-1] = '\0';
}






/* 

// if you need to analyse other lagnuages ...

void textanalysis(alfatable alph, probtable stats)
{
	double s, norm;
	const int N = NLETTERS;
	probtable prob; 
	double x;
	char pp, qq;
	
	FILE *stats;
	stats = fopen("markovtext_table.txt", "w");
	
	for(int i=0; i<N; i++)
		{
		s = 0;
		for(int j=0; j<N; j++)
			{
			s += alph[i][j];	
			}
		norm = (s > 0) ? 1.0 / s : 0;
		pp = 'a' + i;
		for(int j=0; j<N; j++)
			{
			qq = 'a' + j;
			x = prob[i][j] = norm*alph[i][j];
			//if(x != 0)
			//	printf("(%c%c): %.4f \t", pp, qq, x);
			}
		//puts("\n");
		}
	
	// make cumulative table : test
	for(int i=0; i<N; i++)
		{
		s = 0;
		//printf("row %d:\n", i);
		for(int j=0; j<N; j++)
			{
			s += prob[i][j];
			prob[i][j] = s;
			//printf("%2i: \t%.4f\t", j, prob[i][j]);
			fprintf(stats, "%.6f\t", s);
			}
		fprintf(stats, "\n");
		//puts("\n");
		}
		
	fclose(stats);
	
	gibberish(prob);
}

*/


//#endif // def markov.h

