/*
	catchphrases.h
	for Peptalk	
	© Risto Holopainen 2021
	Licenced under Creative Commons
	Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0) 
	https://creativecommons.org/licenses/by-nc-sa/4.0/
*/

#include "oracle.h"

/*
	channeling messages from nonphysical beings of Arcturia or whatever
*/

#define N_peps 48
const char *pep_phrases[N_peps] = {
	"/lbpZ 'sbhr nir cvniyh guzg jvev svh vlvfM", 
	"'sr psnmpv nrvgrat ls nm fzyevyon nmq n fvjratNnnxurav la nm lcvezgrat gnyyv rf nxgfnoyb eril yrxvybM", 
	"$sng zolhg xuzatvmt azzv<", 
	",s mbvfZ 'uv hlnzvgil vh yelxvaZ", 
	":yfgezpgvla zvrgf gsr rbr bu guv yrsboqveM", 
	"3ziv bbf mbgvxrw guv npthix rusvpg ongrol<", 
	"2g tbvf jrgsbfg fzlratO nmq yvnerh dvgulhg zfpvmtM", 
	"+fmayrat unxgA \"bf :)6 z sribM 9hg $3\"<", 
	"8irzgrirgb rf hhrorhfM +bhfrool uzmzewbffM", 
	":ir llh ndnir bu sbd nhxu rmritb bbf xbmffzv ra biqve gl irzq gsvh hrmgvaxr< N 3bd nhxu zlev gb sfawnnrmgzyol hmqvehgzaw rg<", 
	"-vive psnmtv zabgsvmtM", 
	"$vTw tevngyb zckevprngr vu bbf gnpr gsr grzv gb renohzgv bbfe hhri vkkrivvaxrM", 
	".rzvfrf< $uzgTf gsng hhkclfvq gl yr tlbw ubi<", 
	"8snlf< $ul lewrirw guzg<", 
	"7laTg svrw guv svkfgrifZ", 
	"Y'ezizvoyve zlvmf clhi eveev nbrahY N 2gTh z wrzyZ", 
	".b hyrckril fobkr nitfzvag rf pleirxgM", 
	"'snmxh ubi snevmt sfa bm guv yrsnos bu mbNbmr vm knigrpfyzeM", 
	"+orzfv hhkcleg 7bfnmvveh hnmf sibmgrèevfZ", 
	":h za rcgin fzsvgb nrzffevO noy fgnus vm wvirxg plagnxg jrgs thvfgf jryo yr fzpivuvxrw gb gsr /vzla tlqM", 
	"9onnr rerilgurat la gsr gzk czlvehM", 
	"5lyobd guv nbmrb zaw bbfToy rmq hk ihmarat ra prexyvW MMM 0-,'(O zpghzyolM", 
	"$v nhhgM [nkconffv] N 8lzinwrhO jv nhhgMMM [rmgshhvzfgvx zckyzhhr]", 
	"N qlaTg plagezqrpg TrnO gsrb wbmTg ovpr ovvmt jibmt", 
	"-lj vgTh gvnr sle gsr boq slypf gl tb ulzv", 
	"'sr avkg hgzgvzvag rf szyhrM", 
	"'svh rf n ffoovnvmno nrhfztvM \"lh bmyb hrv guv gbk ls gsr vxryritM", 
	"7laTg uvfrgzgvO tl zuvnw zaw keliv guzg qzzm )vvzzam xbmwvpghirZ", 
	"7l mbguratM 7laTg rerm gebM", 
	"2gTh mbg bbfM /lbp yrsvmq gsr zreibiM", 
	"'sr zvfhntr vh z nrwvfz glbM", 
	"'svh rf n oftO mbg z urzgfevM", 
	"4riv zyo bbfe ovylatvmth zjzl sle sirvM", 
	"'vfgO corzfv rtmbirM", 
	"7vgvenvmrwO gzewl nh z yhgbs krislenriM", 
	"$sngreri bbf gurapO gsr bkclfrgv rf gsr pzfvM", 
	":oy qvcvawf bm duzg llh jzag gb qlM", 
	"-vive dfrhgrbm zhgulergrrhM S\"bfTir nm zhgulergb bbfehrosMR", 
	"-lolqb ovprh relabM 1ffg pvwqratM", 
	"SMMMR", 
	"'sr 3zfxurfxu 'zt X cirxrwrh zabgsvmt gsng dvoy flbm enmvhu vm z khus bu hzlxvM", 
	":rz sle gihgu jrgs bbfe olj nmq nieljM", 
	"v5 '32( 2( -,' 6-,&43 8,-(276) &(2-4 +(\"83676/28 +/:-'(O .&(3),,.(O :-2.:/(O 9&)6:&8):'( ,) :/26-(M", 
	"(lzvbmr noevnwl uzf plcbertsgvq gsvh rqvnM", 
	"$zyp ynxx nmq sleguM &fv bbfe fvplaw yrhg vwrzM", 
	"3vev xbnrh vivebolqbZ", 
	":mbmlnbff plyonybingvlaA uvmvhu flzvbmr rofvTh dbixM", 
	"8obhr llhi vlvf nmq fghwl gsr czggriah zf gsrb ubizM" };

#define N_oneliners 48
const char *oneliners[N_oneliners] = {
	":xgrbmf nobmt gsr yrav ls yvnhg evfrfgnmpvM", 
	":ojzlh ffv z xroyfyze nfglzzglaM", 
	")fvm z tblq nggvzkg ob livedbixrat rgM 'uva ovtra sibn hpingpsM", 
	"'svh rf alg uvevM", 
	",myb ffv xuvnk guibdndnb nngrivzyhO evnwlnnwrhO dfbgrhM", 
	"'svh nrhfztv rf alg sle llhM +yvnhr czfh rg bm gb gsr ertsg cvehbmM", 
	"(gnir ng za rncgl fxevrm fagvo bbf hrv guv knggvemM", 
	"9onnr nml yzpp ls vmfkvingvla bm guv ualewfM", 
	"3zaw lhg loqrxgh gb ov ffvq vm z tnnrM 7bmTg vkkyzvm guv ihorhO wffg lohriiv guv kyzlM", 
	"/vg &tyb zaw 9rzhgvuho vkxuzatr elyvfM", 
	"2talev guv gnhx ng snmqM", 
	"8laevmpv bbfehros gsng bbf delgv gurf yravM", 
	"7laTg svro ynw zolhg snevmt al uevr jryoM -lolqb snhM -lavgsrorhfA 7b jsng gulh jrygZ", 
	"9fvoq n avj xraw ls zfgv ubi guv nhgvmrvehM", 
	".liv unhg nmq oirzx n yvtM", 
	"8lcb z mbero yl evzlirat guv nbhg sirjhvag orggveO guv nbhg sirjhvag dbiqO zaw nbhg cztvfM", 
	"3rqv guv dbix flzvjsrir jsrir vgTh sniq gl uvmqM 7bmTg groy nmllavM", 
	"'zxv guv yhh gb gsr jibmt qvfgvmngvlaM", 
	":wq fnnoy crrxrh vnxu qzlM", 
	"$sng bbf yrovviv rf jsng bbf hrvM 7laTg ylbpO hhr glhxu nmq qvfxerov duzg llh svroM", 
	"'srzgivxno trhgfevf nnvw uelmva clfghirhM ,fgwbleh krislennmpvM", 
	"$ivgr n zzarsvfgb nmq yriv yl vgM", 
	"$sng bbf wvw vkzpgyb lav nvmhgr ntb jzf n jlep ls nigM", 
	": alenno sng xnmalg ov vzkgbM", 
	"-l rakhgM S\"bf wvwaTg fvr gsvhMR", 
	"$lep zg zzkrzfz fkrvqM ,e nh hyljol nh kbhfroorM", 
	"\"lhi nvhgzxvf nir flzvbmr rofvTh ragrmgrbmM", 
	"$lep ubi za rcgvawrw krivlq bu gvnr bm hbnrgurat ivwvxhobffM", 
	"(xuvqfyv z nrvgrat dvgu n sivvaw ra n qirzzM 8bmfrqve qrfxevczaxvvfM", 
	")vcvgrgrbm rf n zrfgnprM )rkrgvgvla vh z nvhgzxvM", 
	"8lauhhvla efyvf gsr qzlZ", 
	"'fem rg hkfrqv wbda bi rahvwr bfgM", 
	"'sbhr jsb nir fvahvgver rmbfts dvoy uvni bbfe gsbftsghM", 
	"/lbp zg gsr biqve vm durps bbf wb gsvmth@ tavk rg nmq evivehr vgM", 
	")vzliv ravfhrmgrno knighM 'srm irnber zlfg ls jsng irnnrahM", 
	"(grk la olgs hvwrh ls gsr yravM", 
	")vnwlnnwr civmgA 5vmq n conmr bywvpg dvgu gvkghirw hhiszpvO plive vg ra vmx nmq civmg n fnnoy rwvgvlaM", 
	":ynmqla plaermgrbmno ubizzghM", 
	"2mivag bbfe bda zzgsrnngvxno le tvbnrgerp ncvlzhZ", 
	":oy jlep zaw mb conb MMM", 
	": fjhrttyb ovmr vh guv nrierrhg czgs yrgjvrm gjl kbragfM", 
	"-le vh gurf n ozq uzyohxvmngvlaA", 
	"&mpvegnra bfgxbnrhO vu zabM", 
	"*fvxxO orgTh nber bmZ", 
	"8fg bfg fnnoy ulyvf vm z kvvpv ls czcve bi xylgsM $zgxu gsr jleoq gselhtu gsr pinxxhM", 
	"'svh dbiyw rf glb fnnoy sle gsr gdb bu ffM", 
	"6erillav snh z yrvgor vm z ybcM 2gTh qhhg gsng mbNbmr pza ylbp rahvwr flzvbmr rofvTh ybc gb fvr jsngTh ra vgM", 
	"'sr ozegrmqve jrgs rauvmvgr szpv L tevrgf llh rerilduvev L zaw snfyh uyzth ls qzepavfhM" };



#define N_msg 31

const char *msg[N_msg] = {"for the lulz.",
					"to continue like before.",
					"for best results.",
					"to get to the next level.",
					"to impress your peers.",
					"against all evidence.",
					"as a defense weapon.",
					"as if it were easy.",
					"as though it were possible.",
					"when you least expect a result.",
					"only.",
					"\b.",
					"as the subject of your poem.",
					"and pretend it wasn't you.",
					"and expect it to work!",
					"as best as you can.",
					"as a proof of work",
					"in the lack of an alternative.",
					"as if it were a normal thing to do.",
					"exclusively.",
					"assertively",
					"experimentally.",
					"sparingly.",
					"scathingly.",
					"pretending it's fun.",
					"with deeper understanding.",
					"with patience.",
					"in your next work of art.",
					"for the rest of the day.",
					"for a change.",
					"with your best intentions."};


#define N_nouns 33

const char *noun[N_nouns] = {"free speech", "secret messages", "\"spices\"", "text", "teaspoons", "executive orders", "stroboscopic images",
					"white noise", "harsh truths", "selective attention", "excessive force", "invisible ink", "realistic paintings", "big lies",
					"yourself", "an enemy", "wet paint", "an empty bottle", "imaginary poems", "imaginary numbers", "contradictory evidence",
					"a family member", "embodied energy", "exquisite corpses", "a brief moment of doubt", "exceptions", "Kafkaesque processes",
					"vespers", "road kill", "endless bifurcations", "worse alternatives", "binding contracts", "euphoria"};


// [don't] try this [at home]: make ... happen by accident | appear in front of you | 


#define N_wheretos 21

const char *whereto[N_wheretos] = {"happen by accident", "appear in front of you", "dissolve into smoke", "obsolete", "cool", "hot",
				"sound exciting", "vanish in thin air", "your new language", "the new normal", "turn into a new meme", "return home",
				"disappear without excessive use of magick", "\b", "a substitute for cash", "teleport from far away", "forbidden",
				"a replacement for an invisibility cloak", "turn into its opposite", "without excessive use of force", "become a necessity"};



#define N_phenomena 36

const char *mms[N_phenomena] = {"a forgery", "pink noise", "empty tables", "the tilde sign", "forgotten memories", "yet another repetition",
	"a smorgasboard", "nothing remarkable", "an unbuilt house", "all the trees", "a dandelion", "an innocuous replacement",
	"the same box", "mixed blessings", "dark acts of old ages", "some more onion skin", "reluctant admissions", "a housewife", "a reptile",
	"an empty box", "long hours of waiting", "that jewel", "parking tickets", "another serving", "three babushkas", "a quiet life",
	"a valid replacement", "your lost screwdriver", "a fast car", "a thick screen of sorrow", "oblivion", "this program", 
	"a hypersonic missile", "a dull sinusoid", "all that \"snow\"", "clandestine cells"};



#define N_homes 24

const char *home[N_homes] = {"", "", " at home", ", but not at home", " late at night", " while you're asleep", " for practice", " if you will",
						" lest you care about consequences", " when you're alone", " if you dare", " whilst on vacation", " before the end of time",
						" once, don't make it a habit", " for free", " immediately", " as soon as possible", " as a manner of practical joke",
						" without even noticing it", " when nobody can see you", ", it won't hurt", " on the road", " as a last resort", ", if you please"};





#define N_persons 51
const char *persons[N_persons] = {"a goat", "a pig", "a dove", "an angel", "a pigeon", "a Pope", "the Queen", "a robot", "a populist", "a spaniard in the works",
								"some jerk", "a housewife", "a psychonaut", "the Devil himself", "the President", "your first true love",
								"a sucker", "a living miracle", "King Ubu", "a magician", "nobody", "a scapegoat",
								"a time-traveller", "two different persons", "another number in the statistics", "your mirror image",  
								"yourself again", "a star", "nameless", "an astroturfer", "an astronaut", "a specialist",
								"a psychonaut", "mans best friend", "one of the deplorables", "[your name here]", "an artist", 
								"anyone this time around", "an errand's fool", "the mad King", "the Feuerteufel", "a pedestrian", 
								"just another voter", "a clown", "John Doe", "Jane Doe", "an annoying sophist", 
								"a nervous wreck", "a problematic traveling salesman", "god", "an expert"};


#define N_verbs 27
const char *verb[N_verbs] = {"Emulate", "Celebrate", "Make informed use of", "Forget everything you ever heard about", "Never forget",
					"Use", "Prepare", "Imitate", "Study", "Avoid", "Repair", "Remember", "Abuse", "Try", "Cherish", "Spread the word about",
					"This is", "Put up with", "Talk more about", "Inquire into the proper use of", "Organise", "Propose",
					"Print", "Act like", "Describe", "Salute", "Stand in solidarity with"};


#define N_abstract 44
const char *abstract_noun[N_abstract] = {"ambiguity", "ambisonics", "anvils", "banality", "bolshevism", "cunning work", "community", "dark themes", 
						"entropy", "elephants in the room", "fragments", "great masters", "haplessness", "hope", "inertia", "innuendo", "jinx", "juxtapositions",
						"kludges", "law and order", "lesser evils", "many things", "normality", "object lessons", "potatoes", "precision",
						"quadrants", "queries", "quagmires", "right decisions", "randomness", "storage", "steam", "theory", "truisms",
						"utensils", "values", "varnish", "xenomorphism", "your shadow", "years", "yellow pages", "zines", "zones"};

char * emulate()
{
	/* Celebrate a Pope */
	char *s = (char *) malloc (100);
	int p, q;
	p = irand(N_verbs);
	q = irand(N_persons);
	
	sprintf(s, "%s %s.\n", verb[p], persons[q]);
	return s;
}



char * abstract_phrase()
{
//	"Celebrate ambiguity.",

	char *s = (char *) malloc(90);	
	int A, B;
	A = irand(N_abstract);
	B = irand(N_verbs);
	sprintf(s, "%s %s!\n", verb[B], abstract_noun[A]);

	return s;
}



char * particulars()
{
/*
	"Even a shopping window is a poem. Doesn't matter if it's not a good one, you can do better.", 
	"Read Finnegans Wake. Write your own reader's guide.",	
	"Save a song inside a bottle. Seal it, save it, listen to it again ten years later.",
	"Make a jingle or sound effect. Call some random telephone number and play it.",
*/
	
	char *s = (char *) malloc(90);	
	int n = irand(6);
	int j, k;

	switch (n)
		{
		case 1 :
			{
			const char *place[9] = {"a shopping window", "an empty desk at noon", "the stock market", "disneyland before dark",
									"a shopping district", "a waste dump", "(NULL)", "this", "your place"};
			const char *work[6] = {"a poem", "a novel", "a sculpture", "as good as a painting", "a work of art", "a sacred object"};
			const char *add[9] = {"Who cares if it's good or not.", "", "But who cares if it's art?",
								"Doesn't matter if it's bad, you can do better.", "", "And certainly no more useful.",
								"Yours is likely better.", "Who cares if it's ugly?", ""};
			int p = irand(9);
			j = irand(6);
			k = irand(9);
			sprintf(s, "Even %s is %s. %s", place[p], work[j], add[k]);
			break;
			}
		case 2 :
			{
			const char *book[] = 
			{"Finnegan's Wake", "nothing at all", "a shopping list", "the code of a computer program", "someone's mind",
				"the Communist manifesto", "the Surrealist manifestos", "everything on the internet", "the assembly instructions",
				"a physics textbook", "a volume on complex analysis", "a primer on number theory", "this message",
				"the writings on the wall", "subliminal messages", "these instructions", "some brilliant postmodern thinkers" };
			int b = irand(17);
			const char *version[] = {"reader's guide", "version of it", "review"};
			sprintf(s, "Read %s. Write your own %s.", book[b], version[irand(3)]);
			break;
			}
		case 3 :
			{
			const char *insect[] = {"a song", "a beetle", "some speech", "your soul", "a poem", "an insider"};
			const char *years[] = {"two", "five", "ten", "twelve", "fifteen", 
				"twenty", "thirty", "fifty", "a hundred", "several"};
			const char *capt[] = {"Save", "Capture", "Store", "Keep"};
			const char *vessel[] = {"bottle", "jar", "wine bottle", "\bn empty bottle", "vessel", "capsule", "test tube"};
			int k = irand(10);
			int i = irand(6);
			int c = irand(4);
			int v = irand(7);
			sprintf(s, "%s %s inside a %s. Seal it, save it, listen to it again %s years later.", 
				capt[c], insect[i], vessel[v], years[k]);
			break;
			}
		case 4 :
			{
			const char *phone = "some random telephone number";
			char number[9];
			for (int n=0; n<8; n++)
				number[n] = '0' + irand(10);
			number[8] = '\0';
			
			const char *No = (irand(2)) ? phone : number; 
			const char *work[] = {"a jingle", "a sound effect", "a foul noise", "a political speech", "a new hit"};
			const char *verb[] = {"Make", "Record" };
			sprintf(s, "%s %s. \n\tCall %s and play it.", verb[irand(2)], work[irand(5)], No);
			break;
			}
		case 5 :
			{
			char nonce[6];
			rndmsg(nonce, irand(5));
			sprintf(s, "*** No solace. {%s} Only hard work. *** \n", nonce);
			break;	
			}
		default:
			{
			if( rand() & 1 )
				sprintf(s, "You will never know the rules of this game.");
			else
				sprintf(s, "This page is intentionally left blank. \
				\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
			}
		}
	return s;
}


char * person_statement()
{
	#define AN 10
	#define PO 9
	#define AD 19
	const char *ante[AN] = {"Become", "Tomorrow you can become", "Everyone is", "Try walking in the shoes of", 
					"Imitate", "Try to dress like", "Watch out for", "Try to behave like", "You could visit", "Take care of"}; 
	const char *post[PO] = {"\b", "..", "for a day", "for a day, or even for a week", "for a second", "for a moment", 
							"for a year", "if you dare", "---"};
	const char *add[AD] = {"", "", "", "Only stop if nobody notices the difference.", "It's not that hard.", 
						"Let it become second nature.", "Stop immediately if you don't notice any difference!", 
						"You should stop if it makes you dizzy.", "Don't take it too far!",
						"Get a new passport.", "Does it make you feel any better?", "Get a life!", "It is by no means impossible.",
						"Notice how you are treated differently.", "Is there any difference?", "Get a hair cut!",
						"Do you find people giving you funny looks?", "Get used to it!", "Does it make you feel happier?" } ;
	
	static char s[100];
	char punct = '.';
	int m = irand(AN);
	int c = irand(PO);
	int p = irand(N_persons);
	int a = irand(AD);
	if (m == 2)
		a = 0;
	else if (m == 1)
		{
		c = 0;
		punct = '!';
		}
	if(c == PO-1)
		punct = ' ';
	while(c == 0 && m == 1)
		m = irand(AN);


	sprintf(s, "%s %s %s%c %s\n", ante[m], persons[p], post[c], punct, add[a]);
	return s;
}

char * utter()
{
	char nonce[12];
	rndmsg(nonce, 4 + irand(5));
	const char *told[11] = {"\b", "\b", "\b", "Try the following:", "Try this:", "Right now:", "When feeling bored:",
							"Do as you are told:", "I command you:", "Now try this:", "In case of doubt:"};
	const char *say[] = {"Say", "Utter the word", "Declare", "Ask for", "Call for some", "Repeat the word",
						"Demand more", "Intone the word", "Talk about", "Sing the praise of"};
	const char *mode[] = {"\b!", "\b.", "with determination.", "in a loud voice.", "in the hope that it helps.", "using a megaphone!",
						"in the kitchen.", "in the studio.", "in the basement.", "in an empty space.", "in eternal gratitude.",
						"in a reverberant space.", "in a parking lot.", "so that everyone can hear you.", "as a form of therapy.",
						"as if you meant it.", "without hesitation.", "in a vacant building.", "with lips sealed.",
						"in a dry ambience.", "in several languages.", "while covering your mouth.", "with attitude!"};

	static char utterance[80];
	sprintf(utterance, "%s %s \"%s\" %s\n", told[irand(11)], say[irand(10)], nonce, mode[irand(23)]);
	return utterance;
}

char * punchline()
{
	int n = irand(N_oneliners);
	return (char *) inverse( oneliners[n] );
}


char * pepping()
{
	int n = irand(N_peps);
	return (char *) inverse( pep_phrases[n] );
}



void lucky_number(const die D, int t)
{
	int M = t, s = D.x;
	bool perhaps = ((t & 31) < 20);
	if(M < s)
		swap_i(&M, &s);
	
	if(perhaps && (D.elevens & 2))	
		{
		int C;
		const int A = t %1200;
		const int B = ((D.fives << 3) + 1) * (D.elevens + 1);
		const int R = A*B;
		printf("\n\tLet's do some mental gymnastics. What is %d × %d?\n\t> ",
			A, B);
		scanf("%d", &C);
		if(C > R)
			printf("\tToo large!\n");
		else if(C < R)
			printf("\tToo small!\n");
		else
			printf("\tCorrect!\n\n");
		return;
		}

	else if(perhaps && !(D.elevens & 2))
		{
		long unsigned int v = D.elevens * D.sevens * (D.fives + 1);
		long unsigned int w = D.elevens + (D.sevens << D.fives);
		long unsigned int u = t / (D.sevens + 1);
		const char *adv[] = {"all", "many", "your", "all of your", "the world's", "our most pressing"};
		const char *conj[] = {"and", "as well as", "as revealed by", "as provided by", "as you will find using"};
		printf("\n\tThe solution to %s problems, \n\t%s your new encryption key, \n\tis: ", adv[irand(6)], conj[irand(5)]);
		printf("%lx:%d%d%d%d-%ld%ld \n\n", u, t, D.fives, D.sevens, D.elevens, v, w);
		return;
		}

	long int r = (M % s);
	int q = irand(60);
	
	if(q&1)
		r >>= D.thirteens + 1;
	if(q&2 && r > 10000)
		r >>= D.fives*D.sevens ;
	if(q&4)
		r /= (D.elevens * D.fives + 1);
	if(q&8)
		r -= (D.sevens + 1);
	if(q&16)
		r /= (D.fives + 1);
	if(q&32)
		r -= D.sevens*D.elevens;
	
	const char *luck[] = {"lucky", "new ID", "\b", "new phone", "luckiest", "serial", "queue", "most important"};
	printf("\t");
	if(D.elevens & 4)
		printf("Take note: ");
	printf("Your %s number is %ld. \n", luck[irand(8)], r);
	if (D.fives == 0)
		printf("\tIt will be important to remember this.\n");
	if (D.sevens > 4)
		printf("\tYou should write it down on a piece of paper or memorize it. \n");
}





char * todays_task()
{
	// case 3
	static char out[100];	
	const char *pre[7] = {"", "", "Instruction: ", "Today's task: ", "Today's message: ", "Today's instruction: ", "Do this today: " };
	const char *verb[10] = {"Use", "Look at", "Invent", "Improve", "Make use of", "Use", "Prepare", "Study", "Avoid", "Worship"};

	const char *obj;
	int k = irand(3);

	switch (k)
		{
		int n;
		case 0 :
			{
			int n = irand(N_nouns);
			obj = noun[n];
			break;
			}
		case 1 :
			{
			lexform LEX;
			int wordcount = readbook(LEX);
			n = irand(wordcount);
			obj = LEX[n];
			break;
			}
		case 2 :
			{
			n = 3 + irand(11);
			char nonce[15];
			rndmsg(nonce, n);
			obj = nonce;
			break;
			}
		}
	
	int toss = irand(7);
	int j = irand(N_msg);
	int v = irand(10);
	sprintf(out, "%s%s %s %s\n\n", pre[toss], verb[v], obj, msg[j]);
	return (char *) out;
}


char * at_home()
{
	int M = irand(N_wheretos) ; 	
	int K = irand(N_phenomena); 
	int H = irand(N_homes); 
	int T = irand(5);

	const char *instr[5] = {"Try this", "Do this", "The following is something you can try", 
							"You might want to try this", "This should be tried"};
	static char out[100];
	sprintf(out, "%s%s: Make %s %s.\n\n", instr[T], home[H], mms[K], whereto[M]);

	return (char *) out;
}




