#include <stdlib.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <string.h>
#include <poll.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <ctype.h>
#include <sys/time.h>

int cert_ok(int u, X509_STORE_CTX* c) {
  (void)u; (void)c;
  return 1;
}

int time_difference(struct timespec *start, struct timespec* end) {
  if (end->tv_sec < start->tv_sec)
    return 0;

  if (end->tv_nsec < start->tv_nsec) {
    --end->tv_sec;
    end->tv_nsec += 1000000000;
  }

  int ms = 1000 * (end->tv_sec - start->tv_sec) + ((end->tv_nsec - start->tv_nsec) / 1000000);
  return ms;
}

int main(int argc, char* argv[]) {
  struct timespec ts1, ts2;
  if (argc < 3) {
    fprintf(stderr, "provide a host and a port\n");
    return -1;
  }

  in_addr_t ia = inet_addr(argv[1]);
  in_port_t ip = htons(atoi(argv[2]));

  clock_gettime(CLOCK_MONOTONIC, &ts1);
  int s = socket(AF_INET, SOCK_STREAM, 0);
  if (s < 0) {
    perror("socket");
    return -1;
  }

  struct sockaddr_in ai;
  ai.sin_family = AF_INET;
  ai.sin_port = ip;
  ai.sin_addr.s_addr = ia;

  if (connect(s, (struct sockaddr*)&ai, sizeof(ai)) < 0) {
    perror("connect");
    return -1;
  }

  clock_gettime(CLOCK_MONOTONIC, &ts2);
  int ms = time_difference(&ts1, &ts2);
  fprintf(stderr, "connected in %d ms\n", ms);

  SSL_CTX* ctx = SSL_CTX_new(TLS_client_method());
  if (!ctx) {
    fprintf(stderr, "No SSL_CTX\n");
    return -1;
  }

  SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);

  SSL* ssl = SSL_new(ctx);
  if (!ssl) {
    fprintf(stderr, "No SSL\n");
  }

  SSL_set_fd(ssl, s);

  if (SSL_connect(ssl) <= 0) {
    fprintf(stderr, "error on connect: %s\n", ERR_reason_error_string(ERR_get_error()));
    return -1;
  }
  fprintf(stderr, "connected\n");

  char* reqstr;
  if (argc > 3) {
    int l = strlen(argv[3]);
    if (l >= 2 && argv[3][l-2] != '\r' && argv[3][l-1] != '\n') {
      fprintf(stderr, "appending \\r\\n to request\n");
      reqstr = malloc(l + 3);
      reqstr[0] = '\0';
      strcat(reqstr, argv[3]);
      reqstr[l] = '\r';
      reqstr[l+1] = '\n';
      reqstr[l+2] = '\0';
    } else {
      reqstr = strdup(argv[3]);
    }
  } else {
    reqstr = strdup("gemini://localhost:1965/test/uri\r\n");
  }

  {
    char* d = strdup(reqstr);
    for (char* c = d; c && *c; ++c) {
      if (!isgraph((int)*c))
        *c = isspace((int)*c) ? ' ' : '.';
    }
    fprintf(stderr, "requesting '%s'\n", d);
    free(d);
  }

  fprintf(stderr, "===\n");
  int r = SSL_write(ssl, reqstr, strlen(reqstr));
  if (r != strlen(reqstr)) {
    fprintf(stderr, "SSL error: %d\n", r);
    return -1;
  }
  free(reqstr);

  size_t block_read = 0;
  size_t total = 0;
  char buf[10240];
  while ((r = SSL_read(ssl, buf, sizeof(buf))) > 0) {
    fprintf(stderr, "read %d bytes\n", r);
    total += r;
    block_read += r;
    fwrite(buf, 1, r, stdout);
    close(s);
    s = -1;
  }

  if (r == 0) {
    int sd = SSL_shutdown(ssl);
    if (sd != 1) {
      fprintf(stderr, "unclean shutdown: %d\n", sd);
    } else {
      fprintf(stderr, "ssl connection shutdown\n");
    }
  } else if (r < 0) {
    unsigned long err = ERR_peek_error();
    int e = SSL_get_error(ssl, r);
    fprintf(stderr, "error on read %d: %s\n", e, ERR_reason_error_string(err));
    if (e == SSL_ERROR_ZERO_RETURN)
      SSL_shutdown(ssl);
  }

  SSL_free(ssl);
  SSL_CTX_free(ctx);
}
