#!/bin/sh

# this will work with (at least) OpenSSL 3.3.3 or later.  LibreSSL 4.1.0 can
# generate ed25519 certificates but libssl cannot use them, so you'll need to
# pick something else on OpenBSD, and you will need to change -noenc to the
# older '-nodes' option (see the second line below).  The -subj option is
# optional, but you probably at least want to specify a /CN= field which should
# be the hostname of your server. You can also expand on the -subj option with
# more info if so desired:
# -subj "/C=US/ST=NY/L=Buffalo/O=IBM/OU=Research/CN=gemini.ibm.com"
openssl req -x509 -newkey ed25519 -keyout key.pem -out cert.pem -sha256 -days 3650 -noenc -subj "/CN=`hostname`"

# This line is compatible with OpenBSD and generates a 4096-bit RSA key
#openssl req -x509 -newkey rsa:4096 -keyout key.pem -out cert.pem -sha1 -days 3650 -nodes -subj "/CN=`hostname`"
