#if defined(__linux__)
#define _GNU_SOURCE
#endif //  defined(__linux__)

#include <libpxd/px_gemini.h>
#include <libpxd/px_log.h>
#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

// whether the URL is a valid gemini request
// requires that the url is percent-encoded
_Bool px_gemini_is_valid_url(struct px_url const* url, _Bool require_scheme) {
  if (!url)
    return false;

  // is it a gemini request?
  if (require_scheme && (!url->scheme || strcmp(url->scheme, "gemini://") != 0))
    return false;

  return true;
}

unsigned px_gemini_encode_header(int code, char const* meta, char* buf, size_t buf_sz) {
  if (code < 0 || code > 99 || !buf || buf_sz < 4 /* <digit><digit>\r\n */)
    return 0;

  size_t meta_sz = meta ? strlen(meta) : 0;
  int i_buf_sz = buf_sz < INT_MAX ? buf_sz : INT_MAX;
  int r = snprintf(buf, i_buf_sz, "%02d%s%s\r\n", code, (meta_sz > 0 ? " " : ""), (meta ? meta : ""));
  if (r < 0 || r >= i_buf_sz) // require buf to be null-terminated
    return 0;
  return r;
}

// return nonzero if the buffer contains a valid gemini header
// gemini header: xx( meta)?\r\n
// where xx == two digits
//       ( meta)? is an optional string beginning with a space
//       \r\n are carriage return line feed
// buf_sz should be the number of non-null chars in buf (e.g. strlen)
int px_gemini_is_valid_header(char const* buf, size_t buf_sz) {

  // TODO we should put more checks here, e.g. make sure meta has no non-printables etc

  if (!buf || buf_sz < 4)
    return 0;

  // make sure there's a status code
  if (buf[0] < '0' || buf[0] > '9' || buf[1] < '0' || buf[1] > '9')
    return 0;

  // need one space after the status code
  if (buf_sz > 4 && buf[2] != ' ')
    return 0;

  if (buf[buf_sz - 2] != '\r' || buf[buf_sz - 1] != '\n')
    return 0;

  return 1;
}
