#ifndef POLLUXD_H__
#define POLLUXD_H__

#include <polluxd_config.h>
#include <polluxd_route.h>

#include <libpxd/px_event.h>
#include <libpxd/px_gemini_ctx.h>
#include <libpxd/px_listen.h>
#include <libpxd/px_route.h>
#include <libpxd/px_workq.h>

#include <dirent.h>
#include <sys/types.h>

#define MAX_POLLUXD_ACTIONS 32

struct px_fileinfo {
  FILE* file;
  DIR*  dir;
  char* pathname;
  //_Bool regular_file;
};

struct polluxd_client; // forward declaration

typedef _Bool (*polluxd_data_cb)(struct polluxd_client*);

struct polluxd_client {
  struct px_queue                   clientq;    ///< queue entry; how the server keeps track of clients
  struct px_gemini_context          gemctx;     ///< the stuff important for gemini

  struct polluxd_context*           pxd;          ///< the server context

  // NEVER send this data to the client, it is internal to the server
  struct polluxd_route_data const*  route;        ///< information about where the request should go
  struct px_path                    routed_path;  ///< the path post-route transformation
  char*                             routed_path_str; ///< stringified version of routed_path

  polluxd_data_cb                   data_cb;

  // for file descriptor-based transmissions
  struct px_fileinfo                fileinfo;

  // events for the work loop
  struct px_event                   net_ev;   ///< event for gemctx->conn.fd
  struct px_event                   file_ev;  ///< event for fd
  struct px_event                   timeout_ev;  ///< event for timing out the connection
};

struct polluxd_context {
  struct polluxd_config     conf;   // logical representation of the configuration file
  struct px_route           routes; // root of the route tree
  struct polluxd_route_data route_data[MAX_POLLUXD_ACTIONS];
  _Bool                     needs_cgi;

  struct px_listen_socket   listen;     ///< listening socket
  struct px_event           accept_ev;  ///< event for accepting connections

  struct px_queue           client_head;  ///< one entry for each client connected to the server
                                          ///< (stored as polluxd_client objects)
  size_t                    n_clients;    ///< length of client queue

  _Bool                     stop;

  struct px_workq           workq;
};

// we need this for our different actions
void                polluxd_close_client(struct polluxd_client* client);
struct px_fileinfo  polluxd_launch_cgi(struct polluxd_client* client, char const* path_str);
void                polluxd_drop_privileges(char const* drop_user, char const* drop_group,
                                            char const* chroot_dir, char const* docroot, _Bool need_cgi);

#endif // POLLUXD_H__
