#!/bin/sh

OUTDIR=${1:-/tmp}

die() {
  echo "$@"
  exit -1
}

git status 2>/dev/null >&2 || die "This script needs 'git archive' to work"

[ -d "$OUTDIR" ] || die "output directory $OUTDIR is not a directory"

echo "Building the project to ensure it's correct"
make 2>/dev/null >&2 || die "could not build the project"

[ -f "include/libpxd/px_version.h" ] || die "no px_version.h, it needs to be present to generate an archive"

TAG=""
if [ "`git status -uno --porcelain 2>/dev/null | wc -l 2>/dev/null`" -ne 0 ] ; then
  TAG="`git rev-list --abbrev-commit --max-count=1 HEAD 2>/dev/null`"
  TAG="${TAG}-devel"
else
  TAG="`git tag --contains HEAD 2>/dev/null`"
  if [ -z "$TAG" ] ; then
    TAG="`git rev-list --abbrev-commit --max-count=1 HEAD 2>/dev/null`"
  fi
fi

PREFIX=libpxd-${TAG:-git}
PX_VERSION_H_DATE="`date --date="@$(stat -c "%Y" include/libpxd/px_version.h)" +%Y%m%d`"
OUTFILE="${OUTDIR}/${PREFIX}-${PX_VERSION_H_DATE}.tar.gz"

git archive --prefix="${PREFIX}/include/libpxd/" --add-file include/libpxd/px_version.h --prefix="${PREFIX}/" -o "$OUTFILE" HEAD || die "Could not create archive"
echo "$OUTFILE"
