#ifndef PX_NETWORK_H__
#define PX_NETWORK_H__

#include <openssl/ssl.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/un.h>

// this is the maximum TLS record size per RFC 8449 (2^14)
#define PX_TLS_MAX_PACKET_SZ 16384
#define PX_TLS_MAX_PLAINTEXT_SZ 16256  // give us 128 bytes of overhead room
#define PX_TLS_MIN_PLAINTEXT_SZ 64

// PX_HOST_STR_LEN is the max size of buffer needed to hold the characters of <IP>:<PORT> when converting
#define PX_HOST_STR_LEN (sizeof(((struct px_connection*)0)->host_addr_str) + sizeof(((struct px_connection*)0)->host_port_str) + 1)

#define PX_INET4_ADDRSTR_LEN (INET_ADDRSTRLEN+1+6+1) // enough space for <IPv4>:<PORT><nul>
#define PX_INET6_ADDRSTR_LEN (INET6_ADDRSTRLEN+1+6+1) // enough space for <IPv6>:<PORT><nul>
#define PX_UNIX_ADDRSTR_LEN (sizeof(((struct sockaddr_un*)0)->sun_path)+1) // enough space for <unix path><nul>

//#define PX_ADDRSTR_LEN sizeof(union { char in4[PX_INET4_ADDRSTR_LEN]; char in6[PX_INET6_ADDRSTR_LEN]; char un[PX_UNIX_ADDRSTR_LEN]; })
#define PX_ADDRSTR_LEN_EXPECTED sizeof(union { char in4[PX_INET4_ADDRSTR_LEN]; char in6[PX_INET6_ADDRSTR_LEN]; char un[PX_UNIX_ADDRSTR_LEN]; })
#define PX_ADDRSTR_LEN 256

_Bool px_net_addr_to_str(int sock, char* addrbuf, size_t addrbuf_sz, char* hostbuf, size_t hostbuf_sz,
                              char* portbuf, size_t portbuf_sz, _Bool get_peer);
_Bool px_net_local_addr_to_str(int sock, char* bufip, size_t bufip_sz);
_Bool px_net_peer_addr_to_str(int sock, char* bufip, size_t bufip_sz);

SSL_CTX* px_net_ssl_ctx(void);
_Bool px_net_use_ssl_cert(SSL_CTX* ctx, char const* certfile, char const* keyfile);

#endif // PX_NETWORK_H__
