#ifndef PX_GEMINI_H__
#define PX_GEMINI_H__

#include <libpxd/px_common.h>
#include <libpxd/px_path.h>
#include <libpxd/px_url.h>
#include <stddef.h>
#include <stdint.h>

#define PX_GEMINI_REQUEST_SZ 1024

//int px_gemini_decode_url(struct px_gemini* gemreq);
//int px_gemini_clean_path(struct px_gemini* gemreq);
//int px_gemini_request_is_valid(struct px_gemini* gemreq);
_Bool px_gemini_is_valid_url(struct px_url const* url, _Bool require_scheme);

// @brief return true if the buffer contains a request delimiter compatible
// with a gemini request (i.e. \r\n is within the first 1024 bytes of buf)
_Bool px_gemini_has_request_delimiter(uint8_t const* buf, size_t buf_sz);

char* px_decode_url_string(char const* str);

unsigned px_gemini_encode_header(int code, char const* meta, char* buf, size_t buf_sz);
int px_gemini_is_valid_header(char const* buf, size_t buf_sz);
//unsigned px_gemini_set_header(struct px_gemini* gemreq, int status, char const* meta);
//char const* px_gemini_get_response_meta(struct px_gemini* gemreq);
//int px_gemini_get_response_code(struct px_gemini* gemreq);

//int px_gemini_needs_body(struct px_gemini* gemreq);

#define PX_GEMINI_HEADER_SZ 1024

#define PX_INPUT_DEFAULT 10
#define PX_INPUT_SENSITIVE 11

#define PX_SUCCESS_DEFAULT 20

#define PX_REDIRECT_TEMP 30
#define PX_REDIRECT_PERM 31

#define PX_TEMPFAIL_DEFAULT 40
#define PX_TEMPFAIL_SERVER_UNAVAIL 41
#define PX_TEMPFAIL_CGI_ERROR 42
#define PX_TEMPFAIL_PROXY_ERROR 43
#define PX_TEMPFAIL_SLOW_DOWN 44

#define PX_PERMFAIL_DEFAULT 50
#define PX_PERMFAIL_NOT_FOUND 51
#define PX_PERMFAIL_GONE 52
#define PX_PERMFAIL_PROXY_REFUSED 53
#define PX_PERMFAIL_BAD_REQUEST 59

#define PX_AUTH_DEFAULT 60
#define PX_AUTH_CERT_NOAUTH 61
#define PX_AUTH_CERT_INVALID 62

#endif // PX_GEMINI_H__
