#!/bin/sh

OUTDIR=${1:-/tmp}

PXD_VERSION_FILE="libpxd/include/libpxd/px_version.h"

die() {
  echo "$@"
  exit -1
}

git status 2>/dev/null >&2 || die "This script needs 'git archive' to work"

[ -d "$OUTDIR" ] || die "output directory $OUTDIR is not a directory"

echo "Building the project..."
if [ "x$VERBOSE" != "x1" ] ; then
  make >/dev/null 2>/dev/null || die "could not build the project"
else
  make || die "could not build the project"
fi

[ -f "$PXD_VERSION_FILE" ] || die "no px_version.h, it needs to be present to generate an archive"

TAG=""
if [ "$(git status -uno --porcelain 2>/dev/null | wc -l 2>/dev/null)" -ne 0 ] ; then
  TAG="$(git rev-list --abbrev-commit --max-count=1 HEAD 2>/dev/null)"
  TAG="${TAG}-devel"
else
  TAG="$(git tag --contains HEAD 2>/dev/null)"
  if [ -z "$TAG" ] ; then
    TAG="$(git rev-list --abbrev-commit --max-count=1 HEAD 2>/dev/null)"
  fi
fi

PX_VERSION_H_DATE="`date --date="@$(stat -c "%Y" "$PXD_VERSION_FILE")" +%Y%m%d`"
PREFIX=libpxd-${TAG:-git}-${PX_VERSION_H_DATE}
OUTFILE="${OUTDIR}/${PREFIX}.tar.gz"

# we need to explicitly include the px_version.h file because it's not tracked by git
git archive \
  --prefix="${PREFIX}/$(dirname "$PXD_VERSION_FILE")/" --add-file "$PXD_VERSION_FILE" \
  --prefix="${PREFIX}/" -o "$OUTFILE" HEAD || die "Could not create archive"
echo "$OUTFILE"
