#if defined(__linux__)
#define _GNU_SOURCE
#endif //  defined(__linux__)

#include <polluxd_log.h>
#include <libpxd/px_log.h>
#include <stdio.h>

void polluxd_setup_logfile(struct polluxd_config* conf) {
  if (!conf || !conf->logfile)
    return;

  if (freopen(conf->logfile, "a", stderr) == NULL) {
    px_log_error("could not redirect stderr to %s", conf->logfile);
    exit(-2);
  }

  if (freopen(conf->logfile, "a", stdout) == NULL) {
    px_log_error("could not redirect stdout to %s", conf->logfile);
    exit(-2);
  }
}

