#ifndef POLLUXD_CGI_H__
#define POLLUXD_CGI_H__

#include <stdint.h>

struct polluxd_client; // forward declaration
struct polluxd_context; // forward declaration

// we want to keep all of this to less than 4096 bytes so that we can do an atomic
// write from the polluxd main process to the CGI helper script
//    { "GATEWAY_INTERFACE","CGI/1.1", -1 }, <- constant
//    { "SERVER_PROTOCOL",  "GEMINI", -1 }, <- constant
//    { "SERVER_SOFTWARE",  "libpxd", -1 }, <- constant TODO make variable?
//    { "PATH_INFO",        gemctx->gemreq.decoded_url.path, -1 },
//    { "GEMINI_URL",       gemctx->gemreq.reqbuf, reqbuf_sz },
//    { "SCRIPT_NAME",      scriptname, -1 },
//    { "HOSTNAME",         gemctx->gemreq.decoded_url.path, -1 },
//    { "SERVER_NAME",      gemctx->gemreq.decoded_url.path, -1 },
//    { "SERVER_ADDR",      gemctx->conn.host_addr_str, -1 },
//    { "SERVER_PORT",      local_port, -1 },
//    { "REMOTE_ADDR",      gemctx->conn.peer_addr_str, -1 },
//    { "REMOTE_HOST",      peer_host, -1 },
//    { "REMOTE_PORT",      peer_port, -1 },
//    { "TLS_CIPHER",       SSL_CIPHER_get_name(cipher), -1 },
//    { "TLS_VERSION",      SSL_CIPHER_get_version(cipher), -1 },
//    { "AUTH_TYPE",        gemctx->cert_digests.cert_digest ? "CERTIFICATE" : NULL, -1 },
//    { "TLS_CLIENT_HASH",  gemctx->cert_digests.cert_digest, -1 },
//    { "TLS_CLIENT_PUBKEY_HASH",  gemctx->cert_digests.pubkey_digest, -1 },

_Bool polluxd_launch_cgi_helpers(struct polluxd_context* pxd);
int   polluxd_get_cgi_socket(struct polluxd_context* pxd);
_Bool polluxd_recv_cgi_fd(struct polluxd_client* client, int rxsock, int* out_f);

#endif // POLLUXD_CGI_H__
