#if defined(__linux__)
#define _GNU_SOURCE
#endif //  defined(__linux__)

#include <libpxd/px_time.h>


struct timespec px_time_now_plus_milliseconds(int ms) {
  struct timespec now;
  if (clock_gettime(CLOCK_MONOTONIC, &now) != 0)
    return (struct timespec) { 0 };

  if (ms == 0)
    return now;

  long add_s = ms / 1000;
  long add_ns = (ms - add_s * 1000) * 1000000;
  now.tv_sec += add_s;
  now.tv_nsec += add_ns;
  if (now.tv_nsec > 1000000000) {
    now.tv_sec += 1;
    now.tv_nsec -= 1000000000;
  } else if (now.tv_nsec < 0) {
    now.tv_sec -= 1;
    now.tv_nsec += 1000000000;
  }

  return now;
}

int px_time_difference_ms(struct timespec const* start, struct timespec const* end_ro) {
  if (end_ro->tv_sec < start->tv_sec)
    return 0;

  struct timespec end = *end_ro;
  if (end.tv_nsec < start->tv_nsec) {
    --end.tv_sec;
    end.tv_nsec += 1000000000;
  }

  int ms = 1000 * (end.tv_sec - start->tv_sec) + ((end.tv_nsec - start->tv_nsec) / 1000000);
  return ms;
}

