#ifndef PX_URI_H__
#define PX_URI_H__

#include <stdbool.h>
#include <stdint.h>

struct px_url {
  char* scheme;
  char* userinfo;
  char* host;
  char* port;
  char* path;
  char* query;
  char* fragment;
};

void  px_url_init(struct px_url* url);
void  px_url_reset(struct px_url* url);
_Bool px_url_from_buffer(struct px_url* url, uint8_t const* buf, unsigned buflen);
_Bool px_url_encode(struct px_url* out, struct px_url const* url);
char* px_url_encode_str(char const* str, int (* const encode_char)(unsigned char));
char* px_url_encode_buffer(uint8_t const* buf, size_t buf_sz, int (* const encode_char)(unsigned char));
char* px_url_decode_str(char const* str);
_Bool px_url_decode(struct px_url* decoded, struct px_url const* url);
char* px_url_to_str(struct px_url const* url);
char* px_url_to_str_unencoded(struct px_url const* url);

#endif // PX_URI_H__
