#ifndef PX_ROUTE_H__
#define PX_ROUTE_H__

#include <libpxd/px_log.h>
#include <libpxd/px_path.h>

#define MAX_ROUTE_NODES 16

struct px_route_node {
  struct px_route_node* parent;
  struct px_route_node* subnodes[MAX_ROUTE_NODES];
  unsigned              depth;
  char*                 path;
  void*                 priv;
};

struct px_route {
  // NOTE: we don't store a path in the root node because it's always assumed to be '/'
  struct px_route_node root;
};

void px_route_node_init(struct px_route_node* node);
void px_route_node_reset(struct px_route_node* node);
void px_route_init(struct px_route* node);
void px_route_reset(struct px_route* node);

struct px_route_node* px_route_add(struct px_route* route, char const* route_str, _Bool excl);
struct px_route_node* px_route_add_path(struct px_route* route, struct px_path const* route_path, _Bool excl);
_Bool px_route_remove(struct px_route* route, struct px_route_node* node);
struct px_route_node* px_route_find(struct px_route* route, char const *path_str);
struct px_route_node* px_route_find_path(struct px_route* route, struct px_path const* path);
struct px_route_node* px_route_find_components(struct px_route_node* node,
                                                char const** components,
                                                size_t comp_sz);

struct px_route_node* px_route_node_add_components(struct px_route_node* node,
                                                    char const** components,
                                                    size_t components_sz,
                                                    _Bool excl);

typedef void (*px_route_visit_fxn)(struct px_route_node*, int depth);
void px_route_visit_tree(struct px_route_node* node, unsigned depth, px_route_visit_fxn fxn);

#endif // PX_ROUTE_H__
