#ifndef PX_LOG_H__
#define PX_LOG_H__

#include <stdlib.h>

enum px_log_level {
  px_log_level_fatal = 0,
  px_log_level_error,
  px_log_level_warn,
  px_log_level_info,
  px_log_level_debug
};


#if defined(PX_QUIET_LOGS)
#define PX_FILE NULL
#define PX_LINE -1
#else // defined(PX_QUIET_LOGS)
#define PX_FILE __FILE__
#define PX_LINE __LINE__
#endif // defined(PX_QUIET_LOGS)

#define PX_ENABLE_ASSERTS

#if defined(PX_ENABLE_ASSERTS)
#define px_log_assert(cond, ...) \
  if (!(cond)) { \
    px_log_msg(PX_FILE, PX_LINE, px_log_level_fatal, __VA_ARGS__); \
    abort(); \
  }
#else // PX_ENABLE_ASSERTS
#define px_log_assert(cond, ...)
#endif // PX_ENABLE_ASSERTS

#define px_log_fatal(...) { px_log_msg(PX_FILE, PX_LINE, px_log_level_fatal, __VA_ARGS__) ; abort(); }
#define px_log_error(...) px_log_msg(PX_FILE, PX_LINE, px_log_level_error, __VA_ARGS__)
#define px_log_warn(...) px_log_msg(PX_FILE, PX_LINE, px_log_level_warn, __VA_ARGS__)
#define px_log_info(...) px_log_msg(PX_FILE, PX_LINE, px_log_level_info, __VA_ARGS__)
#define px_log_debug(...) px_log_msg(PX_FILE, PX_LINE, px_log_level_debug, __VA_ARGS__)

// struct px_log_opts
//void px_setup_log(struct px_log_opts const* logopts);

void px_log_msg(char const* file, int line, enum px_log_level lvl, char const* fmt, ...) __attribute__((format(printf, 4, 5)));

#endif // POLLUX_LOG_H__
