#!/bin/sh

# check if we're in a git repo.  if so we can update $VERSION_FILE
if git status 2>/dev/null >&2 ; then
  # first check if any tracked files have been modified.
  # if so we're on a development branch
  if [ "`git status -uno --porcelain 2>/dev/null | wc -l 2>/dev/null`" -ne 0 ] ; then
    echo -n "development version based on "
    git rev-list --date=short --no-commit-header --max-count=1 \
      --pretty="format:revision %h %cd" HEAD 2>/dev/null
  else # <- no files have changed, so we can use a tag or un-munged revision
    # check if there's a tag associated with this commit, and use it for the version if so
    TAG="`git tag --contains HEAD 2>/dev/null`"
    if [ -n "$TAG" ] ; then # <- tag exists on our commit, cool
      echo "version $TAG" 2>/dev/null
    else # <- no tag associated with commit, use revision and date
      # we're sitting on an unmodified commit, use its revision
      if ! git rev-list --date=short --no-commit-header --max-count=1 \
        --pretty="format:revision %h %cd" HEAD 2>/dev/null ; then
            echo "unknown version"
      fi
    fi
  fi
else
  exit $?
fi
