#include <libpxd/px_connection.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include <openssl/ssl.h>
#include <unistd.h>

int main(void) {
  int s = socket(AF_INET, SOCK_STREAM, 0);
  if (s < 0) {
    perror("socket");
    return -1;
  }

  struct sockaddr_in in = { .sin_family = AF_INET, .sin_port = htons(9999) };
  inet_pton(AF_INET, "127.0.0.1", &in.sin_addr);

  if (connect(s, (struct sockaddr const*)&in, sizeof(in)) != 0) {
    perror("connect");
    return -1;
  }

  SSL_CTX* ctx = SSL_CTX_new(TLS_client_method());
  if (!ctx) {
    perror("SSL_CTX_new");
  }

  struct px_connection conn;
  px_connection_init(&conn);
  if (!px_connection_start(&conn, s, ctx)) {
    perror("px_connecton_start");
    return -1;
  }

  while (px_connection_do_handshake(&conn) == PX_OP_RETRY) {
    usleep(100000);
  }

  if (px_connection_is_closed(&conn)) {
    printf("couldn't connect\n");
  } else {
    printf("connected\n");
  }

  px_op_status r;
  uint8_t buf[256];
  size_t buf_sz = sizeof(buf);
  while ((buf_sz = sizeof(buf), r = px_connection_recv(&conn, buf, &buf_sz)) == PX_OP_RETRY) {
    usleep(100000);
  }

  if (r == PX_OP_DONE) {
    printf("got data: %.*s\n", (int)buf_sz, (char*)buf);
  } else {
    printf("error when receiving data\n");
  }

  struct px_conn_buffer *cb = px_conn_buffer_get();
  strcpy((char*)cb->data, "hello");
  cb->data_sz = sizeof("hello");
  if (!px_connection_queue_buffer(&conn, cb)) {
    px_conn_buffer_free(cb);
    printf("could not queue data\n");
    return -1;
  }

  while ((r = px_connection_send(&conn)) == PX_OP_RETRY) {
    usleep(100000);
  }

  if (r == PX_OP_DONE) {
    printf("sent data ok\n");
  } else {
    printf("error sending data\n");
  }

  while (px_connection_shutdown(&conn) == PX_OP_RETRY) {
    usleep(100000);
  }

  return 0;
}
