#include <stdio.h>
#include <px_path.h>
#include <stdlib.h>

int main() {
  char* tests[] = {
    "/",
    "/filename",
    "/dirname/",
    "/dirname/filename",
    "/dirname/dirname/filename",
    "/dirname/dirname/dirname/",
    "///dirname/",
    "/dirname///",
    "/dirname///filename",
    "/dirname///dirname///",
    "/dirname///dirname///filename",
    "/dirname///dirname///dirname///",
    "  /dirname///dirname///dirname///",
    "filename",
    "dirname/",
    "dirname/filename",
    "dirname/dirname/filename",
    "dirname/dirname/dirname/",
    "//dirname/",
    "dirname///",
    "dirname///filename",
    "dirname///dirname///",
    "dirname///dirname///filename",
    "dirname///dirname///dirname///",
    "  /dirname///dirname///dirname///",
    "/shouldnotsee/../",
    "/shouldnotsee/..",
    "/shouldnotsee/.././",
    "/shouldnotsee/../.",
    "/shouldnotsee/./../",
    "/shouldnotsee/./..",
    "/shouldnotsee/../shouldseewithroot",
    "/shouldnotsee/../shouldseewithroot/",
    "shouldnotseenoroot/../",
    "shouldnotseenoroot/..",
    "shouldnotseenoroot/../.",
    "shouldnotseenoroot/.././",
    "shouldnotseenoroot/../shouldsee",
    "shouldnotseenoroot/../shouldsee/",
    "/shouldsee/.",
    "/shouldnotsee/./../",
    "/shouldnotsee/.././",
    "  /",
    " / ",
    "/  ",
    "  /filename",
    " / filename",
    "/  filename",
    "  /dirname/",
    " / dirname/",
    "/  dirname/",
    "  /dirname/filename",
    "",
    NULL,
    "\x01"
  };

    //NULL,
    //"",
    //" ",
    //"/",
    //" /",
    //"    /",
    //" ////",
    //"    ////",
    //"/some_file",
    //" /some_file",
    //"    /some_file",
    //"    ///some_file",
    //"/some_file/",
    //" /some_file/",
    //"    /some_file/",
    //"    ///some_file/",
    //"///some_file///extra/extra2////extra3",
    //"///some_file///extra/extra2////extra3//////////",
    //" some_file",
    //" some_file/",
    //"    some_file",
    //"    some_file////",
    //"    some_file/\0///",
    //"    some_file/\x09///",
    //"some_file///extra/extra2////extra3",
    //"some_file///extra/extra2////extra3//////////",
    //"1/2/3/4/5/6/7/8/9/10/11",
    //"1/2/3/4/5/6/7/8/9/10/11/",

  for (unsigned i = 0; i < sizeof(tests) / sizeof(tests[0]); ++i) {
    struct px_path p;
    //struct px_path p;
    px_path_init(&p);
    //px_path_init(&p);
    px_make_path(&p, tests[i]);
    px_path_sanitize(&p);
    //px_path_standardize(&p, &p);
    fprintf(stdout, "path: \"%s\"\n", tests[i] ? tests[i] : "NULL");
    if (!p.components)
      fprintf(stdout, "  no components\n");
    for (unsigned j = 0; p.components && p.components[j] != NULL; ++j) {
      fprintf(stdout, "  test %02u: component %02u: %s\n", i, j, p.components[j]);
    }
    char* str = px_path_to_str(&p);
    fprintf(stdout, "  test %02u: reconstituted path: \"%s\"\n", i, str ? str : "(NULL)");
    free(str);

    px_path_reset(&p);
  }
}
