#include <libpxd/px_common.h>
#include <libpxd/px_route.h>
#include <libpxd/px_log.h>
#include <libpxd/px_url.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

int main(void) {

  char const* test_urls[] = {
    "/basic/path/to/something?query#fragment",
    "gemini://somehost.com/path/to/something?query#fragment",
    "gemini:///path/to/something?query#fragment",
    "gemini://user@somehost.com/path/to/something?query1=this&query2=that",
    "gemini://mysite.ai/robots.txt?robot=true&uri=gemini%3A%2F%2Ffreeshell.de%2Ftags%2Ffaq.gmi",
    "gemini://some_user@some.host:1234/some/path?some&query#some_fragment",
    "gemini://some_user@some.host:1234/some/path?some&query=/unencoded/slash#some_fragment/unencoded/slash"
  };
  unsigned const n_test_urls = sizeof(test_urls) / sizeof(test_urls[0]);

  int ret = 0;
  for (unsigned i = 0; i < n_test_urls; ++i) {
    struct px_url url = { 0 };

    if (px_url_from_bytes(&url, (uint8_t const*)test_urls[i], strlen(test_urls[i]))) {
      struct field { char const* name; char const* content; };
      struct field fields[] = {
        { "scheme",   url.scheme },
        { "userinfo", url.userinfo },
        { "host",     url.host },
        { "port",     url.port },
        { "path",     url.path },
        { "query",    url.query },
        { "fragment", url.fragment }
      };

      char* to_str = px_url_to_str(&url);
      if (to_str) {
        fprintf(stdout, "result: %s\n", to_str);
        free(to_str);
        for (unsigned i = 0; i < px_n_elements(fields); ++i) {
          fprintf(stdout, "  field %s: ", fields[i].name);
          for (char const* itr = fields[i].content; itr && *itr; ++itr) {
            unsigned char c = *itr;
            if (isprint(c))
              fprintf(stdout, "%c", c);
            else
              fprintf(stdout, "(%x%x)", ((c & 0xF0) >> 4), c & 0xF);
          }
          fprintf(stdout, "\n");
        }

      } else {
        fprintf(stdout, "fail to_str %s\n", test_urls[i]);
      }
    } else {
      fprintf(stdout, "fail from_str test %s\n", test_urls[i]);
    }
    px_url_reset(&url);
  }

  return ret;
}
