#include <libpxd/px_log.h>
#include <stdio.h>
#include <stdarg.h>
#include <pthread.h>

pthread_mutex_t* get_mtx(void) {
  static pthread_mutex_t mtx = PTHREAD_MUTEX_INITIALIZER;
  return &mtx;
}

void px_log_msg(char const* file, int line, enum px_log_level lvl, char const* fmt, ...) {
  pthread_mutex_t* mtx = get_mtx();
  pthread_mutex_lock(mtx);

  if (file && line > 0) {
    char const* prefix;
    switch (lvl) {
      case px_log_level_error :
        prefix="error ";
        break;
      case px_log_level_warn :
        prefix="warn  ";
        break;
      case px_log_level_info :
        prefix="info  ";
        break;
      case px_log_level_debug :
        prefix="debug ";
        break;
      default:
        prefix="unk";
    }
    fprintf(stderr, "%s %s: %d: ", prefix, file, line);
  }
  va_list va;
  va_start(va, fmt);
  vfprintf(stderr, fmt, va);
  va_end(va);
  fputc('\n', stderr);
  pthread_mutex_unlock(mtx);
}
